/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;

public class FTPListParseEngine {
    private List entries = new LinkedList();
    private ListIterator _internalIterator = this.entries.listIterator();
    FTPFileEntryParser parser = null;

    public FTPListParseEngine(FTPFileEntryParser fTPFileEntryParser) {
        this.parser = fTPFileEntryParser;
    }

    public FTPFile[] getFiles() throws IOException {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(fTPFile);
        }
        return linkedList.toArray(new FTPFile[0]);
    }

    public FTPFile[] getNext(int n) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        int n2 = n;
        while (n2 > 0 && this._internalIterator.hasNext()) {
            String string = (String)this._internalIterator.next();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(fTPFile);
            --n2;
        }
        return linkedList.toArray(new FTPFile[0]);
    }

    public FTPFile[] getPrevious(int n) {
        LinkedList<FTPFile> linkedList = new LinkedList<FTPFile>();
        int n2 = n;
        while (n2 > 0 && this._internalIterator.hasPrevious()) {
            String string = (String)this._internalIterator.previous();
            FTPFile fTPFile = this.parser.parseFTPEntry(string);
            linkedList.add(0, fTPFile);
            --n2;
        }
        return linkedList.toArray(new FTPFile[0]);
    }

    public boolean hasNext() {
        return this._internalIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this._internalIterator.hasPrevious();
    }

    public void readServerList(InputStream inputStream) throws IOException {
        this.readServerList(inputStream, null);
    }

    public void readServerList(InputStream inputStream, String string) throws IOException {
        this.entries = new LinkedList();
        this.readStream(inputStream, string);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    private void readStream(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader = string == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, string));
        String string2 = this.parser.readNextEntry(bufferedReader);
        while (string2 != null) {
            this.entries.add(string2);
            string2 = this.parser.readNextEntry(bufferedReader);
        }
        bufferedReader.close();
    }

    public void resetIterator() {
        this._internalIterator = this.entries.listIterator();
    }
}

