// license:BSD-3-Clause
// copyright-holders:David Haywood
#ifndef MAME_NAMCO_NAMCO_DSP_H
#define MAME_NAMCO_NAMCO_DSP_H

#pragma once

#include "cpu/tms320c2x/tms320c2x.h"


class namco_c67_device : public tms320c25_device
{
public:
	namco_c67_device(const machine_config &mconfig, const char *tag, device_t *owner, uint32_t clock);

protected:
	virtual const tiny_rom_entry *device_rom_region() const override ATTR_COLD;

};

class namco_c71_device : public tms320c25_device
{
public:
	namco_c71_device(const machine_config &mconfig, const char *tag, device_t *owner, uint32_t clock);

protected:
	virtual const tiny_rom_entry *device_rom_region() const override ATTR_COLD;

};

DECLARE_DEVICE_TYPE(NAMCO_C67, namco_c67_device)
DECLARE_DEVICE_TYPE(NAMCO_C71, namco_c71_device)

#endif // MAME_NAMCO_NAMCO_DSP_H
