/*
  gmorgan - a ryhthm station software

  gmorgan.MIDIIn.C  -  MIDI In functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
 (version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modified by Josep Andreu
   ...and again in 2015 by Robert Vogel. 
*/

#include "GMorgan.h"
#include "Chord.h"
#include <iostream>
using namespace std;
#include <string>
using
  std::string;
int
  topnote;
int
  numbernotes;
int
  keynote[128];
int
  kc;
int
  nn;

extern CHORD
  zing;

vector < int >
  midinotes;
vector < int >
  lastmidinotes;
// ****************************************************************
//  loop for midievents.
// ****************************************************************
void
GMO::miramidi ()
{
  lastmidinotes.clear ();
  if (snd_seq_event_input_pending (MidiInPuerto[1].midi_in, 1))
    {
      do
	{
	  midievents (1);
	}
      while (snd_seq_event_input_pending (MidiInPuerto[1].midi_in, 0));
    }
};

void
GMO::midievents (int keIN)
{
  snd_seq_event_t *midievent;
  midievent = NULL;
  snd_seq_event_input (MidiInPuerto[1].midi_in, &midievent);
  if (midievent == NULL)
    return;
  if (midievent->type == 42)
    return;
  if ((midievent->type == SND_SEQ_EVENT_NOTEON)
      || (midievent->type == SND_SEQ_EVENT_NOTEOFF))
    {
      int i,j;	
      int cmdnote = midievent->data.note.note;
      int cmdvelo = midievent->data.note.velocity;
//      int cmddur = midievent->data.note.duration;
      int cmdchannel = midievent->data.note.channel;
      if (cmdchannel == 9)
	return;
      globalchannel = cmdchannel;
	
      snd_seq_ev_set_subs (midievent);
      snd_seq_ev_set_direct (midievent);
      for (i = 0; i < POLY; i++)
	{
	  if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo != 0))
	    {
	      note_active[i] = 1;
	      keynote[cmdnote] = cmdnote;
	      gate[i] = 1;
	    }
	}
// ***************************************************************************************
// Pack input midi keys pressed into a vector. 
// Midi2Note prints letter equivalents to the screen.
// ***************************************************************************************
      midinotes.clear ();
      for (j = 0; j < 128; j++)
	{
	  if (keynote[j] != 0)
	    {
	      topnote = keynote[j];
	      midinotes.push_back (topnote);
	    }
	}
// 
// event from funny keyboard. 
      if (KeybON)
	{
	  std::string KBChord;
 	  zing.SetCurrentChordsym(KBChord);
	}
// **************************************************************************************
// If batch play is on, the leadsheet has provided the chord symbol, but, if not,
// determine Chord from midi keys pressed... if recognized. Don't do it if vectors of midinotes are unchanged.
// ***************************************************************************************
      else
	{
	  if ((midinotes != lastmidinotes) && (bplay != 1))
	    {
	      std::string chordoutnew = zing.Midi2Chordsym (midinotes);
	      lastmidinotes = midinotes;
	      if ((chordoutnew != " ") && (bplay == 0))
		{
		  zing.SetCurrentChordsym (chordoutnew);
//		  cout << " count.. " << chordoutnew << endl; 
		  std::string ngchordout = zing.GetCurrentChordsym ();
		  char *sz;
		  sz = new char[ngchordout.length () + 1];
		  strcpy (sz, ngchordout.c_str ());
		  ChangeChord ();
		  delete[]sz;
		}
	    }
	}
      if ((midievent->type == SND_SEQ_EVENT_NOTEON) && (cmdvelo == 0))
	{
	  keynote[cmdnote] = 0;
	  if ((note_active[i]) && (rnote[i] == cmdnote))
	    {
	      keynote[cmdnote] = 0;
	      note_active[i] = 0;
	      if (pedal == 0)
		gate[i] = 0;
	    }
	}
      if (midievent->type == SND_SEQ_EVENT_NOTEOFF)
	{
	  keynote[cmdnote] = 0;
	}
//  ********************************************************************
//  Harmonization only works on the the first voice or any accompaniment..
//  Set the lower and upper limits so that there is no
//  interference with chord determination...if not in the sequencer.
//  ********************************************************************
      if (OnOff[1])
	{
	  if ((((cmdnote >= lonote[1]) && (cmdnote <= hinote[1]))
	      && ((cmdvelo >= lowvel[1]) && (cmdvelo <= hivel[1])))
	      || (cmdvelo == 0))
	    {
//	      cout << "channel 1: note = " << cmdnote << " lownote = " << lonote[1] << " highnote " << hinote[1];
//	      cout << " velocity= " << cmdvelo << " lowvelocity = " << lowvel[1] << " highvelocity " << hivel[1] << endl; 
	      if (HMode != 0)
			{	
//				cout << "HMode: " << HMode << " note: " << cmdnote << " v1low: " << v1lowMidi << " v1high: " << v1highMidi << endl;
				harmonize (HMode, 0, TMch[1],
			   	cmdnote + (12 * octa[1]) + transpose, cmdvelo, 0);
			}
	      midievent->data.note.channel = TMch[1];
	      midievent->data.note.note =
				cmdnote + 12 + (12 * octa[1]) + transpose;
	      midievent->data.note.velocity = cmdvelo;
	      if (grabacion)
				PonGraba (2, tick, midievent->data.note.note,
			  	midievent->data.note.channel,
			  	midievent->data.note.velocity, 0, 0, 0, 0);
	      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out,
					   midievent);
	    }
	}
      if (OnOff[2])
	{
	  if ((((cmdnote >= lonote[2]) && (cmdnote <= hinote[2]))
	      && ((cmdvelo >= lowvel[2]) && (cmdvelo <= hivel[2])))
	      || (cmdvelo == 0))
	    {
	      midievent->data.note.channel = TMch[2];
	      midievent->data.note.note =
		cmdnote + 12 + (12 * octa[2]) + transpose;
	      midievent->data.note.velocity = cmdvelo;
	      if (grabacion)
		PonGraba (2, tick, midievent->data.note.note,
			  midievent->data.note.channel,
			  midievent->data.note.velocity, 0, 0, 0, 0);
	      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out,
					   midievent);
	    }
	}
      if (OnOff[3])
	{
	  if ((((cmdnote >= lonote[3]) && (cmdnote <= hinote[3]))
	      && ((cmdvelo >= lowvel[3]) && (cmdvelo <= hivel[3])))
	      || (cmdvelo == 0))
	    {
	      midievent->data.note.channel = TMch[3];
	      midievent->data.note.note =
		cmdnote + (12 * octa[3]) + transpose;
	      midievent->data.note.velocity = cmdvelo;
	      if (grabacion)
		PonGraba (2, tick, midievent->data.note.note,
			  midievent->data.note.channel,
			  midievent->data.note.velocity, 0, 0, 0, 0);
	      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out,
					   midievent);
//      if (HMode != 0 ) harmonize(HMode, 0, 2, cmdnote+(12*octa[3])+transpose, cmdvelo, 0);
	    }
	}
      if (OnOff[4])
	{
	  if ((((cmdnote >= lonote[4]) && (cmdnote <= hinote[4]))
	      && ((cmdvelo >= lowvel[4]) && (cmdvelo <= hivel[4])))
	      || (cmdvelo == 0))
	    {
	      midievent->data.note.channel = TMch[4];
	      midievent->data.note.note =
		cmdnote + (12 * octa[4]) + transpose;
	      midievent->data.note.velocity = cmdvelo;
	      if (grabacion)
		PonGraba (2, tick, midievent->data.note.note,
			  midievent->data.note.channel,
			  midievent->data.note.velocity, 0, 0, 0, 0);
	      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out,
					   midievent);
	    }
	}
      snd_seq_free_event (midievent);
    }
};

// *************************************************************************************
//      harmonize if mode is on 
// *************************************************************************************
void
GMO::harmonize (int hm, int sons, int channel, int note, int velo, int dur)
{
// ****************************************************************
// ****************************************************************
  int i;
  int hnotes[12];
//  cout << "harmonize hm: " << hm << " sons " << sons << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
  if (velo == 0)
    {
      HarOFF[channel][note].estado = 0;
      for (i = 0; i <= HarOFF[channel][note].nnotas; i++)
	suenaev (channel, HarOFF[channel][note].notas[i] + transpose, 0);
      return;
    }
  int nolimit = 1;
  int modlead = 0;
 switch (hm)
        {
        case 0:
		{
      		hnotes[0] = note;
      		nolimit = 1;       // number of notes. this is unison.
		break;
		}
        case 1:
	    {
	hnotes[0] = note;
	hnotes[1] = zing.GetThird (note);
	nolimit = 2;
//
	cout << "Thirds: ";
	Midi2Note (hnotes[0]);
	cout << hnotes[0] << " and ";
	Midi2Note (hnotes[1]);
	cout <<  hnotes[1] << endl;
//
	break;
	    }
        case 2:
	    {
      hnotes[0] = note;
      vector < int >HarmonyVector = zing.CurrentSixths;
      modlead = (note - zing.iroot) % 12;
      hnotes[1] = (note - HarmonyVector.at (modlead));
      nolimit = 2;
      cout << "Sixths: " << " -->"; 
	      Midi2Note (hnotes[1]);
	      Midi2Note (hnotes[0]);
	cout << " number: " << modlead << " value: " << HarmonyVector.at (modlead) << endl;
	break;
	    }
        case 3:
	    {
      hnotes[0] = note;
      vector < int >HarmonyVector = zing.CurrentSixths;
      modlead = (note - zing.iroot) % 12;
      hnotes[1] = (note - HarmonyVector.at (modlead));
      HarmonyVector = zing.CurrentFifths;
      hnotes[2] = (note - HarmonyVector.at (modlead));
      nolimit = 3;
/*
      cout << "Triad1: " << " -->"; 
	      Midi2Note (hnotes[2]);
	      Midi2Note (hnotes[1]);
	      Midi2Note (hnotes[0]);
	cout << " number: " << modlead << " value: " << HarmonyVector.at (modlead) << endl;
*/
	break;
	    }
//  ************************************************
        case 4:
    {
      hnotes[0] = note;
      vector < int >HarmonyVector = zing.CurrentSixths;
      modlead = (note - zing.iroot) % 12;
      hnotes[1] = ((note - HarmonyVector.at (modlead)) -12);
      HarmonyVector = zing.CurrentFifths;
      hnotes[2] = (note - HarmonyVector.at (modlead));
      nolimit = 3;
	break;
	    }
// 
//
//  ************************************************
        case 5:
    {
      hnotes[0] = note;
      vector < int >HarmonyVector = zing.CurrentSixths;
      modlead = (note - zing.iroot) % 12;
      hnotes[1] = ((note - HarmonyVector.at (modlead)) -12);
      HarmonyVector = zing.CurrentFifths;
      hnotes[2] = (note - HarmonyVector.at (modlead));
      nolimit = 3;
// split the keyboard if harmony is on for it.
	std::string displaychordout = zing.GetCurrentChordsym ();
//	cout << "harmonize mode 5:  " << displaychordout << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
//  cout << "harmonize hm: " << hm << " sons " << sons << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
//	vector < int >harmonynotes = zing.GetCurrentChordNotes ();
//	cout << "number of ChordNotes: " << harmonynotes.size () << endl;
	vector < int >blocknotes = zing.GetCurrentBlock (note);	
	nolimit = blocknotes.size ();
      for (int hk = 0; hk < blocknotes.size (); ++hk)
	{
//	cout << " blocknotes: " << hk << " = " << blocknotes.at (hk);
        hnotes[hk] = blocknotes.at (hk);
//      cout << "  #" << hk << " " << hnotes[hk] << ": " << "--> ";
//	Midi2Note (hnotes[hk]);
//	cout << endl;
	    }
	break;
	}
	case 6:
    {
// split the keyboard if harmony is on for it.
//    if ((note < 60) && (channel < 4)) return;
	std::string displaychordout = zing.GetCurrentChordsym ();
//	cout << "harmonize mode 6:  " << displaychordout << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
//  cout << "harmonize hm: " << hm << " sons " << sons << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
//	vector < int >harmonynotes = zing.GetCurrentChordNotes ();
//	cout << "number of ChordNotes: " << harmonynotes.size () << endl;
	vector < int >blocknotes = zing.GetCurrentBlock (note);	
	nolimit = blocknotes.size ();
// -----Drop 2----- 
      for (int hk = 0; hk < blocknotes.size (); ++hk)
	{
        hnotes[hk] = blocknotes.at (hk);
	if (hk == 1) {hnotes[hk] = ( hnotes[hk] - 12);} 
//	cout << " blocknotes: " << hk << " = " << blocknotes.at (hk);
//        cout << "  #" << hk << " " << hnotes[hk] << ": " << "--> ";
//	Midi2Note (hnotes[hk]);
//	cout << endl;
	    }
	break;
	}
        case 7:
    {
// split the keyboard if harmony is on for it.
//    if ((note < 60) && (channel < 4)) return;
	std::string displaychordout = zing.GetCurrentChordsym ();
//	cout << "harmonize mode 7:  " << displaychordout << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
//  cout << "harmonize hm: " << hm << " sons " << sons << " channel: " << channel << " topnote:" << note << " velo: " << velo << " dur: " << dur << endl;
//	vector < int >harmonynotes = zing.GetCurrentChordNotes ();
//	cout << "number of ChordNotes: " << harmonynotes.size () << endl;
	vector < int >blocknotes = zing.GetCurrentBlock (note);	
	nolimit = blocknotes.size ();
// -----Drop 2----- 
      for (int hk = 0; hk < blocknotes.size (); ++hk)
	{
        hnotes[hk] = blocknotes.at (hk);
	if (hk == 1) {hnotes[hk] = ( hnotes[hk] - 12);} 
	if (hk == 3) {hnotes[hk] = ( hnotes[hk] - 12);} 
//	cout << " blocknotes: " << hk << " = " << blocknotes.at (hk);
//        cout << "  #" << hk << " " << hnotes[hk] << ": " << "--> ";
//	Midi2Note (hnotes[hk]);
//	cout << endl;
	    }
	break;
	}
 default:
	{
      return;
	}
    }
// cout << " harmonization channel: " << channel << " note: " << note << " nolimit: " << nolimit << " sons= " << sons << endl; 
	int partchannel = channel;
	HarOFF[partchannel][note].estado = 1;
	HarOFF[partchannel][note].nnotas = nolimit;
	HarOFF[partchannel][note].velo = velo;
//	cout << " globalchannel " << globalchannel << " partchannel " << partchannel << endl;
  for (i = 0; i < nolimit; i++)
    {
	int thisnote = hnotes[i] + transpose;
      if (sons)
	{
//        cout << " sons... *i: " << i << "partchannel" << partchannel << " thisnote " << thisnote << endl; 
	sacaev (partchannel, thisnote, velo, dur);
	}
      else
	{
	  Midi2Note (thisnote);
//	  cout << " --> suenaev... *i: " << i << "partchannel-" << partchannel << " "; 
//	  cout << "   *velo* " << velo << endl;
	  HarOFF[partchannel][note].notas[i] = thisnote;
	  suenaev (partchannel, thisnote, velo);
	}
    }
};
