/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.openide.util.RequestProcessor;

public final class WeakProcessor {
    private Reference<RequestProcessor> processor;
    private final String name;
    private final int throughput;

    public WeakProcessor(String name) {
        this(name, 1);
    }

    public WeakProcessor(String name, int throughput) {
        this.name = name;
        this.throughput = throughput;
    }

    public void post(Runnable task) {
        this.processor().post(task);
    }

    public void post(Runnable task, int delay) {
        this.processor().post(task, delay);
    }

    private synchronized RequestProcessor processor() {
        RequestProcessor p;
        RequestProcessor requestProcessor = p = this.processor != null ? this.processor.get() : null;
        if (p == null) {
            p = new RequestProcessor(this.name, this.throughput);
            this.processor = new WeakReference<RequestProcessor>(p);
        }
        return p;
    }
}

