/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.rules;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.FieldAccess;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Histogram;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.IteratingRule;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.MemoryLint;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class OverallocatedString
extends IteratingRule {
    private FieldAccess fldCount;
    private FieldAccess fldOffset;
    private FieldAccess fldValue;
    private JavaClass clsString;
    private Map<Instance, Integer> covered = new HashMap<Instance, Integer>();
    private int total;

    public OverallocatedString() {
        super(NbBundle.getMessage(OverallocatedString.class, (String)"LBL_OverStr_Name"), NbBundle.getMessage(OverallocatedString.class, (String)"LBL_OverStr_Desc"), "java.lang.String");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(OverallocatedString.class, (String)"LBL_OverStr_LongDesc");
    }

    @Override
    protected void perform(Instance in) {
        int off = this.fldOffset.getIntValue(in);
        int cnt = this.fldCount.getIntValue(in);
        PrimitiveArrayInstance arrValue = (PrimitiveArrayInstance)this.fldValue.getRefValue(in);
        if (arrValue == null) {
            return;
        }
        if (off > 0 || arrValue.getLength() > cnt) {
            if (this.covered.containsKey(arrValue)) {
                this.total -= this.covered.remove(arrValue).intValue();
            } else {
                int waste = 2 * off + 2 * (arrValue.getLength() - (cnt + off));
                this.covered.put((Instance)arrValue, waste);
                this.total += waste;
            }
        }
    }

    @Override
    protected void prepareRule(MemoryLint context) {
        Heap heap = context.getHeap();
        this.clsString = heap.getJavaClassByName("java.lang.String");
        this.fldOffset = new FieldAccess(this.clsString, "offset");
        this.fldCount = new FieldAccess(this.clsString, "count");
        this.fldValue = new FieldAccess(this.clsString, "value");
    }

    @Override
    protected void summary() {
        this.getContext().appendResults(NbBundle.getMessage(OverallocatedString.class, (String)"FMT_OverStr_Result", (Object)this.total));
        Histogram h = new Histogram();
        for (Map.Entry<Instance, Integer> e : this.covered.entrySet()) {
            String incomming = this.getContext().getRootIncommingString(e.getKey());
            incomming = Utils.printClass(this.getContext(), incomming);
            h.add(incomming, new Histogram.Entry(e.getValue().intValue()));
        }
        this.getContext().appendResults(h.toString(5000));
    }
}

