/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.BitSet;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.CookieProcessorBase;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.SameSiteCookies;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.res.StringManager;

public final class LegacyCookieProcessor
extends CookieProcessorBase {
    private static final Log log = LogFactory.getLog(LegacyCookieProcessor.class);
    private static final UserDataHelper userDataLog = new UserDataHelper(log);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.http");
    private static final char[] V0_SEPARATORS = new char[]{',', ';', ' ', '\t'};
    private static final BitSet V0_SEPARATOR_FLAGS = new BitSet(128);
    private static final char[] HTTP_SEPARATORS = new char[]{'\t', ' ', '\"', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
    private final boolean STRICT_SERVLET_COMPLIANCE = Boolean.getBoolean("org.apache.catalina.STRICT_SERVLET_COMPLIANCE");
    private boolean allowEqualsInValue = false;
    private boolean allowNameOnly = false;
    private boolean allowHttpSepsInV0 = false;
    private boolean alwaysAddExpires = !this.STRICT_SERVLET_COMPLIANCE;
    private final BitSet httpSeparatorFlags = new BitSet(128);
    private final BitSet allowedWithoutQuotes = new BitSet(128);

    public LegacyCookieProcessor() {
        for (char n : HTTP_SEPARATORS) {
            this.httpSeparatorFlags.set(n);
        }
        boolean bl = this.STRICT_SERVLET_COMPLIANCE;
        if (bl) {
            this.httpSeparatorFlags.set(47);
        }
        String string = this.getAllowHttpSepsInV0() ? ",; " : "()<>@,;:\\\"/[]?={} \t";
        this.allowedWithoutQuotes.set(32, 127);
        for (char c : string.toCharArray()) {
            this.allowedWithoutQuotes.clear(c);
        }
        if (!this.getAllowHttpSepsInV0() && !this.getForwardSlashIsSeparator()) {
            this.allowedWithoutQuotes.set(47);
        }
    }

    public boolean getAllowEqualsInValue() {
        return this.allowEqualsInValue;
    }

    public void setAllowEqualsInValue(boolean bl) {
        this.allowEqualsInValue = bl;
    }

    public boolean getAllowNameOnly() {
        return this.allowNameOnly;
    }

    public void setAllowNameOnly(boolean bl) {
        this.allowNameOnly = bl;
    }

    public boolean getAllowHttpSepsInV0() {
        return this.allowHttpSepsInV0;
    }

    public void setAllowHttpSepsInV0(boolean bl) {
        char[] cArray;
        this.allowHttpSepsInV0 = bl;
        for (char c : cArray = "()<>@:\\\"[]?={}\t".toCharArray()) {
            if (bl) {
                this.allowedWithoutQuotes.set(c);
                continue;
            }
            this.allowedWithoutQuotes.clear(c);
        }
        if (this.getForwardSlashIsSeparator() && !bl) {
            this.allowedWithoutQuotes.clear(47);
        } else {
            this.allowedWithoutQuotes.set(47);
        }
    }

    public boolean getForwardSlashIsSeparator() {
        return this.httpSeparatorFlags.get(47);
    }

    public void setForwardSlashIsSeparator(boolean bl) {
        if (bl) {
            this.httpSeparatorFlags.set(47);
        } else {
            this.httpSeparatorFlags.clear(47);
        }
        if (bl && !this.getAllowHttpSepsInV0()) {
            this.allowedWithoutQuotes.clear(47);
        } else {
            this.allowedWithoutQuotes.set(47);
        }
    }

    public boolean getAlwaysAddExpires() {
        return this.alwaysAddExpires;
    }

    public void setAlwaysAddExpires(boolean bl) {
        this.alwaysAddExpires = bl;
    }

    @Override
    public Charset getCharset() {
        return StandardCharsets.ISO_8859_1;
    }

    @Override
    public void parseCookieHeader(MimeHeaders mimeHeaders, ServerCookies serverCookies) {
        if (mimeHeaders == null) {
            return;
        }
        int n = mimeHeaders.findHeader("Cookie", 0);
        while (n >= 0) {
            MessageBytes messageBytes = mimeHeaders.getValue(n);
            if (messageBytes != null && !messageBytes.isNull()) {
                Exception exception;
                if (messageBytes.getType() != 2) {
                    exception = new Exception();
                    log.debug((Object)"Cookies: Parsing cookie as String. Expected bytes.", (Throwable)exception);
                    messageBytes.toBytes();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cookies: Parsing b[]: " + messageBytes.toString()));
                }
                exception = messageBytes.getByteChunk();
                this.processCookieHeader(exception.getBytes(), exception.getStart(), exception.getLength(), serverCookies);
            }
            ++n;
            n = mimeHeaders.findHeader("Cookie", n);
        }
    }

    @Override
    public String generateHeader(Cookie cookie) {
        return this.generateHeader(cookie, null);
    }

    @Override
    public String generateHeader(Cookie cookie, HttpServletRequest httpServletRequest) {
        SameSiteCookies sameSiteCookies;
        int n;
        int n2 = cookie.getVersion();
        String string = cookie.getValue();
        String string2 = cookie.getPath();
        String string3 = cookie.getDomain();
        String string4 = cookie.getComment();
        if (n2 == 0 && (this.needsQuotes(string, 0) || string4 != null || this.needsQuotes(string2, 0) || this.needsQuotes(string3, 0))) {
            n2 = 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cookie.getName());
        stringBuffer.append('=');
        this.maybeQuote(stringBuffer, string, n2);
        if (n2 == 1) {
            stringBuffer.append("; Version=1");
            if (string4 != null) {
                stringBuffer.append("; Comment=");
                this.maybeQuote(stringBuffer, string4, n2);
            }
        }
        if (string3 != null) {
            stringBuffer.append("; Domain=");
            this.maybeQuote(stringBuffer, string3, n2);
        }
        if ((n = cookie.getMaxAge()) >= 0) {
            if (n2 > 0) {
                stringBuffer.append("; Max-Age=");
                stringBuffer.append(n);
            }
            if (n2 == 0 || this.getAlwaysAddExpires()) {
                stringBuffer.append("; Expires=");
                if (n == 0) {
                    stringBuffer.append(ANCIENT_DATE);
                } else {
                    ((DateFormat)COOKIE_DATE_FORMAT.get()).format(new Date(System.currentTimeMillis() + (long)n * 1000L), stringBuffer, new FieldPosition(0));
                }
            }
        }
        if (string2 != null) {
            stringBuffer.append("; Path=");
            this.maybeQuote(stringBuffer, string2, n2);
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            stringBuffer.append("; HttpOnly");
        }
        if (!(sameSiteCookies = this.getSameSiteCookies()).equals((Object)SameSiteCookies.UNSET)) {
            stringBuffer.append("; SameSite=");
            stringBuffer.append(sameSiteCookies.getValue());
        }
        if (this.getPartitioned()) {
            stringBuffer.append("; Partitioned");
        }
        return stringBuffer.toString();
    }

    private void maybeQuote(StringBuffer stringBuffer, String string, int n) {
        if (string == null || string.length() == 0) {
            stringBuffer.append("\"\"");
        } else if (LegacyCookieProcessor.alreadyQuoted(string)) {
            stringBuffer.append('\"');
            LegacyCookieProcessor.escapeDoubleQuotes(stringBuffer, string, 1, string.length() - 1);
            stringBuffer.append('\"');
        } else if (this.needsQuotes(string, n)) {
            stringBuffer.append('\"');
            LegacyCookieProcessor.escapeDoubleQuotes(stringBuffer, string, 0, string.length());
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string);
        }
    }

    private static void escapeDoubleQuotes(StringBuffer stringBuffer, String string, int n, int n2) {
        if (string.indexOf(34) == -1 && string.indexOf(92) == -1) {
            stringBuffer.append(string);
            return;
        }
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private boolean needsQuotes(String string, int n) {
        if (string == null) {
            return false;
        }
        int n2 = 0;
        int n3 = string.length();
        if (LegacyCookieProcessor.alreadyQuoted(string)) {
            ++n2;
            --n3;
        }
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c < ' ' && c != '\t' || c >= '\u007f') {
                throw new IllegalArgumentException("Control character in cookie value or attribute.");
            }
            if (n == 0 && !this.allowedWithoutQuotes.get(c) || n == 1 && this.isHttpSeparator(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean alreadyQuoted(String string) {
        return string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    /*
     * Unable to fully structure code
     */
    private void processCookieHeader(byte[] var1_1, int var2_2, int var3_3, ServerCookies var4_4) {
        if (var3_3 <= 0 || var1_1 == null) {
            return;
        }
        var5_5 = var2_2 + var3_3;
        var6_6 = var2_2;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = 0;
        var12_12 = null;
        while (var6_6 < var5_5) {
            block34: {
                block33: {
                    var13_13 = false;
                    var14_14 = false;
                    while (var6_6 < var5_5 && (this.isHttpSeparator((char)var1_1[var6_6]) && !this.getAllowHttpSepsInV0() || LegacyCookieProcessor.isV0Separator((char)var1_1[var6_6]) || LegacyCookieProcessor.isWhiteSpace(var1_1[var6_6]))) {
                        ++var6_6;
                    }
                    if (var6_6 >= var5_5) {
                        return;
                    }
                    if (var1_1[var6_6] == 36) {
                        var13_13 = true;
                    }
                    var9_9 = var7_7 = ++var6_6;
                    var10_10 = var7_7;
                    for (var6_6 = var8_8 = this.getTokenEndPosition(var1_1, var6_6, var5_5, var11_11, true); var6_6 < var5_5 && LegacyCookieProcessor.isWhiteSpace(var1_1[var6_6]); ++var6_6) {
                    }
                    if (var6_6 >= var5_5 - 1 || var1_1[var6_6] != 61) break block33;
                    while (++var6_6 < var5_5 && LegacyCookieProcessor.isWhiteSpace(var1_1[var6_6])) {
                    }
                    if (var6_6 >= var5_5) {
                        return;
                    }
                    switch (var1_1[var6_6]) {
                        case 34: {
                            var14_14 = true;
                            var9_9 = var6_6 + 1;
                            var6_6 = var10_10 = LegacyCookieProcessor.getQuotedValueEndPosition(var1_1, var9_9, var5_5);
                            if (var6_6 >= var5_5) {
                                return;
                            }
                            break block34;
                        }
                        case 44: 
                        case 59: {
                            var10_10 = -1;
                            var9_9 = -1;
                            break block34;
                        }
                        default: {
                            if ((var11_11 != 0 || LegacyCookieProcessor.isV0Separator((char)var1_1[var6_6]) || !this.getAllowHttpSepsInV0()) && this.isHttpSeparator((char)var1_1[var6_6]) && var1_1[var6_6] != 61) ** GOTO lbl50
                            var9_9 = var6_6;
                            var6_6 = var10_10 = this.getTokenEndPosition(var1_1, var9_9, var5_5, var11_11, false);
                            if (var9_9 == var10_10) {
                                var9_9 = -1;
                                var10_10 = -1;
                            }
                            break block34;
lbl50:
                            // 1 sources

                            var15_15 = LegacyCookieProcessor.userDataLog.getNextMode();
                            if (var15_15 != null) {
                                var16_16 = LegacyCookieProcessor.sm.getString("cookies.invalidCookieToken");
                                switch (1.$SwitchMap$org$apache$tomcat$util$log$UserDataHelper$Mode[var15_15.ordinal()]) {
                                    case 1: {
                                        var16_16 = var16_16 + LegacyCookieProcessor.sm.getString("cookies.fallToDebug");
                                    }
                                    case 2: {
                                        LegacyCookieProcessor.log.info((Object)var16_16);
                                        break;
                                    }
                                    case 3: {
                                        LegacyCookieProcessor.log.debug((Object)var16_16);
                                    }
                                }
                            }
                            while (var6_6 < var5_5 && var1_1[var6_6] != 59 && var1_1[var6_6] != 44) {
                                ++var6_6;
                            }
                            ++var6_6;
                            var12_12 = null;
                            break;
                        }
                    }
                    continue;
                }
                var10_10 = -1;
                var9_9 = -1;
                var6_6 = var8_8;
            }
            while (var6_6 < var5_5 && LegacyCookieProcessor.isWhiteSpace(var1_1[var6_6])) {
                ++var6_6;
            }
            while (var6_6 < var5_5 && var1_1[var6_6] != 59 && var1_1[var6_6] != 44) {
                ++var6_6;
            }
            ++var6_6;
            if (var13_13) {
                var13_13 = false;
                if (LegacyCookieProcessor.equals("Version", var1_1, var7_7, var8_8) && var12_12 == null) {
                    if (var1_1[var9_9] != 49 || var10_10 != var9_9 + 1) continue;
                    var11_11 = 1;
                    continue;
                }
                if (var12_12 == null) continue;
                if (LegacyCookieProcessor.equals("Domain", var1_1, var7_7, var8_8)) {
                    var12_12.getDomain().setBytes(var1_1, var9_9, var10_10 - var9_9);
                    continue;
                }
                if (LegacyCookieProcessor.equals("Path", var1_1, var7_7, var8_8)) {
                    var12_12.getPath().setBytes(var1_1, var9_9, var10_10 - var9_9);
                    continue;
                }
                if (LegacyCookieProcessor.equals("Port", var1_1, var7_7, var8_8) || LegacyCookieProcessor.equals("CommentURL", var1_1, var7_7, var8_8) || (var15_15 = LegacyCookieProcessor.userDataLog.getNextMode()) == null) continue;
                var16_16 = LegacyCookieProcessor.sm.getString("cookies.invalidSpecial");
                switch (1.$SwitchMap$org$apache$tomcat$util$log$UserDataHelper$Mode[var15_15.ordinal()]) {
                    case 1: {
                        var16_16 = var16_16 + LegacyCookieProcessor.sm.getString("cookies.fallToDebug");
                    }
                    case 2: {
                        LegacyCookieProcessor.log.info((Object)var16_16);
                        break;
                    }
                    case 3: {
                        LegacyCookieProcessor.log.debug((Object)var16_16);
                    }
                }
                continue;
            }
            if (var9_9 == -1 && !this.getAllowNameOnly()) continue;
            var12_12 = var4_4.addCookie();
            var12_12.setVersion(var11_11);
            var12_12.getName().setBytes(var1_1, var7_7, var8_8 - var7_7);
            if (var9_9 != -1) {
                var12_12.getValue().setBytes(var1_1, var9_9, var10_10 - var9_9);
                if (!var14_14) continue;
                LegacyCookieProcessor.unescapeDoubleQuotes(var12_12.getValue().getByteChunk());
                continue;
            }
            var12_12.getValue().setString("");
        }
    }

    private int getTokenEndPosition(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        for (n4 = n; n4 < n2 && (!this.isHttpSeparator((char)byArray[n4]) || n3 == 0 && this.getAllowHttpSepsInV0() && byArray[n4] != 61 && !LegacyCookieProcessor.isV0Separator((char)byArray[n4]) || !bl && byArray[n4] == 61 && this.getAllowEqualsInValue()); ++n4) {
        }
        if (n4 > n2) {
            return n2;
        }
        return n4;
    }

    private boolean isHttpSeparator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw new IllegalArgumentException("Control character in cookie value or attribute.");
        }
        return this.httpSeparatorFlags.get(c);
    }

    private static boolean isV0Separator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw new IllegalArgumentException("Control character in cookie value or attribute.");
        }
        return V0_SEPARATOR_FLAGS.get(c);
    }

    private static int getQuotedValueEndPosition(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (byArray[n3] == 34) {
                return n3;
            }
            if (byArray[n3] == 92 && n3 < n2 - 1) {
                n3 += 2;
                continue;
            }
            ++n3;
        }
        return n2;
    }

    private static boolean equals(String string, byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (byArray == null || n3 != string.length()) {
            return false;
        }
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            if (byArray[n4++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(byte by) {
        return by == 32 || by == 9 || by == 10 || by == 13 || by == 12;
    }

    private static void unescapeDoubleQuotes(ByteChunk byteChunk) {
        if (byteChunk == null || byteChunk.getLength() == 0 || byteChunk.indexOf('\"', 0) == -1) {
            return;
        }
        byte[] byArray = byteChunk.getBuffer();
        int n = byteChunk.getLength();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, byteChunk.getStart(), byArray2, 0, n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] == 92 && i < n && byArray2[i + 1] == 34) {
                ++i;
            }
            byArray2[n2] = byArray2[i];
            ++n2;
        }
        byteChunk.setBytes(byArray2, 0, n2);
    }

    static {
        for (char c : V0_SEPARATORS) {
            V0_SEPARATOR_FLAGS.set(c);
        }
    }
}

