\name{DoubleThresholdImageFilter}
\alias{DoubleThresholdImageFilter}
\title{DoubleThresholdImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Binarize an input image using double thresholding.
DoubleThresholdImageFilter}
\details{
Double threshold addresses the difficulty in selecting a threshold
that will select the objects of interest without selecting extraneous
objects. Double threshold considers two threshold ranges: a narrow
range and a wide range (where the wide range encompasses the narrow
range). If the wide range was used for a traditional threshold (where
values inside the range map to the foreground and values outside the
range map to the background), many extraneous pixels may survive the
threshold operation. If the narrow range was used for a traditional
threshold, then too few pixels may survive the threshold.
Double threshold uses the narrow threshold image as a marker image and
the wide threshold image as a mask image in the geodesic dilation.
Essentially, the marker image (narrow threshold) is dilated but
constrained to lie within the mask image (wide threshold). Thus, only
the objects of interest (those pixels that survived the narrow
threshold) are extracted but the those objects appear in the final
image as they would have if the wide threshold was used.
See:
GrayscaleGeodesicDilateImageFilter
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
DoubleThreshold for the procedural interface
itk::DoubleThresholdImageFilter for the Doxygen on the original ITK class.
DoubleThresholdImageFilter}
%C++ includes: sitkDoubleThresholdImageFilter.h
\section{Methods}{
\describe{
\item{ DoubleThresholdImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{uint8_t GetInsideValue() const:}{
Get the "inside" pixel value.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint8_t GetOutsideValue() const:}{
Get the "outside" pixel value.
}
\item{double GetThreshold1() const:}{
Get the threshold values.
}
\item{double GetThreshold2() const:}{
Get the threshold values.
}
\item{double GetThreshold3() const:}{
Get the threshold values.
}
\item{double GetThreshold4() const:}{
Get the threshold values.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetInsideValue(uint8_t InsideValue):}{
Set the "inside" pixel value. The default value NumericTraits<OutputPixelType>::max()
}
\item{Self SetOutsideValue(uint8_t OutsideValue):}{
Set the "outside" pixel value. The default value NumericTraits<OutputPixelType>::ZeroValue() .
}
\item{Self SetThreshold1(double Threshold1):}{
Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.
}
\item{Self SetThreshold2(double Threshold2):}{
Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.
}
\item{Self SetThreshold3(double Threshold3):}{
Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.
}
\item{Self SetThreshold4(double Threshold4):}{
Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~DoubleThresholdImageFilter():}{
Destructor
}
}
}
