"""
Exports grapheme cluster break property tables for Unicode version 17.0.0.

This module provides lookup tables for Unicode grapheme cluster break properties as defined in UAX
#29: Unicode Text Segmentation.

This code generated by wcwidth/bin/update-tables.py on 2026-01-29 23:33:42 UTC.
"""
# pylint: disable=duplicate-code

GRAPHEME_CR = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x0000d, 0x0000d,),  # (nil)
)

GRAPHEME_LF = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x0000a, 0x0000a,),  # (nil)
)

GRAPHEME_CONTROL = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x00000, 0x00009,),  # (nil)
    (0x0000b, 0x0000c,),  # (nil)
    (0x0000e, 0x0001f,),  # (nil)
    (0x0007f, 0x0009f,),  # (nil)
    (0x000ad, 0x000ad,),  # Soft Hyphen
    (0x0061c, 0x0061c,),  # Arabic Letter Mark
    (0x0180e, 0x0180e,),  # Mongolian Vowel Separator
    (0x0200b, 0x0200b,),  # Zero Width Space
    (0x0200e, 0x0200f,),  # Left-to-right Mark      ..Right-to-left Mark
    (0x02028, 0x0202e,),  # Line Separator          ..Right-to-left Override
    (0x02060, 0x0206f,),  # Word Joiner             ..Nominal Digit Shapes
    (0x0feff, 0x0feff,),  # Zero Width No-break Space
    (0x0fff0, 0x0fffb,),  # (nil)                   ..Interlinear Annotation T
    (0x13430, 0x1343f,),  # Egyptian Hieroglyph Vert..Egyptian Hieroglyph End
    (0x1bca0, 0x1bca3,),  # Shorthand Format Letter ..Shorthand Format Up Step
    (0x1d173, 0x1d17a,),  # Musical Symbol Begin Bea..Musical Symbol End Phras
    (0xe0000, 0xe001f,),  # (nil)
    (0xe0080, 0xe00ff,),  # (nil)
    (0xe01f0, 0xe0fff,),  # (nil)
)

GRAPHEME_EXTEND = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
    (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
    (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
    (0x005bf, 0x005bf,),  # Hebrew Point Rafe
    (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
    (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
    (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qatan
    (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
    (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
    (0x00670, 0x00670,),  # Arabic Letter Superscript Alef
    (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
    (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
    (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
    (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
    (0x00711, 0x00711,),  # Syriac Letter Superscript Alaph
    (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
    (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
    (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
    (0x007fd, 0x007fd,),  # Nko Dantayalan
    (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
    (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
    (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
    (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
    (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
    (0x00897, 0x0089f,),  # Arabic Pepet            ..Arabic Half Madda Over M
    (0x008ca, 0x008e1,),  # Arabic Small High Farsi ..Arabic Small High Sign S
    (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
    (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe
    (0x0093c, 0x0093c,),  # Devanagari Sign Nukta
    (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
    (0x0094d, 0x0094d,),  # Devanagari Sign Virama
    (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
    (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
    (0x00981, 0x00981,),  # Bengali Sign Candrabindu
    (0x009bc, 0x009bc,),  # Bengali Sign Nukta
    (0x009be, 0x009be,),  # Bengali Vowel Sign Aa
    (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
    (0x009cd, 0x009cd,),  # Bengali Sign Virama
    (0x009d7, 0x009d7,),  # Bengali Au Length Mark
    (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
    (0x009fe, 0x009fe,),  # Bengali Sandhi Mark
    (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
    (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta
    (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
    (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
    (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
    (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat
    (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
    (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash
    (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
    (0x00abc, 0x00abc,),  # Gujarati Sign Nukta
    (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
    (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
    (0x00acd, 0x00acd,),  # Gujarati Sign Virama
    (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
    (0x00afa, 0x00aff,),  # Gujarati Sign Sukun     ..Gujarati Sign Two-circle
    (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu
    (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta
    (0x00b3e, 0x00b3f,),  # Oriya Vowel Sign Aa     ..Oriya Vowel Sign I
    (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
    (0x00b4d, 0x00b4d,),  # Oriya Sign Virama
    (0x00b55, 0x00b57,),  # Oriya Sign Overline     ..Oriya Au Length Mark
    (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
    (0x00b82, 0x00b82,),  # Tamil Sign Anusvara
    (0x00bbe, 0x00bbe,),  # Tamil Vowel Sign Aa
    (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii
    (0x00bcd, 0x00bcd,),  # Tamil Sign Virama
    (0x00bd7, 0x00bd7,),  # Tamil Au Length Mark
    (0x00c00, 0x00c00,),  # Telugu Sign Combining Candrabindu Above
    (0x00c04, 0x00c04,),  # Telugu Sign Combining Anusvara Above
    (0x00c3c, 0x00c3c,),  # Telugu Sign Nukta
    (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
    (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
    (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
    (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
    (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
    (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu
    (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta
    (0x00cbf, 0x00cc0,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign Ii
    (0x00cc2, 0x00cc2,),  # Kannada Vowel Sign Uu
    (0x00cc6, 0x00cc8,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign Ai
    (0x00cca, 0x00ccd,),  # Kannada Vowel Sign O    ..Kannada Sign Virama
    (0x00cd5, 0x00cd6,),  # Kannada Length Mark     ..Kannada Ai Length Mark
    (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
    (0x00d00, 0x00d01,),  # Malayalam Sign Combining..Malayalam Sign Candrabin
    (0x00d3b, 0x00d3c,),  # Malayalam Sign Vertical ..Malayalam Sign Circular
    (0x00d3e, 0x00d3e,),  # Malayalam Vowel Sign Aa
    (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
    (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama
    (0x00d57, 0x00d57,),  # Malayalam Au Length Mark
    (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
    (0x00d81, 0x00d81,),  # Sinhala Sign Candrabindu
    (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna
    (0x00dcf, 0x00dcf,),  # Sinhala Vowel Sign Aela-pilla
    (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
    (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga Paa-pilla
    (0x00ddf, 0x00ddf,),  # Sinhala Vowel Sign Gayanukitta
    (0x00e31, 0x00e31,),  # Thai Character Mai Han-akat
    (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
    (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
    (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan
    (0x00eb4, 0x00ebc,),  # Lao Vowel Sign I        ..Lao Semivowel Sign Lo
    (0x00ec8, 0x00ece,),  # Lao Tone Mai Ek         ..Lao Yamakkan
    (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
    (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung Nyi Zla
    (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung Sgor Rtags
    (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru
    (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
    (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
    (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
    (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
    (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
    (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gdan
    (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
    (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
    (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
    (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
    (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
    (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
    (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
    (0x01082, 0x01082,),  # Myanmar Consonant Sign Shan Medial Wa
    (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
    (0x0108d, 0x0108d,),  # Myanmar Sign Shan Council Emphatic Tone
    (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton Ai
    (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
    (0x01712, 0x01715,),  # Tagalog Vowel Sign I    ..Tagalog Sign Pamudpod
    (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
    (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
    (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
    (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
    (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
    (0x017c6, 0x017c6,),  # Khmer Sign Nikahit
    (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
    (0x017dd, 0x017dd,),  # Khmer Sign Atthacan
    (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
    (0x0180f, 0x0180f,),  # Mongolian Free Variation Selector Four
    (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
    (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gali Dagalga
    (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
    (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
    (0x01932, 0x01932,),  # Limbu Small Letter Anusvara
    (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
    (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
    (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae
    (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign Medial La
    (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
    (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot
    (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai Sat
    (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
    (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
    (0x01a7f, 0x01a7f,),  # Tai Tham Combining Cryptogrammic Dot
    (0x01ab0, 0x01add,),  # Combining Doubled Circum..Combining Dot-and-ring B
    (0x01ae0, 0x01aeb,),  # Combining Left Tack Abov..Combining Double Rightwa
    (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
    (0x01b34, 0x01b3d,),  # Balinese Sign Rerekan   ..Balinese Vowel Sign La L
    (0x01b42, 0x01b44,),  # Balinese Vowel Sign Pepe..Balinese Adeg Adeg
    (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
    (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
    (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
    (0x01ba8, 0x01bad,),  # Sundanese Vowel Sign Pam..Sundanese Consonant Sign
    (0x01be6, 0x01be6,),  # Batak Sign Tompi
    (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
    (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O
    (0x01bef, 0x01bf3,),  # Batak Vowel Sign U For S..Batak Panongonan
    (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
    (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
    (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
    (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
    (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
    (0x01ced, 0x01ced,),  # Vedic Sign Tiryak
    (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above
    (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
    (0x01dc0, 0x01dff,),  # Combining Dotted Grave A..Combining Right Arrowhea
    (0x0200c, 0x0200c,),  # Zero Width Non-joiner
    (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
    (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
    (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joiner
    (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
    (0x0302a, 0x0302f,),  # Ideographic Level Tone M..Hangul Double Dot Tone M
    (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
    (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
    (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
    (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
    (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
    (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisvara
    (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasanta
    (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusvara
    (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
    (0x0a82c, 0x0a82c,),  # Syloti Nagri Sign Alternate Hasanta
    (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
    (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
    (0x0a8ff, 0x0a8ff,),  # Devanagari Vowel Sign Ay
    (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
    (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
    (0x0a953, 0x0a953,),  # Rejang Virama
    (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
    (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu
    (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
    (0x0a9bc, 0x0a9bd,),  # Javanese Vowel Sign Pepe..Javanese Consonant Sign
    (0x0a9c0, 0x0a9c0,),  # Javanese Pangkon
    (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw
    (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
    (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
    (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
    (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Final Ng
    (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Final M
    (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing Tone-2
    (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang
    (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
    (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
    (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
    (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho
    (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
    (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama
    (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign Anap
    (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign Unap
    (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek
    (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spanish Varika
    (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
    (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
    (0x0ff9e, 0x0ff9f,),  # Halfwidth Katakana Voice..Halfwidth Katakana Semi-
    (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combining Oblique Stroke
    (0x102e0, 0x102e0,),  # Coptic Epact Thousands Mark
    (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
    (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
    (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
    (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
    (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
    (0x10a3f, 0x10a3f,),  # Kharoshthi Virama
    (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
    (0x10d24, 0x10d27,),  # Hanifi Rohingya Sign Har..Hanifi Rohingya Sign Tas
    (0x10d69, 0x10d6d,),  # Garay Vowel Sign E      ..Garay Consonant Nasaliza
    (0x10eab, 0x10eac,),  # Yezidi Combining Hamza M..Yezidi Combining Madda M
    (0x10efa, 0x10eff,),  # Arabic Double Vertical B..Arabic Small Low Word Ma
    (0x10f46, 0x10f50,),  # Sogdian Combining Dot Be..Sogdian Combining Stroke
    (0x10f82, 0x10f85,),  # Old Uyghur Combining Dot..Old Uyghur Combining Two
    (0x11001, 0x11001,),  # Brahmi Sign Anusvara
    (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
    (0x11070, 0x11070,),  # Brahmi Sign Old Tamil Virama
    (0x11073, 0x11074,),  # Brahmi Vowel Sign Old Ta..Brahmi Vowel Sign Old Ta
    (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
    (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
    (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
    (0x110c2, 0x110c2,),  # Kaithi Vowel Sign Vocalic R
    (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
    (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
    (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
    (0x11173, 0x11173,),  # Mahajani Sign Nukta
    (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
    (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
    (0x111c0, 0x111c0,),  # Sharada Sign Virama
    (0x111c9, 0x111cc,),  # Sharada Sandhi Mark     ..Sharada Extra Short Vowe
    (0x111cf, 0x111cf,),  # Sharada Sign Inverted Candrabindu
    (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
    (0x11234, 0x11237,),  # Khojki Sign Anusvara    ..Khojki Sign Shadda
    (0x1123e, 0x1123e,),  # Khojki Sign Sukun
    (0x11241, 0x11241,),  # Khojki Vowel Sign Vocalic R
    (0x112df, 0x112df,),  # Khudawadi Sign Anusvara
    (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
    (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
    (0x1133b, 0x1133c,),  # Combining Bindu Below   ..Grantha Sign Nukta
    (0x1133e, 0x1133e,),  # Grantha Vowel Sign Aa
    (0x11340, 0x11340,),  # Grantha Vowel Sign Ii
    (0x1134d, 0x1134d,),  # Grantha Sign Virama
    (0x11357, 0x11357,),  # Grantha Au Length Mark
    (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
    (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
    (0x113b8, 0x113b8,),  # Tulu-tigalari Vowel Sign Aa
    (0x113bb, 0x113c0,),  # Tulu-tigalari Vowel Sign..Tulu-tigalari Vowel Sign
    (0x113c2, 0x113c2,),  # Tulu-tigalari Vowel Sign Ee
    (0x113c5, 0x113c5,),  # Tulu-tigalari Vowel Sign Ai
    (0x113c7, 0x113c9,),  # Tulu-tigalari Vowel Sign..Tulu-tigalari Au Length
    (0x113ce, 0x113d0,),  # Tulu-tigalari Sign Viram..Tulu-tigalari Conjoiner
    (0x113d2, 0x113d2,),  # Tulu-tigalari Gemination Mark
    (0x113e1, 0x113e2,),  # Tulu-tigalari Vedic Tone..Tulu-tigalari Vedic Tone
    (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
    (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
    (0x11446, 0x11446,),  # Newa Sign Nukta
    (0x1145e, 0x1145e,),  # Newa Sandhi Mark
    (0x114b0, 0x114b0,),  # Tirhuta Vowel Sign Aa
    (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
    (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short E
    (0x114bd, 0x114bd,),  # Tirhuta Vowel Sign Short O
    (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
    (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
    (0x115af, 0x115af,),  # Siddham Vowel Sign Aa
    (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
    (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
    (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
    (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
    (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
    (0x1163d, 0x1163d,),  # Modi Sign Anusvara
    (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
    (0x116ab, 0x116ab,),  # Takri Sign Anusvara
    (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa
    (0x116b0, 0x116b7,),  # Takri Vowel Sign U      ..Takri Sign Nukta
    (0x1171d, 0x1171d,),  # Ahom Consonant Sign Medial La
    (0x1171f, 0x1171f,),  # Ahom Consonant Sign Medial Ligating Ra
    (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
    (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
    (0x1182f, 0x11837,),  # Dogra Vowel Sign U      ..Dogra Sign Anusvara
    (0x11839, 0x1183a,),  # Dogra Sign Virama       ..Dogra Sign Nukta
    (0x11930, 0x11930,),  # Dives Akuru Vowel Sign Aa
    (0x1193b, 0x1193e,),  # Dives Akuru Sign Anusvar..Dives Akuru Virama
    (0x11943, 0x11943,),  # Dives Akuru Sign Nukta
    (0x119d4, 0x119d7,),  # Nandinagari Vowel Sign U..Nandinagari Vowel Sign V
    (0x119da, 0x119db,),  # Nandinagari Vowel Sign E..Nandinagari Vowel Sign A
    (0x119e0, 0x119e0,),  # Nandinagari Sign Virama
    (0x11a01, 0x11a0a,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel L
    (0x11a33, 0x11a38,),  # Zanabazar Square Final C..Zanabazar Square Sign An
    (0x11a3b, 0x11a3e,),  # Zanabazar Square Cluster..Zanabazar Square Cluster
    (0x11a47, 0x11a47,),  # Zanabazar Square Subjoiner
    (0x11a51, 0x11a56,),  # Soyombo Vowel Sign I    ..Soyombo Vowel Sign Oe
    (0x11a59, 0x11a5b,),  # Soyombo Vowel Sign Vocal..Soyombo Vowel Length Mar
    (0x11a8a, 0x11a96,),  # Soyombo Final Consonant ..Soyombo Sign Anusvara
    (0x11a98, 0x11a99,),  # Soyombo Gemination Mark ..Soyombo Subjoiner
    (0x11b60, 0x11b60,),  # Sharada Vowel Sign Oe
    (0x11b62, 0x11b64,),  # Sharada Vowel Sign Ue   ..Sharada Vowel Sign Short
    (0x11b66, 0x11b66,),  # Sharada Vowel Sign Candra E
    (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
    (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
    (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama
    (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
    (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
    (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
    (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
    (0x11d31, 0x11d36,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
    (0x11d3a, 0x11d3a,),  # Masaram Gondi Vowel Sign E
    (0x11d3c, 0x11d3d,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
    (0x11d3f, 0x11d45,),  # Masaram Gondi Vowel Sign..Masaram Gondi Virama
    (0x11d47, 0x11d47,),  # Masaram Gondi Ra-kara
    (0x11d90, 0x11d91,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
    (0x11d95, 0x11d95,),  # Gunjala Gondi Sign Anusvara
    (0x11d97, 0x11d97,),  # Gunjala Gondi Virama
    (0x11ef3, 0x11ef4,),  # Makasar Vowel Sign I    ..Makasar Vowel Sign U
    (0x11f00, 0x11f01,),  # Kawi Sign Candrabindu   ..Kawi Sign Anusvara
    (0x11f36, 0x11f3a,),  # Kawi Vowel Sign I       ..Kawi Vowel Sign Vocalic
    (0x11f40, 0x11f42,),  # Kawi Vowel Sign Eu      ..Kawi Conjoiner
    (0x11f5a, 0x11f5a,),  # Kawi Sign Nukta
    (0x13440, 0x13440,),  # Egyptian Hieroglyph Mirror Horizontally
    (0x13447, 0x13455,),  # Egyptian Hieroglyph Modi..Egyptian Hieroglyph Modi
    (0x1611e, 0x16129,),  # Gurung Khema Vowel Sign ..Gurung Khema Vowel Lengt
    (0x1612d, 0x1612f,),  # Gurung Khema Sign Anusva..Gurung Khema Sign Tholho
    (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
    (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
    (0x16f4f, 0x16f4f,),  # Miao Sign Consonant Modifier Bar
    (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
    (0x16fe4, 0x16fe4,),  # Khitan Small Script Filler
    (0x16ff0, 0x16ff1,),  # Vietnamese Alternate Rea..Vietnamese Alternate Rea
    (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
    (0x1cf00, 0x1cf2d,),  # Znamenny Combining Mark ..Znamenny Combining Mark
    (0x1cf30, 0x1cf46,),  # Znamenny Combining Tonal..Znamenny Priznak Modifie
    (0x1d165, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d16d, 0x1d172,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
    (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
    (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
    (0x1da75, 0x1da75,),  # Signwriting Upper Body Tilting From Hip Joints
    (0x1da84, 0x1da84,),  # Signwriting Location Head Neck
    (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
    (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
    (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e08f, 0x1e08f,),  # Combining Cyrillic Small Letter Byelorussian-ukr
    (0x1e130, 0x1e136,),  # Nyiakeng Puachue Hmong T..Nyiakeng Puachue Hmong T
    (0x1e2ae, 0x1e2ae,),  # Toto Sign Rising Tone
    (0x1e2ec, 0x1e2ef,),  # Wancho Tone Tup         ..Wancho Tone Koini
    (0x1e4ec, 0x1e4ef,),  # Nag Mundari Sign Muhor  ..Nag Mundari Sign Sutuh
    (0x1e5ee, 0x1e5ef,),  # Ol Onal Sign Mu         ..Ol Onal Sign Ikir
    (0x1e6e3, 0x1e6e3,),  # Tai Yo Sign Ue
    (0x1e6e6, 0x1e6e6,),  # Tai Yo Sign Au
    (0x1e6ee, 0x1e6ef,),  # Tai Yo Sign Ay          ..Tai Yo Sign Ang
    (0x1e6f5, 0x1e6f5,),  # Tai Yo Sign Om
    (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
    (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
    (0x1f3fb, 0x1f3ff,),  # Emoji Modifier Fitzpatri..Emoji Modifier Fitzpatri
    (0xe0020, 0xe007f,),  # Tag Space               ..Cancel Tag
    (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
)

GRAPHEME_ZWJ = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x0200d, 0x0200d,),  # Zero Width Joiner
)

GRAPHEME_REGIONAL_INDICATOR = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x1f1e6, 0x1f1ff,),  # Regional Indicator Symbo..Regional Indicator Symbo
)

GRAPHEME_PREPEND = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x00600, 0x00605,),  # Arabic Number Sign      ..Arabic Number Mark Above
    (0x006dd, 0x006dd,),  # Arabic End Of Ayah
    (0x0070f, 0x0070f,),  # Syriac Abbreviation Mark
    (0x00890, 0x00891,),  # Arabic Pound Mark Above ..Arabic Piastre Mark Abov
    (0x008e2, 0x008e2,),  # Arabic Disputed End Of Ayah
    (0x00d4e, 0x00d4e,),  # Malayalam Letter Dot Reph
    (0x110bd, 0x110bd,),  # Kaithi Number Sign
    (0x110cd, 0x110cd,),  # Kaithi Number Sign Above
    (0x111c2, 0x111c3,),  # Sharada Sign Jihvamuliya..Sharada Sign Upadhmaniya
    (0x113d1, 0x113d1,),  # Tulu-tigalari Repha
    (0x1193f, 0x1193f,),  # Dives Akuru Prefixed Nasal Sign
    (0x11941, 0x11941,),  # Dives Akuru Initial Ra
    (0x11a84, 0x11a89,),  # Soyombo Sign Jihvamuliya..Soyombo Cluster-initial
    (0x11d46, 0x11d46,),  # Masaram Gondi Repha
    (0x11f02, 0x11f02,),  # Kawi Sign Repha
)

GRAPHEME_SPACINGMARK = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x00903, 0x00903,),  # Devanagari Sign Visarga
    (0x0093b, 0x0093b,),  # Devanagari Vowel Sign Ooe
    (0x0093e, 0x00940,),  # Devanagari Vowel Sign Aa..Devanagari Vowel Sign Ii
    (0x00949, 0x0094c,),  # Devanagari Vowel Sign Ca..Devanagari Vowel Sign Au
    (0x0094e, 0x0094f,),  # Devanagari Vowel Sign Pr..Devanagari Vowel Sign Aw
    (0x00982, 0x00983,),  # Bengali Sign Anusvara   ..Bengali Sign Visarga
    (0x009bf, 0x009c0,),  # Bengali Vowel Sign I    ..Bengali Vowel Sign Ii
    (0x009c7, 0x009c8,),  # Bengali Vowel Sign E    ..Bengali Vowel Sign Ai
    (0x009cb, 0x009cc,),  # Bengali Vowel Sign O    ..Bengali Vowel Sign Au
    (0x00a03, 0x00a03,),  # Gurmukhi Sign Visarga
    (0x00a3e, 0x00a40,),  # Gurmukhi Vowel Sign Aa  ..Gurmukhi Vowel Sign Ii
    (0x00a83, 0x00a83,),  # Gujarati Sign Visarga
    (0x00abe, 0x00ac0,),  # Gujarati Vowel Sign Aa  ..Gujarati Vowel Sign Ii
    (0x00ac9, 0x00ac9,),  # Gujarati Vowel Sign Candra O
    (0x00acb, 0x00acc,),  # Gujarati Vowel Sign O   ..Gujarati Vowel Sign Au
    (0x00b02, 0x00b03,),  # Oriya Sign Anusvara     ..Oriya Sign Visarga
    (0x00b40, 0x00b40,),  # Oriya Vowel Sign Ii
    (0x00b47, 0x00b48,),  # Oriya Vowel Sign E      ..Oriya Vowel Sign Ai
    (0x00b4b, 0x00b4c,),  # Oriya Vowel Sign O      ..Oriya Vowel Sign Au
    (0x00bbf, 0x00bbf,),  # Tamil Vowel Sign I
    (0x00bc1, 0x00bc2,),  # Tamil Vowel Sign U      ..Tamil Vowel Sign Uu
    (0x00bc6, 0x00bc8,),  # Tamil Vowel Sign E      ..Tamil Vowel Sign Ai
    (0x00bca, 0x00bcc,),  # Tamil Vowel Sign O      ..Tamil Vowel Sign Au
    (0x00c01, 0x00c03,),  # Telugu Sign Candrabindu ..Telugu Sign Visarga
    (0x00c41, 0x00c44,),  # Telugu Vowel Sign U     ..Telugu Vowel Sign Vocali
    (0x00c82, 0x00c83,),  # Kannada Sign Anusvara   ..Kannada Sign Visarga
    (0x00cbe, 0x00cbe,),  # Kannada Vowel Sign Aa
    (0x00cc1, 0x00cc1,),  # Kannada Vowel Sign U
    (0x00cc3, 0x00cc4,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
    (0x00cf3, 0x00cf3,),  # Kannada Sign Combining Anusvara Above Right
    (0x00d02, 0x00d03,),  # Malayalam Sign Anusvara ..Malayalam Sign Visarga
    (0x00d3f, 0x00d40,),  # Malayalam Vowel Sign I  ..Malayalam Vowel Sign Ii
    (0x00d46, 0x00d48,),  # Malayalam Vowel Sign E  ..Malayalam Vowel Sign Ai
    (0x00d4a, 0x00d4c,),  # Malayalam Vowel Sign O  ..Malayalam Vowel Sign Au
    (0x00d82, 0x00d83,),  # Sinhala Sign Anusvaraya ..Sinhala Sign Visargaya
    (0x00dd0, 0x00dd1,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Diga
    (0x00dd8, 0x00dde,),  # Sinhala Vowel Sign Gaett..Sinhala Vowel Sign Kombu
    (0x00df2, 0x00df3,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
    (0x00e33, 0x00e33,),  # Thai Character Sara Am
    (0x00eb3, 0x00eb3,),  # Lao Vowel Sign Am
    (0x00f3e, 0x00f3f,),  # Tibetan Sign Yar Tshes  ..Tibetan Sign Mar Tshes
    (0x00f7f, 0x00f7f,),  # Tibetan Sign Rnam Bcad
    (0x01031, 0x01031,),  # Myanmar Vowel Sign E
    (0x0103b, 0x0103c,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
    (0x01056, 0x01057,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
    (0x01084, 0x01084,),  # Myanmar Vowel Sign Shan E
    (0x017b6, 0x017b6,),  # Khmer Vowel Sign Aa
    (0x017be, 0x017c5,),  # Khmer Vowel Sign Oe     ..Khmer Vowel Sign Au
    (0x017c7, 0x017c8,),  # Khmer Sign Reahmuk      ..Khmer Sign Yuukaleapintu
    (0x01923, 0x01926,),  # Limbu Vowel Sign Ee     ..Limbu Vowel Sign Au
    (0x01929, 0x0192b,),  # Limbu Subjoined Letter Y..Limbu Subjoined Letter W
    (0x01930, 0x01931,),  # Limbu Small Letter Ka   ..Limbu Small Letter Nga
    (0x01933, 0x01938,),  # Limbu Small Letter Ta   ..Limbu Small Letter La
    (0x01a19, 0x01a1a,),  # Buginese Vowel Sign E   ..Buginese Vowel Sign O
    (0x01a55, 0x01a55,),  # Tai Tham Consonant Sign Medial Ra
    (0x01a57, 0x01a57,),  # Tai Tham Consonant Sign La Tang Lai
    (0x01a6d, 0x01a72,),  # Tai Tham Vowel Sign Oy  ..Tai Tham Vowel Sign Tham
    (0x01b04, 0x01b04,),  # Balinese Sign Bisah
    (0x01b3e, 0x01b41,),  # Balinese Vowel Sign Tali..Balinese Vowel Sign Tali
    (0x01b82, 0x01b82,),  # Sundanese Sign Pangwisad
    (0x01ba1, 0x01ba1,),  # Sundanese Consonant Sign Pamingkal
    (0x01ba6, 0x01ba7,),  # Sundanese Vowel Sign Pan..Sundanese Vowel Sign Pan
    (0x01be7, 0x01be7,),  # Batak Vowel Sign E
    (0x01bea, 0x01bec,),  # Batak Vowel Sign I      ..Batak Vowel Sign O
    (0x01bee, 0x01bee,),  # Batak Vowel Sign U
    (0x01c24, 0x01c2b,),  # Lepcha Subjoined Letter ..Lepcha Vowel Sign Uu
    (0x01c34, 0x01c35,),  # Lepcha Consonant Sign Ny..Lepcha Consonant Sign Ka
    (0x01ce1, 0x01ce1,),  # Vedic Tone Atharvavedic Independent Svarita
    (0x01cf7, 0x01cf7,),  # Vedic Sign Atikrama
    (0x0a823, 0x0a824,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
    (0x0a827, 0x0a827,),  # Syloti Nagri Vowel Sign Oo
    (0x0a880, 0x0a881,),  # Saurashtra Sign Anusvara..Saurashtra Sign Visarga
    (0x0a8b4, 0x0a8c3,),  # Saurashtra Consonant Sig..Saurashtra Vowel Sign Au
    (0x0a952, 0x0a952,),  # Rejang Consonant Sign H
    (0x0a983, 0x0a983,),  # Javanese Sign Wignyan
    (0x0a9b4, 0x0a9b5,),  # Javanese Vowel Sign Taru..Javanese Vowel Sign Tolo
    (0x0a9ba, 0x0a9bb,),  # Javanese Vowel Sign Tali..Javanese Vowel Sign Dirg
    (0x0a9be, 0x0a9bf,),  # Javanese Consonant Sign ..Javanese Consonant Sign
    (0x0aa2f, 0x0aa30,),  # Cham Vowel Sign O       ..Cham Vowel Sign Ai
    (0x0aa33, 0x0aa34,),  # Cham Consonant Sign Ya  ..Cham Consonant Sign Ra
    (0x0aa4d, 0x0aa4d,),  # Cham Consonant Sign Final H
    (0x0aaeb, 0x0aaeb,),  # Meetei Mayek Vowel Sign Ii
    (0x0aaee, 0x0aaef,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
    (0x0aaf5, 0x0aaf5,),  # Meetei Mayek Vowel Sign Visarga
    (0x0abe3, 0x0abe4,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
    (0x0abe6, 0x0abe7,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
    (0x0abe9, 0x0abea,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
    (0x0abec, 0x0abec,),  # Meetei Mayek Lum Iyek
    (0x11000, 0x11000,),  # Brahmi Sign Candrabindu
    (0x11002, 0x11002,),  # Brahmi Sign Visarga
    (0x11082, 0x11082,),  # Kaithi Sign Visarga
    (0x110b0, 0x110b2,),  # Kaithi Vowel Sign Aa    ..Kaithi Vowel Sign Ii
    (0x110b7, 0x110b8,),  # Kaithi Vowel Sign O     ..Kaithi Vowel Sign Au
    (0x1112c, 0x1112c,),  # Chakma Vowel Sign E
    (0x11145, 0x11146,),  # Chakma Vowel Sign Aa    ..Chakma Vowel Sign Ei
    (0x11182, 0x11182,),  # Sharada Sign Visarga
    (0x111b3, 0x111b5,),  # Sharada Vowel Sign Aa   ..Sharada Vowel Sign Ii
    (0x111bf, 0x111bf,),  # Sharada Vowel Sign Au
    (0x111ce, 0x111ce,),  # Sharada Vowel Sign Prishthamatra E
    (0x1122c, 0x1122e,),  # Khojki Vowel Sign Aa    ..Khojki Vowel Sign Ii
    (0x11232, 0x11233,),  # Khojki Vowel Sign O     ..Khojki Vowel Sign Au
    (0x112e0, 0x112e2,),  # Khudawadi Vowel Sign Aa ..Khudawadi Vowel Sign Ii
    (0x11302, 0x11303,),  # Grantha Sign Anusvara   ..Grantha Sign Visarga
    (0x1133f, 0x1133f,),  # Grantha Vowel Sign I
    (0x11341, 0x11344,),  # Grantha Vowel Sign U    ..Grantha Vowel Sign Vocal
    (0x11347, 0x11348,),  # Grantha Vowel Sign Ee   ..Grantha Vowel Sign Ai
    (0x1134b, 0x1134c,),  # Grantha Vowel Sign Oo   ..Grantha Vowel Sign Au
    (0x11362, 0x11363,),  # Grantha Vowel Sign Vocal..Grantha Vowel Sign Vocal
    (0x113b9, 0x113ba,),  # Tulu-tigalari Vowel Sign..Tulu-tigalari Vowel Sign
    (0x113ca, 0x113ca,),  # Tulu-tigalari Sign Candra Anunasika
    (0x113cc, 0x113cd,),  # Tulu-tigalari Sign Anusv..Tulu-tigalari Sign Visar
    (0x11435, 0x11437,),  # Newa Vowel Sign Aa      ..Newa Vowel Sign Ii
    (0x11440, 0x11441,),  # Newa Vowel Sign O       ..Newa Vowel Sign Au
    (0x11445, 0x11445,),  # Newa Sign Visarga
    (0x114b1, 0x114b2,),  # Tirhuta Vowel Sign I    ..Tirhuta Vowel Sign Ii
    (0x114b9, 0x114b9,),  # Tirhuta Vowel Sign E
    (0x114bb, 0x114bc,),  # Tirhuta Vowel Sign Ai   ..Tirhuta Vowel Sign O
    (0x114be, 0x114be,),  # Tirhuta Vowel Sign Au
    (0x114c1, 0x114c1,),  # Tirhuta Sign Visarga
    (0x115b0, 0x115b1,),  # Siddham Vowel Sign I    ..Siddham Vowel Sign Ii
    (0x115b8, 0x115bb,),  # Siddham Vowel Sign E    ..Siddham Vowel Sign Au
    (0x115be, 0x115be,),  # Siddham Sign Visarga
    (0x11630, 0x11632,),  # Modi Vowel Sign Aa      ..Modi Vowel Sign Ii
    (0x1163b, 0x1163c,),  # Modi Vowel Sign O       ..Modi Vowel Sign Au
    (0x1163e, 0x1163e,),  # Modi Sign Visarga
    (0x116ac, 0x116ac,),  # Takri Sign Visarga
    (0x116ae, 0x116af,),  # Takri Vowel Sign I      ..Takri Vowel Sign Ii
    (0x1171e, 0x1171e,),  # Ahom Consonant Sign Medial Ra
    (0x11726, 0x11726,),  # Ahom Vowel Sign E
    (0x1182c, 0x1182e,),  # Dogra Vowel Sign Aa     ..Dogra Vowel Sign Ii
    (0x11838, 0x11838,),  # Dogra Sign Visarga
    (0x11931, 0x11935,),  # Dives Akuru Vowel Sign I..Dives Akuru Vowel Sign E
    (0x11937, 0x11938,),  # Dives Akuru Vowel Sign A..Dives Akuru Vowel Sign O
    (0x11940, 0x11940,),  # Dives Akuru Medial Ya
    (0x11942, 0x11942,),  # Dives Akuru Medial Ra
    (0x119d1, 0x119d3,),  # Nandinagari Vowel Sign A..Nandinagari Vowel Sign I
    (0x119dc, 0x119df,),  # Nandinagari Vowel Sign O..Nandinagari Sign Visarga
    (0x119e4, 0x119e4,),  # Nandinagari Vowel Sign Prishthamatra E
    (0x11a39, 0x11a39,),  # Zanabazar Square Sign Visarga
    (0x11a57, 0x11a58,),  # Soyombo Vowel Sign Ai   ..Soyombo Vowel Sign Au
    (0x11a97, 0x11a97,),  # Soyombo Sign Visarga
    (0x11b61, 0x11b61,),  # Sharada Vowel Sign Ooe
    (0x11b65, 0x11b65,),  # Sharada Vowel Sign Short O
    (0x11b67, 0x11b67,),  # Sharada Vowel Sign Candra O
    (0x11c2f, 0x11c2f,),  # Bhaiksuki Vowel Sign Aa
    (0x11c3e, 0x11c3e,),  # Bhaiksuki Sign Visarga
    (0x11ca9, 0x11ca9,),  # Marchen Subjoined Letter Ya
    (0x11cb1, 0x11cb1,),  # Marchen Vowel Sign I
    (0x11cb4, 0x11cb4,),  # Marchen Vowel Sign O
    (0x11d8a, 0x11d8e,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
    (0x11d93, 0x11d94,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
    (0x11d96, 0x11d96,),  # Gunjala Gondi Sign Visarga
    (0x11ef5, 0x11ef6,),  # Makasar Vowel Sign E    ..Makasar Vowel Sign O
    (0x11f03, 0x11f03,),  # Kawi Sign Visarga
    (0x11f34, 0x11f35,),  # Kawi Vowel Sign Aa      ..Kawi Vowel Sign Alternat
    (0x11f3e, 0x11f3f,),  # Kawi Vowel Sign E       ..Kawi Vowel Sign Ai
    (0x1612a, 0x1612c,),  # Gurung Khema Consonant S..Gurung Khema Consonant S
    (0x16f51, 0x16f87,),  # Miao Sign Aspiration    ..Miao Vowel Sign Ui
)

GRAPHEME_L = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x01100, 0x0115f,),  # Hangul Choseong Kiyeok  ..Hangul Choseong Filler
    (0x0a960, 0x0a97c,),  # Hangul Choseong Tikeut-m..Hangul Choseong Ssangyeo
)

GRAPHEME_V = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x01160, 0x011a7,),  # Hangul Jungseong Filler ..Hangul Jungseong O-yae
    (0x0d7b0, 0x0d7c6,),  # Hangul Jungseong O-yeo  ..Hangul Jungseong Araea-e
    (0x16d63, 0x16d63,),  # Kirat Rai Vowel Sign Aa
    (0x16d67, 0x16d6a,),  # Kirat Rai Vowel Sign E  ..Kirat Rai Vowel Sign Au
)

GRAPHEME_T = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x011a8, 0x011ff,),  # Hangul Jongseong Kiyeok ..Hangul Jongseong Ssangni
    (0x0d7cb, 0x0d7fb,),  # Hangul Jongseong Nieun-r..Hangul Jongseong Phieuph
)

GRAPHEME_LV = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x0ac00, 0x0ac00,),  # Hangul Syllable Ga
    (0x0ac1c, 0x0ac1c,),  # Hangul Syllable Gae
    (0x0ac38, 0x0ac38,),  # Hangul Syllable Gya
    (0x0ac54, 0x0ac54,),  # Hangul Syllable Gyae
    (0x0ac70, 0x0ac70,),  # Hangul Syllable Geo
    (0x0ac8c, 0x0ac8c,),  # Hangul Syllable Ge
    (0x0aca8, 0x0aca8,),  # Hangul Syllable Gyeo
    (0x0acc4, 0x0acc4,),  # Hangul Syllable Gye
    (0x0ace0, 0x0ace0,),  # Hangul Syllable Go
    (0x0acfc, 0x0acfc,),  # Hangul Syllable Gwa
    (0x0ad18, 0x0ad18,),  # Hangul Syllable Gwae
    (0x0ad34, 0x0ad34,),  # Hangul Syllable Goe
    (0x0ad50, 0x0ad50,),  # Hangul Syllable Gyo
    (0x0ad6c, 0x0ad6c,),  # Hangul Syllable Gu
    (0x0ad88, 0x0ad88,),  # Hangul Syllable Gweo
    (0x0ada4, 0x0ada4,),  # Hangul Syllable Gwe
    (0x0adc0, 0x0adc0,),  # Hangul Syllable Gwi
    (0x0addc, 0x0addc,),  # Hangul Syllable Gyu
    (0x0adf8, 0x0adf8,),  # Hangul Syllable Geu
    (0x0ae14, 0x0ae14,),  # Hangul Syllable Gyi
    (0x0ae30, 0x0ae30,),  # Hangul Syllable Gi
    (0x0ae4c, 0x0ae4c,),  # Hangul Syllable Gga
    (0x0ae68, 0x0ae68,),  # Hangul Syllable Ggae
    (0x0ae84, 0x0ae84,),  # Hangul Syllable Ggya
    (0x0aea0, 0x0aea0,),  # Hangul Syllable Ggyae
    (0x0aebc, 0x0aebc,),  # Hangul Syllable Ggeo
    (0x0aed8, 0x0aed8,),  # Hangul Syllable Gge
    (0x0aef4, 0x0aef4,),  # Hangul Syllable Ggyeo
    (0x0af10, 0x0af10,),  # Hangul Syllable Ggye
    (0x0af2c, 0x0af2c,),  # Hangul Syllable Ggo
    (0x0af48, 0x0af48,),  # Hangul Syllable Ggwa
    (0x0af64, 0x0af64,),  # Hangul Syllable Ggwae
    (0x0af80, 0x0af80,),  # Hangul Syllable Ggoe
    (0x0af9c, 0x0af9c,),  # Hangul Syllable Ggyo
    (0x0afb8, 0x0afb8,),  # Hangul Syllable Ggu
    (0x0afd4, 0x0afd4,),  # Hangul Syllable Ggweo
    (0x0aff0, 0x0aff0,),  # Hangul Syllable Ggwe
    (0x0b00c, 0x0b00c,),  # Hangul Syllable Ggwi
    (0x0b028, 0x0b028,),  # Hangul Syllable Ggyu
    (0x0b044, 0x0b044,),  # Hangul Syllable Ggeu
    (0x0b060, 0x0b060,),  # Hangul Syllable Ggyi
    (0x0b07c, 0x0b07c,),  # Hangul Syllable Ggi
    (0x0b098, 0x0b098,),  # Hangul Syllable Na
    (0x0b0b4, 0x0b0b4,),  # Hangul Syllable Nae
    (0x0b0d0, 0x0b0d0,),  # Hangul Syllable Nya
    (0x0b0ec, 0x0b0ec,),  # Hangul Syllable Nyae
    (0x0b108, 0x0b108,),  # Hangul Syllable Neo
    (0x0b124, 0x0b124,),  # Hangul Syllable Ne
    (0x0b140, 0x0b140,),  # Hangul Syllable Nyeo
    (0x0b15c, 0x0b15c,),  # Hangul Syllable Nye
    (0x0b178, 0x0b178,),  # Hangul Syllable No
    (0x0b194, 0x0b194,),  # Hangul Syllable Nwa
    (0x0b1b0, 0x0b1b0,),  # Hangul Syllable Nwae
    (0x0b1cc, 0x0b1cc,),  # Hangul Syllable Noe
    (0x0b1e8, 0x0b1e8,),  # Hangul Syllable Nyo
    (0x0b204, 0x0b204,),  # Hangul Syllable Nu
    (0x0b220, 0x0b220,),  # Hangul Syllable Nweo
    (0x0b23c, 0x0b23c,),  # Hangul Syllable Nwe
    (0x0b258, 0x0b258,),  # Hangul Syllable Nwi
    (0x0b274, 0x0b274,),  # Hangul Syllable Nyu
    (0x0b290, 0x0b290,),  # Hangul Syllable Neu
    (0x0b2ac, 0x0b2ac,),  # Hangul Syllable Nyi
    (0x0b2c8, 0x0b2c8,),  # Hangul Syllable Ni
    (0x0b2e4, 0x0b2e4,),  # Hangul Syllable Da
    (0x0b300, 0x0b300,),  # Hangul Syllable Dae
    (0x0b31c, 0x0b31c,),  # Hangul Syllable Dya
    (0x0b338, 0x0b338,),  # Hangul Syllable Dyae
    (0x0b354, 0x0b354,),  # Hangul Syllable Deo
    (0x0b370, 0x0b370,),  # Hangul Syllable De
    (0x0b38c, 0x0b38c,),  # Hangul Syllable Dyeo
    (0x0b3a8, 0x0b3a8,),  # Hangul Syllable Dye
    (0x0b3c4, 0x0b3c4,),  # Hangul Syllable Do
    (0x0b3e0, 0x0b3e0,),  # Hangul Syllable Dwa
    (0x0b3fc, 0x0b3fc,),  # Hangul Syllable Dwae
    (0x0b418, 0x0b418,),  # Hangul Syllable Doe
    (0x0b434, 0x0b434,),  # Hangul Syllable Dyo
    (0x0b450, 0x0b450,),  # Hangul Syllable Du
    (0x0b46c, 0x0b46c,),  # Hangul Syllable Dweo
    (0x0b488, 0x0b488,),  # Hangul Syllable Dwe
    (0x0b4a4, 0x0b4a4,),  # Hangul Syllable Dwi
    (0x0b4c0, 0x0b4c0,),  # Hangul Syllable Dyu
    (0x0b4dc, 0x0b4dc,),  # Hangul Syllable Deu
    (0x0b4f8, 0x0b4f8,),  # Hangul Syllable Dyi
    (0x0b514, 0x0b514,),  # Hangul Syllable Di
    (0x0b530, 0x0b530,),  # Hangul Syllable Dda
    (0x0b54c, 0x0b54c,),  # Hangul Syllable Ddae
    (0x0b568, 0x0b568,),  # Hangul Syllable Ddya
    (0x0b584, 0x0b584,),  # Hangul Syllable Ddyae
    (0x0b5a0, 0x0b5a0,),  # Hangul Syllable Ddeo
    (0x0b5bc, 0x0b5bc,),  # Hangul Syllable Dde
    (0x0b5d8, 0x0b5d8,),  # Hangul Syllable Ddyeo
    (0x0b5f4, 0x0b5f4,),  # Hangul Syllable Ddye
    (0x0b610, 0x0b610,),  # Hangul Syllable Ddo
    (0x0b62c, 0x0b62c,),  # Hangul Syllable Ddwa
    (0x0b648, 0x0b648,),  # Hangul Syllable Ddwae
    (0x0b664, 0x0b664,),  # Hangul Syllable Ddoe
    (0x0b680, 0x0b680,),  # Hangul Syllable Ddyo
    (0x0b69c, 0x0b69c,),  # Hangul Syllable Ddu
    (0x0b6b8, 0x0b6b8,),  # Hangul Syllable Ddweo
    (0x0b6d4, 0x0b6d4,),  # Hangul Syllable Ddwe
    (0x0b6f0, 0x0b6f0,),  # Hangul Syllable Ddwi
    (0x0b70c, 0x0b70c,),  # Hangul Syllable Ddyu
    (0x0b728, 0x0b728,),  # Hangul Syllable Ddeu
    (0x0b744, 0x0b744,),  # Hangul Syllable Ddyi
    (0x0b760, 0x0b760,),  # Hangul Syllable Ddi
    (0x0b77c, 0x0b77c,),  # Hangul Syllable Ra
    (0x0b798, 0x0b798,),  # Hangul Syllable Rae
    (0x0b7b4, 0x0b7b4,),  # Hangul Syllable Rya
    (0x0b7d0, 0x0b7d0,),  # Hangul Syllable Ryae
    (0x0b7ec, 0x0b7ec,),  # Hangul Syllable Reo
    (0x0b808, 0x0b808,),  # Hangul Syllable Re
    (0x0b824, 0x0b824,),  # Hangul Syllable Ryeo
    (0x0b840, 0x0b840,),  # Hangul Syllable Rye
    (0x0b85c, 0x0b85c,),  # Hangul Syllable Ro
    (0x0b878, 0x0b878,),  # Hangul Syllable Rwa
    (0x0b894, 0x0b894,),  # Hangul Syllable Rwae
    (0x0b8b0, 0x0b8b0,),  # Hangul Syllable Roe
    (0x0b8cc, 0x0b8cc,),  # Hangul Syllable Ryo
    (0x0b8e8, 0x0b8e8,),  # Hangul Syllable Ru
    (0x0b904, 0x0b904,),  # Hangul Syllable Rweo
    (0x0b920, 0x0b920,),  # Hangul Syllable Rwe
    (0x0b93c, 0x0b93c,),  # Hangul Syllable Rwi
    (0x0b958, 0x0b958,),  # Hangul Syllable Ryu
    (0x0b974, 0x0b974,),  # Hangul Syllable Reu
    (0x0b990, 0x0b990,),  # Hangul Syllable Ryi
    (0x0b9ac, 0x0b9ac,),  # Hangul Syllable Ri
    (0x0b9c8, 0x0b9c8,),  # Hangul Syllable Ma
    (0x0b9e4, 0x0b9e4,),  # Hangul Syllable Mae
    (0x0ba00, 0x0ba00,),  # Hangul Syllable Mya
    (0x0ba1c, 0x0ba1c,),  # Hangul Syllable Myae
    (0x0ba38, 0x0ba38,),  # Hangul Syllable Meo
    (0x0ba54, 0x0ba54,),  # Hangul Syllable Me
    (0x0ba70, 0x0ba70,),  # Hangul Syllable Myeo
    (0x0ba8c, 0x0ba8c,),  # Hangul Syllable Mye
    (0x0baa8, 0x0baa8,),  # Hangul Syllable Mo
    (0x0bac4, 0x0bac4,),  # Hangul Syllable Mwa
    (0x0bae0, 0x0bae0,),  # Hangul Syllable Mwae
    (0x0bafc, 0x0bafc,),  # Hangul Syllable Moe
    (0x0bb18, 0x0bb18,),  # Hangul Syllable Myo
    (0x0bb34, 0x0bb34,),  # Hangul Syllable Mu
    (0x0bb50, 0x0bb50,),  # Hangul Syllable Mweo
    (0x0bb6c, 0x0bb6c,),  # Hangul Syllable Mwe
    (0x0bb88, 0x0bb88,),  # Hangul Syllable Mwi
    (0x0bba4, 0x0bba4,),  # Hangul Syllable Myu
    (0x0bbc0, 0x0bbc0,),  # Hangul Syllable Meu
    (0x0bbdc, 0x0bbdc,),  # Hangul Syllable Myi
    (0x0bbf8, 0x0bbf8,),  # Hangul Syllable Mi
    (0x0bc14, 0x0bc14,),  # Hangul Syllable Ba
    (0x0bc30, 0x0bc30,),  # Hangul Syllable Bae
    (0x0bc4c, 0x0bc4c,),  # Hangul Syllable Bya
    (0x0bc68, 0x0bc68,),  # Hangul Syllable Byae
    (0x0bc84, 0x0bc84,),  # Hangul Syllable Beo
    (0x0bca0, 0x0bca0,),  # Hangul Syllable Be
    (0x0bcbc, 0x0bcbc,),  # Hangul Syllable Byeo
    (0x0bcd8, 0x0bcd8,),  # Hangul Syllable Bye
    (0x0bcf4, 0x0bcf4,),  # Hangul Syllable Bo
    (0x0bd10, 0x0bd10,),  # Hangul Syllable Bwa
    (0x0bd2c, 0x0bd2c,),  # Hangul Syllable Bwae
    (0x0bd48, 0x0bd48,),  # Hangul Syllable Boe
    (0x0bd64, 0x0bd64,),  # Hangul Syllable Byo
    (0x0bd80, 0x0bd80,),  # Hangul Syllable Bu
    (0x0bd9c, 0x0bd9c,),  # Hangul Syllable Bweo
    (0x0bdb8, 0x0bdb8,),  # Hangul Syllable Bwe
    (0x0bdd4, 0x0bdd4,),  # Hangul Syllable Bwi
    (0x0bdf0, 0x0bdf0,),  # Hangul Syllable Byu
    (0x0be0c, 0x0be0c,),  # Hangul Syllable Beu
    (0x0be28, 0x0be28,),  # Hangul Syllable Byi
    (0x0be44, 0x0be44,),  # Hangul Syllable Bi
    (0x0be60, 0x0be60,),  # Hangul Syllable Bba
    (0x0be7c, 0x0be7c,),  # Hangul Syllable Bbae
    (0x0be98, 0x0be98,),  # Hangul Syllable Bbya
    (0x0beb4, 0x0beb4,),  # Hangul Syllable Bbyae
    (0x0bed0, 0x0bed0,),  # Hangul Syllable Bbeo
    (0x0beec, 0x0beec,),  # Hangul Syllable Bbe
    (0x0bf08, 0x0bf08,),  # Hangul Syllable Bbyeo
    (0x0bf24, 0x0bf24,),  # Hangul Syllable Bbye
    (0x0bf40, 0x0bf40,),  # Hangul Syllable Bbo
    (0x0bf5c, 0x0bf5c,),  # Hangul Syllable Bbwa
    (0x0bf78, 0x0bf78,),  # Hangul Syllable Bbwae
    (0x0bf94, 0x0bf94,),  # Hangul Syllable Bboe
    (0x0bfb0, 0x0bfb0,),  # Hangul Syllable Bbyo
    (0x0bfcc, 0x0bfcc,),  # Hangul Syllable Bbu
    (0x0bfe8, 0x0bfe8,),  # Hangul Syllable Bbweo
    (0x0c004, 0x0c004,),  # Hangul Syllable Bbwe
    (0x0c020, 0x0c020,),  # Hangul Syllable Bbwi
    (0x0c03c, 0x0c03c,),  # Hangul Syllable Bbyu
    (0x0c058, 0x0c058,),  # Hangul Syllable Bbeu
    (0x0c074, 0x0c074,),  # Hangul Syllable Bbyi
    (0x0c090, 0x0c090,),  # Hangul Syllable Bbi
    (0x0c0ac, 0x0c0ac,),  # Hangul Syllable Sa
    (0x0c0c8, 0x0c0c8,),  # Hangul Syllable Sae
    (0x0c0e4, 0x0c0e4,),  # Hangul Syllable Sya
    (0x0c100, 0x0c100,),  # Hangul Syllable Syae
    (0x0c11c, 0x0c11c,),  # Hangul Syllable Seo
    (0x0c138, 0x0c138,),  # Hangul Syllable Se
    (0x0c154, 0x0c154,),  # Hangul Syllable Syeo
    (0x0c170, 0x0c170,),  # Hangul Syllable Sye
    (0x0c18c, 0x0c18c,),  # Hangul Syllable So
    (0x0c1a8, 0x0c1a8,),  # Hangul Syllable Swa
    (0x0c1c4, 0x0c1c4,),  # Hangul Syllable Swae
    (0x0c1e0, 0x0c1e0,),  # Hangul Syllable Soe
    (0x0c1fc, 0x0c1fc,),  # Hangul Syllable Syo
    (0x0c218, 0x0c218,),  # Hangul Syllable Su
    (0x0c234, 0x0c234,),  # Hangul Syllable Sweo
    (0x0c250, 0x0c250,),  # Hangul Syllable Swe
    (0x0c26c, 0x0c26c,),  # Hangul Syllable Swi
    (0x0c288, 0x0c288,),  # Hangul Syllable Syu
    (0x0c2a4, 0x0c2a4,),  # Hangul Syllable Seu
    (0x0c2c0, 0x0c2c0,),  # Hangul Syllable Syi
    (0x0c2dc, 0x0c2dc,),  # Hangul Syllable Si
    (0x0c2f8, 0x0c2f8,),  # Hangul Syllable Ssa
    (0x0c314, 0x0c314,),  # Hangul Syllable Ssae
    (0x0c330, 0x0c330,),  # Hangul Syllable Ssya
    (0x0c34c, 0x0c34c,),  # Hangul Syllable Ssyae
    (0x0c368, 0x0c368,),  # Hangul Syllable Sseo
    (0x0c384, 0x0c384,),  # Hangul Syllable Sse
    (0x0c3a0, 0x0c3a0,),  # Hangul Syllable Ssyeo
    (0x0c3bc, 0x0c3bc,),  # Hangul Syllable Ssye
    (0x0c3d8, 0x0c3d8,),  # Hangul Syllable Sso
    (0x0c3f4, 0x0c3f4,),  # Hangul Syllable Sswa
    (0x0c410, 0x0c410,),  # Hangul Syllable Sswae
    (0x0c42c, 0x0c42c,),  # Hangul Syllable Ssoe
    (0x0c448, 0x0c448,),  # Hangul Syllable Ssyo
    (0x0c464, 0x0c464,),  # Hangul Syllable Ssu
    (0x0c480, 0x0c480,),  # Hangul Syllable Ssweo
    (0x0c49c, 0x0c49c,),  # Hangul Syllable Sswe
    (0x0c4b8, 0x0c4b8,),  # Hangul Syllable Sswi
    (0x0c4d4, 0x0c4d4,),  # Hangul Syllable Ssyu
    (0x0c4f0, 0x0c4f0,),  # Hangul Syllable Sseu
    (0x0c50c, 0x0c50c,),  # Hangul Syllable Ssyi
    (0x0c528, 0x0c528,),  # Hangul Syllable Ssi
    (0x0c544, 0x0c544,),  # Hangul Syllable A
    (0x0c560, 0x0c560,),  # Hangul Syllable Ae
    (0x0c57c, 0x0c57c,),  # Hangul Syllable Ya
    (0x0c598, 0x0c598,),  # Hangul Syllable Yae
    (0x0c5b4, 0x0c5b4,),  # Hangul Syllable Eo
    (0x0c5d0, 0x0c5d0,),  # Hangul Syllable E
    (0x0c5ec, 0x0c5ec,),  # Hangul Syllable Yeo
    (0x0c608, 0x0c608,),  # Hangul Syllable Ye
    (0x0c624, 0x0c624,),  # Hangul Syllable O
    (0x0c640, 0x0c640,),  # Hangul Syllable Wa
    (0x0c65c, 0x0c65c,),  # Hangul Syllable Wae
    (0x0c678, 0x0c678,),  # Hangul Syllable Oe
    (0x0c694, 0x0c694,),  # Hangul Syllable Yo
    (0x0c6b0, 0x0c6b0,),  # Hangul Syllable U
    (0x0c6cc, 0x0c6cc,),  # Hangul Syllable Weo
    (0x0c6e8, 0x0c6e8,),  # Hangul Syllable We
    (0x0c704, 0x0c704,),  # Hangul Syllable Wi
    (0x0c720, 0x0c720,),  # Hangul Syllable Yu
    (0x0c73c, 0x0c73c,),  # Hangul Syllable Eu
    (0x0c758, 0x0c758,),  # Hangul Syllable Yi
    (0x0c774, 0x0c774,),  # Hangul Syllable I
    (0x0c790, 0x0c790,),  # Hangul Syllable Ja
    (0x0c7ac, 0x0c7ac,),  # Hangul Syllable Jae
    (0x0c7c8, 0x0c7c8,),  # Hangul Syllable Jya
    (0x0c7e4, 0x0c7e4,),  # Hangul Syllable Jyae
    (0x0c800, 0x0c800,),  # Hangul Syllable Jeo
    (0x0c81c, 0x0c81c,),  # Hangul Syllable Je
    (0x0c838, 0x0c838,),  # Hangul Syllable Jyeo
    (0x0c854, 0x0c854,),  # Hangul Syllable Jye
    (0x0c870, 0x0c870,),  # Hangul Syllable Jo
    (0x0c88c, 0x0c88c,),  # Hangul Syllable Jwa
    (0x0c8a8, 0x0c8a8,),  # Hangul Syllable Jwae
    (0x0c8c4, 0x0c8c4,),  # Hangul Syllable Joe
    (0x0c8e0, 0x0c8e0,),  # Hangul Syllable Jyo
    (0x0c8fc, 0x0c8fc,),  # Hangul Syllable Ju
    (0x0c918, 0x0c918,),  # Hangul Syllable Jweo
    (0x0c934, 0x0c934,),  # Hangul Syllable Jwe
    (0x0c950, 0x0c950,),  # Hangul Syllable Jwi
    (0x0c96c, 0x0c96c,),  # Hangul Syllable Jyu
    (0x0c988, 0x0c988,),  # Hangul Syllable Jeu
    (0x0c9a4, 0x0c9a4,),  # Hangul Syllable Jyi
    (0x0c9c0, 0x0c9c0,),  # Hangul Syllable Ji
    (0x0c9dc, 0x0c9dc,),  # Hangul Syllable Jja
    (0x0c9f8, 0x0c9f8,),  # Hangul Syllable Jjae
    (0x0ca14, 0x0ca14,),  # Hangul Syllable Jjya
    (0x0ca30, 0x0ca30,),  # Hangul Syllable Jjyae
    (0x0ca4c, 0x0ca4c,),  # Hangul Syllable Jjeo
    (0x0ca68, 0x0ca68,),  # Hangul Syllable Jje
    (0x0ca84, 0x0ca84,),  # Hangul Syllable Jjyeo
    (0x0caa0, 0x0caa0,),  # Hangul Syllable Jjye
    (0x0cabc, 0x0cabc,),  # Hangul Syllable Jjo
    (0x0cad8, 0x0cad8,),  # Hangul Syllable Jjwa
    (0x0caf4, 0x0caf4,),  # Hangul Syllable Jjwae
    (0x0cb10, 0x0cb10,),  # Hangul Syllable Jjoe
    (0x0cb2c, 0x0cb2c,),  # Hangul Syllable Jjyo
    (0x0cb48, 0x0cb48,),  # Hangul Syllable Jju
    (0x0cb64, 0x0cb64,),  # Hangul Syllable Jjweo
    (0x0cb80, 0x0cb80,),  # Hangul Syllable Jjwe
    (0x0cb9c, 0x0cb9c,),  # Hangul Syllable Jjwi
    (0x0cbb8, 0x0cbb8,),  # Hangul Syllable Jjyu
    (0x0cbd4, 0x0cbd4,),  # Hangul Syllable Jjeu
    (0x0cbf0, 0x0cbf0,),  # Hangul Syllable Jjyi
    (0x0cc0c, 0x0cc0c,),  # Hangul Syllable Jji
    (0x0cc28, 0x0cc28,),  # Hangul Syllable Ca
    (0x0cc44, 0x0cc44,),  # Hangul Syllable Cae
    (0x0cc60, 0x0cc60,),  # Hangul Syllable Cya
    (0x0cc7c, 0x0cc7c,),  # Hangul Syllable Cyae
    (0x0cc98, 0x0cc98,),  # Hangul Syllable Ceo
    (0x0ccb4, 0x0ccb4,),  # Hangul Syllable Ce
    (0x0ccd0, 0x0ccd0,),  # Hangul Syllable Cyeo
    (0x0ccec, 0x0ccec,),  # Hangul Syllable Cye
    (0x0cd08, 0x0cd08,),  # Hangul Syllable Co
    (0x0cd24, 0x0cd24,),  # Hangul Syllable Cwa
    (0x0cd40, 0x0cd40,),  # Hangul Syllable Cwae
    (0x0cd5c, 0x0cd5c,),  # Hangul Syllable Coe
    (0x0cd78, 0x0cd78,),  # Hangul Syllable Cyo
    (0x0cd94, 0x0cd94,),  # Hangul Syllable Cu
    (0x0cdb0, 0x0cdb0,),  # Hangul Syllable Cweo
    (0x0cdcc, 0x0cdcc,),  # Hangul Syllable Cwe
    (0x0cde8, 0x0cde8,),  # Hangul Syllable Cwi
    (0x0ce04, 0x0ce04,),  # Hangul Syllable Cyu
    (0x0ce20, 0x0ce20,),  # Hangul Syllable Ceu
    (0x0ce3c, 0x0ce3c,),  # Hangul Syllable Cyi
    (0x0ce58, 0x0ce58,),  # Hangul Syllable Ci
    (0x0ce74, 0x0ce74,),  # Hangul Syllable Ka
    (0x0ce90, 0x0ce90,),  # Hangul Syllable Kae
    (0x0ceac, 0x0ceac,),  # Hangul Syllable Kya
    (0x0cec8, 0x0cec8,),  # Hangul Syllable Kyae
    (0x0cee4, 0x0cee4,),  # Hangul Syllable Keo
    (0x0cf00, 0x0cf00,),  # Hangul Syllable Ke
    (0x0cf1c, 0x0cf1c,),  # Hangul Syllable Kyeo
    (0x0cf38, 0x0cf38,),  # Hangul Syllable Kye
    (0x0cf54, 0x0cf54,),  # Hangul Syllable Ko
    (0x0cf70, 0x0cf70,),  # Hangul Syllable Kwa
    (0x0cf8c, 0x0cf8c,),  # Hangul Syllable Kwae
    (0x0cfa8, 0x0cfa8,),  # Hangul Syllable Koe
    (0x0cfc4, 0x0cfc4,),  # Hangul Syllable Kyo
    (0x0cfe0, 0x0cfe0,),  # Hangul Syllable Ku
    (0x0cffc, 0x0cffc,),  # Hangul Syllable Kweo
    (0x0d018, 0x0d018,),  # Hangul Syllable Kwe
    (0x0d034, 0x0d034,),  # Hangul Syllable Kwi
    (0x0d050, 0x0d050,),  # Hangul Syllable Kyu
    (0x0d06c, 0x0d06c,),  # Hangul Syllable Keu
    (0x0d088, 0x0d088,),  # Hangul Syllable Kyi
    (0x0d0a4, 0x0d0a4,),  # Hangul Syllable Ki
    (0x0d0c0, 0x0d0c0,),  # Hangul Syllable Ta
    (0x0d0dc, 0x0d0dc,),  # Hangul Syllable Tae
    (0x0d0f8, 0x0d0f8,),  # Hangul Syllable Tya
    (0x0d114, 0x0d114,),  # Hangul Syllable Tyae
    (0x0d130, 0x0d130,),  # Hangul Syllable Teo
    (0x0d14c, 0x0d14c,),  # Hangul Syllable Te
    (0x0d168, 0x0d168,),  # Hangul Syllable Tyeo
    (0x0d184, 0x0d184,),  # Hangul Syllable Tye
    (0x0d1a0, 0x0d1a0,),  # Hangul Syllable To
    (0x0d1bc, 0x0d1bc,),  # Hangul Syllable Twa
    (0x0d1d8, 0x0d1d8,),  # Hangul Syllable Twae
    (0x0d1f4, 0x0d1f4,),  # Hangul Syllable Toe
    (0x0d210, 0x0d210,),  # Hangul Syllable Tyo
    (0x0d22c, 0x0d22c,),  # Hangul Syllable Tu
    (0x0d248, 0x0d248,),  # Hangul Syllable Tweo
    (0x0d264, 0x0d264,),  # Hangul Syllable Twe
    (0x0d280, 0x0d280,),  # Hangul Syllable Twi
    (0x0d29c, 0x0d29c,),  # Hangul Syllable Tyu
    (0x0d2b8, 0x0d2b8,),  # Hangul Syllable Teu
    (0x0d2d4, 0x0d2d4,),  # Hangul Syllable Tyi
    (0x0d2f0, 0x0d2f0,),  # Hangul Syllable Ti
    (0x0d30c, 0x0d30c,),  # Hangul Syllable Pa
    (0x0d328, 0x0d328,),  # Hangul Syllable Pae
    (0x0d344, 0x0d344,),  # Hangul Syllable Pya
    (0x0d360, 0x0d360,),  # Hangul Syllable Pyae
    (0x0d37c, 0x0d37c,),  # Hangul Syllable Peo
    (0x0d398, 0x0d398,),  # Hangul Syllable Pe
    (0x0d3b4, 0x0d3b4,),  # Hangul Syllable Pyeo
    (0x0d3d0, 0x0d3d0,),  # Hangul Syllable Pye
    (0x0d3ec, 0x0d3ec,),  # Hangul Syllable Po
    (0x0d408, 0x0d408,),  # Hangul Syllable Pwa
    (0x0d424, 0x0d424,),  # Hangul Syllable Pwae
    (0x0d440, 0x0d440,),  # Hangul Syllable Poe
    (0x0d45c, 0x0d45c,),  # Hangul Syllable Pyo
    (0x0d478, 0x0d478,),  # Hangul Syllable Pu
    (0x0d494, 0x0d494,),  # Hangul Syllable Pweo
    (0x0d4b0, 0x0d4b0,),  # Hangul Syllable Pwe
    (0x0d4cc, 0x0d4cc,),  # Hangul Syllable Pwi
    (0x0d4e8, 0x0d4e8,),  # Hangul Syllable Pyu
    (0x0d504, 0x0d504,),  # Hangul Syllable Peu
    (0x0d520, 0x0d520,),  # Hangul Syllable Pyi
    (0x0d53c, 0x0d53c,),  # Hangul Syllable Pi
    (0x0d558, 0x0d558,),  # Hangul Syllable Ha
    (0x0d574, 0x0d574,),  # Hangul Syllable Hae
    (0x0d590, 0x0d590,),  # Hangul Syllable Hya
    (0x0d5ac, 0x0d5ac,),  # Hangul Syllable Hyae
    (0x0d5c8, 0x0d5c8,),  # Hangul Syllable Heo
    (0x0d5e4, 0x0d5e4,),  # Hangul Syllable He
    (0x0d600, 0x0d600,),  # Hangul Syllable Hyeo
    (0x0d61c, 0x0d61c,),  # Hangul Syllable Hye
    (0x0d638, 0x0d638,),  # Hangul Syllable Ho
    (0x0d654, 0x0d654,),  # Hangul Syllable Hwa
    (0x0d670, 0x0d670,),  # Hangul Syllable Hwae
    (0x0d68c, 0x0d68c,),  # Hangul Syllable Hoe
    (0x0d6a8, 0x0d6a8,),  # Hangul Syllable Hyo
    (0x0d6c4, 0x0d6c4,),  # Hangul Syllable Hu
    (0x0d6e0, 0x0d6e0,),  # Hangul Syllable Hweo
    (0x0d6fc, 0x0d6fc,),  # Hangul Syllable Hwe
    (0x0d718, 0x0d718,),  # Hangul Syllable Hwi
    (0x0d734, 0x0d734,),  # Hangul Syllable Hyu
    (0x0d750, 0x0d750,),  # Hangul Syllable Heu
    (0x0d76c, 0x0d76c,),  # Hangul Syllable Hyi
    (0x0d788, 0x0d788,),  # Hangul Syllable Hi
)

GRAPHEME_LVT = (
    # Source: GraphemeBreakProperty-17.0.0.txt
    # Date: 2025-06-30, 06:20:23 GMT
    #
    (0x0ac01, 0x0ac1b,),  # Hangul Syllable Gag     ..Hangul Syllable Gah
    (0x0ac1d, 0x0ac37,),  # Hangul Syllable Gaeg    ..Hangul Syllable Gaeh
    (0x0ac39, 0x0ac53,),  # Hangul Syllable Gyag    ..Hangul Syllable Gyah
    (0x0ac55, 0x0ac6f,),  # Hangul Syllable Gyaeg   ..Hangul Syllable Gyaeh
    (0x0ac71, 0x0ac8b,),  # Hangul Syllable Geog    ..Hangul Syllable Geoh
    (0x0ac8d, 0x0aca7,),  # Hangul Syllable Geg     ..Hangul Syllable Geh
    (0x0aca9, 0x0acc3,),  # Hangul Syllable Gyeog   ..Hangul Syllable Gyeoh
    (0x0acc5, 0x0acdf,),  # Hangul Syllable Gyeg    ..Hangul Syllable Gyeh
    (0x0ace1, 0x0acfb,),  # Hangul Syllable Gog     ..Hangul Syllable Goh
    (0x0acfd, 0x0ad17,),  # Hangul Syllable Gwag    ..Hangul Syllable Gwah
    (0x0ad19, 0x0ad33,),  # Hangul Syllable Gwaeg   ..Hangul Syllable Gwaeh
    (0x0ad35, 0x0ad4f,),  # Hangul Syllable Goeg    ..Hangul Syllable Goeh
    (0x0ad51, 0x0ad6b,),  # Hangul Syllable Gyog    ..Hangul Syllable Gyoh
    (0x0ad6d, 0x0ad87,),  # Hangul Syllable Gug     ..Hangul Syllable Guh
    (0x0ad89, 0x0ada3,),  # Hangul Syllable Gweog   ..Hangul Syllable Gweoh
    (0x0ada5, 0x0adbf,),  # Hangul Syllable Gweg    ..Hangul Syllable Gweh
    (0x0adc1, 0x0addb,),  # Hangul Syllable Gwig    ..Hangul Syllable Gwih
    (0x0addd, 0x0adf7,),  # Hangul Syllable Gyug    ..Hangul Syllable Gyuh
    (0x0adf9, 0x0ae13,),  # Hangul Syllable Geug    ..Hangul Syllable Geuh
    (0x0ae15, 0x0ae2f,),  # Hangul Syllable Gyig    ..Hangul Syllable Gyih
    (0x0ae31, 0x0ae4b,),  # Hangul Syllable Gig     ..Hangul Syllable Gih
    (0x0ae4d, 0x0ae67,),  # Hangul Syllable Ggag    ..Hangul Syllable Ggah
    (0x0ae69, 0x0ae83,),  # Hangul Syllable Ggaeg   ..Hangul Syllable Ggaeh
    (0x0ae85, 0x0ae9f,),  # Hangul Syllable Ggyag   ..Hangul Syllable Ggyah
    (0x0aea1, 0x0aebb,),  # Hangul Syllable Ggyaeg  ..Hangul Syllable Ggyaeh
    (0x0aebd, 0x0aed7,),  # Hangul Syllable Ggeog   ..Hangul Syllable Ggeoh
    (0x0aed9, 0x0aef3,),  # Hangul Syllable Ggeg    ..Hangul Syllable Ggeh
    (0x0aef5, 0x0af0f,),  # Hangul Syllable Ggyeog  ..Hangul Syllable Ggyeoh
    (0x0af11, 0x0af2b,),  # Hangul Syllable Ggyeg   ..Hangul Syllable Ggyeh
    (0x0af2d, 0x0af47,),  # Hangul Syllable Ggog    ..Hangul Syllable Ggoh
    (0x0af49, 0x0af63,),  # Hangul Syllable Ggwag   ..Hangul Syllable Ggwah
    (0x0af65, 0x0af7f,),  # Hangul Syllable Ggwaeg  ..Hangul Syllable Ggwaeh
    (0x0af81, 0x0af9b,),  # Hangul Syllable Ggoeg   ..Hangul Syllable Ggoeh
    (0x0af9d, 0x0afb7,),  # Hangul Syllable Ggyog   ..Hangul Syllable Ggyoh
    (0x0afb9, 0x0afd3,),  # Hangul Syllable Ggug    ..Hangul Syllable Gguh
    (0x0afd5, 0x0afef,),  # Hangul Syllable Ggweog  ..Hangul Syllable Ggweoh
    (0x0aff1, 0x0b00b,),  # Hangul Syllable Ggweg   ..Hangul Syllable Ggweh
    (0x0b00d, 0x0b027,),  # Hangul Syllable Ggwig   ..Hangul Syllable Ggwih
    (0x0b029, 0x0b043,),  # Hangul Syllable Ggyug   ..Hangul Syllable Ggyuh
    (0x0b045, 0x0b05f,),  # Hangul Syllable Ggeug   ..Hangul Syllable Ggeuh
    (0x0b061, 0x0b07b,),  # Hangul Syllable Ggyig   ..Hangul Syllable Ggyih
    (0x0b07d, 0x0b097,),  # Hangul Syllable Ggig    ..Hangul Syllable Ggih
    (0x0b099, 0x0b0b3,),  # Hangul Syllable Nag     ..Hangul Syllable Nah
    (0x0b0b5, 0x0b0cf,),  # Hangul Syllable Naeg    ..Hangul Syllable Naeh
    (0x0b0d1, 0x0b0eb,),  # Hangul Syllable Nyag    ..Hangul Syllable Nyah
    (0x0b0ed, 0x0b107,),  # Hangul Syllable Nyaeg   ..Hangul Syllable Nyaeh
    (0x0b109, 0x0b123,),  # Hangul Syllable Neog    ..Hangul Syllable Neoh
    (0x0b125, 0x0b13f,),  # Hangul Syllable Neg     ..Hangul Syllable Neh
    (0x0b141, 0x0b15b,),  # Hangul Syllable Nyeog   ..Hangul Syllable Nyeoh
    (0x0b15d, 0x0b177,),  # Hangul Syllable Nyeg    ..Hangul Syllable Nyeh
    (0x0b179, 0x0b193,),  # Hangul Syllable Nog     ..Hangul Syllable Noh
    (0x0b195, 0x0b1af,),  # Hangul Syllable Nwag    ..Hangul Syllable Nwah
    (0x0b1b1, 0x0b1cb,),  # Hangul Syllable Nwaeg   ..Hangul Syllable Nwaeh
    (0x0b1cd, 0x0b1e7,),  # Hangul Syllable Noeg    ..Hangul Syllable Noeh
    (0x0b1e9, 0x0b203,),  # Hangul Syllable Nyog    ..Hangul Syllable Nyoh
    (0x0b205, 0x0b21f,),  # Hangul Syllable Nug     ..Hangul Syllable Nuh
    (0x0b221, 0x0b23b,),  # Hangul Syllable Nweog   ..Hangul Syllable Nweoh
    (0x0b23d, 0x0b257,),  # Hangul Syllable Nweg    ..Hangul Syllable Nweh
    (0x0b259, 0x0b273,),  # Hangul Syllable Nwig    ..Hangul Syllable Nwih
    (0x0b275, 0x0b28f,),  # Hangul Syllable Nyug    ..Hangul Syllable Nyuh
    (0x0b291, 0x0b2ab,),  # Hangul Syllable Neug    ..Hangul Syllable Neuh
    (0x0b2ad, 0x0b2c7,),  # Hangul Syllable Nyig    ..Hangul Syllable Nyih
    (0x0b2c9, 0x0b2e3,),  # Hangul Syllable Nig     ..Hangul Syllable Nih
    (0x0b2e5, 0x0b2ff,),  # Hangul Syllable Dag     ..Hangul Syllable Dah
    (0x0b301, 0x0b31b,),  # Hangul Syllable Daeg    ..Hangul Syllable Daeh
    (0x0b31d, 0x0b337,),  # Hangul Syllable Dyag    ..Hangul Syllable Dyah
    (0x0b339, 0x0b353,),  # Hangul Syllable Dyaeg   ..Hangul Syllable Dyaeh
    (0x0b355, 0x0b36f,),  # Hangul Syllable Deog    ..Hangul Syllable Deoh
    (0x0b371, 0x0b38b,),  # Hangul Syllable Deg     ..Hangul Syllable Deh
    (0x0b38d, 0x0b3a7,),  # Hangul Syllable Dyeog   ..Hangul Syllable Dyeoh
    (0x0b3a9, 0x0b3c3,),  # Hangul Syllable Dyeg    ..Hangul Syllable Dyeh
    (0x0b3c5, 0x0b3df,),  # Hangul Syllable Dog     ..Hangul Syllable Doh
    (0x0b3e1, 0x0b3fb,),  # Hangul Syllable Dwag    ..Hangul Syllable Dwah
    (0x0b3fd, 0x0b417,),  # Hangul Syllable Dwaeg   ..Hangul Syllable Dwaeh
    (0x0b419, 0x0b433,),  # Hangul Syllable Doeg    ..Hangul Syllable Doeh
    (0x0b435, 0x0b44f,),  # Hangul Syllable Dyog    ..Hangul Syllable Dyoh
    (0x0b451, 0x0b46b,),  # Hangul Syllable Dug     ..Hangul Syllable Duh
    (0x0b46d, 0x0b487,),  # Hangul Syllable Dweog   ..Hangul Syllable Dweoh
    (0x0b489, 0x0b4a3,),  # Hangul Syllable Dweg    ..Hangul Syllable Dweh
    (0x0b4a5, 0x0b4bf,),  # Hangul Syllable Dwig    ..Hangul Syllable Dwih
    (0x0b4c1, 0x0b4db,),  # Hangul Syllable Dyug    ..Hangul Syllable Dyuh
    (0x0b4dd, 0x0b4f7,),  # Hangul Syllable Deug    ..Hangul Syllable Deuh
    (0x0b4f9, 0x0b513,),  # Hangul Syllable Dyig    ..Hangul Syllable Dyih
    (0x0b515, 0x0b52f,),  # Hangul Syllable Dig     ..Hangul Syllable Dih
    (0x0b531, 0x0b54b,),  # Hangul Syllable Ddag    ..Hangul Syllable Ddah
    (0x0b54d, 0x0b567,),  # Hangul Syllable Ddaeg   ..Hangul Syllable Ddaeh
    (0x0b569, 0x0b583,),  # Hangul Syllable Ddyag   ..Hangul Syllable Ddyah
    (0x0b585, 0x0b59f,),  # Hangul Syllable Ddyaeg  ..Hangul Syllable Ddyaeh
    (0x0b5a1, 0x0b5bb,),  # Hangul Syllable Ddeog   ..Hangul Syllable Ddeoh
    (0x0b5bd, 0x0b5d7,),  # Hangul Syllable Ddeg    ..Hangul Syllable Ddeh
    (0x0b5d9, 0x0b5f3,),  # Hangul Syllable Ddyeog  ..Hangul Syllable Ddyeoh
    (0x0b5f5, 0x0b60f,),  # Hangul Syllable Ddyeg   ..Hangul Syllable Ddyeh
    (0x0b611, 0x0b62b,),  # Hangul Syllable Ddog    ..Hangul Syllable Ddoh
    (0x0b62d, 0x0b647,),  # Hangul Syllable Ddwag   ..Hangul Syllable Ddwah
    (0x0b649, 0x0b663,),  # Hangul Syllable Ddwaeg  ..Hangul Syllable Ddwaeh
    (0x0b665, 0x0b67f,),  # Hangul Syllable Ddoeg   ..Hangul Syllable Ddoeh
    (0x0b681, 0x0b69b,),  # Hangul Syllable Ddyog   ..Hangul Syllable Ddyoh
    (0x0b69d, 0x0b6b7,),  # Hangul Syllable Ddug    ..Hangul Syllable Dduh
    (0x0b6b9, 0x0b6d3,),  # Hangul Syllable Ddweog  ..Hangul Syllable Ddweoh
    (0x0b6d5, 0x0b6ef,),  # Hangul Syllable Ddweg   ..Hangul Syllable Ddweh
    (0x0b6f1, 0x0b70b,),  # Hangul Syllable Ddwig   ..Hangul Syllable Ddwih
    (0x0b70d, 0x0b727,),  # Hangul Syllable Ddyug   ..Hangul Syllable Ddyuh
    (0x0b729, 0x0b743,),  # Hangul Syllable Ddeug   ..Hangul Syllable Ddeuh
    (0x0b745, 0x0b75f,),  # Hangul Syllable Ddyig   ..Hangul Syllable Ddyih
    (0x0b761, 0x0b77b,),  # Hangul Syllable Ddig    ..Hangul Syllable Ddih
    (0x0b77d, 0x0b797,),  # Hangul Syllable Rag     ..Hangul Syllable Rah
    (0x0b799, 0x0b7b3,),  # Hangul Syllable Raeg    ..Hangul Syllable Raeh
    (0x0b7b5, 0x0b7cf,),  # Hangul Syllable Ryag    ..Hangul Syllable Ryah
    (0x0b7d1, 0x0b7eb,),  # Hangul Syllable Ryaeg   ..Hangul Syllable Ryaeh
    (0x0b7ed, 0x0b807,),  # Hangul Syllable Reog    ..Hangul Syllable Reoh
    (0x0b809, 0x0b823,),  # Hangul Syllable Reg     ..Hangul Syllable Reh
    (0x0b825, 0x0b83f,),  # Hangul Syllable Ryeog   ..Hangul Syllable Ryeoh
    (0x0b841, 0x0b85b,),  # Hangul Syllable Ryeg    ..Hangul Syllable Ryeh
    (0x0b85d, 0x0b877,),  # Hangul Syllable Rog     ..Hangul Syllable Roh
    (0x0b879, 0x0b893,),  # Hangul Syllable Rwag    ..Hangul Syllable Rwah
    (0x0b895, 0x0b8af,),  # Hangul Syllable Rwaeg   ..Hangul Syllable Rwaeh
    (0x0b8b1, 0x0b8cb,),  # Hangul Syllable Roeg    ..Hangul Syllable Roeh
    (0x0b8cd, 0x0b8e7,),  # Hangul Syllable Ryog    ..Hangul Syllable Ryoh
    (0x0b8e9, 0x0b903,),  # Hangul Syllable Rug     ..Hangul Syllable Ruh
    (0x0b905, 0x0b91f,),  # Hangul Syllable Rweog   ..Hangul Syllable Rweoh
    (0x0b921, 0x0b93b,),  # Hangul Syllable Rweg    ..Hangul Syllable Rweh
    (0x0b93d, 0x0b957,),  # Hangul Syllable Rwig    ..Hangul Syllable Rwih
    (0x0b959, 0x0b973,),  # Hangul Syllable Ryug    ..Hangul Syllable Ryuh
    (0x0b975, 0x0b98f,),  # Hangul Syllable Reug    ..Hangul Syllable Reuh
    (0x0b991, 0x0b9ab,),  # Hangul Syllable Ryig    ..Hangul Syllable Ryih
    (0x0b9ad, 0x0b9c7,),  # Hangul Syllable Rig     ..Hangul Syllable Rih
    (0x0b9c9, 0x0b9e3,),  # Hangul Syllable Mag     ..Hangul Syllable Mah
    (0x0b9e5, 0x0b9ff,),  # Hangul Syllable Maeg    ..Hangul Syllable Maeh
    (0x0ba01, 0x0ba1b,),  # Hangul Syllable Myag    ..Hangul Syllable Myah
    (0x0ba1d, 0x0ba37,),  # Hangul Syllable Myaeg   ..Hangul Syllable Myaeh
    (0x0ba39, 0x0ba53,),  # Hangul Syllable Meog    ..Hangul Syllable Meoh
    (0x0ba55, 0x0ba6f,),  # Hangul Syllable Meg     ..Hangul Syllable Meh
    (0x0ba71, 0x0ba8b,),  # Hangul Syllable Myeog   ..Hangul Syllable Myeoh
    (0x0ba8d, 0x0baa7,),  # Hangul Syllable Myeg    ..Hangul Syllable Myeh
    (0x0baa9, 0x0bac3,),  # Hangul Syllable Mog     ..Hangul Syllable Moh
    (0x0bac5, 0x0badf,),  # Hangul Syllable Mwag    ..Hangul Syllable Mwah
    (0x0bae1, 0x0bafb,),  # Hangul Syllable Mwaeg   ..Hangul Syllable Mwaeh
    (0x0bafd, 0x0bb17,),  # Hangul Syllable Moeg    ..Hangul Syllable Moeh
    (0x0bb19, 0x0bb33,),  # Hangul Syllable Myog    ..Hangul Syllable Myoh
    (0x0bb35, 0x0bb4f,),  # Hangul Syllable Mug     ..Hangul Syllable Muh
    (0x0bb51, 0x0bb6b,),  # Hangul Syllable Mweog   ..Hangul Syllable Mweoh
    (0x0bb6d, 0x0bb87,),  # Hangul Syllable Mweg    ..Hangul Syllable Mweh
    (0x0bb89, 0x0bba3,),  # Hangul Syllable Mwig    ..Hangul Syllable Mwih
    (0x0bba5, 0x0bbbf,),  # Hangul Syllable Myug    ..Hangul Syllable Myuh
    (0x0bbc1, 0x0bbdb,),  # Hangul Syllable Meug    ..Hangul Syllable Meuh
    (0x0bbdd, 0x0bbf7,),  # Hangul Syllable Myig    ..Hangul Syllable Myih
    (0x0bbf9, 0x0bc13,),  # Hangul Syllable Mig     ..Hangul Syllable Mih
    (0x0bc15, 0x0bc2f,),  # Hangul Syllable Bag     ..Hangul Syllable Bah
    (0x0bc31, 0x0bc4b,),  # Hangul Syllable Baeg    ..Hangul Syllable Baeh
    (0x0bc4d, 0x0bc67,),  # Hangul Syllable Byag    ..Hangul Syllable Byah
    (0x0bc69, 0x0bc83,),  # Hangul Syllable Byaeg   ..Hangul Syllable Byaeh
    (0x0bc85, 0x0bc9f,),  # Hangul Syllable Beog    ..Hangul Syllable Beoh
    (0x0bca1, 0x0bcbb,),  # Hangul Syllable Beg     ..Hangul Syllable Beh
    (0x0bcbd, 0x0bcd7,),  # Hangul Syllable Byeog   ..Hangul Syllable Byeoh
    (0x0bcd9, 0x0bcf3,),  # Hangul Syllable Byeg    ..Hangul Syllable Byeh
    (0x0bcf5, 0x0bd0f,),  # Hangul Syllable Bog     ..Hangul Syllable Boh
    (0x0bd11, 0x0bd2b,),  # Hangul Syllable Bwag    ..Hangul Syllable Bwah
    (0x0bd2d, 0x0bd47,),  # Hangul Syllable Bwaeg   ..Hangul Syllable Bwaeh
    (0x0bd49, 0x0bd63,),  # Hangul Syllable Boeg    ..Hangul Syllable Boeh
    (0x0bd65, 0x0bd7f,),  # Hangul Syllable Byog    ..Hangul Syllable Byoh
    (0x0bd81, 0x0bd9b,),  # Hangul Syllable Bug     ..Hangul Syllable Buh
    (0x0bd9d, 0x0bdb7,),  # Hangul Syllable Bweog   ..Hangul Syllable Bweoh
    (0x0bdb9, 0x0bdd3,),  # Hangul Syllable Bweg    ..Hangul Syllable Bweh
    (0x0bdd5, 0x0bdef,),  # Hangul Syllable Bwig    ..Hangul Syllable Bwih
    (0x0bdf1, 0x0be0b,),  # Hangul Syllable Byug    ..Hangul Syllable Byuh
    (0x0be0d, 0x0be27,),  # Hangul Syllable Beug    ..Hangul Syllable Beuh
    (0x0be29, 0x0be43,),  # Hangul Syllable Byig    ..Hangul Syllable Byih
    (0x0be45, 0x0be5f,),  # Hangul Syllable Big     ..Hangul Syllable Bih
    (0x0be61, 0x0be7b,),  # Hangul Syllable Bbag    ..Hangul Syllable Bbah
    (0x0be7d, 0x0be97,),  # Hangul Syllable Bbaeg   ..Hangul Syllable Bbaeh
    (0x0be99, 0x0beb3,),  # Hangul Syllable Bbyag   ..Hangul Syllable Bbyah
    (0x0beb5, 0x0becf,),  # Hangul Syllable Bbyaeg  ..Hangul Syllable Bbyaeh
    (0x0bed1, 0x0beeb,),  # Hangul Syllable Bbeog   ..Hangul Syllable Bbeoh
    (0x0beed, 0x0bf07,),  # Hangul Syllable Bbeg    ..Hangul Syllable Bbeh
    (0x0bf09, 0x0bf23,),  # Hangul Syllable Bbyeog  ..Hangul Syllable Bbyeoh
    (0x0bf25, 0x0bf3f,),  # Hangul Syllable Bbyeg   ..Hangul Syllable Bbyeh
    (0x0bf41, 0x0bf5b,),  # Hangul Syllable Bbog    ..Hangul Syllable Bboh
    (0x0bf5d, 0x0bf77,),  # Hangul Syllable Bbwag   ..Hangul Syllable Bbwah
    (0x0bf79, 0x0bf93,),  # Hangul Syllable Bbwaeg  ..Hangul Syllable Bbwaeh
    (0x0bf95, 0x0bfaf,),  # Hangul Syllable Bboeg   ..Hangul Syllable Bboeh
    (0x0bfb1, 0x0bfcb,),  # Hangul Syllable Bbyog   ..Hangul Syllable Bbyoh
    (0x0bfcd, 0x0bfe7,),  # Hangul Syllable Bbug    ..Hangul Syllable Bbuh
    (0x0bfe9, 0x0c003,),  # Hangul Syllable Bbweog  ..Hangul Syllable Bbweoh
    (0x0c005, 0x0c01f,),  # Hangul Syllable Bbweg   ..Hangul Syllable Bbweh
    (0x0c021, 0x0c03b,),  # Hangul Syllable Bbwig   ..Hangul Syllable Bbwih
    (0x0c03d, 0x0c057,),  # Hangul Syllable Bbyug   ..Hangul Syllable Bbyuh
    (0x0c059, 0x0c073,),  # Hangul Syllable Bbeug   ..Hangul Syllable Bbeuh
    (0x0c075, 0x0c08f,),  # Hangul Syllable Bbyig   ..Hangul Syllable Bbyih
    (0x0c091, 0x0c0ab,),  # Hangul Syllable Bbig    ..Hangul Syllable Bbih
    (0x0c0ad, 0x0c0c7,),  # Hangul Syllable Sag     ..Hangul Syllable Sah
    (0x0c0c9, 0x0c0e3,),  # Hangul Syllable Saeg    ..Hangul Syllable Saeh
    (0x0c0e5, 0x0c0ff,),  # Hangul Syllable Syag    ..Hangul Syllable Syah
    (0x0c101, 0x0c11b,),  # Hangul Syllable Syaeg   ..Hangul Syllable Syaeh
    (0x0c11d, 0x0c137,),  # Hangul Syllable Seog    ..Hangul Syllable Seoh
    (0x0c139, 0x0c153,),  # Hangul Syllable Seg     ..Hangul Syllable Seh
    (0x0c155, 0x0c16f,),  # Hangul Syllable Syeog   ..Hangul Syllable Syeoh
    (0x0c171, 0x0c18b,),  # Hangul Syllable Syeg    ..Hangul Syllable Syeh
    (0x0c18d, 0x0c1a7,),  # Hangul Syllable Sog     ..Hangul Syllable Soh
    (0x0c1a9, 0x0c1c3,),  # Hangul Syllable Swag    ..Hangul Syllable Swah
    (0x0c1c5, 0x0c1df,),  # Hangul Syllable Swaeg   ..Hangul Syllable Swaeh
    (0x0c1e1, 0x0c1fb,),  # Hangul Syllable Soeg    ..Hangul Syllable Soeh
    (0x0c1fd, 0x0c217,),  # Hangul Syllable Syog    ..Hangul Syllable Syoh
    (0x0c219, 0x0c233,),  # Hangul Syllable Sug     ..Hangul Syllable Suh
    (0x0c235, 0x0c24f,),  # Hangul Syllable Sweog   ..Hangul Syllable Sweoh
    (0x0c251, 0x0c26b,),  # Hangul Syllable Sweg    ..Hangul Syllable Sweh
    (0x0c26d, 0x0c287,),  # Hangul Syllable Swig    ..Hangul Syllable Swih
    (0x0c289, 0x0c2a3,),  # Hangul Syllable Syug    ..Hangul Syllable Syuh
    (0x0c2a5, 0x0c2bf,),  # Hangul Syllable Seug    ..Hangul Syllable Seuh
    (0x0c2c1, 0x0c2db,),  # Hangul Syllable Syig    ..Hangul Syllable Syih
    (0x0c2dd, 0x0c2f7,),  # Hangul Syllable Sig     ..Hangul Syllable Sih
    (0x0c2f9, 0x0c313,),  # Hangul Syllable Ssag    ..Hangul Syllable Ssah
    (0x0c315, 0x0c32f,),  # Hangul Syllable Ssaeg   ..Hangul Syllable Ssaeh
    (0x0c331, 0x0c34b,),  # Hangul Syllable Ssyag   ..Hangul Syllable Ssyah
    (0x0c34d, 0x0c367,),  # Hangul Syllable Ssyaeg  ..Hangul Syllable Ssyaeh
    (0x0c369, 0x0c383,),  # Hangul Syllable Sseog   ..Hangul Syllable Sseoh
    (0x0c385, 0x0c39f,),  # Hangul Syllable Sseg    ..Hangul Syllable Sseh
    (0x0c3a1, 0x0c3bb,),  # Hangul Syllable Ssyeog  ..Hangul Syllable Ssyeoh
    (0x0c3bd, 0x0c3d7,),  # Hangul Syllable Ssyeg   ..Hangul Syllable Ssyeh
    (0x0c3d9, 0x0c3f3,),  # Hangul Syllable Ssog    ..Hangul Syllable Ssoh
    (0x0c3f5, 0x0c40f,),  # Hangul Syllable Sswag   ..Hangul Syllable Sswah
    (0x0c411, 0x0c42b,),  # Hangul Syllable Sswaeg  ..Hangul Syllable Sswaeh
    (0x0c42d, 0x0c447,),  # Hangul Syllable Ssoeg   ..Hangul Syllable Ssoeh
    (0x0c449, 0x0c463,),  # Hangul Syllable Ssyog   ..Hangul Syllable Ssyoh
    (0x0c465, 0x0c47f,),  # Hangul Syllable Ssug    ..Hangul Syllable Ssuh
    (0x0c481, 0x0c49b,),  # Hangul Syllable Ssweog  ..Hangul Syllable Ssweoh
    (0x0c49d, 0x0c4b7,),  # Hangul Syllable Ssweg   ..Hangul Syllable Ssweh
    (0x0c4b9, 0x0c4d3,),  # Hangul Syllable Sswig   ..Hangul Syllable Sswih
    (0x0c4d5, 0x0c4ef,),  # Hangul Syllable Ssyug   ..Hangul Syllable Ssyuh
    (0x0c4f1, 0x0c50b,),  # Hangul Syllable Sseug   ..Hangul Syllable Sseuh
    (0x0c50d, 0x0c527,),  # Hangul Syllable Ssyig   ..Hangul Syllable Ssyih
    (0x0c529, 0x0c543,),  # Hangul Syllable Ssig    ..Hangul Syllable Ssih
    (0x0c545, 0x0c55f,),  # Hangul Syllable Ag      ..Hangul Syllable Ah
    (0x0c561, 0x0c57b,),  # Hangul Syllable Aeg     ..Hangul Syllable Aeh
    (0x0c57d, 0x0c597,),  # Hangul Syllable Yag     ..Hangul Syllable Yah
    (0x0c599, 0x0c5b3,),  # Hangul Syllable Yaeg    ..Hangul Syllable Yaeh
    (0x0c5b5, 0x0c5cf,),  # Hangul Syllable Eog     ..Hangul Syllable Eoh
    (0x0c5d1, 0x0c5eb,),  # Hangul Syllable Eg      ..Hangul Syllable Eh
    (0x0c5ed, 0x0c607,),  # Hangul Syllable Yeog    ..Hangul Syllable Yeoh
    (0x0c609, 0x0c623,),  # Hangul Syllable Yeg     ..Hangul Syllable Yeh
    (0x0c625, 0x0c63f,),  # Hangul Syllable Og      ..Hangul Syllable Oh
    (0x0c641, 0x0c65b,),  # Hangul Syllable Wag     ..Hangul Syllable Wah
    (0x0c65d, 0x0c677,),  # Hangul Syllable Waeg    ..Hangul Syllable Waeh
    (0x0c679, 0x0c693,),  # Hangul Syllable Oeg     ..Hangul Syllable Oeh
    (0x0c695, 0x0c6af,),  # Hangul Syllable Yog     ..Hangul Syllable Yoh
    (0x0c6b1, 0x0c6cb,),  # Hangul Syllable Ug      ..Hangul Syllable Uh
    (0x0c6cd, 0x0c6e7,),  # Hangul Syllable Weog    ..Hangul Syllable Weoh
    (0x0c6e9, 0x0c703,),  # Hangul Syllable Weg     ..Hangul Syllable Weh
    (0x0c705, 0x0c71f,),  # Hangul Syllable Wig     ..Hangul Syllable Wih
    (0x0c721, 0x0c73b,),  # Hangul Syllable Yug     ..Hangul Syllable Yuh
    (0x0c73d, 0x0c757,),  # Hangul Syllable Eug     ..Hangul Syllable Euh
    (0x0c759, 0x0c773,),  # Hangul Syllable Yig     ..Hangul Syllable Yih
    (0x0c775, 0x0c78f,),  # Hangul Syllable Ig      ..Hangul Syllable Ih
    (0x0c791, 0x0c7ab,),  # Hangul Syllable Jag     ..Hangul Syllable Jah
    (0x0c7ad, 0x0c7c7,),  # Hangul Syllable Jaeg    ..Hangul Syllable Jaeh
    (0x0c7c9, 0x0c7e3,),  # Hangul Syllable Jyag    ..Hangul Syllable Jyah
    (0x0c7e5, 0x0c7ff,),  # Hangul Syllable Jyaeg   ..Hangul Syllable Jyaeh
    (0x0c801, 0x0c81b,),  # Hangul Syllable Jeog    ..Hangul Syllable Jeoh
    (0x0c81d, 0x0c837,),  # Hangul Syllable Jeg     ..Hangul Syllable Jeh
    (0x0c839, 0x0c853,),  # Hangul Syllable Jyeog   ..Hangul Syllable Jyeoh
    (0x0c855, 0x0c86f,),  # Hangul Syllable Jyeg    ..Hangul Syllable Jyeh
    (0x0c871, 0x0c88b,),  # Hangul Syllable Jog     ..Hangul Syllable Joh
    (0x0c88d, 0x0c8a7,),  # Hangul Syllable Jwag    ..Hangul Syllable Jwah
    (0x0c8a9, 0x0c8c3,),  # Hangul Syllable Jwaeg   ..Hangul Syllable Jwaeh
    (0x0c8c5, 0x0c8df,),  # Hangul Syllable Joeg    ..Hangul Syllable Joeh
    (0x0c8e1, 0x0c8fb,),  # Hangul Syllable Jyog    ..Hangul Syllable Jyoh
    (0x0c8fd, 0x0c917,),  # Hangul Syllable Jug     ..Hangul Syllable Juh
    (0x0c919, 0x0c933,),  # Hangul Syllable Jweog   ..Hangul Syllable Jweoh
    (0x0c935, 0x0c94f,),  # Hangul Syllable Jweg    ..Hangul Syllable Jweh
    (0x0c951, 0x0c96b,),  # Hangul Syllable Jwig    ..Hangul Syllable Jwih
    (0x0c96d, 0x0c987,),  # Hangul Syllable Jyug    ..Hangul Syllable Jyuh
    (0x0c989, 0x0c9a3,),  # Hangul Syllable Jeug    ..Hangul Syllable Jeuh
    (0x0c9a5, 0x0c9bf,),  # Hangul Syllable Jyig    ..Hangul Syllable Jyih
    (0x0c9c1, 0x0c9db,),  # Hangul Syllable Jig     ..Hangul Syllable Jih
    (0x0c9dd, 0x0c9f7,),  # Hangul Syllable Jjag    ..Hangul Syllable Jjah
    (0x0c9f9, 0x0ca13,),  # Hangul Syllable Jjaeg   ..Hangul Syllable Jjaeh
    (0x0ca15, 0x0ca2f,),  # Hangul Syllable Jjyag   ..Hangul Syllable Jjyah
    (0x0ca31, 0x0ca4b,),  # Hangul Syllable Jjyaeg  ..Hangul Syllable Jjyaeh
    (0x0ca4d, 0x0ca67,),  # Hangul Syllable Jjeog   ..Hangul Syllable Jjeoh
    (0x0ca69, 0x0ca83,),  # Hangul Syllable Jjeg    ..Hangul Syllable Jjeh
    (0x0ca85, 0x0ca9f,),  # Hangul Syllable Jjyeog  ..Hangul Syllable Jjyeoh
    (0x0caa1, 0x0cabb,),  # Hangul Syllable Jjyeg   ..Hangul Syllable Jjyeh
    (0x0cabd, 0x0cad7,),  # Hangul Syllable Jjog    ..Hangul Syllable Jjoh
    (0x0cad9, 0x0caf3,),  # Hangul Syllable Jjwag   ..Hangul Syllable Jjwah
    (0x0caf5, 0x0cb0f,),  # Hangul Syllable Jjwaeg  ..Hangul Syllable Jjwaeh
    (0x0cb11, 0x0cb2b,),  # Hangul Syllable Jjoeg   ..Hangul Syllable Jjoeh
    (0x0cb2d, 0x0cb47,),  # Hangul Syllable Jjyog   ..Hangul Syllable Jjyoh
    (0x0cb49, 0x0cb63,),  # Hangul Syllable Jjug    ..Hangul Syllable Jjuh
    (0x0cb65, 0x0cb7f,),  # Hangul Syllable Jjweog  ..Hangul Syllable Jjweoh
    (0x0cb81, 0x0cb9b,),  # Hangul Syllable Jjweg   ..Hangul Syllable Jjweh
    (0x0cb9d, 0x0cbb7,),  # Hangul Syllable Jjwig   ..Hangul Syllable Jjwih
    (0x0cbb9, 0x0cbd3,),  # Hangul Syllable Jjyug   ..Hangul Syllable Jjyuh
    (0x0cbd5, 0x0cbef,),  # Hangul Syllable Jjeug   ..Hangul Syllable Jjeuh
    (0x0cbf1, 0x0cc0b,),  # Hangul Syllable Jjyig   ..Hangul Syllable Jjyih
    (0x0cc0d, 0x0cc27,),  # Hangul Syllable Jjig    ..Hangul Syllable Jjih
    (0x0cc29, 0x0cc43,),  # Hangul Syllable Cag     ..Hangul Syllable Cah
    (0x0cc45, 0x0cc5f,),  # Hangul Syllable Caeg    ..Hangul Syllable Caeh
    (0x0cc61, 0x0cc7b,),  # Hangul Syllable Cyag    ..Hangul Syllable Cyah
    (0x0cc7d, 0x0cc97,),  # Hangul Syllable Cyaeg   ..Hangul Syllable Cyaeh
    (0x0cc99, 0x0ccb3,),  # Hangul Syllable Ceog    ..Hangul Syllable Ceoh
    (0x0ccb5, 0x0cccf,),  # Hangul Syllable Ceg     ..Hangul Syllable Ceh
    (0x0ccd1, 0x0cceb,),  # Hangul Syllable Cyeog   ..Hangul Syllable Cyeoh
    (0x0cced, 0x0cd07,),  # Hangul Syllable Cyeg    ..Hangul Syllable Cyeh
    (0x0cd09, 0x0cd23,),  # Hangul Syllable Cog     ..Hangul Syllable Coh
    (0x0cd25, 0x0cd3f,),  # Hangul Syllable Cwag    ..Hangul Syllable Cwah
    (0x0cd41, 0x0cd5b,),  # Hangul Syllable Cwaeg   ..Hangul Syllable Cwaeh
    (0x0cd5d, 0x0cd77,),  # Hangul Syllable Coeg    ..Hangul Syllable Coeh
    (0x0cd79, 0x0cd93,),  # Hangul Syllable Cyog    ..Hangul Syllable Cyoh
    (0x0cd95, 0x0cdaf,),  # Hangul Syllable Cug     ..Hangul Syllable Cuh
    (0x0cdb1, 0x0cdcb,),  # Hangul Syllable Cweog   ..Hangul Syllable Cweoh
    (0x0cdcd, 0x0cde7,),  # Hangul Syllable Cweg    ..Hangul Syllable Cweh
    (0x0cde9, 0x0ce03,),  # Hangul Syllable Cwig    ..Hangul Syllable Cwih
    (0x0ce05, 0x0ce1f,),  # Hangul Syllable Cyug    ..Hangul Syllable Cyuh
    (0x0ce21, 0x0ce3b,),  # Hangul Syllable Ceug    ..Hangul Syllable Ceuh
    (0x0ce3d, 0x0ce57,),  # Hangul Syllable Cyig    ..Hangul Syllable Cyih
    (0x0ce59, 0x0ce73,),  # Hangul Syllable Cig     ..Hangul Syllable Cih
    (0x0ce75, 0x0ce8f,),  # Hangul Syllable Kag     ..Hangul Syllable Kah
    (0x0ce91, 0x0ceab,),  # Hangul Syllable Kaeg    ..Hangul Syllable Kaeh
    (0x0cead, 0x0cec7,),  # Hangul Syllable Kyag    ..Hangul Syllable Kyah
    (0x0cec9, 0x0cee3,),  # Hangul Syllable Kyaeg   ..Hangul Syllable Kyaeh
    (0x0cee5, 0x0ceff,),  # Hangul Syllable Keog    ..Hangul Syllable Keoh
    (0x0cf01, 0x0cf1b,),  # Hangul Syllable Keg     ..Hangul Syllable Keh
    (0x0cf1d, 0x0cf37,),  # Hangul Syllable Kyeog   ..Hangul Syllable Kyeoh
    (0x0cf39, 0x0cf53,),  # Hangul Syllable Kyeg    ..Hangul Syllable Kyeh
    (0x0cf55, 0x0cf6f,),  # Hangul Syllable Kog     ..Hangul Syllable Koh
    (0x0cf71, 0x0cf8b,),  # Hangul Syllable Kwag    ..Hangul Syllable Kwah
    (0x0cf8d, 0x0cfa7,),  # Hangul Syllable Kwaeg   ..Hangul Syllable Kwaeh
    (0x0cfa9, 0x0cfc3,),  # Hangul Syllable Koeg    ..Hangul Syllable Koeh
    (0x0cfc5, 0x0cfdf,),  # Hangul Syllable Kyog    ..Hangul Syllable Kyoh
    (0x0cfe1, 0x0cffb,),  # Hangul Syllable Kug     ..Hangul Syllable Kuh
    (0x0cffd, 0x0d017,),  # Hangul Syllable Kweog   ..Hangul Syllable Kweoh
    (0x0d019, 0x0d033,),  # Hangul Syllable Kweg    ..Hangul Syllable Kweh
    (0x0d035, 0x0d04f,),  # Hangul Syllable Kwig    ..Hangul Syllable Kwih
    (0x0d051, 0x0d06b,),  # Hangul Syllable Kyug    ..Hangul Syllable Kyuh
    (0x0d06d, 0x0d087,),  # Hangul Syllable Keug    ..Hangul Syllable Keuh
    (0x0d089, 0x0d0a3,),  # Hangul Syllable Kyig    ..Hangul Syllable Kyih
    (0x0d0a5, 0x0d0bf,),  # Hangul Syllable Kig     ..Hangul Syllable Kih
    (0x0d0c1, 0x0d0db,),  # Hangul Syllable Tag     ..Hangul Syllable Tah
    (0x0d0dd, 0x0d0f7,),  # Hangul Syllable Taeg    ..Hangul Syllable Taeh
    (0x0d0f9, 0x0d113,),  # Hangul Syllable Tyag    ..Hangul Syllable Tyah
    (0x0d115, 0x0d12f,),  # Hangul Syllable Tyaeg   ..Hangul Syllable Tyaeh
    (0x0d131, 0x0d14b,),  # Hangul Syllable Teog    ..Hangul Syllable Teoh
    (0x0d14d, 0x0d167,),  # Hangul Syllable Teg     ..Hangul Syllable Teh
    (0x0d169, 0x0d183,),  # Hangul Syllable Tyeog   ..Hangul Syllable Tyeoh
    (0x0d185, 0x0d19f,),  # Hangul Syllable Tyeg    ..Hangul Syllable Tyeh
    (0x0d1a1, 0x0d1bb,),  # Hangul Syllable Tog     ..Hangul Syllable Toh
    (0x0d1bd, 0x0d1d7,),  # Hangul Syllable Twag    ..Hangul Syllable Twah
    (0x0d1d9, 0x0d1f3,),  # Hangul Syllable Twaeg   ..Hangul Syllable Twaeh
    (0x0d1f5, 0x0d20f,),  # Hangul Syllable Toeg    ..Hangul Syllable Toeh
    (0x0d211, 0x0d22b,),  # Hangul Syllable Tyog    ..Hangul Syllable Tyoh
    (0x0d22d, 0x0d247,),  # Hangul Syllable Tug     ..Hangul Syllable Tuh
    (0x0d249, 0x0d263,),  # Hangul Syllable Tweog   ..Hangul Syllable Tweoh
    (0x0d265, 0x0d27f,),  # Hangul Syllable Tweg    ..Hangul Syllable Tweh
    (0x0d281, 0x0d29b,),  # Hangul Syllable Twig    ..Hangul Syllable Twih
    (0x0d29d, 0x0d2b7,),  # Hangul Syllable Tyug    ..Hangul Syllable Tyuh
    (0x0d2b9, 0x0d2d3,),  # Hangul Syllable Teug    ..Hangul Syllable Teuh
    (0x0d2d5, 0x0d2ef,),  # Hangul Syllable Tyig    ..Hangul Syllable Tyih
    (0x0d2f1, 0x0d30b,),  # Hangul Syllable Tig     ..Hangul Syllable Tih
    (0x0d30d, 0x0d327,),  # Hangul Syllable Pag     ..Hangul Syllable Pah
    (0x0d329, 0x0d343,),  # Hangul Syllable Paeg    ..Hangul Syllable Paeh
    (0x0d345, 0x0d35f,),  # Hangul Syllable Pyag    ..Hangul Syllable Pyah
    (0x0d361, 0x0d37b,),  # Hangul Syllable Pyaeg   ..Hangul Syllable Pyaeh
    (0x0d37d, 0x0d397,),  # Hangul Syllable Peog    ..Hangul Syllable Peoh
    (0x0d399, 0x0d3b3,),  # Hangul Syllable Peg     ..Hangul Syllable Peh
    (0x0d3b5, 0x0d3cf,),  # Hangul Syllable Pyeog   ..Hangul Syllable Pyeoh
    (0x0d3d1, 0x0d3eb,),  # Hangul Syllable Pyeg    ..Hangul Syllable Pyeh
    (0x0d3ed, 0x0d407,),  # Hangul Syllable Pog     ..Hangul Syllable Poh
    (0x0d409, 0x0d423,),  # Hangul Syllable Pwag    ..Hangul Syllable Pwah
    (0x0d425, 0x0d43f,),  # Hangul Syllable Pwaeg   ..Hangul Syllable Pwaeh
    (0x0d441, 0x0d45b,),  # Hangul Syllable Poeg    ..Hangul Syllable Poeh
    (0x0d45d, 0x0d477,),  # Hangul Syllable Pyog    ..Hangul Syllable Pyoh
    (0x0d479, 0x0d493,),  # Hangul Syllable Pug     ..Hangul Syllable Puh
    (0x0d495, 0x0d4af,),  # Hangul Syllable Pweog   ..Hangul Syllable Pweoh
    (0x0d4b1, 0x0d4cb,),  # Hangul Syllable Pweg    ..Hangul Syllable Pweh
    (0x0d4cd, 0x0d4e7,),  # Hangul Syllable Pwig    ..Hangul Syllable Pwih
    (0x0d4e9, 0x0d503,),  # Hangul Syllable Pyug    ..Hangul Syllable Pyuh
    (0x0d505, 0x0d51f,),  # Hangul Syllable Peug    ..Hangul Syllable Peuh
    (0x0d521, 0x0d53b,),  # Hangul Syllable Pyig    ..Hangul Syllable Pyih
    (0x0d53d, 0x0d557,),  # Hangul Syllable Pig     ..Hangul Syllable Pih
    (0x0d559, 0x0d573,),  # Hangul Syllable Hag     ..Hangul Syllable Hah
    (0x0d575, 0x0d58f,),  # Hangul Syllable Haeg    ..Hangul Syllable Haeh
    (0x0d591, 0x0d5ab,),  # Hangul Syllable Hyag    ..Hangul Syllable Hyah
    (0x0d5ad, 0x0d5c7,),  # Hangul Syllable Hyaeg   ..Hangul Syllable Hyaeh
    (0x0d5c9, 0x0d5e3,),  # Hangul Syllable Heog    ..Hangul Syllable Heoh
    (0x0d5e5, 0x0d5ff,),  # Hangul Syllable Heg     ..Hangul Syllable Heh
    (0x0d601, 0x0d61b,),  # Hangul Syllable Hyeog   ..Hangul Syllable Hyeoh
    (0x0d61d, 0x0d637,),  # Hangul Syllable Hyeg    ..Hangul Syllable Hyeh
    (0x0d639, 0x0d653,),  # Hangul Syllable Hog     ..Hangul Syllable Hoh
    (0x0d655, 0x0d66f,),  # Hangul Syllable Hwag    ..Hangul Syllable Hwah
    (0x0d671, 0x0d68b,),  # Hangul Syllable Hwaeg   ..Hangul Syllable Hwaeh
    (0x0d68d, 0x0d6a7,),  # Hangul Syllable Hoeg    ..Hangul Syllable Hoeh
    (0x0d6a9, 0x0d6c3,),  # Hangul Syllable Hyog    ..Hangul Syllable Hyoh
    (0x0d6c5, 0x0d6df,),  # Hangul Syllable Hug     ..Hangul Syllable Huh
    (0x0d6e1, 0x0d6fb,),  # Hangul Syllable Hweog   ..Hangul Syllable Hweoh
    (0x0d6fd, 0x0d717,),  # Hangul Syllable Hweg    ..Hangul Syllable Hweh
    (0x0d719, 0x0d733,),  # Hangul Syllable Hwig    ..Hangul Syllable Hwih
    (0x0d735, 0x0d74f,),  # Hangul Syllable Hyug    ..Hangul Syllable Hyuh
    (0x0d751, 0x0d76b,),  # Hangul Syllable Heug    ..Hangul Syllable Heuh
    (0x0d76d, 0x0d787,),  # Hangul Syllable Hyig    ..Hangul Syllable Hyih
    (0x0d789, 0x0d7a3,),  # Hangul Syllable Hig     ..Hangul Syllable Hih
)

EXTENDED_PICTOGRAPHIC = (
    # Source: emoji-data.txt
    # Date: 2025-07-25, 17:54:31 GMT
    #
    (0x000a9, 0x000a9,),  # Copyright Sign
    (0x000ae, 0x000ae,),  # Registered Sign
    (0x0203c, 0x0203c,),  # Double Exclamation Mark
    (0x02049, 0x02049,),  # Exclamation Question Mark
    (0x02122, 0x02122,),  # Trade Mark Sign
    (0x02139, 0x02139,),  # Information Source
    (0x02194, 0x02199,),  # Left Right Arrow        ..South West Arrow
    (0x021a9, 0x021aa,),  # Leftwards Arrow With Hoo..Rightwards Arrow With Ho
    (0x0231a, 0x0231b,),  # Watch                   ..Hourglass
    (0x02328, 0x02328,),  # Keyboard
    (0x023cf, 0x023cf,),  # Eject Symbol
    (0x023e9, 0x023f3,),  # Black Right-pointing Dou..Hourglass With Flowing S
    (0x023f8, 0x023fa,),  # Double Vertical Bar     ..Black Circle For Record
    (0x024c2, 0x024c2,),  # Circled Latin Capital Letter M
    (0x025aa, 0x025ab,),  # Black Small Square      ..White Small Square
    (0x025b6, 0x025b6,),  # Black Right-pointing Triangle
    (0x025c0, 0x025c0,),  # Black Left-pointing Triangle
    (0x025fb, 0x025fe,),  # White Medium Square     ..Black Medium Small Squar
    (0x02600, 0x02604,),  # Black Sun With Rays     ..Comet
    (0x0260e, 0x0260e,),  # Black Telephone
    (0x02611, 0x02611,),  # Ballot Box With Check
    (0x02614, 0x02615,),  # Umbrella With Rain Drops..Hot Beverage
    (0x02618, 0x02618,),  # Shamrock
    (0x0261d, 0x0261d,),  # White Up Pointing Index
    (0x02620, 0x02620,),  # Skull And Crossbones
    (0x02622, 0x02623,),  # Radioactive Sign        ..Biohazard Sign
    (0x02626, 0x02626,),  # Orthodox Cross
    (0x0262a, 0x0262a,),  # Star And Crescent
    (0x0262e, 0x0262f,),  # Peace Symbol            ..Yin Yang
    (0x02638, 0x0263a,),  # Wheel Of Dharma         ..White Smiling Face
    (0x02640, 0x02640,),  # Female Sign
    (0x02642, 0x02642,),  # Male Sign
    (0x02648, 0x02653,),  # Aries                   ..Pisces
    (0x0265f, 0x02660,),  # Black Chess Pawn        ..Black Spade Suit
    (0x02663, 0x02663,),  # Black Club Suit
    (0x02665, 0x02666,),  # Black Heart Suit        ..Black Diamond Suit
    (0x02668, 0x02668,),  # Hot Springs
    (0x0267b, 0x0267b,),  # Black Universal Recycling Symbol
    (0x0267e, 0x0267f,),  # Permanent Paper Sign    ..Wheelchair Symbol
    (0x02692, 0x02697,),  # Hammer And Pick         ..Alembic
    (0x02699, 0x02699,),  # Gear
    (0x0269b, 0x0269c,),  # Atom Symbol             ..Fleur-de-lis
    (0x026a0, 0x026a1,),  # Warning Sign            ..High Voltage Sign
    (0x026a7, 0x026a7,),  # Male With Stroke And Male And Female Sign
    (0x026aa, 0x026ab,),  # Medium White Circle     ..Medium Black Circle
    (0x026b0, 0x026b1,),  # Coffin                  ..Funeral Urn
    (0x026bd, 0x026be,),  # Soccer Ball             ..Baseball
    (0x026c4, 0x026c5,),  # Snowman Without Snow    ..Sun Behind Cloud
    (0x026c8, 0x026c8,),  # Thunder Cloud And Rain
    (0x026ce, 0x026cf,),  # Ophiuchus               ..Pick
    (0x026d1, 0x026d1,),  # Helmet With White Cross
    (0x026d3, 0x026d4,),  # Chains                  ..No Entry
    (0x026e9, 0x026ea,),  # Shinto Shrine           ..Church
    (0x026f0, 0x026f5,),  # Mountain                ..Sailboat
    (0x026f7, 0x026fa,),  # Skier                   ..Tent
    (0x026fd, 0x026fd,),  # Fuel Pump
    (0x02702, 0x02702,),  # Black Scissors
    (0x02705, 0x02705,),  # White Heavy Check Mark
    (0x02708, 0x0270d,),  # Airplane                ..Writing Hand
    (0x0270f, 0x0270f,),  # Pencil
    (0x02712, 0x02712,),  # Black Nib
    (0x02714, 0x02714,),  # Heavy Check Mark
    (0x02716, 0x02716,),  # Heavy Multiplication X
    (0x0271d, 0x0271d,),  # Latin Cross
    (0x02721, 0x02721,),  # Star Of David
    (0x02728, 0x02728,),  # Sparkles
    (0x02733, 0x02734,),  # Eight Spoked Asterisk   ..Eight Pointed Black Star
    (0x02744, 0x02744,),  # Snowflake
    (0x02747, 0x02747,),  # Sparkle
    (0x0274c, 0x0274c,),  # Cross Mark
    (0x0274e, 0x0274e,),  # Negative Squared Cross Mark
    (0x02753, 0x02755,),  # Black Question Mark Orna..White Exclamation Mark O
    (0x02757, 0x02757,),  # Heavy Exclamation Mark Symbol
    (0x02763, 0x02764,),  # Heavy Heart Exclamation ..Heavy Black Heart
    (0x02795, 0x02797,),  # Heavy Plus Sign         ..Heavy Division Sign
    (0x027a1, 0x027a1,),  # Black Rightwards Arrow
    (0x027b0, 0x027b0,),  # Curly Loop
    (0x027bf, 0x027bf,),  # Double Curly Loop
    (0x02934, 0x02935,),  # Arrow Pointing Rightward..Arrow Pointing Rightward
    (0x02b05, 0x02b07,),  # Leftwards Black Arrow   ..Downwards Black Arrow
    (0x02b1b, 0x02b1c,),  # Black Large Square      ..White Large Square
    (0x02b50, 0x02b50,),  # White Medium Star
    (0x02b55, 0x02b55,),  # Heavy Large Circle
    (0x03030, 0x03030,),  # Wavy Dash
    (0x0303d, 0x0303d,),  # Part Alternation Mark
    (0x03297, 0x03297,),  # Circled Ideograph Congratulation
    (0x03299, 0x03299,),  # Circled Ideograph Secret
    (0x1f004, 0x1f004,),  # Mahjong Tile Red Dragon
    (0x1f02c, 0x1f02f,),  # (nil)
    (0x1f094, 0x1f09f,),  # (nil)
    (0x1f0af, 0x1f0b0,),  # (nil)
    (0x1f0c0, 0x1f0c0,),  # (nil)
    (0x1f0cf, 0x1f0d0,),  # Playing Card Black Joker..(nil)
    (0x1f0f6, 0x1f0ff,),  # (nil)
    (0x1f170, 0x1f171,),  # Negative Squared Latin C..Negative Squared Latin C
    (0x1f17e, 0x1f17f,),  # Negative Squared Latin C..Negative Squared Latin C
    (0x1f18e, 0x1f18e,),  # Negative Squared Ab
    (0x1f191, 0x1f19a,),  # Squared Cl              ..Squared Vs
    (0x1f1ae, 0x1f1e5,),  # (nil)
    (0x1f201, 0x1f20f,),  # Squared Katakana Koko   ..(nil)
    (0x1f21a, 0x1f21a,),  # Squared Cjk Unified Ideograph-7121
    (0x1f22f, 0x1f22f,),  # Squared Cjk Unified Ideograph-6307
    (0x1f232, 0x1f23a,),  # Squared Cjk Unified Ideo..Squared Cjk Unified Ideo
    (0x1f23c, 0x1f23f,),  # (nil)
    (0x1f249, 0x1f25f,),  # (nil)
    (0x1f266, 0x1f321,),  # (nil)                   ..Thermometer
    (0x1f324, 0x1f393,),  # White Sun With Small Clo..Graduation Cap
    (0x1f396, 0x1f397,),  # Military Medal          ..Reminder Ribbon
    (0x1f399, 0x1f39b,),  # Studio Microphone       ..Control Knobs
    (0x1f39e, 0x1f3f0,),  # Film Frames             ..European Castle
    (0x1f3f3, 0x1f3f5,),  # Waving White Flag       ..Rosette
    (0x1f3f7, 0x1f3fa,),  # Label                   ..Amphora
    (0x1f400, 0x1f4fd,),  # Rat                     ..Film Projector
    (0x1f4ff, 0x1f53d,),  # Prayer Beads            ..Down-pointing Small Red
    (0x1f549, 0x1f54e,),  # Om Symbol               ..Menorah With Nine Branch
    (0x1f550, 0x1f567,),  # Clock Face One Oclock   ..Clock Face Twelve-thirty
    (0x1f56f, 0x1f570,),  # Candle                  ..Mantelpiece Clock
    (0x1f573, 0x1f57a,),  # Hole                    ..Man Dancing
    (0x1f587, 0x1f587,),  # Linked Paperclips
    (0x1f58a, 0x1f58d,),  # Lower Left Ballpoint Pen..Lower Left Crayon
    (0x1f590, 0x1f590,),  # Raised Hand With Fingers Splayed
    (0x1f595, 0x1f596,),  # Reversed Hand With Middl..Raised Hand With Part Be
    (0x1f5a4, 0x1f5a5,),  # Black Heart             ..Desktop Computer
    (0x1f5a8, 0x1f5a8,),  # Printer
    (0x1f5b1, 0x1f5b2,),  # Three Button Mouse      ..Trackball
    (0x1f5bc, 0x1f5bc,),  # Frame With Picture
    (0x1f5c2, 0x1f5c4,),  # Card Index Dividers     ..File Cabinet
    (0x1f5d1, 0x1f5d3,),  # Wastebasket             ..Spiral Calendar Pad
    (0x1f5dc, 0x1f5de,),  # Compression             ..Rolled-up Newspaper
    (0x1f5e1, 0x1f5e1,),  # Dagger Knife
    (0x1f5e3, 0x1f5e3,),  # Speaking Head In Silhouette
    (0x1f5e8, 0x1f5e8,),  # Left Speech Bubble
    (0x1f5ef, 0x1f5ef,),  # Right Anger Bubble
    (0x1f5f3, 0x1f5f3,),  # Ballot Box With Ballot
    (0x1f5fa, 0x1f64f,),  # World Map               ..Person With Folded Hands
    (0x1f680, 0x1f6c5,),  # Rocket                  ..Left Luggage
    (0x1f6cb, 0x1f6d2,),  # Couch And Lamp          ..Shopping Trolley
    (0x1f6d5, 0x1f6e5,),  # Hindu Temple            ..Motor Boat
    (0x1f6e9, 0x1f6e9,),  # Small Airplane
    (0x1f6eb, 0x1f6f0,),  # Airplane Departure      ..Satellite
    (0x1f6f3, 0x1f6ff,),  # Passenger Ship          ..(nil)
    (0x1f7da, 0x1f7ff,),  # (nil)
    (0x1f80c, 0x1f80f,),  # (nil)
    (0x1f848, 0x1f84f,),  # (nil)
    (0x1f85a, 0x1f85f,),  # (nil)
    (0x1f888, 0x1f88f,),  # (nil)
    (0x1f8ae, 0x1f8af,),  # (nil)
    (0x1f8bc, 0x1f8bf,),  # (nil)
    (0x1f8c2, 0x1f8cf,),  # (nil)
    (0x1f8d9, 0x1f8ff,),  # (nil)
    (0x1f90c, 0x1f93a,),  # Pinched Fingers         ..Fencer
    (0x1f93c, 0x1f945,),  # Wrestlers               ..Goal Net
    (0x1f947, 0x1f9ff,),  # First Place Medal       ..Nazar Amulet
    (0x1fa58, 0x1fa5f,),  # (nil)
    (0x1fa6e, 0x1faff,),  # (nil)
    (0x1fc00, 0x1fffd,),  # (nil)
)

INCB_LINKER = (
    # Source: DerivedCoreProperties
    # Date: see file
    #
    (0x0094d, 0x0094d,),  # Devanagari Sign Virama
    (0x009cd, 0x009cd,),  # Bengali Sign Virama
    (0x00acd, 0x00acd,),  # Gujarati Sign Virama
    (0x00b4d, 0x00b4d,),  # Oriya Sign Virama
    (0x00c4d, 0x00c4d,),  # Telugu Sign Virama
    (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama
    (0x01039, 0x01039,),  # Myanmar Sign Virama
    (0x017d2, 0x017d2,),  # Khmer Sign Coeng
    (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot
    (0x01b44, 0x01b44,),  # Balinese Adeg Adeg
    (0x01bab, 0x01bab,),  # Sundanese Sign Virama
    (0x0a9c0, 0x0a9c0,),  # Javanese Pangkon
    (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama
    (0x10a3f, 0x10a3f,),  # Kharoshthi Virama
    (0x11133, 0x11133,),  # Chakma Virama
    (0x113d0, 0x113d0,),  # Tulu-tigalari Conjoiner
    (0x1193e, 0x1193e,),  # Dives Akuru Virama
    (0x11a47, 0x11a47,),  # Zanabazar Square Subjoiner
    (0x11a99, 0x11a99,),  # Soyombo Subjoiner
    (0x11f42, 0x11f42,),  # Kawi Conjoiner
)

INCB_CONSONANT = (
    # Source: DerivedCoreProperties
    # Date: see file
    #
    (0x00915, 0x00939,),  # Devanagari Letter Ka    ..Devanagari Letter Ha
    (0x00958, 0x0095f,),  # Devanagari Letter Qa    ..Devanagari Letter Yya
    (0x00978, 0x0097f,),  # Devanagari Letter Marwar..Devanagari Letter Bba
    (0x00995, 0x009a8,),  # Bengali Letter Ka       ..Bengali Letter Na
    (0x009aa, 0x009b0,),  # Bengali Letter Pa       ..Bengali Letter Ra
    (0x009b2, 0x009b2,),  # Bengali Letter La
    (0x009b6, 0x009b9,),  # Bengali Letter Sha      ..Bengali Letter Ha
    (0x009dc, 0x009dd,),  # Bengali Letter Rra      ..Bengali Letter Rha
    (0x009df, 0x009df,),  # Bengali Letter Yya
    (0x009f0, 0x009f1,),  # Bengali Letter Ra With M..Bengali Letter Ra With L
    (0x00a95, 0x00aa8,),  # Gujarati Letter Ka      ..Gujarati Letter Na
    (0x00aaa, 0x00ab0,),  # Gujarati Letter Pa      ..Gujarati Letter Ra
    (0x00ab2, 0x00ab3,),  # Gujarati Letter La      ..Gujarati Letter Lla
    (0x00ab5, 0x00ab9,),  # Gujarati Letter Va      ..Gujarati Letter Ha
    (0x00af9, 0x00af9,),  # Gujarati Letter Zha
    (0x00b15, 0x00b28,),  # Oriya Letter Ka         ..Oriya Letter Na
    (0x00b2a, 0x00b30,),  # Oriya Letter Pa         ..Oriya Letter Ra
    (0x00b32, 0x00b33,),  # Oriya Letter La         ..Oriya Letter Lla
    (0x00b35, 0x00b39,),  # Oriya Letter Va         ..Oriya Letter Ha
    (0x00b5c, 0x00b5d,),  # Oriya Letter Rra        ..Oriya Letter Rha
    (0x00b5f, 0x00b5f,),  # Oriya Letter Yya
    (0x00b71, 0x00b71,),  # Oriya Letter Wa
    (0x00c15, 0x00c28,),  # Telugu Letter Ka        ..Telugu Letter Na
    (0x00c2a, 0x00c39,),  # Telugu Letter Pa        ..Telugu Letter Ha
    (0x00c58, 0x00c5a,),  # Telugu Letter Tsa       ..Telugu Letter Rrra
    (0x00d15, 0x00d3a,),  # Malayalam Letter Ka     ..Malayalam Letter Ttta
    (0x01000, 0x0102a,),  # Myanmar Letter Ka       ..Myanmar Letter Au
    (0x0103f, 0x0103f,),  # Myanmar Letter Great Sa
    (0x01050, 0x01055,),  # Myanmar Letter Sha      ..Myanmar Letter Vocalic L
    (0x0105a, 0x0105d,),  # Myanmar Letter Mon Nga  ..Myanmar Letter Mon Bbe
    (0x01061, 0x01061,),  # Myanmar Letter Sgaw Karen Sha
    (0x01065, 0x01066,),  # Myanmar Letter Western P..Myanmar Letter Western P
    (0x0106e, 0x01070,),  # Myanmar Letter Eastern P..Myanmar Letter Eastern P
    (0x01075, 0x01081,),  # Myanmar Letter Shan Ka  ..Myanmar Letter Shan Ha
    (0x0108e, 0x0108e,),  # Myanmar Letter Rumai Palaung Fa
    (0x01780, 0x017b3,),  # Khmer Letter Ka         ..Khmer Independent Vowel
    (0x01a20, 0x01a54,),  # Tai Tham Letter High Ka ..Tai Tham Letter Great Sa
    (0x01b0b, 0x01b0c,),  # Balinese Letter Ra Repa ..Balinese Letter Ra Repa
    (0x01b13, 0x01b33,),  # Balinese Letter Ka      ..Balinese Letter Ha
    (0x01b45, 0x01b4c,),  # Balinese Letter Kaf Sasa..Balinese Letter Archaic
    (0x01b83, 0x01ba0,),  # Sundanese Letter A      ..Sundanese Letter Ha
    (0x01bae, 0x01baf,),  # Sundanese Letter Kha    ..Sundanese Letter Sya
    (0x01bbb, 0x01bbd,),  # Sundanese Letter Reu    ..Sundanese Letter Bha
    (0x0a989, 0x0a98b,),  # Javanese Letter Pa Cerek..Javanese Letter Nga Lele
    (0x0a98f, 0x0a9b2,),  # Javanese Letter Ka      ..Javanese Letter Ha
    (0x0a9e0, 0x0a9e4,),  # Myanmar Letter Shan Gha ..Myanmar Letter Shan Bha
    (0x0a9e7, 0x0a9ef,),  # Myanmar Letter Tai Laing..Myanmar Letter Tai Laing
    (0x0a9fa, 0x0a9fe,),  # Myanmar Letter Tai Laing..Myanmar Letter Tai Laing
    (0x0aa60, 0x0aa6f,),  # Myanmar Letter Khamti Ga..Myanmar Letter Khamti Fa
    (0x0aa71, 0x0aa73,),  # Myanmar Letter Khamti Xa..Myanmar Letter Khamti Ra
    (0x0aa7a, 0x0aa7a,),  # Myanmar Letter Aiton Ra
    (0x0aa7e, 0x0aa7f,),  # Myanmar Letter Shwe Pala..Myanmar Letter Shwe Pala
    (0x0aae0, 0x0aaea,),  # Meetei Mayek Letter E   ..Meetei Mayek Letter Ssa
    (0x0abc0, 0x0abda,),  # Meetei Mayek Letter Kok ..Meetei Mayek Letter Bham
    (0x10a00, 0x10a00,),  # Kharoshthi Letter A
    (0x10a10, 0x10a13,),  # Kharoshthi Letter Ka    ..Kharoshthi Letter Gha
    (0x10a15, 0x10a17,),  # Kharoshthi Letter Ca    ..Kharoshthi Letter Ja
    (0x10a19, 0x10a35,),  # Kharoshthi Letter Nya   ..Kharoshthi Letter Vha
    (0x11103, 0x11126,),  # Chakma Letter Aa        ..Chakma Letter Haa
    (0x11144, 0x11144,),  # Chakma Letter Lhaa
    (0x11147, 0x11147,),  # Chakma Letter Vaa
    (0x11380, 0x11389,),  # Tulu-tigalari Letter A  ..Tulu-tigalari Letter Voc
    (0x1138b, 0x1138b,),  # Tulu-tigalari Letter Ee
    (0x1138e, 0x1138e,),  # Tulu-tigalari Letter Ai
    (0x11390, 0x113b5,),  # Tulu-tigalari Letter Oo ..Tulu-tigalari Letter Lll
    (0x11900, 0x11906,),  # Dives Akuru Letter A    ..Dives Akuru Letter E
    (0x11909, 0x11909,),  # Dives Akuru Letter O
    (0x1190c, 0x11913,),  # Dives Akuru Letter Ka   ..Dives Akuru Letter Ja
    (0x11915, 0x11916,),  # Dives Akuru Letter Nya  ..Dives Akuru Letter Tta
    (0x11918, 0x1192f,),  # Dives Akuru Letter Dda  ..Dives Akuru Letter Za
    (0x11a00, 0x11a00,),  # Zanabazar Square Letter A
    (0x11a0b, 0x11a32,),  # Zanabazar Square Letter ..Zanabazar Square Letter
    (0x11a50, 0x11a50,),  # Soyombo Letter A
    (0x11a5c, 0x11a83,),  # Soyombo Letter Ka       ..Soyombo Letter Kssa
    (0x11f04, 0x11f10,),  # Kawi Letter A           ..Kawi Letter O
    (0x11f12, 0x11f33,),  # Kawi Letter Ka          ..Kawi Letter Jnya
)

INCB_EXTEND = (
    # Source: DerivedCoreProperties
    # Date: see file
    #
    (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
    (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
    (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
    (0x005bf, 0x005bf,),  # Hebrew Point Rafe
    (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
    (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
    (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qatan
    (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
    (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
    (0x00670, 0x00670,),  # Arabic Letter Superscript Alef
    (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
    (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
    (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
    (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
    (0x00711, 0x00711,),  # Syriac Letter Superscript Alaph
    (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
    (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
    (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
    (0x007fd, 0x007fd,),  # Nko Dantayalan
    (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
    (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
    (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
    (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
    (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
    (0x00897, 0x0089f,),  # Arabic Pepet            ..Arabic Half Madda Over M
    (0x008ca, 0x008e1,),  # Arabic Small High Farsi ..Arabic Small High Sign S
    (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
    (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe
    (0x0093c, 0x0093c,),  # Devanagari Sign Nukta
    (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
    (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
    (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
    (0x00981, 0x00981,),  # Bengali Sign Candrabindu
    (0x009bc, 0x009bc,),  # Bengali Sign Nukta
    (0x009be, 0x009be,),  # Bengali Vowel Sign Aa
    (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
    (0x009d7, 0x009d7,),  # Bengali Au Length Mark
    (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
    (0x009fe, 0x009fe,),  # Bengali Sandhi Mark
    (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
    (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta
    (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
    (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
    (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
    (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat
    (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
    (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash
    (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
    (0x00abc, 0x00abc,),  # Gujarati Sign Nukta
    (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
    (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
    (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
    (0x00afa, 0x00aff,),  # Gujarati Sign Sukun     ..Gujarati Sign Two-circle
    (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu
    (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta
    (0x00b3e, 0x00b3f,),  # Oriya Vowel Sign Aa     ..Oriya Vowel Sign I
    (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
    (0x00b55, 0x00b57,),  # Oriya Sign Overline     ..Oriya Au Length Mark
    (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
    (0x00b82, 0x00b82,),  # Tamil Sign Anusvara
    (0x00bbe, 0x00bbe,),  # Tamil Vowel Sign Aa
    (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii
    (0x00bcd, 0x00bcd,),  # Tamil Sign Virama
    (0x00bd7, 0x00bd7,),  # Tamil Au Length Mark
    (0x00c00, 0x00c00,),  # Telugu Sign Combining Candrabindu Above
    (0x00c04, 0x00c04,),  # Telugu Sign Combining Anusvara Above
    (0x00c3c, 0x00c3c,),  # Telugu Sign Nukta
    (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
    (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
    (0x00c4a, 0x00c4c,),  # Telugu Vowel Sign O     ..Telugu Vowel Sign Au
    (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
    (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
    (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu
    (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta
    (0x00cbf, 0x00cc0,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign Ii
    (0x00cc2, 0x00cc2,),  # Kannada Vowel Sign Uu
    (0x00cc6, 0x00cc8,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign Ai
    (0x00cca, 0x00ccd,),  # Kannada Vowel Sign O    ..Kannada Sign Virama
    (0x00cd5, 0x00cd6,),  # Kannada Length Mark     ..Kannada Ai Length Mark
    (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
    (0x00d00, 0x00d01,),  # Malayalam Sign Combining..Malayalam Sign Candrabin
    (0x00d3b, 0x00d3c,),  # Malayalam Sign Vertical ..Malayalam Sign Circular
    (0x00d3e, 0x00d3e,),  # Malayalam Vowel Sign Aa
    (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
    (0x00d57, 0x00d57,),  # Malayalam Au Length Mark
    (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
    (0x00d81, 0x00d81,),  # Sinhala Sign Candrabindu
    (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna
    (0x00dcf, 0x00dcf,),  # Sinhala Vowel Sign Aela-pilla
    (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
    (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga Paa-pilla
    (0x00ddf, 0x00ddf,),  # Sinhala Vowel Sign Gayanukitta
    (0x00e31, 0x00e31,),  # Thai Character Mai Han-akat
    (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
    (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
    (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan
    (0x00eb4, 0x00ebc,),  # Lao Vowel Sign I        ..Lao Semivowel Sign Lo
    (0x00ec8, 0x00ece,),  # Lao Tone Mai Ek         ..Lao Yamakkan
    (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
    (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung Nyi Zla
    (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung Sgor Rtags
    (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru
    (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
    (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
    (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
    (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
    (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
    (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gdan
    (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
    (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
    (0x0103a, 0x0103a,),  # Myanmar Sign Asat
    (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
    (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
    (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
    (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
    (0x01082, 0x01082,),  # Myanmar Consonant Sign Shan Medial Wa
    (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
    (0x0108d, 0x0108d,),  # Myanmar Sign Shan Council Emphatic Tone
    (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton Ai
    (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
    (0x01712, 0x01715,),  # Tagalog Vowel Sign I    ..Tagalog Sign Pamudpod
    (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
    (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
    (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
    (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
    (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
    (0x017c6, 0x017c6,),  # Khmer Sign Nikahit
    (0x017c9, 0x017d1,),  # Khmer Sign Muusikatoan  ..Khmer Sign Viriam
    (0x017d3, 0x017d3,),  # Khmer Sign Bathamasat
    (0x017dd, 0x017dd,),  # Khmer Sign Atthacan
    (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
    (0x0180f, 0x0180f,),  # Mongolian Free Variation Selector Four
    (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
    (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gali Dagalga
    (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
    (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
    (0x01932, 0x01932,),  # Limbu Small Letter Anusvara
    (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
    (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
    (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae
    (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign Medial La
    (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
    (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai Sat
    (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
    (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
    (0x01a7f, 0x01a7f,),  # Tai Tham Combining Cryptogrammic Dot
    (0x01ab0, 0x01add,),  # Combining Doubled Circum..Combining Dot-and-ring B
    (0x01ae0, 0x01aeb,),  # Combining Left Tack Abov..Combining Double Rightwa
    (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
    (0x01b34, 0x01b3d,),  # Balinese Sign Rerekan   ..Balinese Vowel Sign La L
    (0x01b42, 0x01b43,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
    (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
    (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
    (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
    (0x01ba8, 0x01baa,),  # Sundanese Vowel Sign Pam..Sundanese Sign Pamaaeh
    (0x01bac, 0x01bad,),  # Sundanese Consonant Sign..Sundanese Consonant Sign
    (0x01be6, 0x01be6,),  # Batak Sign Tompi
    (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
    (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O
    (0x01bef, 0x01bf3,),  # Batak Vowel Sign U For S..Batak Panongonan
    (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
    (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
    (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
    (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
    (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
    (0x01ced, 0x01ced,),  # Vedic Sign Tiryak
    (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above
    (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
    (0x01dc0, 0x01dff,),  # Combining Dotted Grave A..Combining Right Arrowhea
    (0x0200d, 0x0200d,),  # Zero Width Joiner
    (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
    (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
    (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joiner
    (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
    (0x0302a, 0x0302f,),  # Ideographic Level Tone M..Hangul Double Dot Tone M
    (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
    (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
    (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
    (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
    (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
    (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisvara
    (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasanta
    (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusvara
    (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
    (0x0a82c, 0x0a82c,),  # Syloti Nagri Sign Alternate Hasanta
    (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
    (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
    (0x0a8ff, 0x0a8ff,),  # Devanagari Vowel Sign Ay
    (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
    (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
    (0x0a953, 0x0a953,),  # Rejang Virama
    (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
    (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu
    (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
    (0x0a9bc, 0x0a9bd,),  # Javanese Vowel Sign Pepe..Javanese Consonant Sign
    (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw
    (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
    (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
    (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
    (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Final Ng
    (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Final M
    (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing Tone-2
    (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang
    (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
    (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
    (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
    (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho
    (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
    (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign Anap
    (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign Unap
    (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek
    (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spanish Varika
    (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
    (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
    (0x0ff9e, 0x0ff9f,),  # Halfwidth Katakana Voice..Halfwidth Katakana Semi-
    (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combining Oblique Stroke
    (0x102e0, 0x102e0,),  # Coptic Epact Thousands Mark
    (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
    (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
    (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
    (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
    (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
    (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
    (0x10d24, 0x10d27,),  # Hanifi Rohingya Sign Har..Hanifi Rohingya Sign Tas
    (0x10d69, 0x10d6d,),  # Garay Vowel Sign E      ..Garay Consonant Nasaliza
    (0x10eab, 0x10eac,),  # Yezidi Combining Hamza M..Yezidi Combining Madda M
    (0x10efa, 0x10eff,),  # Arabic Double Vertical B..Arabic Small Low Word Ma
    (0x10f46, 0x10f50,),  # Sogdian Combining Dot Be..Sogdian Combining Stroke
    (0x10f82, 0x10f85,),  # Old Uyghur Combining Dot..Old Uyghur Combining Two
    (0x11001, 0x11001,),  # Brahmi Sign Anusvara
    (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
    (0x11070, 0x11070,),  # Brahmi Sign Old Tamil Virama
    (0x11073, 0x11074,),  # Brahmi Vowel Sign Old Ta..Brahmi Vowel Sign Old Ta
    (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
    (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
    (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
    (0x110c2, 0x110c2,),  # Kaithi Vowel Sign Vocalic R
    (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
    (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
    (0x1112d, 0x11132,),  # Chakma Vowel Sign Ai    ..Chakma Au Mark
    (0x11134, 0x11134,),  # Chakma Maayyaa
    (0x11173, 0x11173,),  # Mahajani Sign Nukta
    (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
    (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
    (0x111c0, 0x111c0,),  # Sharada Sign Virama
    (0x111c9, 0x111cc,),  # Sharada Sandhi Mark     ..Sharada Extra Short Vowe
    (0x111cf, 0x111cf,),  # Sharada Sign Inverted Candrabindu
    (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
    (0x11234, 0x11237,),  # Khojki Sign Anusvara    ..Khojki Sign Shadda
    (0x1123e, 0x1123e,),  # Khojki Sign Sukun
    (0x11241, 0x11241,),  # Khojki Vowel Sign Vocalic R
    (0x112df, 0x112df,),  # Khudawadi Sign Anusvara
    (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
    (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
    (0x1133b, 0x1133c,),  # Combining Bindu Below   ..Grantha Sign Nukta
    (0x1133e, 0x1133e,),  # Grantha Vowel Sign Aa
    (0x11340, 0x11340,),  # Grantha Vowel Sign Ii
    (0x1134d, 0x1134d,),  # Grantha Sign Virama
    (0x11357, 0x11357,),  # Grantha Au Length Mark
    (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
    (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
    (0x113b8, 0x113b8,),  # Tulu-tigalari Vowel Sign Aa
    (0x113bb, 0x113c0,),  # Tulu-tigalari Vowel Sign..Tulu-tigalari Vowel Sign
    (0x113c2, 0x113c2,),  # Tulu-tigalari Vowel Sign Ee
    (0x113c5, 0x113c5,),  # Tulu-tigalari Vowel Sign Ai
    (0x113c7, 0x113c9,),  # Tulu-tigalari Vowel Sign..Tulu-tigalari Au Length
    (0x113ce, 0x113cf,),  # Tulu-tigalari Sign Viram..Tulu-tigalari Sign Loope
    (0x113d2, 0x113d2,),  # Tulu-tigalari Gemination Mark
    (0x113e1, 0x113e2,),  # Tulu-tigalari Vedic Tone..Tulu-tigalari Vedic Tone
    (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
    (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
    (0x11446, 0x11446,),  # Newa Sign Nukta
    (0x1145e, 0x1145e,),  # Newa Sandhi Mark
    (0x114b0, 0x114b0,),  # Tirhuta Vowel Sign Aa
    (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
    (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short E
    (0x114bd, 0x114bd,),  # Tirhuta Vowel Sign Short O
    (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
    (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
    (0x115af, 0x115af,),  # Siddham Vowel Sign Aa
    (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
    (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
    (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
    (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
    (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
    (0x1163d, 0x1163d,),  # Modi Sign Anusvara
    (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
    (0x116ab, 0x116ab,),  # Takri Sign Anusvara
    (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa
    (0x116b0, 0x116b7,),  # Takri Vowel Sign U      ..Takri Sign Nukta
    (0x1171d, 0x1171d,),  # Ahom Consonant Sign Medial La
    (0x1171f, 0x1171f,),  # Ahom Consonant Sign Medial Ligating Ra
    (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
    (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
    (0x1182f, 0x11837,),  # Dogra Vowel Sign U      ..Dogra Sign Anusvara
    (0x11839, 0x1183a,),  # Dogra Sign Virama       ..Dogra Sign Nukta
    (0x11930, 0x11930,),  # Dives Akuru Vowel Sign Aa
    (0x1193b, 0x1193d,),  # Dives Akuru Sign Anusvar..Dives Akuru Sign Halanta
    (0x11943, 0x11943,),  # Dives Akuru Sign Nukta
    (0x119d4, 0x119d7,),  # Nandinagari Vowel Sign U..Nandinagari Vowel Sign V
    (0x119da, 0x119db,),  # Nandinagari Vowel Sign E..Nandinagari Vowel Sign A
    (0x119e0, 0x119e0,),  # Nandinagari Sign Virama
    (0x11a01, 0x11a0a,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel L
    (0x11a33, 0x11a38,),  # Zanabazar Square Final C..Zanabazar Square Sign An
    (0x11a3b, 0x11a3e,),  # Zanabazar Square Cluster..Zanabazar Square Cluster
    (0x11a51, 0x11a56,),  # Soyombo Vowel Sign I    ..Soyombo Vowel Sign Oe
    (0x11a59, 0x11a5b,),  # Soyombo Vowel Sign Vocal..Soyombo Vowel Length Mar
    (0x11a8a, 0x11a96,),  # Soyombo Final Consonant ..Soyombo Sign Anusvara
    (0x11a98, 0x11a98,),  # Soyombo Gemination Mark
    (0x11b60, 0x11b60,),  # Sharada Vowel Sign Oe
    (0x11b62, 0x11b64,),  # Sharada Vowel Sign Ue   ..Sharada Vowel Sign Short
    (0x11b66, 0x11b66,),  # Sharada Vowel Sign Candra E
    (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
    (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
    (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama
    (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
    (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
    (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
    (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
    (0x11d31, 0x11d36,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
    (0x11d3a, 0x11d3a,),  # Masaram Gondi Vowel Sign E
    (0x11d3c, 0x11d3d,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
    (0x11d3f, 0x11d45,),  # Masaram Gondi Vowel Sign..Masaram Gondi Virama
    (0x11d47, 0x11d47,),  # Masaram Gondi Ra-kara
    (0x11d90, 0x11d91,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
    (0x11d95, 0x11d95,),  # Gunjala Gondi Sign Anusvara
    (0x11d97, 0x11d97,),  # Gunjala Gondi Virama
    (0x11ef3, 0x11ef4,),  # Makasar Vowel Sign I    ..Makasar Vowel Sign U
    (0x11f00, 0x11f01,),  # Kawi Sign Candrabindu   ..Kawi Sign Anusvara
    (0x11f36, 0x11f3a,),  # Kawi Vowel Sign I       ..Kawi Vowel Sign Vocalic
    (0x11f40, 0x11f41,),  # Kawi Vowel Sign Eu      ..Kawi Sign Killer
    (0x11f5a, 0x11f5a,),  # Kawi Sign Nukta
    (0x13440, 0x13440,),  # Egyptian Hieroglyph Mirror Horizontally
    (0x13447, 0x13455,),  # Egyptian Hieroglyph Modi..Egyptian Hieroglyph Modi
    (0x1611e, 0x16129,),  # Gurung Khema Vowel Sign ..Gurung Khema Vowel Lengt
    (0x1612d, 0x1612f,),  # Gurung Khema Sign Anusva..Gurung Khema Sign Tholho
    (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
    (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
    (0x16f4f, 0x16f4f,),  # Miao Sign Consonant Modifier Bar
    (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
    (0x16fe4, 0x16fe4,),  # Khitan Small Script Filler
    (0x16ff0, 0x16ff1,),  # Vietnamese Alternate Rea..Vietnamese Alternate Rea
    (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
    (0x1cf00, 0x1cf2d,),  # Znamenny Combining Mark ..Znamenny Combining Mark
    (0x1cf30, 0x1cf46,),  # Znamenny Combining Tonal..Znamenny Priznak Modifie
    (0x1d165, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d16d, 0x1d172,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
    (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
    (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
    (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
    (0x1da75, 0x1da75,),  # Signwriting Upper Body Tilting From Hip Joints
    (0x1da84, 0x1da84,),  # Signwriting Location Head Neck
    (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
    (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
    (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
    (0x1e08f, 0x1e08f,),  # Combining Cyrillic Small Letter Byelorussian-ukr
    (0x1e130, 0x1e136,),  # Nyiakeng Puachue Hmong T..Nyiakeng Puachue Hmong T
    (0x1e2ae, 0x1e2ae,),  # Toto Sign Rising Tone
    (0x1e2ec, 0x1e2ef,),  # Wancho Tone Tup         ..Wancho Tone Koini
    (0x1e4ec, 0x1e4ef,),  # Nag Mundari Sign Muhor  ..Nag Mundari Sign Sutuh
    (0x1e5ee, 0x1e5ef,),  # Ol Onal Sign Mu         ..Ol Onal Sign Ikir
    (0x1e6e3, 0x1e6e3,),  # Tai Yo Sign Ue
    (0x1e6e6, 0x1e6e6,),  # Tai Yo Sign Au
    (0x1e6ee, 0x1e6ef,),  # Tai Yo Sign Ay          ..Tai Yo Sign Ang
    (0x1e6f5, 0x1e6f5,),  # Tai Yo Sign Om
    (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
    (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
    (0x1f3fb, 0x1f3ff,),  # Emoji Modifier Fitzpatri..Emoji Modifier Fitzpatri
    (0xe0020, 0xe007f,),  # Tag Space               ..Cancel Tag
    (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
)

ISC_CONSONANT = (
    # Source: IndicSyllabicCategory
    # Date: see file
    #
    (0x00915, 0x00939,),  # Devanagari Letter Ka    ..Devanagari Letter Ha
    (0x00958, 0x0095f,),  # Devanagari Letter Qa    ..Devanagari Letter Yya
    (0x00978, 0x0097f,),  # Devanagari Letter Marwar..Devanagari Letter Bba
    (0x00995, 0x009a8,),  # Bengali Letter Ka       ..Bengali Letter Na
    (0x009aa, 0x009b0,),  # Bengali Letter Pa       ..Bengali Letter Ra
    (0x009b2, 0x009b2,),  # Bengali Letter La
    (0x009b6, 0x009b9,),  # Bengali Letter Sha      ..Bengali Letter Ha
    (0x009dc, 0x009dd,),  # Bengali Letter Rra      ..Bengali Letter Rha
    (0x009df, 0x009df,),  # Bengali Letter Yya
    (0x009f0, 0x009f1,),  # Bengali Letter Ra With M..Bengali Letter Ra With L
    (0x00a15, 0x00a28,),  # Gurmukhi Letter Ka      ..Gurmukhi Letter Na
    (0x00a2a, 0x00a30,),  # Gurmukhi Letter Pa      ..Gurmukhi Letter Ra
    (0x00a32, 0x00a33,),  # Gurmukhi Letter La      ..Gurmukhi Letter Lla
    (0x00a35, 0x00a36,),  # Gurmukhi Letter Va      ..Gurmukhi Letter Sha
    (0x00a38, 0x00a39,),  # Gurmukhi Letter Sa      ..Gurmukhi Letter Ha
    (0x00a59, 0x00a5c,),  # Gurmukhi Letter Khha    ..Gurmukhi Letter Rra
    (0x00a5e, 0x00a5e,),  # Gurmukhi Letter Fa
    (0x00a95, 0x00aa8,),  # Gujarati Letter Ka      ..Gujarati Letter Na
    (0x00aaa, 0x00ab0,),  # Gujarati Letter Pa      ..Gujarati Letter Ra
    (0x00ab2, 0x00ab3,),  # Gujarati Letter La      ..Gujarati Letter Lla
    (0x00ab5, 0x00ab9,),  # Gujarati Letter Va      ..Gujarati Letter Ha
    (0x00af9, 0x00af9,),  # Gujarati Letter Zha
    (0x00b15, 0x00b28,),  # Oriya Letter Ka         ..Oriya Letter Na
    (0x00b2a, 0x00b30,),  # Oriya Letter Pa         ..Oriya Letter Ra
    (0x00b32, 0x00b33,),  # Oriya Letter La         ..Oriya Letter Lla
    (0x00b35, 0x00b39,),  # Oriya Letter Va         ..Oriya Letter Ha
    (0x00b5c, 0x00b5d,),  # Oriya Letter Rra        ..Oriya Letter Rha
    (0x00b5f, 0x00b5f,),  # Oriya Letter Yya
    (0x00b71, 0x00b71,),  # Oriya Letter Wa
    (0x00b95, 0x00b95,),  # Tamil Letter Ka
    (0x00b99, 0x00b9a,),  # Tamil Letter Nga        ..Tamil Letter Ca
    (0x00b9c, 0x00b9c,),  # Tamil Letter Ja
    (0x00b9e, 0x00b9f,),  # Tamil Letter Nya        ..Tamil Letter Tta
    (0x00ba3, 0x00ba4,),  # Tamil Letter Nna        ..Tamil Letter Ta
    (0x00ba8, 0x00baa,),  # Tamil Letter Na         ..Tamil Letter Pa
    (0x00bae, 0x00bb9,),  # Tamil Letter Ma         ..Tamil Letter Ha
    (0x00c15, 0x00c28,),  # Telugu Letter Ka        ..Telugu Letter Na
    (0x00c2a, 0x00c39,),  # Telugu Letter Pa        ..Telugu Letter Ha
    (0x00c58, 0x00c5a,),  # Telugu Letter Tsa       ..Telugu Letter Rrra
    (0x00c95, 0x00ca8,),  # Kannada Letter Ka       ..Kannada Letter Na
    (0x00caa, 0x00cb3,),  # Kannada Letter Pa       ..Kannada Letter Lla
    (0x00cb5, 0x00cb9,),  # Kannada Letter Va       ..Kannada Letter Ha
    (0x00cde, 0x00cde,),  # Kannada Letter Fa
    (0x00d15, 0x00d3a,),  # Malayalam Letter Ka     ..Malayalam Letter Ttta
    (0x00d9a, 0x00db1,),  # Sinhala Letter Alpapraan..Sinhala Letter Dantaja N
    (0x00db3, 0x00dbb,),  # Sinhala Letter Sanyaka D..Sinhala Letter Rayanna
    (0x00dbd, 0x00dbd,),  # Sinhala Letter Dantaja Layanna
    (0x00dc0, 0x00dc6,),  # Sinhala Letter Vayanna  ..Sinhala Letter Fayanna
    (0x00e01, 0x00e2e,),  # Thai Character Ko Kai   ..Thai Character Ho Nokhuk
    (0x00e81, 0x00e82,),  # Lao Letter Ko           ..Lao Letter Kho Sung
    (0x00e84, 0x00e84,),  # Lao Letter Kho Tam
    (0x00e86, 0x00e8a,),  # Lao Letter Pali Gha     ..Lao Letter So Tam
    (0x00e8c, 0x00ea3,),  # Lao Letter Pali Jha     ..Lao Letter Lo Ling
    (0x00ea5, 0x00ea5,),  # Lao Letter Lo Loot
    (0x00ea7, 0x00eae,),  # Lao Letter Wo           ..Lao Letter Ho Tam
    (0x00edc, 0x00edf,),  # Lao Ho No               ..Lao Letter Khmu Nyo
    (0x00f40, 0x00f47,),  # Tibetan Letter Ka       ..Tibetan Letter Ja
    (0x00f49, 0x00f6c,),  # Tibetan Letter Nya      ..Tibetan Letter Rra
    (0x01000, 0x01020,),  # Myanmar Letter Ka       ..Myanmar Letter Lla
    (0x0103f, 0x0103f,),  # Myanmar Letter Great Sa
    (0x01050, 0x01051,),  # Myanmar Letter Sha      ..Myanmar Letter Ssa
    (0x0105a, 0x0105d,),  # Myanmar Letter Mon Nga  ..Myanmar Letter Mon Bbe
    (0x01061, 0x01061,),  # Myanmar Letter Sgaw Karen Sha
    (0x01065, 0x01066,),  # Myanmar Letter Western P..Myanmar Letter Western P
    (0x0106e, 0x01070,),  # Myanmar Letter Eastern P..Myanmar Letter Eastern P
    (0x01075, 0x01081,),  # Myanmar Letter Shan Ka  ..Myanmar Letter Shan Ha
    (0x0108e, 0x0108e,),  # Myanmar Letter Rumai Palaung Fa
    (0x01703, 0x01711,),  # Tagalog Letter Ka       ..Tagalog Letter Ha
    (0x0171f, 0x0171f,),  # Tagalog Letter Archaic Ra
    (0x01723, 0x01731,),  # Hanunoo Letter Ka       ..Hanunoo Letter Ha
    (0x01743, 0x01751,),  # Buhid Letter Ka         ..Buhid Letter Ha
    (0x01763, 0x0176c,),  # Tagbanwa Letter Ka      ..Tagbanwa Letter Ya
    (0x0176e, 0x01770,),  # Tagbanwa Letter La      ..Tagbanwa Letter Sa
    (0x01780, 0x017a2,),  # Khmer Letter Ka         ..Khmer Letter Qa
    (0x01900, 0x0191e,),  # Limbu Vowel-carrier Lett..Limbu Letter Tra
    (0x01950, 0x01962,),  # Tai Le Letter Ka        ..Tai Le Letter Na
    (0x01980, 0x019ab,),  # New Tai Lue Letter High ..New Tai Lue Letter Low S
    (0x01a00, 0x01a16,),  # Buginese Letter Ka      ..Buginese Letter Ha
    (0x01a20, 0x01a4c,),  # Tai Tham Letter High Ka ..Tai Tham Letter Low Ha
    (0x01a53, 0x01a54,),  # Tai Tham Letter Lae     ..Tai Tham Letter Great Sa
    (0x01b13, 0x01b33,),  # Balinese Letter Ka      ..Balinese Letter Ha
    (0x01b45, 0x01b4c,),  # Balinese Letter Kaf Sasa..Balinese Letter Archaic
    (0x01b8a, 0x01ba0,),  # Sundanese Letter Ka     ..Sundanese Letter Ha
    (0x01bae, 0x01baf,),  # Sundanese Letter Kha    ..Sundanese Letter Sya
    (0x01bbb, 0x01bbd,),  # Sundanese Letter Reu    ..Sundanese Letter Bha
    (0x01bc0, 0x01be3,),  # Batak Letter A          ..Batak Letter Mba
    (0x01c00, 0x01c23,),  # Lepcha Letter Ka        ..Lepcha Letter A
    (0x01c4d, 0x01c4f,),  # Lepcha Letter Tta       ..Lepcha Letter Dda
    (0x0a807, 0x0a80a,),  # Syloti Nagri Letter Ko  ..Syloti Nagri Letter Gho
    (0x0a80c, 0x0a822,),  # Syloti Nagri Letter Co  ..Syloti Nagri Letter Ho
    (0x0a840, 0x0a85d,),  # Phags-pa Letter Ka      ..Phags-pa Letter A
    (0x0a862, 0x0a865,),  # Phags-pa Letter Qa      ..Phags-pa Letter Gga
    (0x0a869, 0x0a870,),  # Phags-pa Letter Tta     ..Phags-pa Letter Aspirate
    (0x0a872, 0x0a872,),  # Phags-pa Superfixed Letter Ra
    (0x0a892, 0x0a8b3,),  # Saurashtra Letter Ka    ..Saurashtra Letter Lla
    (0x0a90a, 0x0a921,),  # Kayah Li Letter Ka      ..Kayah Li Letter Ca
    (0x0a930, 0x0a946,),  # Rejang Letter Ka        ..Rejang Letter A
    (0x0a989, 0x0a98b,),  # Javanese Letter Pa Cerek..Javanese Letter Nga Lele
    (0x0a98f, 0x0a9b2,),  # Javanese Letter Ka      ..Javanese Letter Ha
    (0x0a9e0, 0x0a9e4,),  # Myanmar Letter Shan Gha ..Myanmar Letter Shan Bha
    (0x0a9e7, 0x0a9ef,),  # Myanmar Letter Tai Laing..Myanmar Letter Tai Laing
    (0x0a9fa, 0x0a9fe,),  # Myanmar Letter Tai Laing..Myanmar Letter Tai Laing
    (0x0aa06, 0x0aa28,),  # Cham Letter Ka          ..Cham Letter Ha
    (0x0aa60, 0x0aa6f,),  # Myanmar Letter Khamti Ga..Myanmar Letter Khamti Fa
    (0x0aa71, 0x0aa73,),  # Myanmar Letter Khamti Xa..Myanmar Letter Khamti Ra
    (0x0aa7a, 0x0aa7a,),  # Myanmar Letter Aiton Ra
    (0x0aa7e, 0x0aaaf,),  # Myanmar Letter Shwe Pala..Tai Viet Letter High O
    (0x0aae2, 0x0aaea,),  # Meetei Mayek Letter Cha ..Meetei Mayek Letter Ssa
    (0x0abc0, 0x0abcd,),  # Meetei Mayek Letter Kok ..Meetei Mayek Letter Huk
    (0x0abd0, 0x0abd0,),  # Meetei Mayek Letter Pham
    (0x0abd2, 0x0abda,),  # Meetei Mayek Letter Gok ..Meetei Mayek Letter Bham
    (0x10a00, 0x10a00,),  # Kharoshthi Letter A
    (0x10a10, 0x10a13,),  # Kharoshthi Letter Ka    ..Kharoshthi Letter Gha
    (0x10a15, 0x10a17,),  # Kharoshthi Letter Ca    ..Kharoshthi Letter Ja
    (0x10a19, 0x10a35,),  # Kharoshthi Letter Nya   ..Kharoshthi Letter Vha
    (0x11013, 0x11037,),  # Brahmi Letter Ka        ..Brahmi Letter Old Tamil
    (0x11075, 0x11075,),  # Brahmi Letter Old Tamil Lla
    (0x1108d, 0x110af,),  # Kaithi Letter Ka        ..Kaithi Letter Ha
    (0x11107, 0x11126,),  # Chakma Letter Kaa       ..Chakma Letter Haa
    (0x11144, 0x11144,),  # Chakma Letter Lhaa
    (0x11147, 0x11147,),  # Chakma Letter Vaa
    (0x11155, 0x11172,),  # Mahajani Letter Ka      ..Mahajani Letter Rra
    (0x11191, 0x111b2,),  # Sharada Letter Ka       ..Sharada Letter Ha
    (0x11208, 0x11211,),  # Khojki Letter Ka        ..Khojki Letter Jja
    (0x11213, 0x1122b,),  # Khojki Letter Nya       ..Khojki Letter Lla
    (0x1123f, 0x1123f,),  # Khojki Letter Qa
    (0x11284, 0x11286,),  # Multani Letter Ka       ..Multani Letter Ga
    (0x11288, 0x11288,),  # Multani Letter Gha
    (0x1128a, 0x1128d,),  # Multani Letter Ca       ..Multani Letter Jja
    (0x1128f, 0x1129d,),  # Multani Letter Nya      ..Multani Letter Ba
    (0x1129f, 0x112a8,),  # Multani Letter Bha      ..Multani Letter Rha
    (0x112ba, 0x112de,),  # Khudawadi Letter Ka     ..Khudawadi Letter Ha
    (0x11315, 0x11328,),  # Grantha Letter Ka       ..Grantha Letter Na
    (0x1132a, 0x11330,),  # Grantha Letter Pa       ..Grantha Letter Ra
    (0x11332, 0x11333,),  # Grantha Letter La       ..Grantha Letter Lla
    (0x11335, 0x11339,),  # Grantha Letter Va       ..Grantha Letter Ha
    (0x11392, 0x113b5,),  # Tulu-tigalari Letter Ka ..Tulu-tigalari Letter Lll
    (0x1140e, 0x11434,),  # Newa Letter Ka          ..Newa Letter Ha
    (0x1148f, 0x114af,),  # Tirhuta Letter Ka       ..Tirhuta Letter Ha
    (0x1158e, 0x115ae,),  # Siddham Letter Ka       ..Siddham Letter Ha
    (0x1160e, 0x1162f,),  # Modi Letter Ka          ..Modi Letter Lla
    (0x1168a, 0x116aa,),  # Takri Letter Ka         ..Takri Letter Rra
    (0x116b8, 0x116b8,),  # Takri Letter Archaic Kha
    (0x11700, 0x1171a,),  # Ahom Letter Ka          ..Ahom Letter Alternate Ba
    (0x11740, 0x11746,),  # Ahom Letter Ca          ..Ahom Letter Lla
    (0x1180a, 0x1182b,),  # Dogra Letter Ka         ..Dogra Letter Rra
    (0x1190c, 0x11913,),  # Dives Akuru Letter Ka   ..Dives Akuru Letter Ja
    (0x11915, 0x11916,),  # Dives Akuru Letter Nya  ..Dives Akuru Letter Tta
    (0x11918, 0x1192f,),  # Dives Akuru Letter Dda  ..Dives Akuru Letter Za
    (0x119ae, 0x119d0,),  # Nandinagari Letter Ka   ..Nandinagari Letter Rra
    (0x11a00, 0x11a00,),  # Zanabazar Square Letter A
    (0x11a0b, 0x11a32,),  # Zanabazar Square Letter ..Zanabazar Square Letter
    (0x11a50, 0x11a50,),  # Soyombo Letter A
    (0x11a5c, 0x11a83,),  # Soyombo Letter Ka       ..Soyombo Letter Kssa
    (0x11c0e, 0x11c2e,),  # Bhaiksuki Letter Ka     ..Bhaiksuki Letter Ha
    (0x11c72, 0x11c8f,),  # Marchen Letter Ka       ..Marchen Letter A
    (0x11d0c, 0x11d30,),  # Masaram Gondi Letter Ka ..Masaram Gondi Letter Tra
    (0x11d6c, 0x11d89,),  # Gunjala Gondi Letter Ya ..Gunjala Gondi Letter Sa
    (0x11ee0, 0x11ef1,),  # Makasar Letter Ka       ..Makasar Letter A
    (0x11f12, 0x11f33,),  # Kawi Letter Ka          ..Kawi Letter Jnya
    (0x16101, 0x1611d,),  # Gurung Khema Letter Ka  ..Gurung Khema Letter Sa
    (0x16d43, 0x16d62,),  # Kirat Rai Letter A      ..Kirat Rai Letter Ha
)
