from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

DUTCH_LANG_MODEL = {
    26: {  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.LIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.LIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    29: {  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.UNLIKELY,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    38: {  # 'C'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.UNLIKELY,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    24: {  # 'D'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    27: {  # 'E'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.LIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.POSITIVE,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.POSITIVE,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.LIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.LIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.UNLIKELY,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    47: {  # 'F'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    40: {  # 'G'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.UNLIKELY,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.UNLIKELY,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    25: {  # 'H'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.UNLIKELY,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.UNLIKELY,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    31: {  # 'I'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        43: SequenceLikelihood.LIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    46: {  # 'J'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.UNLIKELY,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    43: {  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    42: {  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.LIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    30: {  # 'M'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.UNLIKELY,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    36: {  # 'N'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.LIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.LIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    34: {  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.LIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.LIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.UNLIKELY,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    39: {  # 'P'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    55: {  # 'Q'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    41: {  # 'R'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.LIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.LIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.UNLIKELY,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    28: {  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.LIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    37: {  # 'T'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.LIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.LIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    48: {  # 'U'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.LIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.LIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.UNLIKELY,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    32: {  # 'V'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.LIKELY,  # 'C'
        24: SequenceLikelihood.LIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.LIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.LIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.UNLIKELY,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    35: {  # 'W'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.LIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    54: {  # 'X'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    53: {  # 'Y'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.LIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    45: {  # 'Z'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    3: {  # 'a'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.LIKELY,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.POSITIVE,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.UNLIKELY,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.LIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    19: {  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.LIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    20: {  # 'c'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.UNLIKELY,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    8: {  # 'd'
        26: SequenceLikelihood.LIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.UNLIKELY,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    1: {  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.POSITIVE,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.POSITIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.POSITIVE,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    23: {  # 'f'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.LIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    11: {  # 'g'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.LIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    15: {  # 'h'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    4: {  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.UNLIKELY,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.UNLIKELY,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.LIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.POSITIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    18: {  # 'j'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    12: {  # 'k'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.LIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.UNLIKELY,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    10: {  # 'l'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    13: {  # 'm'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    2: {  # 'n'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.LIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    7: {  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.POSITIVE,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.LIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    17: {  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    51: {  # 'q'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    6: {  # 'r'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.LIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    9: {  # 's'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    5: {  # 't'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.POSITIVE,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.POSITIVE,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    16: {  # 'u'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.LIKELY,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.LIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.POSITIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.UNLIKELY,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.LIKELY,  # 'ï'
        63: SequenceLikelihood.UNLIKELY,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    14: {  # 'v'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    21: {  # 'w'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.LIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.LIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    44: {  # 'x'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.LIKELY,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        16: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.UNLIKELY,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    33: {  # 'y'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        8: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        2: SequenceLikelihood.LIKELY,  # 'n'
        7: SequenceLikelihood.LIKELY,  # 'o'
        17: SequenceLikelihood.POSITIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        21: SequenceLikelihood.LIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.UNLIKELY,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    22: {  # 'z'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.POSITIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.POSITIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.POSITIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.LIKELY,  # 'y'
        22: SequenceLikelihood.LIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.UNLIKELY,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    73: {  # 'À'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    67: {  # 'Â'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    69: {  # 'Ç'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    71: {  # 'È'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    62: {  # 'É'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        76: SequenceLikelihood.UNLIKELY,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    76: {  # 'Ê'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    66: {  # 'Ë'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    72: {  # 'Î'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    74: {  # 'Ï'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.UNLIKELY,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    77: {  # 'Ñ'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    75: {  # 'Ô'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    80: {  # 'Ù'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    78: {  # 'Û'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.UNLIKELY,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    57: {  # 'à'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.UNLIKELY,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    60: {  # 'â'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.UNLIKELY,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.UNLIKELY,  # 'œ'
    },
    58: {  # 'ç'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    56: {  # 'è'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.UNLIKELY,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    50: {  # 'é'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.UNLIKELY,  # 'â'
        58: SequenceLikelihood.UNLIKELY,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.POSITIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    59: {  # 'ê'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.UNLIKELY,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    49: {  # 'ë'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.UNLIKELY,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        48: SequenceLikelihood.UNLIKELY,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.LIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    65: {  # 'î'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    52: {  # 'ï'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.UNLIKELY,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.POSITIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.UNLIKELY,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    63: {  # 'ñ'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    61: {  # 'ô'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.UNLIKELY,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.UNLIKELY,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    68: {  # 'ù'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.UNLIKELY,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    64: {  # 'û'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.UNLIKELY,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.UNLIKELY,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.UNLIKELY,  # 'p'
        51: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.UNLIKELY,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    79: {  # 'Œ'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.NEGATIVE,  # 'D'
        27: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.NEGATIVE,  # 'G'
        25: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.NEGATIVE,  # 'K'
        42: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        34: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.NEGATIVE,  # 'V'
        35: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.NEGATIVE,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.NEGATIVE,  # 'j'
        12: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.NEGATIVE,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.NEGATIVE,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
    70: {  # 'œ'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        29: SequenceLikelihood.NEGATIVE,  # 'B'
        38: SequenceLikelihood.NEGATIVE,  # 'C'
        24: SequenceLikelihood.UNLIKELY,  # 'D'
        27: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        40: SequenceLikelihood.UNLIKELY,  # 'G'
        25: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        43: SequenceLikelihood.UNLIKELY,  # 'K'
        42: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        34: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        48: SequenceLikelihood.NEGATIVE,  # 'U'
        32: SequenceLikelihood.UNLIKELY,  # 'V'
        35: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        45: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        8: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        23: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.NEGATIVE,  # 'g'
        15: SequenceLikelihood.UNLIKELY,  # 'h'
        4: SequenceLikelihood.NEGATIVE,  # 'i'
        18: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        2: SequenceLikelihood.NEGATIVE,  # 'n'
        7: SequenceLikelihood.UNLIKELY,  # 'o'
        17: SequenceLikelihood.NEGATIVE,  # 'p'
        51: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        16: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        21: SequenceLikelihood.NEGATIVE,  # 'w'
        44: SequenceLikelihood.NEGATIVE,  # 'x'
        33: SequenceLikelihood.UNLIKELY,  # 'y'
        22: SequenceLikelihood.NEGATIVE,  # 'z'
        73: SequenceLikelihood.NEGATIVE,  # 'À'
        67: SequenceLikelihood.NEGATIVE,  # 'Â'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        71: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        76: SequenceLikelihood.NEGATIVE,  # 'Ê'
        66: SequenceLikelihood.NEGATIVE,  # 'Ë'
        72: SequenceLikelihood.NEGATIVE,  # 'Î'
        74: SequenceLikelihood.NEGATIVE,  # 'Ï'
        77: SequenceLikelihood.NEGATIVE,  # 'Ñ'
        75: SequenceLikelihood.NEGATIVE,  # 'Ô'
        80: SequenceLikelihood.NEGATIVE,  # 'Ù'
        78: SequenceLikelihood.NEGATIVE,  # 'Û'
        57: SequenceLikelihood.NEGATIVE,  # 'à'
        60: SequenceLikelihood.NEGATIVE,  # 'â'
        58: SequenceLikelihood.NEGATIVE,  # 'ç'
        56: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        59: SequenceLikelihood.NEGATIVE,  # 'ê'
        49: SequenceLikelihood.NEGATIVE,  # 'ë'
        65: SequenceLikelihood.NEGATIVE,  # 'î'
        52: SequenceLikelihood.NEGATIVE,  # 'ï'
        63: SequenceLikelihood.NEGATIVE,  # 'ñ'
        61: SequenceLikelihood.NEGATIVE,  # 'ô'
        68: SequenceLikelihood.NEGATIVE,  # 'ù'
        64: SequenceLikelihood.NEGATIVE,  # 'û'
        79: SequenceLikelihood.NEGATIVE,  # 'Œ'
        70: SequenceLikelihood.NEGATIVE,  # 'œ'
    },
}

# Character Mapping Table(s):
CP037_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 60,  # 'â'
    67: 0,  # 'ä'
    68: 57,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 58,  # 'ç'
    73: 63,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 50,  # 'é'
    82: 59,  # 'ê'
    83: 49,  # 'ë'
    84: 56,  # 'è'
    85: 0,  # 'í'
    86: 65,  # 'î'
    87: 52,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 67,  # 'Â'
    99: 0,  # 'Ä'
    100: 73,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 69,  # 'Ç'
    105: 77,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 76,  # 'Ê'
    115: 66,  # 'Ë'
    116: 71,  # 'È'
    117: 0,  # 'Í'
    118: 72,  # 'Î'
    119: 74,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 3,  # 'a'
    130: 19,  # 'b'
    131: 20,  # 'c'
    132: 8,  # 'd'
    133: 1,  # 'e'
    134: 23,  # 'f'
    135: 11,  # 'g'
    136: 15,  # 'h'
    137: 4,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 18,  # 'j'
    146: 12,  # 'k'
    147: 10,  # 'l'
    148: 13,  # 'm'
    149: 2,  # 'n'
    150: 7,  # 'o'
    151: 17,  # 'p'
    152: 51,  # 'q'
    153: 6,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 5,  # 't'
    164: 16,  # 'u'
    165: 14,  # 'v'
    166: 21,  # 'w'
    167: 44,  # 'x'
    168: 33,  # 'y'
    169: 22,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 26,  # 'A'
    194: 29,  # 'B'
    195: 38,  # 'C'
    196: 24,  # 'D'
    197: 27,  # 'E'
    198: 47,  # 'F'
    199: 40,  # 'G'
    200: 25,  # 'H'
    201: 31,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 61,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 46,  # 'J'
    210: 43,  # 'K'
    211: 42,  # 'L'
    212: 30,  # 'M'
    213: 36,  # 'N'
    214: 34,  # 'O'
    215: 39,  # 'P'
    216: 55,  # 'Q'
    217: 41,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 64,  # 'û'
    220: 0,  # 'ü'
    221: 68,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 28,  # 'S'
    227: 37,  # 'T'
    228: 48,  # 'U'
    229: 32,  # 'V'
    230: 35,  # 'W'
    231: 54,  # 'X'
    232: 53,  # 'Y'
    233: 45,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 75,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 78,  # 'Û'
    252: 0,  # 'Ü'
    253: 80,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Dutch",
    char_to_order_map=CP037_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834365996117526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

CP437_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 29,  # 'B'
    67: 38,  # 'C'
    68: 24,  # 'D'
    69: 27,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 25,  # 'H'
    73: 31,  # 'I'
    74: 46,  # 'J'
    75: 43,  # 'K'
    76: 42,  # 'L'
    77: 30,  # 'M'
    78: 36,  # 'N'
    79: 34,  # 'O'
    80: 39,  # 'P'
    81: 55,  # 'Q'
    82: 41,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 48,  # 'U'
    86: 32,  # 'V'
    87: 35,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 45,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 20,  # 'c'
    100: 8,  # 'd'
    101: 1,  # 'e'
    102: 23,  # 'f'
    103: 11,  # 'g'
    104: 15,  # 'h'
    105: 4,  # 'i'
    106: 18,  # 'j'
    107: 12,  # 'k'
    108: 10,  # 'l'
    109: 13,  # 'm'
    110: 2,  # 'n'
    111: 7,  # 'o'
    112: 17,  # 'p'
    113: 51,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 16,  # 'u'
    118: 14,  # 'v'
    119: 21,  # 'w'
    120: 44,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 69,  # 'Ç'
    129: 0,  # 'ü'
    130: 50,  # 'é'
    131: 60,  # 'â'
    132: 0,  # 'ä'
    133: 57,  # 'à'
    134: 0,  # 'å'
    135: 58,  # 'ç'
    136: 59,  # 'ê'
    137: 49,  # 'ë'
    138: 56,  # 'è'
    139: 52,  # 'ï'
    140: 65,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 61,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 64,  # 'û'
    151: 68,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 63,  # 'ñ'
    165: 77,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Dutch",
    char_to_order_map=CP437_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834408911909966,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

CP500_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 60,  # 'â'
    67: 0,  # 'ä'
    68: 57,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 58,  # 'ç'
    73: 63,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 50,  # 'é'
    82: 59,  # 'ê'
    83: 49,  # 'ë'
    84: 56,  # 'è'
    85: 0,  # 'í'
    86: 65,  # 'î'
    87: 52,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 67,  # 'Â'
    99: 0,  # 'Ä'
    100: 73,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 69,  # 'Ç'
    105: 77,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 76,  # 'Ê'
    115: 66,  # 'Ë'
    116: 71,  # 'È'
    117: 0,  # 'Í'
    118: 72,  # 'Î'
    119: 74,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 3,  # 'a'
    130: 19,  # 'b'
    131: 20,  # 'c'
    132: 8,  # 'd'
    133: 1,  # 'e'
    134: 23,  # 'f'
    135: 11,  # 'g'
    136: 15,  # 'h'
    137: 4,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 18,  # 'j'
    146: 12,  # 'k'
    147: 10,  # 'l'
    148: 13,  # 'm'
    149: 2,  # 'n'
    150: 7,  # 'o'
    151: 17,  # 'p'
    152: 51,  # 'q'
    153: 6,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 5,  # 't'
    164: 16,  # 'u'
    165: 14,  # 'v'
    166: 21,  # 'w'
    167: 44,  # 'x'
    168: 33,  # 'y'
    169: 22,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 26,  # 'A'
    194: 29,  # 'B'
    195: 38,  # 'C'
    196: 24,  # 'D'
    197: 27,  # 'E'
    198: 47,  # 'F'
    199: 40,  # 'G'
    200: 25,  # 'H'
    201: 31,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 61,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 46,  # 'J'
    210: 43,  # 'K'
    211: 42,  # 'L'
    212: 30,  # 'M'
    213: 36,  # 'N'
    214: 34,  # 'O'
    215: 39,  # 'P'
    216: 55,  # 'Q'
    217: 41,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 64,  # 'û'
    220: 0,  # 'ü'
    221: 68,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 28,  # 'S'
    227: 37,  # 'T'
    228: 48,  # 'U'
    229: 32,  # 'V'
    230: 35,  # 'W'
    231: 54,  # 'X'
    232: 53,  # 'Y'
    233: 45,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 75,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 78,  # 'Û'
    252: 0,  # 'Ü'
    253: 80,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Dutch",
    char_to_order_map=CP500_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834365996117526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

CP850_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 29,  # 'B'
    67: 38,  # 'C'
    68: 24,  # 'D'
    69: 27,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 25,  # 'H'
    73: 31,  # 'I'
    74: 46,  # 'J'
    75: 43,  # 'K'
    76: 42,  # 'L'
    77: 30,  # 'M'
    78: 36,  # 'N'
    79: 34,  # 'O'
    80: 39,  # 'P'
    81: 55,  # 'Q'
    82: 41,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 48,  # 'U'
    86: 32,  # 'V'
    87: 35,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 45,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 20,  # 'c'
    100: 8,  # 'd'
    101: 1,  # 'e'
    102: 23,  # 'f'
    103: 11,  # 'g'
    104: 15,  # 'h'
    105: 4,  # 'i'
    106: 18,  # 'j'
    107: 12,  # 'k'
    108: 10,  # 'l'
    109: 13,  # 'm'
    110: 2,  # 'n'
    111: 7,  # 'o'
    112: 17,  # 'p'
    113: 51,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 16,  # 'u'
    118: 14,  # 'v'
    119: 21,  # 'w'
    120: 44,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 69,  # 'Ç'
    129: 0,  # 'ü'
    130: 50,  # 'é'
    131: 60,  # 'â'
    132: 0,  # 'ä'
    133: 57,  # 'à'
    134: 0,  # 'å'
    135: 58,  # 'ç'
    136: 59,  # 'ê'
    137: 49,  # 'ë'
    138: 56,  # 'è'
    139: 52,  # 'ï'
    140: 65,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 61,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 64,  # 'û'
    151: 68,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 63,  # 'ñ'
    165: 77,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 67,  # 'Â'
    183: 73,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 76,  # 'Ê'
    211: 66,  # 'Ë'
    212: 71,  # 'È'
    213: 0,  # 'ı'
    214: 0,  # 'Í'
    215: 72,  # 'Î'
    216: 74,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 75,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 78,  # 'Û'
    235: 80,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Dutch",
    char_to_order_map=CP850_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834365996117526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

CP858_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 29,  # 'B'
    67: 38,  # 'C'
    68: 24,  # 'D'
    69: 27,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 25,  # 'H'
    73: 31,  # 'I'
    74: 46,  # 'J'
    75: 43,  # 'K'
    76: 42,  # 'L'
    77: 30,  # 'M'
    78: 36,  # 'N'
    79: 34,  # 'O'
    80: 39,  # 'P'
    81: 55,  # 'Q'
    82: 41,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 48,  # 'U'
    86: 32,  # 'V'
    87: 35,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 45,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 20,  # 'c'
    100: 8,  # 'd'
    101: 1,  # 'e'
    102: 23,  # 'f'
    103: 11,  # 'g'
    104: 15,  # 'h'
    105: 4,  # 'i'
    106: 18,  # 'j'
    107: 12,  # 'k'
    108: 10,  # 'l'
    109: 13,  # 'm'
    110: 2,  # 'n'
    111: 7,  # 'o'
    112: 17,  # 'p'
    113: 51,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 16,  # 'u'
    118: 14,  # 'v'
    119: 21,  # 'w'
    120: 44,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 69,  # 'Ç'
    129: 0,  # 'ü'
    130: 50,  # 'é'
    131: 60,  # 'â'
    132: 0,  # 'ä'
    133: 57,  # 'à'
    134: 0,  # 'å'
    135: 58,  # 'ç'
    136: 59,  # 'ê'
    137: 49,  # 'ë'
    138: 56,  # 'è'
    139: 52,  # 'ï'
    140: 65,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 61,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 64,  # 'û'
    151: 68,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 63,  # 'ñ'
    165: 77,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 67,  # 'Â'
    183: 73,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 76,  # 'Ê'
    211: 66,  # 'Ë'
    212: 71,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 0,  # 'Í'
    215: 72,  # 'Î'
    216: 74,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 75,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 78,  # 'Û'
    235: 80,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Dutch",
    char_to_order_map=CP858_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834365996117526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

ISO_8859_1_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 29,  # 'B'
    67: 38,  # 'C'
    68: 24,  # 'D'
    69: 27,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 25,  # 'H'
    73: 31,  # 'I'
    74: 46,  # 'J'
    75: 43,  # 'K'
    76: 42,  # 'L'
    77: 30,  # 'M'
    78: 36,  # 'N'
    79: 34,  # 'O'
    80: 39,  # 'P'
    81: 55,  # 'Q'
    82: 41,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 48,  # 'U'
    86: 32,  # 'V'
    87: 35,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 45,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 20,  # 'c'
    100: 8,  # 'd'
    101: 1,  # 'e'
    102: 23,  # 'f'
    103: 11,  # 'g'
    104: 15,  # 'h'
    105: 4,  # 'i'
    106: 18,  # 'j'
    107: 12,  # 'k'
    108: 10,  # 'l'
    109: 13,  # 'm'
    110: 2,  # 'n'
    111: 7,  # 'o'
    112: 17,  # 'p'
    113: 51,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 16,  # 'u'
    118: 14,  # 'v'
    119: 21,  # 'w'
    120: 44,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 73,  # 'À'
    193: 0,  # 'Á'
    194: 67,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 69,  # 'Ç'
    200: 71,  # 'È'
    201: 62,  # 'É'
    202: 76,  # 'Ê'
    203: 66,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 72,  # 'Î'
    207: 74,  # 'Ï'
    208: 0,  # 'Ð'
    209: 77,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 75,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 80,  # 'Ù'
    218: 0,  # 'Ú'
    219: 78,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 57,  # 'à'
    225: 0,  # 'á'
    226: 60,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 58,  # 'ç'
    232: 56,  # 'è'
    233: 50,  # 'é'
    234: 59,  # 'ê'
    235: 49,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 65,  # 'î'
    239: 52,  # 'ï'
    240: 0,  # 'ð'
    241: 63,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 61,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 68,  # 'ù'
    250: 0,  # 'ú'
    251: 64,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Dutch",
    char_to_order_map=ISO_8859_1_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834365996117526,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

ISO_8859_15_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 29,  # 'B'
    67: 38,  # 'C'
    68: 24,  # 'D'
    69: 27,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 25,  # 'H'
    73: 31,  # 'I'
    74: 46,  # 'J'
    75: 43,  # 'K'
    76: 42,  # 'L'
    77: 30,  # 'M'
    78: 36,  # 'N'
    79: 34,  # 'O'
    80: 39,  # 'P'
    81: 55,  # 'Q'
    82: 41,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 48,  # 'U'
    86: 32,  # 'V'
    87: 35,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 45,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 20,  # 'c'
    100: 8,  # 'd'
    101: 1,  # 'e'
    102: 23,  # 'f'
    103: 11,  # 'g'
    104: 15,  # 'h'
    105: 4,  # 'i'
    106: 18,  # 'j'
    107: 12,  # 'k'
    108: 10,  # 'l'
    109: 13,  # 'm'
    110: 2,  # 'n'
    111: 7,  # 'o'
    112: 17,  # 'p'
    113: 51,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 16,  # 'u'
    118: 14,  # 'v'
    119: 21,  # 'w'
    120: 44,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 79,  # 'Œ'
    189: 70,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 73,  # 'À'
    193: 0,  # 'Á'
    194: 67,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 69,  # 'Ç'
    200: 71,  # 'È'
    201: 62,  # 'É'
    202: 76,  # 'Ê'
    203: 66,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 72,  # 'Î'
    207: 74,  # 'Ï'
    208: 0,  # 'Ð'
    209: 77,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 75,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 80,  # 'Ù'
    218: 0,  # 'Ú'
    219: 78,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 57,  # 'à'
    225: 0,  # 'á'
    226: 60,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 58,  # 'ç'
    232: 56,  # 'è'
    233: 50,  # 'é'
    234: 59,  # 'ê'
    235: 49,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 65,  # 'î'
    239: 52,  # 'ï'
    240: 0,  # 'ð'
    241: 63,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 61,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 68,  # 'ù'
    250: 0,  # 'ú'
    251: 64,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Dutch",
    char_to_order_map=ISO_8859_15_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834360196714842,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

MACROMAN_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 29,  # 'B'
    67: 38,  # 'C'
    68: 24,  # 'D'
    69: 27,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 25,  # 'H'
    73: 31,  # 'I'
    74: 46,  # 'J'
    75: 43,  # 'K'
    76: 42,  # 'L'
    77: 30,  # 'M'
    78: 36,  # 'N'
    79: 34,  # 'O'
    80: 39,  # 'P'
    81: 55,  # 'Q'
    82: 41,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 48,  # 'U'
    86: 32,  # 'V'
    87: 35,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 45,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 20,  # 'c'
    100: 8,  # 'd'
    101: 1,  # 'e'
    102: 23,  # 'f'
    103: 11,  # 'g'
    104: 15,  # 'h'
    105: 4,  # 'i'
    106: 18,  # 'j'
    107: 12,  # 'k'
    108: 10,  # 'l'
    109: 13,  # 'm'
    110: 2,  # 'n'
    111: 7,  # 'o'
    112: 17,  # 'p'
    113: 51,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 16,  # 'u'
    118: 14,  # 'v'
    119: 21,  # 'w'
    120: 44,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 69,  # 'Ç'
    131: 62,  # 'É'
    132: 77,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 57,  # 'à'
    137: 60,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 58,  # 'ç'
    142: 50,  # 'é'
    143: 56,  # 'è'
    144: 59,  # 'ê'
    145: 49,  # 'ë'
    146: 0,  # 'í'
    147: 0,  # 'ì'
    148: 65,  # 'î'
    149: 52,  # 'ï'
    150: 63,  # 'ñ'
    151: 0,  # 'ó'
    152: 0,  # 'ò'
    153: 61,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 68,  # 'ù'
    158: 64,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 73,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 79,  # 'Œ'
    207: 70,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 67,  # 'Â'
    230: 76,  # 'Ê'
    231: 0,  # 'Á'
    232: 66,  # 'Ë'
    233: 71,  # 'È'
    234: 0,  # 'Í'
    235: 72,  # 'Î'
    236: 74,  # 'Ï'
    237: 0,  # 'Ì'
    238: 0,  # 'Ó'
    239: 75,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 0,  # 'Ú'
    243: 78,  # 'Û'
    244: 80,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Dutch",
    char_to_order_map=MACROMAN_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834360196714842,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)

WINDOWS_1252_DUTCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 29,  # 'B'
    67: 38,  # 'C'
    68: 24,  # 'D'
    69: 27,  # 'E'
    70: 47,  # 'F'
    71: 40,  # 'G'
    72: 25,  # 'H'
    73: 31,  # 'I'
    74: 46,  # 'J'
    75: 43,  # 'K'
    76: 42,  # 'L'
    77: 30,  # 'M'
    78: 36,  # 'N'
    79: 34,  # 'O'
    80: 39,  # 'P'
    81: 55,  # 'Q'
    82: 41,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 48,  # 'U'
    86: 32,  # 'V'
    87: 35,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 45,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 20,  # 'c'
    100: 8,  # 'd'
    101: 1,  # 'e'
    102: 23,  # 'f'
    103: 11,  # 'g'
    104: 15,  # 'h'
    105: 4,  # 'i'
    106: 18,  # 'j'
    107: 12,  # 'k'
    108: 10,  # 'l'
    109: 13,  # 'm'
    110: 2,  # 'n'
    111: 7,  # 'o'
    112: 17,  # 'p'
    113: 51,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 5,  # 't'
    117: 16,  # 'u'
    118: 14,  # 'v'
    119: 21,  # 'w'
    120: 44,  # 'x'
    121: 33,  # 'y'
    122: 22,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 79,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 70,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 73,  # 'À'
    193: 0,  # 'Á'
    194: 67,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 69,  # 'Ç'
    200: 71,  # 'È'
    201: 62,  # 'É'
    202: 76,  # 'Ê'
    203: 66,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 72,  # 'Î'
    207: 74,  # 'Ï'
    208: 0,  # 'Ð'
    209: 77,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 75,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 80,  # 'Ù'
    218: 0,  # 'Ú'
    219: 78,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 57,  # 'à'
    225: 0,  # 'á'
    226: 60,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 58,  # 'ç'
    232: 56,  # 'è'
    233: 50,  # 'é'
    234: 59,  # 'ê'
    235: 49,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 65,  # 'î'
    239: 52,  # 'ï'
    240: 0,  # 'ð'
    241: 63,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 61,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 68,  # 'ù'
    250: 0,  # 'ú'
    251: 64,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_DUTCH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Dutch",
    char_to_order_map=WINDOWS_1252_DUTCH_CHAR_TO_ORDER,
    language_model=DUTCH_LANG_MODEL,
    typical_positive_ratio=0.9834360196714842,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÇÈÉÊËÎÏÑÔÙÛàâçèéêëîïñôùûŒœ",
)
