/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.scope;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.antlr.semantic.scope.Namespace;
import org.opensearch.sql.legacy.antlr.semantic.scope.Symbol;
import org.opensearch.sql.legacy.antlr.semantic.scope.TypeSupplier;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;

public class SymbolTable {
    private final Map<Namespace, NavigableMap<String, TypeSupplier>> tableByNamespace = new EnumMap<Namespace, NavigableMap<String, TypeSupplier>>(Namespace.class);

    public void store(Symbol symbol, Type type2) {
        this.tableByNamespace.computeIfAbsent(symbol.getNamespace(), ns -> new TreeMap()).computeIfAbsent(symbol.getName(), symbolName -> new TypeSupplier((String)symbolName, type2)).add(type2);
    }

    public Optional<Type> lookup(Symbol symbol) {
        Map table = this.tableByNamespace.get((Object)symbol.getNamespace());
        TypeSupplier typeSupplier = null;
        if (table != null) {
            typeSupplier = (TypeSupplier)table.get(symbol.getName());
        }
        return Optional.ofNullable(typeSupplier).map(TypeSupplier::get);
    }

    public Map<String, Type> lookupByPrefix(Symbol prefix) {
        NavigableMap<String, TypeSupplier> table = this.tableByNamespace.get((Object)prefix.getNamespace());
        if (table != null) {
            return table.subMap(prefix.getName(), prefix.getName() + "\uffff").entrySet().stream().filter(entry -> null != ((TypeSupplier)entry.getValue()).get()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TypeSupplier)e.getValue()).get()));
        }
        return Collections.emptyMap();
    }

    public Map<String, Type> lookupAll(Namespace namespace) {
        return this.tableByNamespace.getOrDefault((Object)namespace, Collections.emptyNavigableMap()).entrySet().stream().filter(entry -> null != ((TypeSupplier)entry.getValue()).get()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TypeSupplier)e.getValue()).get()));
    }

    public boolean isEmpty(Namespace namespace) {
        return this.tableByNamespace.getOrDefault((Object)namespace, Collections.emptyNavigableMap()).isEmpty();
    }
}

