/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.data.type.WideningTypeRule;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.function.PPLTypeChecker;

public class CoercionUtils {
    @Nullable
    public static List<RexNode> castArguments(RexBuilder builder, PPLTypeChecker typeChecker, List<RexNode> arguments2) {
        List<List<ExprType>> paramTypeCombinations = typeChecker.getParameterTypes();
        for (List<ExprType> paramTypes : paramTypeCombinations) {
            List<RexNode> castedArguments = CoercionUtils.castArguments(builder, paramTypes, arguments2);
            if (castedArguments == null) continue;
            return castedArguments;
        }
        return null;
    }

    @Nullable
    public static List<RexNode> widenArguments(RexBuilder builder, List<RexNode> arguments2) {
        ExprType widestType = CoercionUtils.findWidestType(arguments2);
        if (widestType == null) {
            return null;
        }
        return arguments2.stream().map(arg -> CoercionUtils.cast(builder, widestType, arg)).toList();
    }

    @Nullable
    private static List<RexNode> castArguments(RexBuilder builder, List<ExprType> paramTypes, List<RexNode> arguments2) {
        if (paramTypes.size() != arguments2.size()) {
            return null;
        }
        ArrayList<RexNode> castedArguments = new ArrayList<RexNode>();
        for (int i = 0; i < paramTypes.size(); ++i) {
            RexNode arg;
            ExprType toType = paramTypes.get(i);
            RexNode castedArg = CoercionUtils.cast(builder, toType, arg = arguments2.get(i));
            if (castedArg == null) {
                return null;
            }
            castedArguments.add(castedArg);
        }
        return castedArguments;
    }

    @Nullable
    private static RexNode cast(RexBuilder builder, ExprType targetType, RexNode arg) {
        ExprType argType = OpenSearchTypeFactory.convertRelDataTypeToExprType(arg.getType());
        if (!argType.shouldCast(targetType)) {
            return arg;
        }
        if (WideningTypeRule.distance(argType, targetType) != Integer.MAX_VALUE) {
            return builder.makeCast(OpenSearchTypeFactory.convertExprTypeToRelDataType(targetType), arg);
        }
        return null;
    }

    @Nullable
    private static ExprType findWidestType(List<RexNode> arguments2) {
        if (arguments2.isEmpty()) {
            return null;
        }
        ExprType widestType = OpenSearchTypeFactory.convertRelDataTypeToExprType(arguments2.getFirst().getType());
        if (arguments2.size() == 1) {
            return widestType;
        }
        for (int i = 1; i < arguments2.size(); ++i) {
            ExprType type2 = OpenSearchTypeFactory.convertRelDataTypeToExprType(arguments2.get(i).getType());
            try {
                if (CoercionUtils.areDateAndTime(widestType, type2)) {
                    widestType = ExprCoreType.TIMESTAMP;
                    continue;
                }
                widestType = WideningTypeRule.max(widestType, type2);
                continue;
            }
            catch (ExpressionEvaluationException e) {
                return null;
            }
        }
        return widestType;
    }

    private static boolean areDateAndTime(ExprType type1, ExprType type2) {
        return type1 == ExprCoreType.DATE && type2 == ExprCoreType.TIME || type1 == ExprCoreType.TIME && type2 == ExprCoreType.DATE;
    }
}

