/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceStatus;
import org.opensearch.sql.datasource.model.DataSourceType;

public final class XContentParserUtils {
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String CONNECTOR_FIELD = "connector";
    public static final String PROPERTIES_FIELD = "properties";
    public static final String ALLOWED_ROLES_FIELD = "allowedRoles";
    public static final String RESULT_INDEX_FIELD = "resultIndex";
    public static final String STATUS_FIELD = "status";

    public static DataSourceMetadata toDataSourceMetadata(XContentParser parser) throws IOException {
        String name = null;
        String description2 = "";
        DataSourceType connector = null;
        ArrayList<String> allowedRoles = new ArrayList<String>();
        HashMap<String, String> properties2 = new HashMap<String, String>();
        String resultIndex = null;
        DataSourceStatus status = null;
        org.opensearch.core.xcontent.XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.textOrNull();
                    continue block18;
                }
                case "description": {
                    description2 = parser.textOrNull();
                    continue block18;
                }
                case "connector": {
                    connector = DataSourceType.fromString(parser.textOrNull());
                    continue block18;
                }
                case "allowedRoles": {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        allowedRoles.add(parser.text());
                    }
                    continue block18;
                }
                case "properties": {
                    org.opensearch.core.xcontent.XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String key = parser.currentName();
                        parser.nextToken();
                        String value = parser.textOrNull();
                        properties2.put(key, value);
                    }
                    continue block18;
                }
                case "resultIndex": {
                    resultIndex = parser.textOrNull();
                    continue block18;
                }
                case "status": {
                    status = DataSourceStatus.fromString(parser.textOrNull());
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        return new DataSourceMetadata.Builder().setName(name).setDescription(description2).setConnector(connector).setProperties(properties2).setAllowedRoles(allowedRoles).setResultIndex(resultIndex).setDataSourceStatus(status).validateAndBuild();
    }

    public static Map<String, Object> toMap(XContentParser parser) throws IOException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> allowedRoles = new ArrayList<String>();
        HashMap<String, String> properties2 = new HashMap<String, String>();
        org.opensearch.core.xcontent.XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    String name = parser.textOrNull();
                    resultMap.put(NAME_FIELD, name);
                    continue block18;
                }
                case "description": {
                    String description2 = parser.textOrNull();
                    resultMap.put(DESCRIPTION_FIELD, description2);
                    continue block18;
                }
                case "connector": {
                    continue block18;
                }
                case "allowedRoles": {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        allowedRoles.add(parser.text());
                    }
                    resultMap.put(ALLOWED_ROLES_FIELD, allowedRoles);
                    continue block18;
                }
                case "properties": {
                    org.opensearch.core.xcontent.XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String key = parser.currentName();
                        parser.nextToken();
                        String value = parser.textOrNull();
                        properties2.put(key, value);
                    }
                    resultMap.put(PROPERTIES_FIELD, properties2);
                    continue block18;
                }
                case "resultIndex": {
                    String resultIndex = parser.textOrNull();
                    resultMap.put(RESULT_INDEX_FIELD, resultIndex);
                    continue block18;
                }
                case "status": {
                    DataSourceStatus status = DataSourceStatus.fromString(parser.textOrNull());
                    resultMap.put(STATUS_FIELD, (Object)status);
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        if (resultMap.get(NAME_FIELD) == null || resultMap.get(NAME_FIELD) == "") {
            throw new IllegalArgumentException("Name is a required field.");
        }
        return resultMap;
    }

    public static DataSourceMetadata toDataSourceMetadata(String json) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, json);){
            DataSourceMetadata dataSourceMetadata = XContentParserUtils.toDataSourceMetadata(parser);
            return dataSourceMetadata;
        }
    }

    public static Map<String, Object> toMap(String json) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, json);){
            Map<String, Object> map = XContentParserUtils.toMap(parser);
            return map;
        }
    }

    public static XContentBuilder convertToXContent(DataSourceMetadata metadata2) throws Exception {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field(NAME_FIELD, metadata2.getName());
        builder.field(DESCRIPTION_FIELD, metadata2.getDescription());
        builder.field(CONNECTOR_FIELD, metadata2.getConnector().name());
        builder.field(ALLOWED_ROLES_FIELD, (Object)metadata2.getAllowedRoles().toArray());
        builder.startObject(PROPERTIES_FIELD);
        for (Map.Entry<String, String> entry : metadata2.getProperties().entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.field(RESULT_INDEX_FIELD, metadata2.getResultIndex());
        builder.field(STATUS_FIELD, (Object)metadata2.getStatus());
        builder.endObject();
        return builder;
    }

    @Generated
    private XContentParserUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

