/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.DefaultBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.BinTimeSpanUtils;
import org.opensearch.sql.calcite.utils.binning.BinFieldValidator;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.calcite.utils.binning.RangeFormatter;

public class DefaultBinHandler
implements BinHandler {
    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor2) {
        DefaultBin defaultBin = (DefaultBin)node;
        RelDataType fieldType = fieldExpr.getType();
        String fieldName = BinFieldValidator.extractFieldName(node);
        if (BinFieldValidator.isTimeBasedField(fieldType)) {
            BinFieldValidator.validateFieldExists(fieldName, context);
            return BinTimeSpanUtils.createBinTimeSpanExpression(fieldExpr, 1, "h", 0L, context);
        }
        return this.createNumericDefaultBinning(fieldExpr, context);
    }

    private RexNode createNumericDefaultBinning(RexNode fieldExpr, CalcitePlanContext context) {
        RexNode minValue = context.relBuilder.min(fieldExpr).over().toRex();
        RexNode maxValue = context.relBuilder.max(fieldExpr).over().toRex();
        RexNode dataRange = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, maxValue, minValue);
        RexNode log10Range = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.LOG10, dataRange);
        RexNode magnitude = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, log10Range);
        RexLiteral tenLiteral = context.relBuilder.literal(10.0);
        RexNode defaultWidth = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.POWER, tenLiteral, magnitude);
        RexNode widthInt = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, defaultWidth);
        RexNode binStartValue = this.calculateBinValue(fieldExpr, widthInt, context);
        RexNode binEndValue = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, binStartValue, widthInt);
        return RangeFormatter.createRangeString(binStartValue, binEndValue, context);
    }

    private RexNode calculateBinValue(RexNode fieldExpr, RexNode width, CalcitePlanContext context) {
        RexNode divided = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, fieldExpr, width);
        RexNode floored = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, divided);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, floored, width);
    }
}

