/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.agent;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.agent.LLMSpec;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLMemorySpec;
import org.opensearch.ml.common.agent.MLToolSpec;

public class MLAgentUpdateInput
implements ToXContentObject,
Writeable {
    public static final String AGENT_ID_FIELD = "agent_id";
    public static final String AGENT_NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String LLM_FIELD = "llm";
    public static final String LLM_MODEL_ID_FIELD = "model_id";
    public static final String LLM_PARAMETERS_FIELD = "parameters";
    public static final String TOOLS_FIELD = "tools";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String MEMORY_FIELD = "memory";
    public static final String MEMORY_TYPE_FIELD = "type";
    public static final String MEMORY_SESSION_ID_FIELD = "session_id";
    public static final String MEMORY_WINDOW_SIZE_FIELD = "window_size";
    public static final String APP_TYPE_FIELD = "app_type";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    private String agentId;
    private String name;
    private String description;
    private String llmModelId;
    private Map<String, String> llmParameters;
    private List<MLToolSpec> tools;
    private Map<String, String> parameters;
    private String memoryType;
    private String memorySessionId;
    private Integer memoryWindowSize;
    private String appType;
    private Instant lastUpdateTime;
    private String tenantId;

    public MLAgentUpdateInput(String agentId, String name, String description2, String llmModelId, Map<String, String> llmParameters, List<MLToolSpec> tools, Map<String, String> parameters2, String memoryType, String memorySessionId, Integer memoryWindowSize, String appType, Instant lastUpdateTime, String tenantId) {
        this.agentId = agentId;
        this.name = name;
        this.description = description2;
        this.llmModelId = llmModelId;
        this.llmParameters = llmParameters;
        this.tools = tools;
        this.parameters = parameters2;
        this.memoryType = memoryType;
        this.memorySessionId = memorySessionId;
        this.memoryWindowSize = memoryWindowSize;
        this.appType = appType;
        this.lastUpdateTime = lastUpdateTime;
        this.tenantId = tenantId;
        this.validate();
    }

    public MLAgentUpdateInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.agentId = in.readString();
        this.name = in.readOptionalString();
        this.description = in.readOptionalString();
        this.llmModelId = in.readOptionalString();
        if (in.readBoolean()) {
            this.llmParameters = in.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        if (in.readBoolean()) {
            this.tools = new ArrayList<MLToolSpec>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.tools.add(new MLToolSpec(in));
            }
        }
        if (in.readBoolean()) {
            this.parameters = in.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        this.memoryType = in.readOptionalString();
        this.memorySessionId = in.readOptionalString();
        this.memoryWindowSize = in.readOptionalInt();
        this.lastUpdateTime = in.readOptionalInstant();
        this.appType = in.readOptionalString();
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(AGENT_ID_FIELD, this.agentId);
        if (this.name != null) {
            builder.field(AGENT_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.llmModelId != null || this.llmParameters != null && !this.llmParameters.isEmpty()) {
            builder.startObject(LLM_FIELD);
            if (this.llmModelId != null) {
                builder.field(LLM_MODEL_ID_FIELD, this.llmModelId);
            }
            if (this.llmParameters != null && !this.llmParameters.isEmpty()) {
                builder.field("parameters", this.llmParameters);
            }
            builder.endObject();
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            builder.field(TOOLS_FIELD, this.tools);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            builder.field("parameters", this.parameters);
        }
        if (this.memoryType != null || this.memorySessionId != null || this.memoryWindowSize != null) {
            builder.startObject(MEMORY_FIELD);
            if (this.memoryType != null) {
                builder.field(MEMORY_TYPE_FIELD, this.memoryType);
            }
            if (this.memorySessionId != null) {
                builder.field(MEMORY_SESSION_ID_FIELD, this.memorySessionId);
            }
            if (this.memoryWindowSize != null) {
                builder.field(MEMORY_WINDOW_SIZE_FIELD, this.memoryWindowSize);
            }
            builder.endObject();
        }
        if (this.appType != null) {
            builder.field(APP_TYPE_FIELD, this.appType);
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.agentId);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.llmModelId);
        if (this.llmParameters != null && !this.llmParameters.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.llmParameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            out.writeBoolean(true);
            out.writeInt(this.tools.size());
            for (MLToolSpec tool : this.tools) {
                tool.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.memoryType);
        out.writeOptionalString(this.memorySessionId);
        out.writeOptionalInt(this.memoryWindowSize);
        out.writeOptionalInstant(this.lastUpdateTime);
        out.writeOptionalString(this.appType);
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public static MLAgentUpdateInput parse(XContentParser parser) throws IOException {
        String agentId = null;
        String name = null;
        String description2 = null;
        String llmModelId = null;
        Map llmParameters = null;
        ArrayList<MLToolSpec> tools = null;
        Map parameters2 = null;
        String memoryType = null;
        String memorySessionId = null;
        Integer memoryWindowSize = null;
        String appType = null;
        Instant lastUpdateTime = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block42: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "agent_id": {
                    agentId = parser.text();
                    continue block42;
                }
                case "name": {
                    name = parser.text();
                    continue block42;
                }
                case "description": {
                    description2 = parser.text();
                    continue block42;
                }
                case "llm": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    block43: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String llmFieldName = parser.currentName();
                        parser.nextToken();
                        switch (llmFieldName) {
                            case "model_id": {
                                llmModelId = parser.text();
                                continue block43;
                            }
                            case "parameters": {
                                llmParameters = parser.mapStrings();
                                continue block43;
                            }
                        }
                        parser.skipChildren();
                    }
                    continue block42;
                }
                case "tools": {
                    tools = new ArrayList<MLToolSpec>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        tools.add(MLToolSpec.parse(parser));
                    }
                    continue block42;
                }
                case "parameters": {
                    parameters2 = parser.mapStrings();
                    continue block42;
                }
                case "memory": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    block45: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String memoryFieldName = parser.currentName();
                        parser.nextToken();
                        switch (memoryFieldName) {
                            case "type": {
                                memoryType = parser.text();
                                continue block45;
                            }
                            case "session_id": {
                                memorySessionId = parser.text();
                                continue block45;
                            }
                            case "window_size": {
                                memoryWindowSize = parser.intValue();
                                continue block45;
                            }
                        }
                        parser.skipChildren();
                    }
                    continue block42;
                }
                case "app_type": {
                    appType = parser.text();
                    continue block42;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block42;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block42;
                }
            }
            parser.skipChildren();
        }
        return new MLAgentUpdateInput(agentId, name, description2, llmModelId, llmParameters, tools, parameters2, memoryType, memorySessionId, memoryWindowSize, appType, lastUpdateTime, tenantId);
    }

    public MLAgent toMLAgent(MLAgent originalAgent) {
        MLMemorySpec finalMemory;
        LLMSpec finalLlm;
        if (this.llmModelId == null && (this.llmParameters == null || this.llmParameters.isEmpty())) {
            finalLlm = originalAgent.getLlm();
        } else {
            LLMSpec originalLlm = originalAgent.getLlm();
            String finalModelId = this.llmModelId != null ? this.llmModelId : originalLlm.getModelId();
            HashMap<String, String> finalParameters = new HashMap<String, String>();
            if (originalLlm != null && originalLlm.getParameters() != null) {
                finalParameters.putAll(originalLlm.getParameters());
            }
            if (this.llmParameters != null) {
                finalParameters.putAll(this.llmParameters);
            }
            finalLlm = LLMSpec.builder().modelId(finalModelId).parameters(finalParameters).build();
        }
        if (this.memoryType == null && this.memorySessionId == null && this.memoryWindowSize == null) {
            finalMemory = originalAgent.getMemory();
        } else {
            MLMemorySpec originalMemory = originalAgent.getMemory();
            String finalMemoryType = this.memoryType != null ? this.memoryType : originalMemory.getType();
            String finalSessionId = this.memorySessionId != null ? this.memorySessionId : originalMemory.getSessionId();
            Integer finalWindowSize = this.memoryWindowSize != null ? this.memoryWindowSize : originalMemory.getWindowSize();
            finalMemory = MLMemorySpec.builder().type(finalMemoryType).sessionId(finalSessionId).windowSize(finalWindowSize).build();
        }
        return MLAgent.builder().type(originalAgent.getType()).createdTime(originalAgent.getCreatedTime()).isHidden(originalAgent.getIsHidden()).name(this.name == null ? originalAgent.getName() : this.name).description(this.description == null ? originalAgent.getDescription() : this.description).llm(finalLlm).tools(this.tools == null ? originalAgent.getTools() : this.tools).parameters(this.parameters == null ? originalAgent.getParameters() : this.parameters).memory(finalMemory).lastUpdateTime(this.lastUpdateTime).appType(this.appType).tenantId(this.tenantId).build();
    }

    private void validate() {
        if (this.name != null && (this.name.isBlank() || this.name.length() > 128)) {
            throw new IllegalArgumentException(String.format("Agent name cannot be empty or exceed max length of %d characters", 128));
        }
        if (this.memoryType != null && !this.memoryType.equals("conversation_index")) {
            throw new IllegalArgumentException(String.format("Invalid memory type: %s", this.memoryType));
        }
        if (this.tools != null) {
            HashSet<String> toolNames = new HashSet<String>();
            for (MLToolSpec toolSpec : this.tools) {
                String toolName = Optional.ofNullable(toolSpec.getName()).orElse(toolSpec.getType());
                if (toolNames.contains(toolName)) {
                    throw new IllegalArgumentException("Duplicate tool defined: " + toolName);
                }
                toolNames.add(toolName);
            }
        }
    }

    @Generated
    public static MLAgentUpdateInputBuilder builder() {
        return new MLAgentUpdateInputBuilder();
    }

    @Generated
    public MLAgentUpdateInputBuilder toBuilder() {
        return new MLAgentUpdateInputBuilder().agentId(this.agentId).name(this.name).description(this.description).llmModelId(this.llmModelId).llmParameters(this.llmParameters).tools(this.tools).parameters(this.parameters).memoryType(this.memoryType).memorySessionId(this.memorySessionId).memoryWindowSize(this.memoryWindowSize).appType(this.appType).lastUpdateTime(this.lastUpdateTime).tenantId(this.tenantId);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getLlmModelId() {
        return this.llmModelId;
    }

    @Generated
    public Map<String, String> getLlmParameters() {
        return this.llmParameters;
    }

    @Generated
    public List<MLToolSpec> getTools() {
        return this.tools;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public String getMemoryType() {
        return this.memoryType;
    }

    @Generated
    public String getMemorySessionId() {
        return this.memorySessionId;
    }

    @Generated
    public Integer getMemoryWindowSize() {
        return this.memoryWindowSize;
    }

    @Generated
    public String getAppType() {
        return this.appType;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description2) {
        this.description = description2;
    }

    @Generated
    public void setLlmModelId(String llmModelId) {
        this.llmModelId = llmModelId;
    }

    @Generated
    public void setLlmParameters(Map<String, String> llmParameters) {
        this.llmParameters = llmParameters;
    }

    @Generated
    public void setTools(List<MLToolSpec> tools) {
        this.tools = tools;
    }

    @Generated
    public void setParameters(Map<String, String> parameters2) {
        this.parameters = parameters2;
    }

    @Generated
    public void setMemoryType(String memoryType) {
        this.memoryType = memoryType;
    }

    @Generated
    public void setMemorySessionId(String memorySessionId) {
        this.memorySessionId = memorySessionId;
    }

    @Generated
    public void setMemoryWindowSize(Integer memoryWindowSize) {
        this.memoryWindowSize = memoryWindowSize;
    }

    @Generated
    public void setAppType(String appType) {
        this.appType = appType;
    }

    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLAgentUpdateInput)) {
            return false;
        }
        MLAgentUpdateInput other = (MLAgentUpdateInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$memoryWindowSize = this.getMemoryWindowSize();
        Integer other$memoryWindowSize = other.getMemoryWindowSize();
        if (this$memoryWindowSize == null ? other$memoryWindowSize != null : !((Object)this$memoryWindowSize).equals(other$memoryWindowSize)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$llmModelId = this.getLlmModelId();
        String other$llmModelId = other.getLlmModelId();
        if (this$llmModelId == null ? other$llmModelId != null : !this$llmModelId.equals(other$llmModelId)) {
            return false;
        }
        Map<String, String> this$llmParameters = this.getLlmParameters();
        Map<String, String> other$llmParameters = other.getLlmParameters();
        if (this$llmParameters == null ? other$llmParameters != null : !((Object)this$llmParameters).equals(other$llmParameters)) {
            return false;
        }
        List<MLToolSpec> this$tools = this.getTools();
        List<MLToolSpec> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$memoryType = this.getMemoryType();
        String other$memoryType = other.getMemoryType();
        if (this$memoryType == null ? other$memoryType != null : !this$memoryType.equals(other$memoryType)) {
            return false;
        }
        String this$memorySessionId = this.getMemorySessionId();
        String other$memorySessionId = other.getMemorySessionId();
        if (this$memorySessionId == null ? other$memorySessionId != null : !this$memorySessionId.equals(other$memorySessionId)) {
            return false;
        }
        String this$appType = this.getAppType();
        String other$appType = other.getAppType();
        if (this$appType == null ? other$appType != null : !this$appType.equals(other$appType)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLAgentUpdateInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Integer $memoryWindowSize = this.getMemoryWindowSize();
        result2 = result2 * 59 + ($memoryWindowSize == null ? 43 : ((Object)$memoryWindowSize).hashCode());
        String $agentId = this.getAgentId();
        result2 = result2 * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result2 = result2 * 59 + ($description == null ? 43 : $description.hashCode());
        String $llmModelId = this.getLlmModelId();
        result2 = result2 * 59 + ($llmModelId == null ? 43 : $llmModelId.hashCode());
        Map<String, String> $llmParameters = this.getLlmParameters();
        result2 = result2 * 59 + ($llmParameters == null ? 43 : ((Object)$llmParameters).hashCode());
        List<MLToolSpec> $tools = this.getTools();
        result2 = result2 * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result2 = result2 * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $memoryType = this.getMemoryType();
        result2 = result2 * 59 + ($memoryType == null ? 43 : $memoryType.hashCode());
        String $memorySessionId = this.getMemorySessionId();
        result2 = result2 * 59 + ($memorySessionId == null ? 43 : $memorySessionId.hashCode());
        String $appType = this.getAppType();
        result2 = result2 * 59 + ($appType == null ? 43 : $appType.hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result2 = result2 * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        String $tenantId = this.getTenantId();
        result2 = result2 * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "MLAgentUpdateInput(agentId=" + this.getAgentId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", llmModelId=" + this.getLlmModelId() + ", llmParameters=" + String.valueOf(this.getLlmParameters()) + ", tools=" + String.valueOf(this.getTools()) + ", parameters=" + String.valueOf(this.getParameters()) + ", memoryType=" + this.getMemoryType() + ", memorySessionId=" + this.getMemorySessionId() + ", memoryWindowSize=" + this.getMemoryWindowSize() + ", appType=" + this.getAppType() + ", lastUpdateTime=" + String.valueOf(this.getLastUpdateTime()) + ", tenantId=" + this.getTenantId() + ")";
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public static class MLAgentUpdateInputBuilder {
        @Generated
        private String agentId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String llmModelId;
        @Generated
        private Map<String, String> llmParameters;
        @Generated
        private List<MLToolSpec> tools;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private String memoryType;
        @Generated
        private String memorySessionId;
        @Generated
        private Integer memoryWindowSize;
        @Generated
        private String appType;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private String tenantId;

        @Generated
        MLAgentUpdateInputBuilder() {
        }

        @Generated
        public MLAgentUpdateInputBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder llmModelId(String llmModelId) {
            this.llmModelId = llmModelId;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder llmParameters(Map<String, String> llmParameters) {
            this.llmParameters = llmParameters;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder tools(List<MLToolSpec> tools) {
            this.tools = tools;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder parameters(Map<String, String> parameters2) {
            this.parameters = parameters2;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder memoryType(String memoryType) {
            this.memoryType = memoryType;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder memorySessionId(String memorySessionId) {
            this.memorySessionId = memorySessionId;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder memoryWindowSize(Integer memoryWindowSize) {
            this.memoryWindowSize = memoryWindowSize;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLAgentUpdateInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLAgentUpdateInput build() {
            return new MLAgentUpdateInput(this.agentId, this.name, this.description, this.llmModelId, this.llmParameters, this.tools, this.parameters, this.memoryType, this.memorySessionId, this.memoryWindowSize, this.appType, this.lastUpdateTime, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MLAgentUpdateInput.MLAgentUpdateInputBuilder(agentId=" + this.agentId + ", name=" + this.name + ", description=" + this.description + ", llmModelId=" + this.llmModelId + ", llmParameters=" + String.valueOf(this.llmParameters) + ", tools=" + String.valueOf(this.tools) + ", parameters=" + String.valueOf(this.parameters) + ", memoryType=" + this.memoryType + ", memorySessionId=" + this.memorySessionId + ", memoryWindowSize=" + this.memoryWindowSize + ", appType=" + this.appType + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

