/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.execute.tool;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

@org.opensearch.ml.common.annotation.MLInput(functionNames={FunctionName.TOOL})
public class ToolMLInput
extends MLInput {
    public static final String TOOL_NAME_FIELD = "tool_name";
    public static final String PARAMETERS_FIELD = "parameters";
    private String toolName;
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField(FunctionName.TOOL.name(), new String[0]), it -> ToolMLInput.parse(it));

    public ToolMLInput(StreamInput in) throws IOException {
        super(in);
        this.toolName = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.toolName);
    }

    public static ToolMLInput parse(XContentParser parser) throws IOException {
        return new ToolMLInput(parser, FunctionName.TOOL);
    }

    public ToolMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        this.algorithm = functionName;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "tool_name": {
                    this.toolName = parser.text();
                    continue block8;
                }
                case "parameters": {
                    Map<String, String> parameters2 = StringUtils.getParameterMap(parser.map());
                    this.inputDataset = new RemoteInferenceInputDataSet(parameters2);
                    continue block8;
                }
            }
            parser.skipChildren();
        }
    }

    @Generated
    public String getToolName() {
        return this.toolName;
    }

    @Generated
    public void setToolName(String toolName) {
        this.toolName = toolName;
    }
}

