/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class FunctionSqlType
extends AbstractSqlType {
    private final RelDataType parameterType;
    private final RelDataType returnType;

    public FunctionSqlType(RelDataType parameterType, RelDataType returnType) {
        super(SqlTypeName.FUNCTION, true, null);
        this.parameterType = Objects.requireNonNull(parameterType, "parameterType");
        this.returnType = Objects.requireNonNull(returnType, "returnType");
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("Function");
        sb.append("(");
        for (Ord<RelDataTypeField> ord : Ord.zip(this.parameterType.getFieldList())) {
            if (ord.i > 0) {
                sb.append(", ");
            }
            RelDataTypeField field = (RelDataTypeField)ord.e;
            sb.append(withDetail ? field.getType().getFullTypeString() : field.getType().toString());
        }
        sb.append(")");
        sb.append(" -> ");
        sb.append(withDetail ? this.returnType.getFullTypeString() : this.returnType.toString());
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    public RelDataType getReturnType() {
        return this.returnType;
    }
}

