/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlInternalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlSetSemanticsTableOperator
extends SqlInternalOperator {
    public SqlSetSemanticsTableOperator() {
        super("SET_SEMANTICS_TABLE", SqlKind.SET_SEMANTICS_TABLE);
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (operands.length == 3);
        SqlNode partitionList = operands[1];
        SqlNode orderList = operands[2];
        assert (partitionList != null && !SqlNodeList.isEmptyList(partitionList) || orderList != null && !SqlNodeList.isEmptyList(orderList));
        return super.createCall(functionQualifier, pos, operands);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlNodeList orderList;
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        SqlNodeList partitionList = (SqlNodeList)call.operand(1);
        if (!partitionList.isEmpty()) {
            writer.sep("PARTITION BY");
            SqlWriter.Frame partitionFrame = writer.startList("", "");
            partitionList.unparse(writer, 0, 0);
            writer.endList(partitionFrame);
        }
        if (!(orderList = (SqlNodeList)call.operand(2)).isEmpty()) {
            writer.sep("ORDER BY");
            writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, orderList);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        return Objects.requireNonNull(validator.deriveType(scope2, operands.get(0)));
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

