/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.rules.CalcRelSplitter;
import org.apache.calcite.rel.rules.ImmutableCalcToWindowRuleConfig;
import org.apache.calcite.rel.rules.ImmutableProjectToLogicalProjectAndWindowRuleConfig;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBiVisitorImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DirectedGraph;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.immutables.value.Value;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;

public abstract class ProjectToWindowRule
extends RelRule<Config>
implements TransformationRule {
    protected ProjectToWindowRule(Config config) {
        super(config);
    }

    public static interface Config
    extends RelRule.Config {
        @Override
        public ProjectToWindowRule toRule();
    }

    static class WindowedAggRelSplitter
    extends CalcRelSplitter {
        private static final CalcRelSplitter.RelType[] REL_TYPES = new CalcRelSplitter.RelType[]{new CalcRelSplitter.RelType("CalcRelType"){

            @Override
            protected boolean canImplement(RexFieldAccess field) {
                return true;
            }

            @Override
            protected boolean canImplement(RexDynamicParam param) {
                return true;
            }

            @Override
            protected boolean canImplement(RexLiteral literal) {
                return true;
            }

            @Override
            protected boolean canImplement(RexCall call) {
                return !(call instanceof RexOver);
            }

            @Override
            protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traitSet, RelBuilder relBuilder, RelNode input, RexProgram program) {
                assert (!program.containsAggs());
                program = program.normalize(cluster.getRexBuilder(), null);
                return super.makeRel(cluster, traitSet, relBuilder, input, program);
            }
        }, new CalcRelSplitter.RelType("WinAggRelType"){

            @Override
            protected boolean canImplement(RexFieldAccess field) {
                return false;
            }

            @Override
            protected boolean canImplement(RexDynamicParam param) {
                return false;
            }

            @Override
            protected boolean canImplement(RexLiteral literal) {
                return false;
            }

            @Override
            protected boolean canImplement(RexCall call) {
                return call instanceof RexOver;
            }

            @Override
            protected boolean supportsCondition() {
                return false;
            }

            @Override
            protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traitSet, RelBuilder relBuilder, RelNode input, RexProgram program) {
                Preconditions.checkArgument(program.getCondition() == null, "WindowedAggregateRel cannot accept a condition");
                return LogicalWindow.create(cluster, traitSet, relBuilder, input, program);
            }
        }};

        WindowedAggRelSplitter(Calc calc, RelBuilder relBuilder) {
            super(calc, relBuilder, REL_TYPES);
        }

        @Override
        protected List<Set<Integer>> getCohorts() {
            List<RexNode> exprs = this.program.getExprList();
            DirectedGraph<Integer, DefaultEdge> graph = WindowedAggRelSplitter.createGraphFromExpression(exprs);
            List<Integer> rank = WindowedAggRelSplitter.getRank(graph);
            ArrayList<Pair<RexWindow, HashSet<Integer>>> windowToIndices = new ArrayList<Pair<RexWindow, HashSet<Integer>>>();
            for (int i = 0; i < exprs.size(); ++i) {
                RexNode expr = exprs.get(i);
                if (!(expr instanceof RexOver)) continue;
                RexOver rexOver = (RexOver)expr;
                boolean isFound = false;
                for (Pair pair : windowToIndices) {
                    if (!((RexWindow)pair.left).equals(rexOver.getWindow())) continue;
                    boolean hasDependency = false;
                    Iterator iterator2 = ((Set)pair.right).iterator();
                    while (iterator2.hasNext()) {
                        int ordinal = (Integer)iterator2.next();
                        if (!WindowedAggRelSplitter.isDependent(graph, rank, ordinal, i)) continue;
                        hasDependency = true;
                        break;
                    }
                    if (hasDependency) continue;
                    ((Set)pair.right).add(i);
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                HashSet<Integer> newSet = new HashSet<Integer>(ImmutableList.of(Integer.valueOf(i)));
                windowToIndices.add(Pair.of(rexOver.getWindow(), newSet));
            }
            ArrayList<Set<Integer>> cohorts = new ArrayList<Set<Integer>>();
            for (Pair pair : windowToIndices) {
                cohorts.add((Set<Integer>)pair.right);
            }
            return cohorts;
        }

        private static boolean isDependent(DirectedGraph<Integer, DefaultEdge> graph, List<Integer> rank, int ordinal1, int ordinal2) {
            if (rank.get(ordinal2) > rank.get(ordinal1)) {
                return WindowedAggRelSplitter.isDependent(graph, rank, ordinal2, ordinal1);
            }
            ArrayDeque<Integer> dfs = new ArrayDeque<Integer>();
            HashSet<Integer> visited = new HashSet<Integer>();
            dfs.push(ordinal2);
            while (!dfs.isEmpty()) {
                int source2 = (Integer)dfs.pop();
                if (visited.contains(source2)) continue;
                if (source2 == ordinal1) {
                    return true;
                }
                visited.add(source2);
                for (DefaultEdge e : graph.getOutwardEdges(source2)) {
                    int target = (Integer)e.target;
                    if (rank.get(target) > rank.get(ordinal1)) continue;
                    dfs.push(target);
                }
            }
            return false;
        }

        private static List<Integer> getRank(DirectedGraph<Integer, DefaultEdge> graph) {
            int[] rankArr = new int[graph.vertexSet().size()];
            int rank = 0;
            for (int i : TopologicalOrderIterator.of(graph)) {
                rankArr[i] = rank++;
            }
            return ImmutableIntList.of(rankArr);
        }

        private static DirectedGraph<Integer, DefaultEdge> createGraphFromExpression(List<RexNode> exprs) {
            final DefaultDirectedGraph<Integer, DefaultEdge> graph = DefaultDirectedGraph.create();
            for (int i = 0; i < exprs.size(); ++i) {
                graph.addVertex(i);
            }
            new RexBiVisitorImpl<Void, Integer>(true){

                @Override
                public Void visitLocalRef(RexLocalRef localRef, Integer i) {
                    graph.addEdge(localRef.getIndex(), i);
                    return null;
                }
            }.visitEachIndexed(exprs);
            assert (graph.vertexSet().size() == exprs.size());
            return graph;
        }
    }

    public static class ProjectToLogicalProjectAndWindowRule
    extends ProjectToWindowRule {
        protected ProjectToLogicalProjectAndWindowRule(ProjectToLogicalProjectAndWindowRuleConfig config) {
            super(config);
        }

        @Deprecated
        public ProjectToLogicalProjectAndWindowRule(RelBuilderFactory relBuilderFactory) {
            this(ProjectToLogicalProjectAndWindowRuleConfig.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(ProjectToLogicalProjectAndWindowRuleConfig.class));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            assert (project.containsOver());
            RelNode input = project.getInput();
            RexProgram program = RexProgram.create(input.getRowType(), project.getProjects(), null, project.getRowType(), project.getCluster().getRexBuilder());
            LogicalCalc calc = LogicalCalc.create(input, program);
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc, call.builder()){

                @Override
                protected RelNode handle(RelNode rel) {
                    if (!(rel instanceof LogicalCalc)) {
                        return rel;
                    }
                    LogicalCalc calc = (LogicalCalc)rel;
                    RexProgram program = calc.getProgram();
                    this.relBuilder.push(calc.getInput());
                    if (program.getCondition() != null) {
                        this.relBuilder.filter(program.expandLocalRef(program.getCondition()));
                    }
                    if (!program.projectsOnlyIdentity()) {
                        this.relBuilder.project(Util.transform(program.getProjectList(), program::expandLocalRef), calc.getRowType().getFieldNames());
                    }
                    return this.relBuilder.build();
                }
            };
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }

        @Value.Immutable
        public static interface ProjectToLogicalProjectAndWindowRuleConfig
        extends Config {
            public static final ProjectToLogicalProjectAndWindowRuleConfig DEFAULT = ImmutableProjectToLogicalProjectAndWindowRuleConfig.of().withOperandSupplier(b -> b.operand(Project.class).predicate(Project::containsOver).anyInputs()).withDescription("ProjectToWindowRule:project");

            @Override
            default public ProjectToLogicalProjectAndWindowRule toRule() {
                return new ProjectToLogicalProjectAndWindowRule(this);
            }
        }
    }

    public static class CalcToWindowRule
    extends ProjectToWindowRule {
        protected CalcToWindowRule(CalcToWindowRuleConfig config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Calc calc = (Calc)call.rel(0);
            assert (calc.containsOver());
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc, call.builder());
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }

        @Value.Immutable
        public static interface CalcToWindowRuleConfig
        extends Config {
            public static final CalcToWindowRuleConfig DEFAULT = ImmutableCalcToWindowRuleConfig.of().withOperandSupplier(b -> b.operand(Calc.class).predicate(Calc::containsOver).anyInputs()).withDescription("ProjectToWindowRule");

            @Override
            default public CalcToWindowRule toRule() {
                return new CalcToWindowRule(this);
            }
        }
    }
}

