/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;

public class ParameterExpression
extends Expression {
    private static final AtomicInteger SEQ = new AtomicInteger();
    public final int modifier;
    public final String name;

    public ParameterExpression(Type type2) {
        this(0, type2, "p" + SEQ.getAndIncrement());
    }

    public ParameterExpression(int modifier, Type type2, String name) {
        super(ExpressionType.Parameter, type2);
        Preconditions.checkArgument(Character.isJavaIdentifierStart(name.charAt(0)), "parameter name should be valid java identifier: %s. The first character is invalid.", (Object)name);
        this.modifier = modifier;
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public @Nullable Object evaluate(Evaluator evaluator) {
        return evaluator.peek(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append(this.name);
    }

    String declString() {
        return this.declString(this.type);
    }

    String declString(Type type2) {
        String modifiers = Modifier.toString(this.modifier);
        return modifiers + (modifiers.isEmpty() ? "" : " ") + Types.className(type2) + " " + this.name;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

