/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final String classClass = "class";
    public final String name;
    public final List<MemberDeclaration> memberDeclarations;
    public final @Nullable Type extended;
    public final List<Type> implemented;

    public ClassDeclaration(int modifier, String name, @Nullable Type extended, List<Type> implemented, List<MemberDeclaration> memberDeclarations) {
        this.modifier = modifier;
        this.name = Objects.requireNonNull(name, "name");
        this.memberDeclarations = memberDeclarations;
        this.extended = extended;
        this.implemented = implemented;
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append("class").append(' ').append(this.name);
        if (this.extended != null) {
            writer.append(" extends ").append(this.extended);
        }
        if (!this.implemented.isEmpty()) {
            writer.list(" implements ", ", ", "", this.implemented);
        }
        writer.list(" {\n", "", "}", this.memberDeclarations);
        writer.newlineAndIndent();
    }

    @Override
    public ClassDeclaration accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        List<MemberDeclaration> members1 = Expressions.acceptMemberDeclarations(this.memberDeclarations, shuttle);
        return shuttle.visit(this, members1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDeclaration that = (ClassDeclaration)o;
        if (this.modifier != that.modifier) {
            return false;
        }
        if (!"class".equals(that.classClass)) {
            return false;
        }
        return Objects.equals(this.extended, that.extended) && this.implemented.equals(that.implemented) && this.memberDeclarations.equals(that.memberDeclarations) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.modifier, "class", this.name, this.memberDeclarations, this.extended, this.implemented);
    }
}

