/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.ha;

import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.ha.LBStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinLBStrategy
implements LBStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RoundRobinLBStrategy.class);
    public static final RoundRobinLBStrategy INSTANCE = new RoundRobinLBStrategy();
    public static final String URL_SEPERATOR_CHAR = ",";
    Map<String, Integer> configToIndexServedMap = new HashMap<String, Integer>();
    Map<String, String[]> configToUrlListMap = new HashMap<String, String[]>();

    private RoundRobinLBStrategy() {
    }

    @Override
    public synchronized String getLbURL(ConnectionConfig config) {
        String key = RoundRobinLBStrategy.getKey(config);
        if (!this.configToIndexServedMap.containsKey(key)) {
            this.configToIndexServedMap.put(key, 0);
            this.configToUrlListMap.put(key, config.getLbURLs().split(URL_SEPERATOR_CHAR));
        }
        String[] urls2 = this.configToUrlListMap.get(key);
        int urlIndex = this.configToIndexServedMap.get(key);
        this.configToIndexServedMap.put(key, (urlIndex + 1) % urls2.length);
        String url = urls2[urlIndex];
        LOG.info("Selected URL:{}", (Object)url);
        return url;
    }

    private static String getKey(ConnectionConfig config) {
        return config.getLbURLs();
    }
}

