/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Preconditions;

public class SelectiveFilter<T> {
    private final T filter;
    private final boolean potentialOverSelectivity;

    private SelectiveFilter(T filter, boolean potentialOverSelectivity) {
        this.filter = Preconditions.checkNotNull(filter);
        this.potentialOverSelectivity = potentialOverSelectivity;
    }

    public static <T> SelectiveFilter<T> of(T filter, boolean potentialOverSelectivity) {
        return new SelectiveFilter<T>(filter, potentialOverSelectivity);
    }

    public T getFilter() {
        return this.filter;
    }

    public boolean isPotentialOverSelectivity() {
        return this.potentialOverSelectivity;
    }

    public int hashCode() {
        return 31 * this.filter.hashCode() + Boolean.valueOf(this.potentialOverSelectivity).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SelectiveFilter)) {
            return false;
        }
        SelectiveFilter other = (SelectiveFilter)o;
        return this.potentialOverSelectivity == other.potentialOverSelectivity && this.filter.equals(other.filter);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

