/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.CommittedKey;
import com.amazonaws.encryptionsdk.internal.HmacKeyDerivationFunction;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public enum CryptoAlgorithm {
    ALG_AES_128_GCM_IV12_TAG16_NO_KDF(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 16, 20, "AES", 16, false),
    ALG_AES_192_GCM_IV12_TAG16_NO_KDF(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 24, 70, "AES", 24, false),
    ALG_AES_256_GCM_IV12_TAG16_NO_KDF(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 120, "AES", 32, false),
    ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 16, 276, "HkdfSHA256", 16, true),
    ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA256(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 24, 326, "HkdfSHA256", 24, true),
    ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA256(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 376, "HkdfSHA256", 32, true),
    ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 16, 532, "HkdfSHA256", 16, true, "SHA256withECDSA", 71),
    ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 24, 838, "HkdfSHA384", 24, true, "SHA384withECDSA", 103),
    ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384(1, 128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 888, "HkdfSHA384", 32, true, "SHA384withECDSA", 103),
    ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY(2, 128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 1144, "HkdfSHA512", 32, true, null, 0, "HkdfSHA512", 32, 32, 32),
    ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY_ECDSA_P384(2, 128, 12, 16, 0xFFFFFFFE0L, "AES", 32, 1400, "HkdfSHA512", 32, true, "SHA384withECDSA", 103, "HkdfSHA512", 32, 32, 32);

    private final byte messageFormatVersion_;
    private final int blockSizeBits_;
    private final byte nonceLenBytes_;
    private final int tagLenBytes_;
    private final long maxContentLen_;
    private final String keyAlgo_;
    private final int keyLenBytes_;
    private final short value_;
    private final String trailingSigAlgo_;
    private final short trailingSigLen_;
    private final String dataKeyAlgo_;
    private final int dataKeyLen_;
    private final boolean safeToCache_;
    private final String keyCommitmentAlgo_;
    private final int commitmentLength_;
    private final int commitmentNonceLength_;
    private final int suiteDataLength_;
    private static final byte VERSION_1 = 1;
    private static final byte VERSION_2 = 2;
    private static final int VERSION_1_MESSAGE_ID_LEN = 16;
    private static final int VERSION_2_MESSAGE_ID_LEN = 32;
    private static final Map<Integer, CryptoAlgorithm> ID_MAPPING;

    private CryptoAlgorithm(int messageFormatVersion, int blockSizeBits, int nonceLenBytes, int tagLenBytes, long maxContentLen, String keyAlgo, int keyLenBytes, int value, String dataKeyAlgo, int dataKeyLen, boolean safeToCache) {
        this(messageFormatVersion, blockSizeBits, nonceLenBytes, tagLenBytes, maxContentLen, keyAlgo, keyLenBytes, value, dataKeyAlgo, dataKeyLen, safeToCache, null, 0);
    }

    private CryptoAlgorithm(int messageFormatVersion, int blockSizeBits, int nonceLenBytes, int tagLenBytes, long maxContentLen, String keyAlgo, int keyLenBytes, int value, String dataKeyAlgo, int dataKeyLen, boolean safeToCache, String trailingSignatureAlgo, int trailingSignatureLength) {
        this(messageFormatVersion, blockSizeBits, nonceLenBytes, tagLenBytes, maxContentLen, keyAlgo, keyLenBytes, value, dataKeyAlgo, dataKeyLen, safeToCache, trailingSignatureAlgo, trailingSignatureLength, null, 0, 0, 0);
    }

    private CryptoAlgorithm(int messageFormatVersion, int blockSizeBits, int nonceLenBytes, int tagLenBytes, long maxContentLen, String keyAlgo, int keyLenBytes, int value, String dataKeyAlgo, int dataKeyLen, boolean safeToCache, String trailingSignatureAlgo, int trailingSignatureLength, String keyCommitmentAlgo, int commitmentLength, int commitmentNonceLength, int suiteDataLength) {
        if ((messageFormatVersion & 0xFF) != messageFormatVersion) {
            throw new IllegalArgumentException("Invalid messageFormatVersion: " + messageFormatVersion);
        }
        if (keyCommitmentAlgo != null && !keyCommitmentAlgo.equals(dataKeyAlgo)) {
            throw new IllegalArgumentException("Invalid keyCommitmentAlgo " + keyCommitmentAlgo + ". Must be equal to dataKeyAlgo " + dataKeyAlgo + ".");
        }
        this.messageFormatVersion_ = (byte)(messageFormatVersion & 0xFF);
        this.blockSizeBits_ = blockSizeBits;
        this.nonceLenBytes_ = (byte)nonceLenBytes;
        this.tagLenBytes_ = tagLenBytes;
        this.keyAlgo_ = keyAlgo;
        this.keyLenBytes_ = keyLenBytes;
        this.maxContentLen_ = maxContentLen;
        this.safeToCache_ = safeToCache;
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Invalid value " + value);
        }
        this.value_ = (short)value;
        this.dataKeyAlgo_ = dataKeyAlgo;
        this.dataKeyLen_ = dataKeyLen;
        this.trailingSigAlgo_ = trailingSignatureAlgo;
        if (trailingSignatureLength > Short.MAX_VALUE || trailingSignatureLength < 0) {
            throw new IllegalArgumentException("Invalid value " + trailingSignatureLength);
        }
        this.trailingSigLen_ = (short)trailingSignatureLength;
        this.keyCommitmentAlgo_ = keyCommitmentAlgo;
        this.commitmentLength_ = commitmentLength;
        this.commitmentNonceLength_ = commitmentNonceLength;
        this.suiteDataLength_ = suiteDataLength;
    }

    private static int fieldsToLookupKey(byte messageFormatVersion, short algorithmId) {
        return messageFormatVersion << 16 | algorithmId;
    }

    public static CryptoAlgorithm deserialize(byte messageFormatVersion, short value) {
        return ID_MAPPING.get(CryptoAlgorithm.fieldsToLookupKey(messageFormatVersion, value));
    }

    public int getMessageIdLength() {
        switch (this.messageFormatVersion_) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
        }
        throw new UnsupportedOperationException("Support for version " + this.messageFormatVersion_ + " not yet built.");
    }

    public byte[] getHeaderNonce() {
        switch (this.messageFormatVersion_) {
            case 1: {
                return null;
            }
            case 2: {
                return new byte[this.nonceLenBytes_];
            }
        }
        throw new UnsupportedOperationException("Support for version " + this.messageFormatVersion_ + " not yet built.");
    }

    public byte getMessageFormatVersion() {
        return this.messageFormatVersion_;
    }

    public int getBlockSize() {
        return this.blockSizeBits_ / 8;
    }

    public byte getNonceLen() {
        return this.nonceLenBytes_;
    }

    public int getTagLen() {
        return this.tagLenBytes_;
    }

    public long getMaxContentLen() {
        return this.maxContentLen_;
    }

    public String getKeyAlgo() {
        return this.keyAlgo_;
    }

    public int getKeyLength() {
        return this.keyLenBytes_;
    }

    public short getValue() {
        return this.value_;
    }

    public String getDataKeyAlgo() {
        return this.dataKeyAlgo_;
    }

    public int getDataKeyLength() {
        return this.dataKeyLen_;
    }

    public String getTrailingSignatureAlgo() {
        return this.trailingSigAlgo_;
    }

    public boolean isSafeToCache() {
        return this.safeToCache_;
    }

    public short getTrailingSignatureLength() {
        return this.trailingSigLen_;
    }

    public String getKeyCommitmentAlgo_() {
        return this.keyCommitmentAlgo_;
    }

    public boolean isCommitting() {
        return this.keyCommitmentAlgo_ != null;
    }

    public int getCommitmentLength() {
        return this.commitmentLength_;
    }

    public int getCommitmentNonceLength() {
        return this.commitmentNonceLength_;
    }

    public int getSuiteDataLength() {
        return this.suiteDataLength_;
    }

    public SecretKey getEncryptionKeyFromDataKey(SecretKey dataKey, CiphertextHeaders headers) throws InvalidKeyException {
        if (!dataKey.getAlgorithm().equalsIgnoreCase(this.getDataKeyAlgo())) {
            throw new InvalidKeyException("DataKey of incorrect algorithm. Expected " + this.getDataKeyAlgo() + " but was " + dataKey.getAlgorithm());
        }
        switch (this.messageFormatVersion_) {
            case 1: {
                return this.getNonCommittedEncryptionKey(dataKey, headers);
            }
            case 2: {
                return this.getCommittedEncryptionKey(dataKey, headers);
            }
        }
        throw new UnsupportedOperationException("Support for message format version " + this.messageFormatVersion_ + " not yet built.");
    }

    private SecretKey getCommittedEncryptionKey(SecretKey dataKey, CiphertextHeaders headers) throws InvalidKeyException {
        CommittedKey committedKey = CommittedKey.generate(this, dataKey, headers.getMessageId());
        if (!MessageDigest.isEqual(committedKey.getCommitment(), headers.getSuiteData())) {
            throw new BadCiphertextException("Key commitment validation failed. Key identity does not match the identity asserted in the message. Halting processing of this message.");
        }
        return committedKey.getKey();
    }

    private SecretKey getNonCommittedEncryptionKey(SecretKey dataKey, CiphertextHeaders headers) throws InvalidKeyException {
        HmacKeyDerivationFunction hkdf;
        String macAlgorithm;
        switch (this) {
            case ALG_AES_128_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_192_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: {
                return dataKey;
            }
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: {
                macAlgorithm = "HmacSHA256";
                break;
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                macAlgorithm = "HmacSHA384";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Support for " + (Object)((Object)this) + " not yet built.");
            }
        }
        if (!dataKey.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Currently only RAW format keys are supported for HKDF algorithms. Actual format was " + dataKey.getFormat());
        }
        byte[] messageId = headers.getMessageId();
        ByteBuffer info = ByteBuffer.allocate(messageId.length + 2);
        info.order(ByteOrder.BIG_ENDIAN);
        info.putShort(this.getValue());
        info.put(messageId);
        byte[] rawDataKey = dataKey.getEncoded();
        if (rawDataKey.length != this.getDataKeyLength()) {
            throw new InvalidKeyException("DataKey of incorrect length. Expected " + this.getDataKeyLength() + " but was " + rawDataKey.length);
        }
        try {
            hkdf = HmacKeyDerivationFunction.getInstance(macAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        hkdf.init(rawDataKey);
        return new SecretKeySpec(hkdf.deriveKey(info.array(), this.getKeyLength()), this.getKeyAlgo());
    }

    static {
        ID_MAPPING = new HashMap<Integer, CryptoAlgorithm>();
        for (CryptoAlgorithm s2 : EnumSet.allOf(CryptoAlgorithm.class)) {
            ID_MAPPING.put(CryptoAlgorithm.fieldsToLookupKey(s2.messageFormatVersion_, s2.value_), s2);
        }
    }
}

