/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OraclePartitionByRangeClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleRangeValuesClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.Token;

public class OracleCreateTableParser
extends SQLCreateTableParser {
    public OracleCreateTableParser(Lexer lexer) {
        super(new OracleExprParser(lexer));
    }

    public OracleCreateTableParser(String sql) {
        super(new OracleExprParser(sql));
    }

    @Override
    protected OracleCreateTableStatement newCreateStatement() {
        return new OracleCreateTableStatement();
    }

    @Override
    public OracleCreateTableStatement parseCrateTable(boolean acceptCreate) {
        OracleCreateTableStatement stmt;
        block28: {
            stmt = (OracleCreateTableStatement)super.parseCrateTable(acceptCreate);
            while (true) {
                OracleStorageClause storage2;
                if (this.lexer.token() == Token.TABLESPACE) {
                    this.lexer.nextToken();
                    stmt.setTablespace(this.exprParser.name());
                    continue;
                }
                if (this.identifierEquals("IN_MEMORY_METADATA")) {
                    this.lexer.nextToken();
                    stmt.setInMemoryMetadata(true);
                    continue;
                }
                if (this.identifierEquals("CURSOR_SPECIFIC_SEGMENT")) {
                    this.lexer.nextToken();
                    stmt.setCursorSpecificSegment(true);
                    continue;
                }
                if (this.identifierEquals("NOPARALLEL")) {
                    this.lexer.nextToken();
                    stmt.setParallel(false);
                    continue;
                }
                if (this.lexer.token() == Token.LOGGING) {
                    this.lexer.nextToken();
                    stmt.setLogging(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.CACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.NOCACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.FALSE);
                    continue;
                }
                if (this.lexer.token() == Token.NOCOMPRESS) {
                    this.lexer.nextToken();
                    stmt.setCompress(Boolean.FALSE);
                    continue;
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.COMMIT);
                    stmt.setOnCommit(true);
                    continue;
                }
                if (this.identifierEquals("PRESERVE")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("ROWS");
                    stmt.setPreserveRows(true);
                    continue;
                }
                if (this.identifierEquals("STORAGE")) {
                    storage2 = ((OracleExprParser)this.exprParser).parseStorage();
                    stmt.setStorage(storage2);
                    continue;
                }
                if (this.identifierEquals("organization")) {
                    this.lexer.nextToken();
                    this.accept(Token.INDEX);
                    stmt.setOrganizationIndex(true);
                    continue;
                }
                if (this.lexer.token() == Token.PCTFREE) {
                    this.lexer.nextToken();
                    stmt.setPtcfree(this.exprParser.expr());
                    continue;
                }
                if (this.identifierEquals("PCTUSED")) {
                    this.lexer.nextToken();
                    stmt.setPctused(this.exprParser.expr());
                    continue;
                }
                if (this.lexer.token() == Token.STORAGE) {
                    storage2 = ((OracleExprParser)this.exprParser).parseStorage();
                    stmt.setStorage(storage2);
                    continue;
                }
                if (this.lexer.token() == Token.LOB) {
                    OracleLobStorageClause lobStorage = ((OracleExprParser)this.exprParser).parseLobStorage();
                    stmt.setLobStorage(lobStorage);
                    continue;
                }
                if (this.lexer.token() == Token.INITRANS) {
                    this.lexer.nextToken();
                    stmt.setInitrans(this.exprParser.expr());
                    continue;
                }
                if (this.lexer.token() == Token.MAXTRANS) {
                    this.lexer.nextToken();
                    stmt.setMaxtrans(this.exprParser.expr());
                    continue;
                }
                if (this.lexer.token() == Token.SEGMENT) {
                    this.lexer.nextToken();
                    this.accept(Token.CREATION);
                    if (this.lexer.token() == Token.IMMEDIATE) {
                        this.lexer.nextToken();
                        stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.IMMEDIATE);
                        continue;
                    }
                    this.accept(Token.DEFERRED);
                    stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.DEFERRED);
                    continue;
                }
                if (!this.identifierEquals("PARTITION")) break block28;
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (!this.identifierEquals("RANGE")) break;
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                OraclePartitionByRangeClause clause = new OraclePartitionByRangeClause();
                while (true) {
                    SQLName column = this.exprParser.name();
                    clause.getColumns().add(column);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                if (this.identifierEquals("INTERVAL")) {
                    this.lexer.nextToken();
                    clause.setInterval(this.exprParser.expr());
                }
                if (this.lexer.token() == Token.STORE) {
                    this.lexer.nextToken();
                    this.accept(Token.IN);
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLName tablespace = this.exprParser.name();
                        clause.getStoreIn().add(tablespace);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.LPAREN);
                while (true) {
                    this.acceptIdentifier("PARTITION");
                    OracleRangeValuesClause range = new OracleRangeValuesClause();
                    range.setName(this.exprParser.name());
                    this.accept(Token.VALUES);
                    this.acceptIdentifier("LESS");
                    this.acceptIdentifier("THAN");
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLExpr rangeValue = this.exprParser.expr();
                        range.getValues().add(rangeValue);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    clause.getRanges().add(range);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                stmt.setPartitioning(clause);
            }
            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            OracleSelect select = new OracleSelectParser(this.exprParser).select();
            stmt.setSelect(select);
        }
        return stmt;
    }
}

