/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class OpenSearchTypeSystem
extends RelDataTypeSystemImpl {
    public static final RelDataTypeSystem INSTANCE = new OpenSearchTypeSystem();
    public static int MAX_PRECISION = 38;
    public static int MAX_SCALE = 38;

    private OpenSearchTypeSystem() {
    }

    public int getMaxNumericPrecision() {
        return MAX_PRECISION;
    }

    public int getMaxNumericScale() {
        return MAX_SCALE;
    }

    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (SqlTypeName.DECIMAL == argumentType.getSqlTypeName()) {
            return typeFactory.createTypeWithNullability(OpenSearchTypeSystem.highPrecision(typeFactory, argumentType), false);
        }
        if (SqlTypeName.INT_TYPES.contains(argumentType.getSqlTypeName())) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), false);
        }
        return argumentType;
    }

    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if ((argumentType = super.deriveSumType(typeFactory, argumentType)) instanceof BasicSqlType) {
            SqlTypeName typeName = argumentType.getSqlTypeName();
            if (SqlTypeName.INT_TYPES.contains(typeName)) {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), argumentType.isNullable());
            }
            if (SqlTypeName.APPROX_TYPES.contains(typeName)) {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), argumentType.isNullable());
            }
        }
        return argumentType;
    }

    public static RelDataType highPrecision(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type.getSqlTypeName() == SqlTypeName.DECIMAL) {
            return typeFactory.createSqlType(type.getSqlTypeName(), Math.min(type.getPrecision() + 4, typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.DECIMAL)), Math.min(type.getScale() + 4, typeFactory.getTypeSystem().getMaxScale(SqlTypeName.DECIMAL)));
        }
        return type;
    }
}

