/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.metrics.MeanMetric;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.MergeSchedulerConfig;
import org.opensearch.index.merge.MergeStats;
import org.opensearch.index.merge.MergedSegmentTransferTracker;
import org.opensearch.index.merge.OnGoingMerge;

class OpenSearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    protected final Logger logger;
    private final IndexSettings indexSettings;
    private final ShardId shardId;
    private final MeanMetric totalMerges = new MeanMetric();
    private final CounterMetric totalMergesNumDocs = new CounterMetric();
    private final CounterMetric totalMergesSizeInBytes = new CounterMetric();
    private final CounterMetric currentMerges = new CounterMetric();
    private final CounterMetric currentMergesNumDocs = new CounterMetric();
    private final CounterMetric currentMergesSizeInBytes = new CounterMetric();
    private final CounterMetric totalMergeStoppedTime = new CounterMetric();
    private final CounterMetric totalMergeThrottledTime = new CounterMetric();
    private final Set<OnGoingMerge> onGoingMerges = ConcurrentCollections.newConcurrentSet();
    private final Set<OnGoingMerge> readOnlyOnGoingMerges = Collections.unmodifiableSet(this.onGoingMerges);
    private final MergeSchedulerConfig config;
    private final MergedSegmentTransferTracker mergedSegmentTransferTracker;

    OpenSearchConcurrentMergeScheduler(ShardId shardId, IndexSettings indexSettings, MergedSegmentTransferTracker mergedSegmentTransferTracker) {
        this.config = indexSettings.getMergeSchedulerConfig();
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), shardId, new String[0]);
        this.mergedSegmentTransferTracker = mergedSegmentTransferTracker;
        this.refreshConfig();
    }

    public Set<OnGoingMerge> onGoingMerges() {
        return this.readOnlyOnGoingMerges;
    }

    private static String getSegmentName(MergePolicy.OneMerge merge) {
        return merge.getMergeInfo() != null ? merge.getMergeInfo().info.name : "_na_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        int totalNumDocs = merge.totalNumDocs();
        long totalSizeInBytes = merge.totalBytesSize();
        long timeNS = System.nanoTime();
        this.currentMerges.inc();
        this.currentMergesNumDocs.inc(totalNumDocs);
        this.currentMergesSizeInBytes.inc(totalSizeInBytes);
        OnGoingMerge onGoingMerge = new OnGoingMerge(merge);
        this.onGoingMerges.add(onGoingMerge);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting..., merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", (Object)OpenSearchConcurrentMergeScheduler.getSegmentName(merge), (Object)merge.segments.size(), (Object)totalNumDocs, (Object)new ByteSizeValue(totalSizeInBytes), (Object)new ByteSizeValue(merge.estimatedMergeBytes));
        }
        try {
            this.beforeMerge(onGoingMerge);
            super.doMerge(mergeSource, merge);
        }
        catch (Throwable throwable) {
            long tookMS = TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS));
            this.onGoingMerges.remove(onGoingMerge);
            this.afterMerge(onGoingMerge);
            this.currentMerges.dec();
            this.currentMergesNumDocs.dec(totalNumDocs);
            this.currentMergesSizeInBytes.dec(totalSizeInBytes);
            this.totalMergesNumDocs.inc(totalNumDocs);
            this.totalMergesSizeInBytes.inc(totalSizeInBytes);
            this.totalMerges.inc(tookMS);
            long stoppedMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.STOPPED)));
            long throttledMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.PAUSED)));
            this.totalMergeStoppedTime.inc(stoppedMS);
            this.totalMergeThrottledTime.inc(throttledMS);
            String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled]", OpenSearchConcurrentMergeScheduler.getSegmentName(merge), TimeValue.timeValueMillis((long)tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis((long)stoppedMS), TimeValue.timeValueMillis((long)throttledMS));
            if (tookMS > 20000L) {
                this.logger.debug("{}", (Object)message);
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}", (Object)message);
            }
            throw throwable;
        }
        long tookMS = TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS));
        this.onGoingMerges.remove(onGoingMerge);
        this.afterMerge(onGoingMerge);
        this.currentMerges.dec();
        this.currentMergesNumDocs.dec(totalNumDocs);
        this.currentMergesSizeInBytes.dec(totalSizeInBytes);
        this.totalMergesNumDocs.inc(totalNumDocs);
        this.totalMergesSizeInBytes.inc(totalSizeInBytes);
        this.totalMerges.inc(tookMS);
        long stoppedMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.STOPPED)));
        long throttledMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.PAUSED)));
        this.totalMergeStoppedTime.inc(stoppedMS);
        this.totalMergeThrottledTime.inc(throttledMS);
        String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled]", OpenSearchConcurrentMergeScheduler.getSegmentName(merge), TimeValue.timeValueMillis((long)tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis((long)stoppedMS), TimeValue.timeValueMillis((long)throttledMS));
        if (tookMS > 20000L) {
            this.logger.debug("{}", (Object)message);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}", (Object)message);
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    public MergeScheduler clone() {
        return this;
    }

    protected boolean maybeStall(MergeScheduler.MergeSource mergeSource) {
        return true;
    }

    protected ConcurrentMergeScheduler.MergeThread getMergeThread(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(mergeSource, merge);
        thread.setName(OpenSearchExecutors.threadName(this.indexSettings.getSettings(), "[" + this.shardId.getIndexName() + "][" + this.shardId.id() + "]: " + thread.getName()));
        return thread;
    }

    MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        mergeStats.add(this.totalMerges.count(), this.totalMerges.sum(), this.totalMergesNumDocs.count(), this.totalMergesSizeInBytes.count(), this.currentMerges.count(), this.currentMergesNumDocs.count(), this.currentMergesSizeInBytes.count(), this.totalMergeStoppedTime.count(), this.totalMergeThrottledTime.count(), this.config.isAutoThrottle() ? this.getIORateLimitMBPerSec() : Double.POSITIVE_INFINITY, this.mergedSegmentTransferTracker.stats());
        return mergeStats;
    }

    void refreshConfig() {
        boolean isEnabled;
        this.config.updateMaxForceMergeMBPerSec(this.indexSettings);
        if (this.getMaxMergeCount() != this.config.getMaxMergeCount() || this.getMaxThreadCount() != this.config.getMaxThreadCount()) {
            this.setMaxMergesAndThreads(this.config.getMaxMergeCount(), this.config.getMaxThreadCount());
        }
        boolean bl = isEnabled = this.getIORateLimitMBPerSec() != Double.POSITIVE_INFINITY;
        if (this.config.isAutoThrottle() && !isEnabled) {
            this.enableAutoIOThrottle();
        } else if (!this.config.isAutoThrottle() && isEnabled) {
            this.disableAutoIOThrottle();
        }
        this.applyMergeRateLimit();
    }

    private void applyMergeRateLimit() {
        double maxForceMergeMBPerSec = this.config.getMaxForceMergeMBPerSec();
        if (maxForceMergeMBPerSec != this.getForceMergeMBPerSec()) {
            this.logger.info("[{}][{}] updating force merge rate limit from [{}] to [{}] MB/sec", (Object)this.shardId.getIndexName(), (Object)this.shardId.id(), (Object)super.getForceMergeMBPerSec(), (Object)maxForceMergeMBPerSec);
            this.setForceMergeMBPerSec(maxForceMergeMBPerSec);
        }
    }
}

