/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.RatioValue;
import org.opensearch.core.common.unit.ByteSizeValue;

public class FileCacheThresholdSettings {
    public static final Setting<Boolean> CLUSTER_FILECACHE_ACTIVEUSAGE_THRESHOLD_ENABLED_SETTING = Setting.boolSetting("cluster.filecache.activeusage.threshold.enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING = new Setting<String>("cluster.filecache.activeusage.indexing.threshold", "90%", s -> FileCacheThresholdSettings.validThresholdSetting(s, "cluster.filecache.activeusage.indexing.threshold"), new IndexThresholdBreachValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING = new Setting<String>("cluster.filecache.activeusage.search.threshold", "100%", s -> FileCacheThresholdSettings.validThresholdSetting(s, "cluster.filecache.activeusage.search.threshold"), new SearchThresholdBreachValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile Double fileCacheIndexThresholdPercentage;
    private volatile Double fileCacheSearchThresholdPercentage;
    private volatile ByteSizeValue fileCacheIndexThresholdBytes;
    private volatile ByteSizeValue fileCacheSearchThresholdBytes;
    private volatile boolean enabled;

    public FileCacheThresholdSettings(Settings settings, ClusterSettings clusterSettings) {
        String index = CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING.get(settings);
        String searchStage = CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING.get(settings);
        boolean enabled = CLUSTER_FILECACHE_ACTIVEUSAGE_THRESHOLD_ENABLED_SETTING.get(settings);
        this.setIndexThreshold(index);
        this.setSearchThreshold(searchStage);
        this.setEnabled(enabled);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_FILECACHE_ACTIVEUSAGE_THRESHOLD_ENABLED_SETTING, this::setEnabled);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING, this::setIndexThreshold);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING, this::setSearchThreshold);
    }

    private static void doValidate(String index, String search) {
        try {
            FileCacheThresholdSettings.doValidateAsPercentage(index, search);
            return;
        }
        catch (OpenSearchParseException openSearchParseException) {
            try {
                FileCacheThresholdSettings.doValidateAsBytes(index, search);
            }
            catch (OpenSearchParseException e) {
                String message = String.format(Locale.ROOT, "unable to consistently parse [%s=%s], [%s=%s], and [%s=%s] as percentage or bytes", CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING.getKey(), index, CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING.getKey(), search);
                throw new IllegalArgumentException(message, e);
            }
            return;
        }
    }

    private static void doValidateAsPercentage(String index, String search) {
        double searchThreshold;
        double indexThreshold = FileCacheThresholdSettings.thresholdPercentageFromValue(index, false);
        if (indexThreshold > (searchThreshold = FileCacheThresholdSettings.thresholdPercentageFromValue(search, false))) {
            throw new IllegalArgumentException("index file cache threshold [" + index + "] more than search file cache threshold [" + search + "]");
        }
    }

    private static void doValidateAsBytes(String index, String search) {
        ByteSizeValue indexBytes = FileCacheThresholdSettings.thresholdBytesFromValue(index, CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING.getKey(), false);
        ByteSizeValue searchBytes = FileCacheThresholdSettings.thresholdBytesFromValue(search, CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING.getKey(), false);
        if (indexBytes.getBytes() > searchBytes.getBytes()) {
            throw new IllegalArgumentException("index file cache threshold [" + index + "] less than search file cache threshold [" + search + "]");
        }
    }

    private static ByteSizeValue thresholdBytesFromSettings(String value, String settingName) {
        return FileCacheThresholdSettings.thresholdBytesFromSettings(value, settingName, true);
    }

    private static ByteSizeValue thresholdBytesFromSettings(String value, String settingName, boolean lenient) {
        try {
            return ByteSizeValue.parseBytesSizeValue((String)value, (String)settingName);
        }
        catch (OpenSearchParseException ex) {
            if (lenient) {
                return ByteSizeValue.parseBytesSizeValue((String)"0b", (String)settingName);
            }
            throw ex;
        }
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void setIndexThreshold(String index) {
        this.fileCacheIndexThresholdPercentage = FileCacheThresholdSettings.thresholdPercentageFromValue(index);
        this.fileCacheIndexThresholdBytes = FileCacheThresholdSettings.thresholdBytesFromSettings(index, CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING.getKey());
    }

    private void setSearchThreshold(String search) {
        this.fileCacheSearchThresholdPercentage = FileCacheThresholdSettings.thresholdPercentageFromValue(search);
        this.fileCacheSearchThresholdBytes = FileCacheThresholdSettings.thresholdBytesFromSettings(search, CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING.getKey());
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public Double getFileCacheIndexThresholdPercentage() {
        return this.fileCacheIndexThresholdPercentage;
    }

    public Double getFileCacheSearchThresholdPercentage() {
        return this.fileCacheSearchThresholdPercentage;
    }

    public ByteSizeValue getFileCacheIndexThresholdBytes() {
        return this.fileCacheIndexThresholdBytes;
    }

    public ByteSizeValue getFileCacheSearchThresholdBytes() {
        return this.fileCacheSearchThresholdBytes;
    }

    String describeIndexThreshold() {
        return this.fileCacheIndexThresholdBytes.equals((Object)ByteSizeValue.ZERO) ? this.fileCacheIndexThresholdPercentage + "%" : this.fileCacheIndexThresholdBytes.toString();
    }

    String describeSearchThreshold() {
        return this.fileCacheSearchThresholdBytes.equals((Object)ByteSizeValue.ZERO) ? this.fileCacheSearchThresholdPercentage + "%" : this.fileCacheSearchThresholdBytes.toString();
    }

    private static double thresholdPercentageFromValue(String value) {
        return FileCacheThresholdSettings.thresholdPercentageFromValue(value, true);
    }

    private static double thresholdPercentageFromValue(String value, boolean lenient) {
        try {
            return RatioValue.parseRatioValue(value).getAsPercent();
        }
        catch (OpenSearchParseException ex) {
            if (lenient) {
                return 0.0;
            }
            throw ex;
        }
    }

    private static ByteSizeValue thresholdBytesFromValue(String value, String settingName, boolean lenient) {
        try {
            return ByteSizeValue.parseBytesSizeValue((String)value, (String)settingName);
        }
        catch (OpenSearchParseException ex) {
            if (lenient) {
                return ByteSizeValue.parseBytesSizeValue((String)"0b", (String)settingName);
            }
            throw ex;
        }
    }

    private static String validThresholdSetting(String value, String settingName) {
        try {
            RatioValue.parseRatioValue(value);
        }
        catch (OpenSearchParseException e) {
            try {
                ByteSizeValue.parseBytesSizeValue((String)value, (String)settingName);
            }
            catch (OpenSearchParseException ex) {
                ex.addSuppressed((Throwable)e);
                throw ex;
            }
        }
        return value;
    }

    static final class IndexThresholdBreachValidator
    implements Setting.Validator<String> {
        IndexThresholdBreachValidator() {
        }

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            String searchThreshold = (String)settings.get(CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING);
            FileCacheThresholdSettings.doValidate(value, searchThreshold);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<String>> settings = List.of(CLUSTER_FILECACHE_ACTIVEUSAGE_SEARCH_THRESHOLD_SETTING);
            return settings.iterator();
        }
    }

    static final class SearchThresholdBreachValidator
    implements Setting.Validator<String> {
        SearchThresholdBreachValidator() {
        }

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            String indexThreshold = (String)settings.get(CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING);
            FileCacheThresholdSettings.doValidate(indexThreshold, value);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<String>> settings = List.of(CLUSTER_FILECACHE_ACTIVEUSAGE_INDEXING_THRESHOLD_SETTING);
            return settings.iterator();
        }
    }
}

