/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.opensearch.index.store.remote.file.AbstractBlockIndexInput;
import org.opensearch.index.store.remote.utils.BlobFetchRequest;
import org.opensearch.index.store.remote.utils.TransferManager;

public class OnDemandBlockSnapshotIndexInput
extends AbstractBlockIndexInput {
    private static final Logger logger = LogManager.getLogger(OnDemandBlockSnapshotIndexInput.class);
    protected final TransferManager transferManager;
    protected final BlobStoreIndexShardSnapshot.FileInfo fileInfo;
    protected final FSDirectory directory;
    protected final String fileName;
    protected final long partSize;
    protected final long originalFileSize;

    public OnDemandBlockSnapshotIndexInput(BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager) {
        this("BlockedSnapshotIndexInput(path=\"" + directory.getDirectory().toString() + "/" + fileInfo.physicalName() + "\", offset=0, length= " + fileInfo.length() + ")", fileInfo, 0L, fileInfo.length(), false, directory, transferManager);
    }

    public OnDemandBlockSnapshotIndexInput(String resourceDescription, BlobStoreIndexShardSnapshot.FileInfo fileInfo, long offset, long length, boolean isClone, FSDirectory directory, TransferManager transferManager) {
        this((AbstractBlockIndexInput.Builder)((AbstractBlockIndexInput.Builder)((AbstractBlockIndexInput.Builder)((AbstractBlockIndexInput.Builder)AbstractBlockIndexInput.builder().resourceDescription(resourceDescription)).isClone(isClone)).offset(offset)).length(length), fileInfo, directory, transferManager);
    }

    protected OnDemandBlockSnapshotIndexInput(AbstractBlockIndexInput.Builder builder, BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager) {
        super(builder);
        this.transferManager = transferManager;
        this.fileInfo = fileInfo;
        this.partSize = fileInfo.partSize() != null ? fileInfo.partSize().getBytes() : Long.MAX_VALUE;
        this.fileName = fileInfo.physicalName();
        this.directory = directory;
        this.originalFileSize = fileInfo.length();
    }

    @Override
    protected OnDemandBlockSnapshotIndexInput buildSlice(String sliceDescription, long offset, long length) {
        return new OnDemandBlockSnapshotIndexInput((AbstractBlockIndexInput.Builder)((AbstractBlockIndexInput.Builder)((AbstractBlockIndexInput.Builder)((AbstractBlockIndexInput.Builder)((AbstractBlockIndexInput.Builder)AbstractBlockIndexInput.builder().blockSizeShift(this.blockSizeShift)).isClone(true)).offset(this.offset + offset)).length(length)).resourceDescription(sliceDescription), this.fileInfo, this.directory, this.transferManager);
    }

    @Override
    protected IndexInput fetchBlock(int blockId) throws IOException {
        logger.trace("fetchBlock called with blockId -> {}", (Object)blockId);
        String blockFileName = OnDemandBlockSnapshotIndexInput.getBlockFileName(this.fileName, blockId);
        long blockStart = this.getBlockStart(blockId);
        long blockEnd = blockStart + OnDemandBlockSnapshotIndexInput.getActualBlockSize(blockId, this.blockSizeShift, this.originalFileSize);
        logger.trace("File: {} , Block File: {} , BlockStart: {} , BlockEnd: {} , OriginalFileSize: {}", (Object)this.fileName, (Object)blockFileName, (Object)blockStart, (Object)blockEnd, (Object)this.originalFileSize);
        BlobFetchRequest blobFetchRequest = BlobFetchRequest.builder().blobParts(this.getBlobParts(blockStart, blockEnd)).directory(this.directory).fileName(blockFileName).build();
        return this.transferManager.fetchBlob(blobFetchRequest);
    }

    protected List<BlobFetchRequest.BlobPart> getBlobParts(long blockStart, long blockEnd) {
        int partNum = (int)(blockStart / this.partSize);
        long pos = blockStart;
        long diff = blockEnd - blockStart;
        ArrayList<BlobFetchRequest.BlobPart> blobParts = new ArrayList<BlobFetchRequest.BlobPart>();
        while (diff > 0L) {
            long partStart = pos % this.partSize;
            long partEnd = partStart + diff > this.partSize ? this.partSize : partStart + diff;
            long fetchBytes = partEnd - partStart;
            blobParts.add(new BlobFetchRequest.BlobPart(this.fileInfo.partName(partNum), partStart, fetchBytes));
            ++partNum;
            diff = blockEnd - (pos += fetchBytes);
        }
        return blobParts;
    }

    @Override
    public OnDemandBlockSnapshotIndexInput clone() {
        OnDemandBlockSnapshotIndexInput clone = this.buildSlice("clone", 0L, this.length);
        clone.cloneBlock(this);
        return clone;
    }
}

