/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DB2GetObjectExtractor;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.DB2AggregateSupport;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.DB2FormatEmulation;
import org.hibernate.dialect.function.DB2SubstringFunction;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.internal.DB2LockingSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.DB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sql.ast.DB2SqlAstTranslator;
import org.hibernate.dialect.sql.ast.PostgreSQLSqlAstTranslator;
import org.hibernate.dialect.temptable.DB2GlobalTemporaryTableStrategy;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.dialect.type.DB2StructJdbcType;
import org.hibernate.dialect.unique.AlterTableUniqueIndexDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.internal.DB2CallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDB2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.InstantJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.LocalDateJdbcType;
import org.hibernate.type.descriptor.jdbc.LocalDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.LocalTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullResolvingJdbcType;
import org.hibernate.type.descriptor.jdbc.OffsetDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.OffsetTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.ZonedDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2Dialect
extends Dialect {
    static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(11, 1);
    private static final int BIND_PARAMETERS_NUMBER_LIMIT = Short.MAX_VALUE;
    private static final String FOR_READ_ONLY_SQL = " for read only with rs";
    private static final String FOR_SHARE_SQL = " for read only with rs use and keep share locks";
    private static final String FOR_UPDATE_SQL = " for read only with rs use and keep update locks";
    private static final String SKIP_LOCKED_SQL = " skip locked data";
    private static final String FOR_SHARE_SKIP_LOCKED_SQL = " for read only with rs use and keep share locks skip locked data";
    private static final String FOR_UPDATE_SKIP_LOCKED_SQL = " for read only with rs use and keep update locks skip locked data";
    private final LimitHandler limitHandler = DB2LimitHandler.INSTANCE;
    private final UniqueDelegate uniqueDelegate = this.createUniqueDelegate();
    private final StandardTableExporter db2TableExporter = new StandardTableExporter(this){

        @Override
        protected void applyAggregateColumnCheck(StringBuilder buf, AggregateColumn aggregateColumn) {
            JdbcType jdbcType = aggregateColumn.getType().getJdbcType();
            if (!jdbcType.isLob() && !jdbcType.isXml()) {
                super.applyAggregateColumnCheck(buf, aggregateColumn);
            }
        }
    };
    private final LockingSupport lockingSupport = this.buildLockingSupport();

    public DB2Dialect() {
        this(MINIMUM_VERSION);
    }

    public DB2Dialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(MINIMUM_VERSION));
        this.registerKeywords(info);
    }

    public DB2Dialect(DatabaseVersion version) {
        super(version);
    }

    protected LockingSupport buildLockingSupport() {
        boolean supportsSkipLocked = this.getVersion().isSameOrAfter(11, 5);
        return DB2LockingSupport.forDB2(supportsSkipLocked);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    public DatabaseVersion getDB2Version() {
        return this.getVersion();
    }

    @Override
    public Exporter<Table> getTableExporter() {
        return this.db2TableExporter;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 0;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -6 -> "smallint";
            case 2 -> this.columnType(3);
            case 2004 -> "blob";
            case 2005 -> "clob";
            case 2014 -> "timestamp($p)";
            case 92, 2013 -> "time";
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "xml", this));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(-2, this.columnType(-3), this).withTypeCapacity(254L, this.columnType(-2)).build());
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return new PostgreSQLSqlAstTranslator(factory, optionalTableUpdate).createMergeOperation(optionalTableUpdate);
    }

    protected UniqueDelegate createUniqueDelegate() {
        return new AlterTableUniqueIndexDelegate(this);
    }

    @Override
    public int getMaxVarcharLength() {
        return 32672;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 31;
    }

    @Override
    public boolean supportsUserDefinedTypes() {
        return true;
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        DdlTypeRegistry ddlTypeRegistry = functionContributions.getTypeConfiguration().getDdlTypeRegistry();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.cot();
        functionFactory.sinh();
        functionFactory.cosh();
        functionFactory.tanh();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.radians();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.repeat();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("substr").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setArgumentCountBetween(2, 3).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER).setArgumentListSignature("(STRING string, INTEGER start[, INTEGER length])").register();
        functionContributions.getFunctionRegistry().register("substring", new DB2SubstringFunction(functionContributions.getTypeConfiguration()));
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.dateTimeTimestamp();
        functionFactory.concat_pipeOperator();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.insert();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.stddev();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.variance();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionFactory.position();
        functionFactory.overlayLength_overlay(false);
        functionFactory.median();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.varianceSamp();
        functionFactory.dateTrunc();
        functionFactory.trunc_dateTrunc();
        functionFactory.addYearsMonthsDaysHoursMinutesSeconds();
        functionFactory.yearsMonthsDaysHoursMinutesSecondsBetween();
        functionFactory.bitLength_pattern("length(?1)*8");
        functionContributions.getFunctionRegistry().register("concat", new CastingConcatFunction(this, "||", true, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("count", new CountFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "||", ddlTypeRegistry.getDescriptor(12).getCastTypeName(Size.nil(), functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING), ddlTypeRegistry), true));
        functionContributions.getFunctionRegistry().register("format", new DB2FormatEmulation(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("atan2", "atan2(?2,?1)").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("posstr").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER)).setExactArgumentCount(2).setParameterTypes(FunctionParameterType.STRING, FunctionParameterType.STRING).setArgumentListSignature("(STRING string, STRING pattern)").register();
        functionContributions.getFunctionRegistry().register("trim", new TrimFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.INLINE_PARAMETERS));
        functionFactory.windowFunctions();
        functionFactory.listagg(null);
        functionFactory.jsonValue_db2();
        functionFactory.jsonQuery_no_passing();
        functionFactory.jsonExists_no_passing();
        functionFactory.jsonObject_db2();
        functionFactory.jsonArray_db2();
        functionFactory.jsonArrayAgg_db2();
        functionFactory.jsonObjectAgg_db2();
        functionFactory.jsonTable_db2(this.getMaximumSeriesSize());
        functionFactory.xmlelement();
        functionFactory.xmlcomment();
        functionFactory.xmlforest();
        functionFactory.xmlconcat();
        functionFactory.xmlpi();
        functionFactory.xmlquery_db2();
        functionFactory.xmlexists();
        functionFactory.xmlagg();
        functionFactory.xmltable_db2();
        functionFactory.unnest_db2(this.getMaximumSeriesSize());
        functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), false, true);
        functionFactory.hex("hex(?1)");
        functionFactory.sha("hash(?1, 2)");
        functionFactory.md5("hash(?1, 0)");
    }

    protected int getMaximumSeriesSize() {
        return 10000;
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return 3019;
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName + " restrict"};
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        String toExpression;
        String fromExpression;
        StringBuilder pattern = new StringBuilder();
        if (unit.isDateUnit()) {
            fromExpression = "?2";
            toExpression = "?3";
        } else {
            fromExpression = switch (fromTemporalType) {
                case TemporalType.DATE -> "cast(?2 as timestamp)";
                case TemporalType.TIME -> "timestamp('1970-01-01',?2)";
                default -> "?2";
            };
            toExpression = switch (toTemporalType) {
                case TemporalType.DATE -> "cast(?3 as timestamp)";
                case TemporalType.TIME -> "timestamp('1970-01-01',?3)";
                default -> "?3";
            };
        }
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("(seconds_between(date_trunc('second',");
                pattern.append(toExpression);
                pattern.append("),date_trunc('second',");
                pattern.append(fromExpression);
                pattern.append("))");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("trunc(months_between(");
                pattern.append(toExpression);
                pattern.append(',');
                pattern.append(fromExpression);
                pattern.append(')');
                break;
            }
            default: {
                pattern.append("?1s_between(");
                pattern.append(toExpression);
                pattern.append(',');
                pattern.append(fromExpression);
                pattern.append(')');
            }
        }
        switch (unit) {
            case NATIVE: {
                pattern.append("+(microsecond(");
                pattern.append(toExpression);
                pattern.append(")-microsecond(");
                pattern.append(fromExpression);
                pattern.append("))/1e6)");
                break;
            }
            case NANOSECOND: {
                pattern.append("*1e9+(microsecond(");
                pattern.append(toExpression);
                pattern.append(")-microsecond(");
                pattern.append(fromExpression);
                pattern.append("))*1e3)");
                break;
            }
            case MONTH: {
                pattern.append(')');
                break;
            }
            case QUARTER: {
                pattern.append("/3)");
            }
        }
        return pattern.toString();
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        String timestampExpression = unit.isDateUnit() ? (temporalType == TemporalType.TIME ? "timestamp('1970-01-01',?3)" : "?3") : (temporalType == TemporalType.DATE ? "cast(?3 as timestamp)" : "?3");
        pattern.append(timestampExpression);
        pattern.append("+(");
        switch (unit) {
            case NATIVE: {
                pattern.append("?2) seconds");
                break;
            }
            case NANOSECOND: {
                pattern.append("(?2)/1e9) seconds");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7) days");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3) months");
                break;
            }
            default: {
                pattern.append("?2) ?1s");
            }
        }
        return pattern.toString();
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return unique ? " exclude null keys" : "";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return DB2SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from syscat.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        if (this.getQuerySequencesString() == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE;
        }
        return SequenceInformationExtractorDB2DatabaseImpl.INSTANCE;
    }

    @Override
    public LockingSupport getLockingSupport() {
        return this.lockingSupport;
    }

    @Override
    public String getForUpdateString() {
        return FOR_UPDATE_SQL;
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateSkipLockedString();
    }

    @Override
    public String getWriteLockString(Timeout timeout) {
        return timeout.milliseconds() == -2 && this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    @Override
    public String getReadLockString(Timeout timeout) {
        return timeout.milliseconds() == -2 && this.supportsSkipLocked() ? FOR_SHARE_SKIP_LOCKED_SQL : FOR_SHARE_SQL;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    @Override
    public String getReadLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_SHARE_SKIP_LOCKED_SQL : FOR_SHARE_SQL;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean requiresCastForConcatenatingNonStrings() {
        return true;
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return DB2Dialect.selectNullString(sqlType);
    }

    public static String selectNullString(int sqlType) {
        String literal = switch (sqlType) {
            case 1, 12 -> "''";
            case 91 -> "'2000-1-1'";
            case 92 -> "'00:00:00'";
            case 93, 2014 -> "'2000-1-1 00:00:00'";
            default -> "0";
        };
        return "nullif(" + literal + "," + literal + ")";
    }

    @Override
    public Boolean supportsRefCursors() {
        return false;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 2012);
        return col;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        statement.registerOutParameter(name, 2012);
        return 1;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " set data type " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion().isSameOrAfter(11, 5);
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public TemporaryTableStrategy getGlobalTemporaryTableStrategy() {
        return DB2GlobalTemporaryTableStrategy.INSTANCE;
    }

    @Override
    public boolean supportsIsTrue() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean useConnectionToCreateLob() {
        return false;
    }

    @Override
    public boolean supportsNationalizedMethods() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(XmlJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(DB2StructJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(ObjectNullResolvingJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        typeContributions.contributeJdbcType(new InstantJdbcType(){

            @Override
            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor<X>(javaType, this, Instant.class);
            }
        });
        typeContributions.contributeJdbcType(new LocalDateTimeJdbcType(){

            @Override
            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor<X>(javaType, this, LocalDateTime.class);
            }
        });
        typeContributions.contributeJdbcType(new LocalDateJdbcType(){

            @Override
            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor<X>(javaType, this, LocalDate.class);
            }
        });
        typeContributions.contributeJdbcType(new LocalTimeJdbcType(){

            @Override
            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor<X>(javaType, this, LocalTime.class);
            }
        });
        typeContributions.contributeJdbcType(new OffsetDateTimeJdbcType(){

            @Override
            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor<X>(javaType, this, OffsetDateTime.class);
            }
        });
        typeContributions.contributeJdbcType(new OffsetTimeJdbcType(){

            @Override
            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor<X>(javaType, this, OffsetTime.class);
            }
        });
        typeContributions.contributeJdbcType(new ZonedDateTimeJdbcType(){

            @Override
            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor<X>(javaType, this, ZonedDateTime.class);
            }
        });
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return DB2AggregateSupport.JSON_INSTANCE;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return DB2CallableStatementSupport.INSTANCE;
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("BX'");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return new TemplatedViolatedConstraintNameExtractor(sqle -> switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
            case -803 -> {
                String constraintWithKind = TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("SQLERRMC=", ",", sqle.getMessage());
                if (constraintWithKind == null) {
                    yield null;
                }
                yield constraintWithKind.substring(2);
            }
            case -545, -543, -531, -530 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("SQLERRMC=", ",", sqle.getMessage());
            default -> null;
        });
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
            case -952 -> new LockTimeoutException(message, sqlException, sql);
            case -803 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case -531, -530 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.FOREIGN_KEY, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case -407 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.NOT_NULL, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case -545, -543 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.CHECK, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            default -> null;
        };
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 128;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return DB2IdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsInsertReturning() {
        return true;
    }

    @Override
    public boolean supportsInsertReturningRowId() {
        return false;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, false, false).result());
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_MONTH -> "day";
            case TemporalUnit.DAY_OF_YEAR -> "doy";
            case TemporalUnit.DAY_OF_WEEK -> "dow";
            default -> super.translateExtractField(unit);
        };
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week_iso(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case QUARTER: {
                return "quarter(?2)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return "cast(?1 as ?2)";
        }
        return super.castPattern(from, to);
    }

    @Override
    public int getInExpressionCountLimit() {
        return Short.MAX_VALUE;
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData metadata) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, metadata);
    }

    @Override
    public boolean canDisableConstraints() {
        return true;
    }

    @Override
    public String getDisableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " alter foreign key " + name + " not enforced";
    }

    @Override
    public String getEnableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " alter foreign key " + name + " enforced";
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return super.getTruncateTableStatement(tableName) + " immediate";
    }

    @Override
    public String getCreateUserDefinedTypeExtensionsString() {
        return " instantiable mode db2sql";
    }

    @Override
    public String rowId(String rowId) {
        return "rowid";
    }

    @Override
    public int rowIdSqlType() {
        return -3;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public String getDual() {
        return "sysibm.sysdummy1";
    }

    @Override
    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return true;
    }
}

