/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.factory;

import io.opentelemetry.api.OpenTelemetry;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.telemetry.InfinispanTelemetry;
import org.infinispan.telemetry.impl.DisabledInfinispanTelemetry;
import org.keycloak.infinispan.module.factory.OpenTelemetryService;

@Scope(value=Scopes.GLOBAL)
@DefaultFactoryFor(classes={InfinispanTelemetry.class})
public class InfinispanTelemetryFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        CDI current;
        try {
            current = CDI.current();
        }
        catch (IllegalStateException e) {
            return new DisabledInfinispanTelemetry();
        }
        Instance selector = current.select(OpenTelemetry.class, new Annotation[0]);
        if (!selector.isResolvable()) {
            return new DisabledInfinispanTelemetry();
        }
        return new OpenTelemetryService((OpenTelemetry)selector.get());
    }
}

