/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class InsertFunction<K, V>
implements ListBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<InsertFunction> EXTERNALIZER = new Externalizer();
    private final boolean before;
    private final V pivot;
    private final V element;

    public InsertFunction(boolean before, V pivot, V element) {
        this.before = before;
        this.pivot = pivot;
        this.element = element;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket<V> bucket = ((ListBucket)existing.get()).insert(this.before, this.pivot, this.element);
            if (bucket == null) {
                return -1L;
            }
            entryView.set(bucket, new MetaParam.Writable[0]);
            return bucket.size();
        }
        return 0L;
    }

    private static class Externalizer
    implements AdvancedExternalizer<InsertFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends InsertFunction>> getTypeClasses() {
            return Collections.singleton(InsertFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.INSERT_FUNCTION;
        }

        public void writeObject(ObjectOutput output, InsertFunction object) throws IOException {
            output.writeBoolean(object.before);
            output.writeObject(object.pivot);
            output.writeObject(object.element);
        }

        public InsertFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new InsertFunction(input.readBoolean(), input.readObject(), input.readObject());
        }
    }
}

