/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shadow.bundletool.com.android.utils.TokenizedCommandLine;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lshadow/bundletool/com/android/utils/StringHelperWindows;", "", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
public final class StringHelperWindows {
    @NotNull
    public static final StringHelperWindows INSTANCE = new StringHelperWindows();

    private StringHelperWindows() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue(arrayList, "newArrayList()");
        List commands = arrayList;
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        int i15 = 0;
        while (i15 < length) {
            char c15 = commandLine.charAt(i15);
            if (c15 == '\"' && !escapingQuotes) {
                quoting = !quoting;
                ++i15;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c15 == '\\') {
                escapingQuotes = true;
                ++i15;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                ++i15;
                continue;
            }
            if (c15 == '^') {
                escapingOthers = true;
                ++i15;
                continue;
            }
            if (!quoting && commandLine.charAt(i15) == '&') {
                String string = commandLine.substring(commandStart, i15);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                commands.add(string);
                if (commandLine.length() <= ++i15 || commandLine.charAt(i15) == '&') {
                    // empty if block
                }
                commandStart = ++i15;
            }
            ++i15;
        }
        if (commandStart < length) {
            String string = commandLine.substring(commandStart);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            commands.add(string);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, false, 2, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        return new TokenizedCommandLine(commandLine, true, 2, null, 8, null).toTokenList();
    }
}

