/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import shadow.bundletool.com.android.utils.CharSequenceReader;
import shadow.bundletool.com.android.utils.XmlUtils;

public class CharSequences {
    public static int indexOf(CharSequence sequence, char c15) {
        return CharSequences.indexOf(sequence, c15, 0);
    }

    public static int indexOf(CharSequence sequence, char c15, int start) {
        for (int i15 = start; i15 < sequence.length(); ++i15) {
            if (sequence.charAt(i15) != c15) continue;
            return i15;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle, int start) {
        int length = haystack.length();
        int needleLength = needle.length();
        if (needleLength <= length && start >= 0) {
            if (needleLength > 0) {
                if (start > length - needleLength) {
                    start = length - needleLength;
                }
                char firstChar = needle.charAt(0);
                while (true) {
                    int i15;
                    if ((i15 = CharSequences.lastIndexOf(haystack, firstChar, start)) == -1) {
                        return -1;
                    }
                    int o15 = i15;
                    int o25 = 0;
                    while (++o25 < needleLength && haystack.charAt(++o15) == needle.charAt(o25)) {
                    }
                    if (o25 == needleLength) {
                        return i15;
                    }
                    start = i15 - 1;
                }
            }
            return start < length ? start : length;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence sequence, char c15) {
        return CharSequences.lastIndexOf(sequence, c15, sequence.length());
    }

    public static int lastIndexOf(CharSequence sequence, int c15, int start) {
        int length = sequence.length();
        if (start >= 0) {
            if (start >= length) {
                start = length - 1;
            }
            for (int i15 = start; i15 >= 0; --i15) {
                if (sequence.charAt(i15) != c15) continue;
                return i15;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle) {
        return CharSequences.lastIndexOf(haystack, needle, haystack.length());
    }

    public static boolean regionMatches(CharSequence sequence, int thisStart, CharSequence string, int start, int length) {
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        if (thisStart < 0 || sequence.length() - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i15 = 0; i15 < length; ++i15) {
            if (sequence.charAt(thisStart + i15) == string.charAt(start + i15)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence sequence, boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return CharSequences.regionMatches(sequence, thisStart, string, start, length);
        }
        if (thisStart < 0 || length > sequence.length() - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int end = thisStart + length;
        while (thisStart < end) {
            char c25;
            char c15;
            if ((c15 = sequence.charAt(thisStart++)) == (c25 = string.charAt(start++)) || CharSequences.foldCase(c15) == CharSequences.foldCase(c25)) continue;
            return false;
        }
        return true;
    }

    private static char foldCase(char ch4) {
        if (ch4 < '\u0080') {
            if ('A' <= ch4 && ch4 <= 'Z') {
                return (char)(ch4 + 32);
            }
            return ch4;
        }
        return Character.toLowerCase(Character.toUpperCase(ch4));
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix) {
        return CharSequences.startsWith(sequence, prefix, 0);
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix, int start) {
        int prefixLength;
        int sequenceLength = sequence.length();
        if (sequenceLength < start + (prefixLength = prefix.length())) {
            return false;
        }
        int i15 = start;
        for (int j15 = 0; j15 < prefixLength; ++j15) {
            if (sequence.charAt(i15) != prefix.charAt(j15)) {
                return false;
            }
            ++i15;
        }
        return true;
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix, boolean caseSensitive) {
        if (suffix.length() > sequence.length()) {
            return false;
        }
        int suffixLength = suffix.length();
        int sequenceLength = sequence.length();
        int i15 = sequenceLength - suffixLength;
        int j15 = 0;
        while (i15 < sequenceLength) {
            char c25;
            char c15 = sequence.charAt(i15);
            if (c15 != (c25 = suffix.charAt(j15))) {
                if (caseSensitive) {
                    return false;
                }
                if (Character.toLowerCase(c15) != Character.toLowerCase(c25)) {
                    return false;
                }
            }
            ++i15;
            ++j15;
        }
        return true;
    }

    public static boolean containsUpperCase(CharSequence s15) {
        if (s15 != null) {
            int n15 = s15.length();
            for (int i15 = 0; i15 < n15; ++i15) {
                if (!Character.isUpperCase(s15.charAt(i15))) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(CharSequence haystack, CharSequence needle) {
        return CharSequences.indexOf(haystack, needle, 0);
    }

    public static int indexOf(CharSequence haystack, CharSequence needle, int start) {
        int needleLength = needle.length();
        if (needleLength == 0) {
            return start;
        }
        char first = needle.charAt(0);
        if (needleLength == 1) {
            return CharSequences.indexOf(haystack, first, start);
        }
        int max = haystack.length() - needleLength;
        block0: for (int i15 = start; i15 <= max; ++i15) {
            if (haystack.charAt(i15) != first) continue;
            int h15 = i15 + 1;
            for (int n15 = 1; n15 < needleLength; ++n15) {
                if (haystack.charAt(h15) != needle.charAt(n15)) continue block0;
                ++h15;
            }
            return i15;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence where, CharSequence what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i15 = fromIndex; i15 <= max; ++i15) {
            if (!CharSequences.charsEqualIgnoreCase(where.charAt(i15), first)) {
                while (++i15 <= max && !CharSequences.charsEqualIgnoreCase(where.charAt(i15), first)) {
                }
            }
            if (i15 > max) continue;
            int j15 = i15 + 1;
            int end = j15 + targetCount - 1;
            int k15 = 1;
            while (j15 < end && CharSequences.charsEqualIgnoreCase(where.charAt(j15), what.charAt(k15))) {
                ++j15;
                ++k15;
            }
            if (j15 != end) continue;
            return i15;
        }
        return -1;
    }

    private static boolean charsEqualIgnoreCase(char c15, char c25) {
        return CharSequences.toUpperCase(c15) == CharSequences.toUpperCase(c25) || CharSequences.toLowerCase(c15) == CharSequences.toLowerCase(c25);
    }

    public static char toUpperCase(char c15) {
        if (c15 < 'a') {
            return c15;
        }
        if (c15 <= 'z') {
            return (char)(c15 + -32);
        }
        return Character.toUpperCase(c15);
    }

    public static char toLowerCase(char c15) {
        if (c15 < 'A' || c15 >= 'a' && c15 <= 'z') {
            return c15;
        }
        if (c15 <= 'Z') {
            return (char)(c15 + 32);
        }
        return Character.toLowerCase(c15);
    }

    public static CharSequence createSequence(char[] data) {
        return new ArrayBackedCharSequence(data);
    }

    public static CharSequence createSequence(char[] data, int offset, int length) {
        return new ArrayBackedCharSequence(data, offset, length);
    }

    public static char[] getCharArray(CharSequence sequence) {
        if (sequence instanceof ArrayBackedCharSequence) {
            return ((ArrayBackedCharSequence)sequence).getCharArray();
        }
        return sequence.toString().toCharArray();
    }

    public static CharSequenceReader getReader(CharSequence data, boolean stripBom) {
        CharSequenceReader reader = new CharSequenceReader(data);
        if (stripBom && data.length() > 0 && data.charAt(0) == '\ufeff') {
            reader.read();
        }
        return reader;
    }

    public static Document parseDocumentSilently(CharSequence xml, boolean namespaceAware) {
        try {
            CharSequenceReader reader = CharSequences.getReader(xml, true);
            return XmlUtils.parseDocument(reader, namespaceAware);
        }
        catch (IOException | SAXException exception) {
            return null;
        }
    }

    public static InputStream getInputStream(CharSequence text) {
        return new ByteArrayInputStream(text.toString().getBytes(Charsets.UTF_8));
    }

    private static class ArrayBackedCharSequence
    implements CharSequence {
        public final char[] data;
        private final int offset;
        private final int length;

        public ArrayBackedCharSequence(char[] data) {
            this(data, 0, data.length);
        }

        public ArrayBackedCharSequence(char[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public char[] getCharArray() {
            if (this.offset == 0 && this.length == this.data.length) {
                return this.data;
            }
            return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ArrayBackedCharSequence(this.data, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            return new String(this.data, this.offset, this.length);
        }
    }
}

