/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.HtmlOccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

public class XmlOccurrenceMarker
implements OccurrenceMarker {
    private static final char[] CLOSE_TAG_START = new char[]{'<', '/'};
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};

    @Override
    public Token getTokenToMark(RSyntaxTextArea textArea) {
        return HtmlOccurrenceMarker.getTagNameTokenForCaretOffset(textArea, this);
    }

    @Override
    public boolean isValidType(RSyntaxTextArea textArea, Token t15) {
        return textArea.getMarkOccurrencesOfTokenType(t15.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void markOccurrences(RSyntaxDocument doc, Token t15, RSyntaxTextAreaHighlighter h15, SmartHighlightPainter p15) {
        char[] lexeme = t15.getLexeme().toCharArray();
        int tokenOffs = t15.getOffset();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        int curLine = root.getElementIndex(t15.getOffset());
        int depth = 0;
        boolean found = false;
        boolean forward = true;
        for (t15 = doc.getTokenListForLine(curLine); t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
            if (t15.getType() != 25) continue;
            if (t15.isSingleChar('<') && t15.getOffset() + 1 == tokenOffs) {
                found = true;
                break;
            }
            if (!t15.is(CLOSE_TAG_START) || t15.getOffset() + 2 != tokenOffs) continue;
            found = true;
            forward = false;
            break;
        }
        if (!found) {
            return;
        }
        if (forward) {
            t15 = t15.getNextToken().getNextToken();
            while (true) {
                if (t15 != null && t15.isPaintable()) {
                    if (t15.getType() == 25) {
                        if (t15.is(CLOSE_TAG_START)) {
                            Token match = t15.getNextToken();
                            if (match != null && match.is(lexeme)) {
                                if (depth > 0) {
                                    --depth;
                                } else {
                                    try {
                                        int end = match.getOffset() + match.length();
                                        h15.addMarkedOccurrenceHighlight(match.getOffset(), end, p15);
                                        end = tokenOffs + match.length();
                                        h15.addMarkedOccurrenceHighlight(tokenOffs, end, p15);
                                        return;
                                    }
                                    catch (BadLocationException ble) {
                                        ble.printStackTrace();
                                    }
                                    return;
                                }
                            }
                        } else if (t15.isSingleChar('<') && (t15 = t15.getNextToken()) != null && t15.is(lexeme)) {
                            ++depth;
                        }
                    }
                    t15 = t15 == null ? null : t15.getNextToken();
                    continue;
                }
                if (++curLine < lineCount) {
                    t15 = doc.getTokenListForLine(curLine);
                }
                if (curLine >= lineCount) break;
            }
            return;
        }
        ArrayList<Entry> openCloses = new ArrayList<Entry>();
        boolean inPossibleMatch = false;
        t15 = doc.getTokenListForLine(curLine);
        int endBefore = tokenOffs - 2;
        while (true) {
            if (t15 != null && t15.getOffset() < endBefore && t15.isPaintable()) {
                if (t15.getType() == 25) {
                    Token next;
                    if (t15.isSingleChar('<')) {
                        Token next2 = t15.getNextToken();
                        if (next2 != null) {
                            if (next2.is(lexeme)) {
                                openCloses.add(new Entry(true, next2));
                                inPossibleMatch = true;
                            } else {
                                inPossibleMatch = false;
                            }
                            t15 = next2;
                        }
                    } else if (t15.isSingleChar('>')) {
                        inPossibleMatch = false;
                    } else if (inPossibleMatch && t15.is(TAG_SELF_CLOSE)) {
                        openCloses.remove(openCloses.size() - 1);
                        inPossibleMatch = false;
                    } else if (t15.is(CLOSE_TAG_START) && (next = t15.getNextToken()) != null) {
                        if (next.is(lexeme)) {
                            openCloses.add(new Entry(false, next));
                        }
                        t15 = next;
                    }
                }
                t15 = t15.getNextToken();
                continue;
            }
            for (int i15 = openCloses.size() - 1; i15 >= 0; --i15) {
                Entry entry = (Entry)openCloses.get(i15);
                if ((depth += entry.open ? -1 : 1) != -1) continue;
                try {
                    Token match = entry.t;
                    int end = match.getOffset() + match.length();
                    h15.addMarkedOccurrenceHighlight(match.getOffset(), end, p15);
                    end = tokenOffs + match.length();
                    h15.addMarkedOccurrenceHighlight(tokenOffs, end, p15);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                openCloses.clear();
                return;
            }
            openCloses.clear();
            if (--curLine >= 0) {
                t15 = doc.getTokenListForLine(curLine);
            }
            if (curLine < 0) break;
        }
    }

    private static class Entry {
        private boolean open;
        private Token t;

        Entry(boolean open, Token t15) {
            this.open = open;
            this.t = t15;
        }
    }
}

