/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.math.BigInteger;
import java.util.Objects;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    private static final long serialVersionUID = 65382027393090L;
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    private final int numerator;
    private final int denominator;
    private transient int hashCode;
    private transient String toString;
    private transient String toProperString;

    private static int addAndCheck(int x15, int y15) {
        long s15 = (long)x15 + (long)y15;
        if (s15 < Integer.MIN_VALUE || s15 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)s15;
    }

    public static Fraction getFraction(double value) {
        int denom2;
        double delta1;
        int sign = value < 0.0 ? -1 : 1;
        if ((value = Math.abs(value)) > 2.147483647E9 || Double.isNaN(value)) {
            throw new ArithmeticException("The value must not be greater than Integer.MAX_VALUE or NaN");
        }
        int wholeNumber = (int)value;
        int numer0 = 0;
        int denom0 = 1;
        int numer1 = 1;
        int denom1 = 0;
        int a15 = (int)(value -= (double)wholeNumber);
        double x15 = 1.0;
        double y15 = value - (double)a15;
        double delta2 = Double.MAX_VALUE;
        int i15 = 1;
        do {
            delta1 = delta2;
            int a25 = (int)(x15 / y15);
            double x25 = y15;
            double y25 = x15 - (double)a25 * y15;
            int numer2 = a15 * numer1 + numer0;
            denom2 = a15 * denom1 + denom0;
            double fraction = (double)numer2 / (double)denom2;
            delta2 = Math.abs(value - fraction);
            a15 = a25;
            x15 = x25;
            y15 = y25;
            numer0 = numer1;
            denom0 = denom1;
            numer1 = numer2;
            denom1 = denom2;
        } while (delta1 > delta2 && denom2 <= 10000 && denom2 > 0 && ++i15 < 25);
        if (i15 == 25) {
            throw new ArithmeticException("Unable to convert double to fraction");
        }
        return Fraction.getReducedFraction((numer0 + wholeNumber * denom0) * sign, denom0);
    }

    public static Fraction getFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        return new Fraction(numerator, denominator);
    }

    public static Fraction getFraction(int whole, int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            throw new ArithmeticException("The denominator must not be negative");
        }
        if (numerator < 0) {
            throw new ArithmeticException("The numerator must not be negative");
        }
        long numeratorValue = whole < 0 ? (long)whole * (long)denominator - (long)numerator : (long)whole * (long)denominator + (long)numerator;
        if (numeratorValue < Integer.MIN_VALUE || numeratorValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Numerator too large to represent as an Integer.");
        }
        return new Fraction((int)numeratorValue, denominator);
    }

    public static Fraction getFraction(String str) {
        Objects.requireNonNull(str, "str");
        int pos = str.indexOf(46);
        if (pos >= 0) {
            return Fraction.getFraction(Double.parseDouble(str));
        }
        pos = str.indexOf(32);
        if (pos > 0) {
            int whole = Integer.parseInt(str.substring(0, pos));
            if ((pos = (str = str.substring(pos + 1)).indexOf(47)) < 0) {
                throw new NumberFormatException("The fraction could not be parsed as the format X Y/Z");
            }
            int numer = Integer.parseInt(str.substring(0, pos));
            int denom = Integer.parseInt(str.substring(pos + 1));
            return Fraction.getFraction(whole, numer, denom);
        }
        pos = str.indexOf(47);
        if (pos < 0) {
            return Fraction.getFraction(Integer.parseInt(str), 1);
        }
        int numer = Integer.parseInt(str.substring(0, pos));
        int denom = Integer.parseInt(str.substring(pos + 1));
        return Fraction.getFraction(numer, denom);
    }

    public static Fraction getReducedFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (numerator == 0) {
            return ZERO;
        }
        if (denominator == Integer.MIN_VALUE && (numerator & 1) == 0) {
            numerator /= 2;
            denominator /= 2;
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        int gcd = Fraction.greatestCommonDivisor(numerator, denominator);
        return new Fraction(numerator /= gcd, denominator /= gcd);
    }

    private static int greatestCommonDivisor(int u15, int v15) {
        int t15;
        int k15;
        if (u15 == 0 || v15 == 0) {
            if (u15 == Integer.MIN_VALUE || v15 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: gcd is 2^31");
            }
            return Math.abs(u15) + Math.abs(v15);
        }
        if (Math.abs(u15) == 1 || Math.abs(v15) == 1) {
            return 1;
        }
        if (u15 > 0) {
            u15 = -u15;
        }
        if (v15 > 0) {
            v15 = -v15;
        }
        for (k15 = 0; (u15 & 1) == 0 && (v15 & 1) == 0 && k15 < 31; ++k15) {
            u15 /= 2;
            v15 /= 2;
        }
        if (k15 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int n15 = t15 = (u15 & 1) == 1 ? v15 : -(u15 / 2);
        while (true) {
            if ((t15 & 1) == 0) {
                t15 /= 2;
                continue;
            }
            if (t15 > 0) {
                u15 = -t15;
            } else {
                v15 = t15;
            }
            if ((t15 = (v15 - u15) / 2) == 0) break;
        }
        return -u15 * (1 << k15);
    }

    private static int mulAndCheck(int x15, int y15) {
        long m15 = (long)x15 * (long)y15;
        if (m15 < Integer.MIN_VALUE || m15 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)m15;
    }

    private static int mulPosAndCheck(int x15, int y15) {
        long m15 = (long)x15 * (long)y15;
        if (m15 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mulPos");
        }
        return (int)m15;
    }

    private static int subAndCheck(int x15, int y15) {
        long s15 = (long)x15 - (long)y15;
        if (s15 < Integer.MIN_VALUE || s15 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)s15;
    }

    private Fraction(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Fraction abs() {
        if (this.numerator >= 0) {
            return this;
        }
        return this.negate();
    }

    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    private Fraction addSub(Fraction fraction, boolean isAdd) {
        int tmodd1;
        int d25;
        Objects.requireNonNull(fraction, "fraction");
        if (this.numerator == 0) {
            return isAdd ? fraction : fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int d15 = Fraction.greatestCommonDivisor(this.denominator, fraction.denominator);
        if (d15 == 1) {
            int uvp = Fraction.mulAndCheck(this.numerator, fraction.denominator);
            int upv = Fraction.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(isAdd ? Fraction.addAndCheck(uvp, upv) : Fraction.subAndCheck(uvp, upv), Fraction.mulPosAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger uvp = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / d15));
        BigInteger upv = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / d15));
        BigInteger t15 = isAdd ? uvp.add(upv) : uvp.subtract(upv);
        BigInteger w15 = t15.divide(BigInteger.valueOf(d25 = (tmodd1 = t15.mod(BigInteger.valueOf(d15)).intValue()) == 0 ? d15 : Fraction.greatestCommonDivisor(tmodd1, d15)));
        if (w15.bitLength() > 31) {
            throw new ArithmeticException("overflow: numerator too large after multiply");
        }
        return new Fraction(w15.intValue(), Fraction.mulPosAndCheck(this.denominator / d15, fraction.denominator / d25));
    }

    @Override
    public int compareTo(Fraction other) {
        if (this == other) {
            return 0;
        }
        if (this.numerator == other.numerator && this.denominator == other.denominator) {
            return 0;
        }
        long first = (long)this.numerator * (long)other.denominator;
        long second = (long)other.numerator * (long)this.denominator;
        return Long.compare(first, second);
    }

    public Fraction divideBy(Fraction fraction) {
        Objects.requireNonNull(fraction, "fraction");
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiplyBy(fraction.invert());
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Fraction)) {
            return false;
        }
        Fraction other = (Fraction)obj;
        return this.getNumerator() == other.getNumerator() && this.getDenominator() == other.getDenominator();
    }

    @Override
    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getProperNumerator() {
        return Math.abs(this.numerator % this.denominator);
    }

    public int getProperWhole() {
        return this.numerator / this.denominator;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.denominator, this.numerator);
        }
        return this.hashCode;
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    public Fraction invert() {
        if (this.numerator == 0) {
            throw new ArithmeticException("Unable to invert zero.");
        }
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: can't negate numerator");
        }
        if (this.numerator < 0) {
            return new Fraction(-this.denominator, -this.numerator);
        }
        return new Fraction(this.denominator, this.numerator);
    }

    @Override
    public long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }

    public Fraction multiplyBy(Fraction fraction) {
        Objects.requireNonNull(fraction, "fraction");
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int d15 = Fraction.greatestCommonDivisor(this.numerator, fraction.denominator);
        int d25 = Fraction.greatestCommonDivisor(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(Fraction.mulAndCheck(this.numerator / d15, fraction.numerator / d25), Fraction.mulPosAndCheck(this.denominator / d25, fraction.denominator / d15));
    }

    public Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    public Fraction pow(int power) {
        if (power == 1) {
            return this;
        }
        if (power == 0) {
            return ONE;
        }
        if (power < 0) {
            if (power == Integer.MIN_VALUE) {
                return this.invert().pow(2).pow(-(power / 2));
            }
            return this.invert().pow(-power);
        }
        Fraction f15 = this.multiplyBy(this);
        if (power % 2 == 0) {
            return f15.pow(power / 2);
        }
        return f15.pow(power / 2).multiplyBy(this);
    }

    public Fraction reduce() {
        if (this.numerator == 0) {
            return this.equals(ZERO) ? this : ZERO;
        }
        int gcd = Fraction.greatestCommonDivisor(Math.abs(this.numerator), this.denominator);
        if (gcd == 1) {
            return this;
        }
        return Fraction.getFraction(this.numerator / gcd, this.denominator / gcd);
    }

    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    public String toProperString() {
        if (this.toProperString == null) {
            int properNumerator;
            this.toProperString = this.numerator == 0 ? "0" : (this.numerator == this.denominator ? "1" : (this.numerator == -1 * this.denominator ? "-1" : ((this.numerator > 0 ? -this.numerator : this.numerator) < -this.denominator ? ((properNumerator = this.getProperNumerator()) == 0 ? Integer.toString(this.getProperWhole()) : this.getProperWhole() + " " + properNumerator + "/" + this.getDenominator()) : this.getNumerator() + "/" + this.getDenominator())));
        }
        return this.toProperString;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.getNumerator() + "/" + this.getDenominator();
        }
        return this.toString;
    }
}

