/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.MultiMap;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFAState
extends State {
    public static final int INITIAL_NUM_TRANSITIONS = 4;
    public static final int PREDICTED_ALT_UNSET = -2;
    public DFA dfa;
    protected List<Transition> transitions = new ArrayList<Transition>(4);
    protected int k;
    protected int acceptStateReachable = -2;
    protected boolean resolvedWithPredicates = false;
    public boolean abortedDueToRecursionOverflow = false;
    protected boolean abortedDueToMultipleRecursiveAlts = false;
    protected int cachedHashCode;
    protected int cachedUniquelyPredicatedAlt = -2;
    public int minAltInConfigurations = Integer.MAX_VALUE;
    public boolean atLeastOneConfigurationHasAPredicate = false;
    public OrderedHashSet<NFAConfiguration> nfaConfigurations = new OrderedHashSet();
    public List<NFAConfiguration> configurationsWithLabeledEdges = new ArrayList<NFAConfiguration>();
    protected Set<NFAConfiguration> closureBusy = new HashSet<NFAConfiguration>();
    protected OrderedHashSet<Label> reachableLabels;

    public DFAState(DFA dfa) {
        this.dfa = dfa;
    }

    public void reset() {
        this.configurationsWithLabeledEdges = null;
        this.closureBusy = null;
        this.reachableLabels = null;
    }

    @Override
    public Transition transition(int i15) {
        return this.transitions.get(i15);
    }

    @Override
    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    @Override
    public void addTransition(Transition t15) {
        this.transitions.add(t15);
    }

    public int addTransition(DFAState target, Label label) {
        this.transitions.add(new Transition(label, (State)target));
        return this.transitions.size() - 1;
    }

    public Transition getTransition(int trans) {
        return this.transitions.get(trans);
    }

    public void removeTransition(int trans) {
        this.transitions.remove(trans);
    }

    public void addNFAConfiguration(NFAState state, NFAConfiguration c15) {
        Label label;
        if (this.nfaConfigurations.contains(c15)) {
            return;
        }
        this.nfaConfigurations.add(c15);
        if (c15.alt < this.minAltInConfigurations) {
            this.minAltInConfigurations = c15.alt;
        }
        if (c15.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
            this.atLeastOneConfigurationHasAPredicate = true;
        }
        this.cachedHashCode += c15.state + c15.alt;
        if (state.transition[0] != null && !(label = state.transition[0].label).isEpsilon() && !label.isSemanticPredicate()) {
            this.configurationsWithLabeledEdges.add(c15);
            if (state.transition[1] == null) {
                c15.singleAtomTransitionEmanating = true;
            }
            this.addReachableLabel(label);
        }
    }

    public NFAConfiguration addNFAConfiguration(NFAState state, int alt, NFAContext context, SemanticContext semanticContext) {
        NFAConfiguration c15 = new NFAConfiguration(state.stateNumber, alt, context, semanticContext);
        this.addNFAConfiguration(state, c15);
        return c15;
    }

    protected void addReachableLabel(Label label) {
        IntSet t15;
        if (this.reachableLabels == null) {
            this.reachableLabels = new OrderedHashSet();
        }
        if (this.reachableLabels.contains(label)) {
            return;
        }
        IntSet remainder = t15 = label.getSet();
        int n15 = this.reachableLabels.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            Label rl4 = this.reachableLabels.get(i15);
            if (!Label.intersect(label, rl4)) continue;
            IntSet s_i = rl4.getSet();
            IntSet intersection = s_i.and(t15);
            this.reachableLabels.set(i15, new Label(intersection));
            IntSet existingMinusNewElements = s_i.subtract(t15);
            if (!existingMinusNewElements.isNil()) {
                Label newLabel = new Label(existingMinusNewElements);
                this.reachableLabels.add(newLabel);
            }
            if ((remainder = t15.subtract(s_i)).isNil()) break;
            t15 = remainder;
        }
        if (!remainder.isNil()) {
            Label newLabel = new Label(remainder);
            this.reachableLabels.add(newLabel);
        }
    }

    public OrderedHashSet<Label> getReachableLabels() {
        return this.reachableLabels;
    }

    public void setNFAConfigurations(OrderedHashSet<NFAConfiguration> configs) {
        this.nfaConfigurations = configs;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            return super.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o15) {
        DFAState other = (DFAState)o15;
        return this.nfaConfigurations.equals(other.nfaConfigurations);
    }

    public int getUniquelyPredictedAlt() {
        if (this.cachedUniquelyPredicatedAlt != -2) {
            return this.cachedUniquelyPredicatedAlt;
        }
        int alt = -1;
        int numConfigs = this.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            if (configuration.resolved) continue;
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        this.cachedUniquelyPredicatedAlt = alt;
        return alt;
    }

    public int getUniqueAlt() {
        int alt = -1;
        int numConfigs = this.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        return alt;
    }

    public Set<Integer> getDisabledAlternatives() {
        LinkedHashSet<Integer> disabled = new LinkedHashSet<Integer>();
        int numConfigs = this.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            if (!configuration.resolved) continue;
            disabled.add(Utils.integer(configuration.alt));
        }
        return disabled;
    }

    protected Set<Integer> getNonDeterministicAlts() {
        int user_k = this.dfa.getUserMaxLookahead();
        if (user_k > 0 && user_k == this.k) {
            return this.getAltSet();
        }
        if (this.abortedDueToMultipleRecursiveAlts || this.abortedDueToRecursionOverflow) {
            return this.getAltSet();
        }
        return this.getConflictingAlts();
    }

    protected Set<Integer> getConflictingAlts() {
        HashSet<Integer> nondeterministicAlts = new HashSet<Integer>();
        int numConfigs = this.nfaConfigurations.size();
        if (numConfigs <= 1) {
            return null;
        }
        MultiMap<Integer, NFAConfiguration> stateToConfigListMap = new MultiMap<Integer, NFAConfiguration>();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            Integer stateI = Utils.integer(configuration.state);
            stateToConfigListMap.map(stateI, configuration);
        }
        Set states = stateToConfigListMap.keySet();
        int numPotentialConflicts = 0;
        for (Integer stateI : states) {
            boolean thisStateHasPotentialProblem = false;
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int alt = 0;
            int numConfigsForState = configsForState.size();
            for (int i16 = 0; i16 < numConfigsForState && numConfigsForState > 1; ++i16) {
                NFAConfiguration c15 = (NFAConfiguration)configsForState.get(i16);
                if (alt == 0) {
                    alt = c15.alt;
                    continue;
                }
                if (c15.alt == alt || this.dfa.nfa.grammar.type == 1 && this.dfa.decisionNFAStartState.enclosingRule.name.equals("Tokens")) continue;
                ++numPotentialConflicts;
                thisStateHasPotentialProblem = true;
            }
            if (thisStateHasPotentialProblem) continue;
            stateToConfigListMap.put(stateI, null);
        }
        if (numPotentialConflicts == 0) {
            return null;
        }
        for (Integer stateI : states) {
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int numConfigsForState = 0;
            if (configsForState != null) {
                numConfigsForState = configsForState.size();
            }
            for (int i17 = 0; i17 < numConfigsForState; ++i17) {
                NFAConfiguration s15 = (NFAConfiguration)configsForState.get(i17);
                for (int j15 = i17 + 1; j15 < numConfigsForState; ++j15) {
                    NFAConfiguration t15 = (NFAConfiguration)configsForState.get(j15);
                    if (s15.alt == t15.alt || !s15.context.conflictsWith(t15.context)) continue;
                    nondeterministicAlts.add(Utils.integer(s15.alt));
                    nondeterministicAlts.add(Utils.integer(t15.alt));
                }
            }
        }
        if (nondeterministicAlts.isEmpty()) {
            return null;
        }
        return nondeterministicAlts;
    }

    public Set<Integer> getAltSet() {
        int numConfigs = this.nfaConfigurations.size();
        HashSet<Integer> alts = new HashSet<Integer>();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            alts.add(Utils.integer(configuration.alt));
        }
        if (alts.isEmpty()) {
            return null;
        }
        return alts;
    }

    public Set<? extends SemanticContext> getGatedSyntacticPredicatesInNFAConfigurations() {
        int numConfigs = this.nfaConfigurations.size();
        HashSet<SemanticContext> synpreds = new HashSet<SemanticContext>();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            SemanticContext gatedPredExpr = configuration.semanticContext.getGatedPredicateContext();
            if (gatedPredExpr == null || !configuration.semanticContext.isSyntacticPredicate()) continue;
            synpreds.add(configuration.semanticContext);
        }
        if (synpreds.isEmpty()) {
            return null;
        }
        return synpreds;
    }

    public SemanticContext getGatedPredicatesInNFAConfigurations() {
        SemanticContext unionOfPredicatesFromAllAlts = null;
        int numConfigs = this.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            SemanticContext gatedPredExpr = configuration.semanticContext.getGatedPredicateContext();
            if (gatedPredExpr == null) {
                return null;
            }
            if (!this.acceptState && configuration.semanticContext.isSyntacticPredicate()) continue;
            unionOfPredicatesFromAllAlts = unionOfPredicatesFromAllAlts == null ? gatedPredExpr : SemanticContext.or(unionOfPredicatesFromAllAlts, gatedPredExpr);
        }
        if (unionOfPredicatesFromAllAlts instanceof SemanticContext.TruePredicate) {
            return null;
        }
        return unionOfPredicatesFromAllAlts;
    }

    public int getAcceptStateReachable() {
        return this.acceptStateReachable;
    }

    public void setAcceptStateReachable(int acceptStateReachable) {
        this.acceptStateReachable = acceptStateReachable;
    }

    public boolean isResolvedWithPredicates() {
        return this.resolvedWithPredicates;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.stateNumber).append(":{");
        for (int i15 = 0; i15 < this.nfaConfigurations.size(); ++i15) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i15);
            if (i15 > 0) {
                buf.append(", ");
            }
            buf.append(configuration);
        }
        buf.append("}");
        return buf.toString();
    }

    public int getLookaheadDepth() {
        return this.k;
    }

    public void setLookaheadDepth(int k15) {
        this.k = k15;
        if (k15 > this.dfa.max_k) {
            this.dfa.max_k = k15;
        }
    }
}

