/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JEditableNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.action.JNodeAction;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.SmaliFoldParser;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.DefaultPopupMenuListener;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.DocumentUpdateListener;
import jadx.gui.utils.ui.ZoomActions;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeArea
extends RSyntaxTextArea {
    private static final long serialVersionUID = -3980354865216031972L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodeArea.class);
    public static final String SYNTAX_STYLE_SMALI = "text/smali";
    protected ContentPanel contentPanel;
    protected JNode node;
    private final AtomicBoolean loaded = new AtomicBoolean(false);

    public AbstractCodeArea(ContentPanel contentPanel, JNode node) {
        this.contentPanel = contentPanel;
        this.node = Objects.requireNonNull(node);
        this.setMarkOccurrences(false);
        this.setFadeCurrentLineHighlight(true);
        this.setAntiAliasingEnabled(true);
        this.applyEditableProperties(node);
        this.loadSettings();
        JadxSettings settings = contentPanel.getMainWindow().getSettings();
        this.setLineWrap(settings.isCodeAreaLineWrap());
        ZoomActions.register(this, settings, this::loadSettings);
        if (node instanceof JEditableNode) {
            JEditableNode editableNode = (JEditableNode)node;
            this.addSaveActions(editableNode);
            this.addChangeUpdates(editableNode);
        } else {
            this.addCaretActions();
            this.addFastCopyAction();
        }
    }

    private void applyEditableProperties(JNode node) {
        boolean editable = node.isEditable();
        this.setEditable(editable);
        if (editable) {
            this.setCloseCurlyBraces(true);
            this.setCloseMarkupTags(true);
            this.setAutoIndentEnabled(true);
            this.setClearWhitespaceLinesEnabled(true);
        }
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        if (this.node.isEditable()) {
            menu.add(this.createPopupMenuItem(AbstractCodeArea.getAction(6)));
            menu.add(this.createPopupMenuItem(AbstractCodeArea.getAction(4)));
            menu.addSeparator();
            menu.add(this.createPopupMenuItem(cutAction));
            menu.add(this.createPopupMenuItem(copyAction));
            menu.add(this.createPopupMenuItem(AbstractCodeArea.getAction(3)));
            menu.add(this.createPopupMenuItem(AbstractCodeArea.getAction(2)));
            menu.addSeparator();
            menu.add(this.createPopupMenuItem(AbstractCodeArea.getAction(5)));
        } else {
            menu.add(this.createPopupMenuItem(copyAction));
            menu.add(this.createPopupMenuItem(AbstractCodeArea.getAction(5)));
        }
        this.appendFoldingMenu(menu);
        this.appendWrapLineMenu(menu);
        return menu;
    }

    @Override
    protected void appendFoldingMenu(JPopupMenu popup) {
        if (this.isCodeFoldingEnabled()) {
            super.appendFoldingMenu(popup);
        }
    }

    private void appendWrapLineMenu(JPopupMenu popupMenu) {
        final JadxSettings settings = this.contentPanel.getMainWindow().getSettings();
        popupMenu.addSeparator();
        final JCheckBoxMenuItem wrapItem = new JCheckBoxMenuItem(NLS.str("popup.line_wrap"), this.getLineWrap());
        wrapItem.setAction(new AbstractAction(NLS.str("popup.line_wrap")){

            @Override
            public void actionPerformed(ActionEvent e15) {
                boolean wrap = !AbstractCodeArea.this.getLineWrap();
                settings.setCodeAreaLineWrap(wrap);
                settings.sync();
                AbstractCodeArea.this.contentPanel.getTabbedPane().getTabs().forEach(v15 -> {
                    if (v15 instanceof AbstractCodeContentPanel) {
                        AbstractCodeArea codeArea = ((AbstractCodeContentPanel)v15).getCodeArea();
                        AbstractCodeArea.this.setCodeAreaLineWrap(codeArea, wrap);
                        if (v15 instanceof ClassCodeContentPanel) {
                            codeArea = ((ClassCodeContentPanel)v15).getSmaliCodeArea();
                            AbstractCodeArea.this.setCodeAreaLineWrap(codeArea, wrap);
                        }
                    }
                });
            }
        });
        popupMenu.add(wrapItem);
        popupMenu.addPopupMenuListener(new DefaultPopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e15) {
                wrapItem.setState(AbstractCodeArea.this.getLineWrap());
            }
        });
    }

    private void setCodeAreaLineWrap(AbstractCodeArea codeArea, boolean wrap) {
        codeArea.setLineWrap(wrap);
        if (codeArea.isVisible()) {
            codeArea.repaint();
        }
    }

    private void addCaretActions() {
        final Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(2);
        }
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e15) {
                caret.setVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e15) {
                caret.setVisible(false);
            }
        });
        this.addCaretListener(new CaretListener(){
            int lastPos = -1;
            String lastText = "";

            @Override
            public void caretUpdate(CaretEvent e15) {
                int pos = AbstractCodeArea.this.getCaretPosition();
                if (this.lastPos != pos) {
                    this.lastPos = pos;
                    this.lastText = AbstractCodeArea.this.highlightCaretWord(this.lastText, pos);
                }
            }
        });
    }

    private void addFastCopyAction() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e15) {
                if (e15.getKeyCode() == 67 && UiUtils.isCtrlDown(e15) && StringUtils.isEmpty(AbstractCodeArea.this.getSelectedText())) {
                    UiUtils.copyToClipboard(AbstractCodeArea.this.getWordUnderCaret());
                }
            }
        });
    }

    private void addSaveActions(final JEditableNode node) {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e15) {
                if (e15.getKeyCode() == 83 && UiUtils.isCtrlDown(e15)) {
                    node.save(AbstractCodeArea.this.getText());
                    node.setChanged(false);
                }
            }
        });
    }

    private void addChangeUpdates(JEditableNode editableNode) {
        this.getDocument().addDocumentListener(new DocumentUpdateListener(ev4 -> {
            if (this.loaded.get()) {
                editableNode.setChanged(true);
            }
        }));
    }

    private String highlightCaretWord(String lastText, int pos) {
        String text = this.getWordByPosition(pos);
        if (StringUtils.isEmpty(text)) {
            this.highlightAllMatches(null);
            lastText = "";
        } else if (!lastText.equals(text)) {
            this.highlightAllMatches(text);
            lastText = text;
        }
        return lastText;
    }

    @Nullable
    public String getWordUnderCaret() {
        return this.getWordByPosition(this.getCaretPosition());
    }

    @Nullable
    public String getWordByPosition(int offset) {
        Token token = this.getWordTokenAtOffset(offset);
        if (token == null) {
            return null;
        }
        String str = token.getLexeme();
        int len = str.length();
        if (len > 2 && str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, len - 1);
        }
        return str;
    }

    @Nullable
    public Token getWordTokenAtOffset(int offset) {
        try {
            int line = this.getLineOfOffset(offset);
            Token lineTokens = this.getTokenListForLine(line);
            Token token = null;
            Token prevToken = null;
            for (Token t15 = lineTokens; t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
                if (t15.containsPosition(offset)) {
                    token = t15;
                    break;
                }
                prevToken = t15;
            }
            if (token == null) {
                return null;
            }
            if (AbstractCodeArea.isWordToken(token)) {
                return token;
            }
            if (AbstractCodeArea.isWordToken(prevToken)) {
                return prevToken;
            }
            return null;
        }
        catch (Exception e15) {
            LOG.error("Failed to get token at pos: {}", (Object)offset, (Object)e15);
            return null;
        }
    }

    public static boolean isWordToken(@Nullable Token token) {
        if (token == null) {
            return false;
        }
        switch (token.getType()) {
            case 0: 
            case 8: 
            case 21: 
            case 22: 
            case 23: {
                return false;
            }
            case 20: {
                if (token.length() == 1) {
                    char ch4 = token.charAt(0);
                    return ch4 != ';' && ch4 != '.' && ch4 != ',';
                }
                return true;
            }
        }
        return true;
    }

    public abstract ICodeInfo getCodeInfo();

    public void load() {
        if (this.isLoaded()) {
            return;
        }
        IBackgroundTask loadTask = this.getLoadTask();
        this.contentPanel.getMainWindow().getBackgroundExecutor().execute(loadTask);
    }

    public abstract IBackgroundTask getLoadTask();

    public void setLoaded() {
        this.loaded.set(true);
        this.discardAllEdits();
    }

    public void setUnLoaded() {
        this.loaded.set(false);
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    public abstract void refresh();

    public static RSyntaxTextArea getDefaultArea(MainWindow mainWindow) {
        RSyntaxTextArea area = new RSyntaxTextArea();
        area.setEditable(false);
        area.setCodeFoldingEnabled(false);
        area.setAntiAliasingEnabled(true);
        AbstractCodeArea.loadCommonSettings(mainWindow, area);
        return area;
    }

    public static void loadCommonSettings(MainWindow mainWindow, RSyntaxTextArea area) {
        JadxSettings settings = mainWindow.getSettings();
        mainWindow.getEditorThemeManager().apply(area);
        area.setFont(settings.getCodeFont());
        Gutter gutter = RSyntaxUtilities.getGutter(area);
        if (gutter != null) {
            gutter.setLineNumberFont(settings.getCodeFont());
        }
    }

    public void loadSettings() {
        AbstractCodeArea.loadCommonSettings(this.contentPanel.getMainWindow(), this);
    }

    public void scrollToPos(int pos) {
        try {
            this.setCaretPosition(pos);
            this.centerCurrentLine();
            this.forceCurrentLineHighlightRepaint();
        }
        catch (Exception e15) {
            LOG.warn("Can't scroll to position {}", (Object)pos, (Object)e15);
        }
    }

    public void centerCurrentLine() {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (viewport == null) {
            return;
        }
        try {
            Rectangle r15 = this.modelToView(this.getCaretPosition());
            if (r15 == null) {
                return;
            }
            int extentHeight = viewport.getExtentSize().height;
            Dimension viewSize = viewport.getViewSize();
            if (viewSize == null) {
                return;
            }
            int viewHeight = viewSize.height;
            int y15 = Math.max(0, r15.y - extentHeight / 2);
            y15 = Math.min(y15, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y15));
        }
        catch (BadLocationException e15) {
            LOG.debug("Can't center current line", e15);
        }
    }

    private void highlightAllMatches(@Nullable String str) {
        try {
            SearchContext context = new SearchContext(str);
            context.setMarkAll(true);
            context.setMatchCase(true);
            context.setWholeWord(true);
            SearchEngine.markAll(this, context);
        }
        catch (Throwable e15) {
            LOG.debug("Search highlight failed", e15);
        }
    }

    @Nullable
    public JumpPosition getCurrentPosition() {
        int pos = this.getCaretPosition();
        if (pos == 0) {
            return null;
        }
        return new JumpPosition(this.node, pos);
    }

    public int getLineStartFor(int pos) throws BadLocationException {
        return this.getLineStartOffset(this.getLineOfOffset(pos));
    }

    public String getLineAt(int pos) throws BadLocationException {
        return this.getLineText(this.getLineOfOffset(pos) + 1);
    }

    public String getLineText(int line) throws BadLocationException {
        int lineNum = line - 1;
        int startOffset = this.getLineStartOffset(lineNum);
        int endOffset = this.getLineEndOffset(lineNum);
        return this.getText(startOffset, endOffset - startOffset);
    }

    public ContentPanel getContentPanel() {
        return this.contentPanel;
    }

    public JNode getNode() {
        return this.node;
    }

    @Nullable
    public JClass getJClass() {
        if (this.node instanceof JClass) {
            return (JClass)this.node;
        }
        return null;
    }

    public boolean isDisposed() {
        return this.node == null;
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        try {
            void var4_12;
            void var4_10;
            this.setIgnoreRepaint(true);
            this.setText("");
            this.setEnabled(false);
            this.setSyntaxEditingStyle("text/plain");
            this.setLinkGenerator(null);
            for (MouseListener mouseListener : this.getMouseListeners()) {
                this.removeMouseListener(mouseListener);
            }
            for (EventListener eventListener : this.getMouseMotionListeners()) {
                this.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            JPopupMenu popupMenu = this.getPopupMenu();
            Object[] objectArray = popupMenu.getPopupMenuListeners();
            int n15 = objectArray.length;
            boolean bl4 = false;
            while (var4_10 < n15) {
                PopupMenuListener popupMenuListener = objectArray[var4_10];
                popupMenu.removePopupMenuListener(popupMenuListener);
                ++var4_10;
            }
            objectArray = popupMenu.getComponents();
            n15 = objectArray.length;
            boolean bl5 = false;
            while (var4_12 < n15) {
                Action action;
                Object component = objectArray[var4_12];
                if (component instanceof JMenuItem && (action = ((JMenuItem)component).getAction()) instanceof JNodeAction) {
                    ((JNodeAction)action).dispose();
                }
                ++var4_12;
            }
            popupMenu.removeAll();
        }
        catch (Throwable e15) {
            LOG.debug("Error on code area dispose", e15);
        }
        this.node = null;
        this.contentPanel = null;
    }

    @Override
    public Dimension getPreferredSize() {
        try {
            return super.getPreferredSize();
        }
        catch (Exception e15) {
            LOG.warn("Failed to calculate preferred size for code area", e15);
            Dimension d15 = new Dimension(400, 400);
            Insets insets = this.getInsets();
            if (this.getColumns() != 0) {
                d15.width = Math.max(d15.width, this.getColumns() * this.getColumnWidth() + insets.left + insets.right);
            }
            if (this.getRows() != 0) {
                d15.height = Math.max(d15.height, this.getRows() * this.getRowHeight() + insets.top + insets.bottom);
            }
            return d15;
        }
    }

    static {
        TokenMakerFactory tokenMakerFactory = TokenMakerFactory.getDefaultInstance();
        if (!(tokenMakerFactory instanceof AbstractTokenMakerFactory)) {
            throw new JadxRuntimeException("Unexpected TokenMakerFactory instance: " + String.valueOf(tokenMakerFactory.getClass()));
        }
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)tokenMakerFactory;
        atmf.putMapping(SYNTAX_STYLE_SMALI, "jadx.gui.ui.codearea.SmaliTokenMaker");
        atmf.putMapping("text/plain", "jadx.gui.ui.codearea.SimpleTokenMaker");
        SmaliFoldParser.register();
    }
}

