/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.rename;

import jadx.api.JadxArgs;
import jadx.api.deobf.IAliasProvider;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.MethodOverrideAttr;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.PackageNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.rename.UserRenames;
import jadx.core.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class RenameVisitor
extends AbstractVisitor {
    private static final Pattern ANONYMOUS_CLASS_PATTERN = Pattern.compile("^\\d+$");

    @Override
    public void init(RootNode root) {
        List<File> inputFiles = root.getArgs().getInputFiles();
        if (inputFiles.isEmpty()) {
            return;
        }
        this.process(root);
        root.registerCodeDataUpdateListener(codeData -> this.process(root));
    }

    private void process(RootNode root) {
        UserRenames.apply(root);
        RenameVisitor.checkNames(root);
    }

    private static void checkNames(RootNode root) {
        JadxArgs args = root.getArgs();
        if (args.getRenameFlags().isEmpty()) {
            return;
        }
        IAliasProvider aliasProvider = args.getAliasProvider();
        List<ClassNode> classes = root.getClasses(true);
        for (ClassNode cls : classes) {
            RenameVisitor.checkClassName(aliasProvider, cls, args);
            RenameVisitor.checkFields(aliasProvider, cls, args);
            RenameVisitor.checkMethods(aliasProvider, cls, args);
        }
        if (!args.isFsCaseSensitive() && args.isRenameCaseSensitive()) {
            HashSet<String> clsFullPaths = new HashSet<String>(classes.size());
            for (ClassNode cls : classes) {
                ClassInfo clsInfo = cls.getClassInfo();
                if (clsFullPaths.add(clsInfo.getAliasFullPath().toLowerCase())) continue;
                clsInfo.changeShortName(aliasProvider.forClass(cls));
                cls.addAttr(new RenameReasonAttr(cls).append("case insensitive filesystem"));
                clsFullPaths.add(clsInfo.getAliasFullPath().toLowerCase());
            }
        }
        boolean pkgUpdated = false;
        for (PackageNode pkg : root.getPackages()) {
            pkgUpdated |= RenameVisitor.checkPackage(args, aliasProvider, pkg);
        }
        if (pkgUpdated) {
            root.runPackagesUpdate();
        }
        RenameVisitor.processRootPackages(aliasProvider, root, classes);
    }

    private static void checkClassName(IAliasProvider aliasProvider, ClassNode cls, JadxArgs args) {
        if (cls.contains(AFlag.DONT_RENAME)) {
            return;
        }
        ClassInfo classInfo = cls.getClassInfo();
        String clsName = classInfo.getAliasShortName();
        String newShortName = RenameVisitor.fixClsShortName(args, clsName);
        if (newShortName == null) {
            cls.rename(aliasProvider.forClass(cls));
            cls.addAttr(new RenameReasonAttr(cls).notPrintable());
            return;
        }
        if (!newShortName.equals(clsName)) {
            classInfo.changeShortName(newShortName);
            cls.addAttr(new RenameReasonAttr(cls).append("invalid class name"));
        }
        if (classInfo.isInner() && args.isRenameValid()) {
            for (ClassInfo parentClass = classInfo.getParentClass(); parentClass != null; parentClass = parentClass.getParentClass()) {
                if (!parentClass.getAliasShortName().equals(newShortName)) continue;
                cls.rename(aliasProvider.forClass(cls));
                cls.addAttr(new RenameReasonAttr(cls).append("collision with other inner class name"));
                break;
            }
        }
    }

    private static boolean checkPackage(JadxArgs args, IAliasProvider aliasProvider, PackageNode pkg) {
        boolean notPrintable;
        if (args.isRenameValid() && pkg.getAliasPkgInfo().isDefaultPkg()) {
            pkg.setFullAlias("defpackage", false);
            return true;
        }
        String pkgName = pkg.getAliasPkgInfo().getName();
        boolean notValid = args.isRenameValid() && !NameMapper.isValidIdentifier(pkgName);
        boolean bl4 = notPrintable = args.isRenamePrintable() && !NameMapper.isAllCharsPrintable(pkgName);
        if (notValid || notPrintable) {
            pkg.setLeafAlias(aliasProvider.forPackage(pkg), false);
            return true;
        }
        return false;
    }

    @Nullable
    private static String fixClsShortName(JadxArgs args, String clsName) {
        String cleanClsName;
        if (StringUtils.isEmpty(clsName)) {
            return null;
        }
        boolean renameValid = args.isRenameValid();
        if (renameValid) {
            if (ANONYMOUS_CLASS_PATTERN.matcher(clsName).matches()) {
                return "AnonymousClass" + NameMapper.removeInvalidCharsMiddle(clsName);
            }
            char firstChar = clsName.charAt(0);
            if (firstChar == '$' || Character.isDigit(firstChar)) {
                return "C" + NameMapper.removeInvalidCharsMiddle(clsName);
            }
        }
        String string = cleanClsName = args.isRenamePrintable() ? NameMapper.removeNonPrintableCharacters(clsName) : clsName;
        if (cleanClsName.isEmpty()) {
            return null;
        }
        if (renameValid && !NameMapper.isValidIdentifier(cleanClsName = NameMapper.removeInvalidChars(clsName, "C"))) {
            return "C" + cleanClsName;
        }
        return cleanClsName;
    }

    private static void checkFields(IAliasProvider aliasProvider, ClassNode cls, JadxArgs args) {
        HashSet<String> names = new HashSet<String>();
        for (FieldNode field : cls.getFields()) {
            boolean notPrintable;
            FieldInfo fieldInfo = field.getFieldInfo();
            String fieldName = fieldInfo.getAlias();
            boolean notUnique = !names.add(fieldName);
            boolean notValid = args.isRenameValid() && !NameMapper.isValidIdentifier(fieldName);
            boolean bl4 = notPrintable = args.isRenamePrintable() && !NameMapper.isAllCharsPrintable(fieldName);
            if (!notUnique && !notValid && !notPrintable) continue;
            field.rename(aliasProvider.forField(field));
            field.addAttr(new RenameReasonAttr(field, notValid, notPrintable));
            if (!notUnique) continue;
            field.addAttr(new RenameReasonAttr(field).append("collision with other field name"));
        }
    }

    private static void checkMethods(IAliasProvider aliasProvider, ClassNode cls, JadxArgs args) {
        ArrayList<MethodNode> methods2 = new ArrayList<MethodNode>(cls.getMethods().size());
        for (MethodNode method : cls.getMethods()) {
            if (method.getAccessFlags().isConstructor()) continue;
            methods2.add(method);
        }
        for (MethodNode mth : methods2) {
            boolean notPrintable;
            String alias = mth.getAlias();
            boolean notValid = args.isRenameValid() && !NameMapper.isValidIdentifier(alias);
            boolean bl4 = notPrintable = args.isRenamePrintable() && !NameMapper.isAllCharsPrintable(alias);
            if (!notValid && !notPrintable) continue;
            mth.rename(aliasProvider.forMethod(mth));
            mth.addAttr(new RenameReasonAttr(mth, notValid, notPrintable));
        }
        if (args.isRenameValid()) {
            HashSet<String> names = new HashSet<String>(methods2.size());
            for (MethodNode mth : methods2) {
                String signature = mth.getMethodInfo().makeSignature(true, false);
                if (names.add(signature) || !RenameVisitor.canRename(mth)) continue;
                mth.rename(aliasProvider.forMethod(mth));
                mth.addAttr(new RenameReasonAttr("collision with other method in class"));
            }
        }
    }

    private static boolean canRename(MethodNode mth) {
        if (mth.contains(AFlag.DONT_RENAME)) {
            return false;
        }
        MethodOverrideAttr overrideAttr = mth.get(AType.METHOD_OVERRIDE);
        if (overrideAttr != null) {
            for (MethodNode relatedMth : overrideAttr.getRelatedMthNodes()) {
                if (relatedMth == mth || !mth.getParentClass().equals(relatedMth.getParentClass())) continue;
                return false;
            }
        }
        return true;
    }

    private static void processRootPackages(IAliasProvider aliasProvider, RootNode root, List<ClassNode> classes) {
        Set<String> rootPkgs = RenameVisitor.collectRootPkgs(root);
        root.getCacheStorage().setRootPkgs(rootPkgs);
        if (root.getArgs().isRenameValid()) {
            for (ClassNode cls : classes) {
                for (FieldNode field : cls.getFields()) {
                    if (!rootPkgs.contains(field.getAlias())) continue;
                    field.rename(aliasProvider.forField(field));
                    field.addAttr(new RenameReasonAttr("collision with root package name"));
                }
            }
        }
    }

    private static Set<String> collectRootPkgs(RootNode root) {
        HashSet<String> rootPkgs = new HashSet<String>();
        for (PackageNode pkg : root.getPackages()) {
            if (!pkg.isRoot()) continue;
            rootPkgs.add(pkg.getPkgInfo().getName());
        }
        return rootPkgs;
    }

    @Override
    public String getName() {
        return "RenameVisitor";
    }
}

