/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import ch.qos.logback.classic.Level;
import jadx.api.JadxDecompiler;
import jadx.cli.JadxCLI;
import jadx.cli.JadxCLIArgs;
import jadx.cli.SingleClassMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LogHelper.class);
    @Nullable(value="For disable log level control")
    private static @Nullable(value="For disable log level control") LogLevelEnum logLevelValue;

    public static void initLogLevel(JadxCLIArgs args) {
        logLevelValue = LogHelper.getLogLevelFromArgs(args);
    }

    private static LogLevelEnum getLogLevelFromArgs(JadxCLIArgs args) {
        if (LogHelper.isCustomLogConfig()) {
            return null;
        }
        if (args.quiet) {
            args.logLevel = LogLevelEnum.QUIET;
        } else if (args.verbose) {
            args.logLevel = LogLevelEnum.DEBUG;
        }
        return args.logLevel;
    }

    public static void setLogLevel(LogLevelEnum newLogLevel) {
        logLevelValue = newLogLevel;
        LogHelper.applyLogLevel(logLevelValue);
    }

    public static void applyLogLevels() {
        if (logLevelValue == null) {
            return;
        }
        LogHelper.applyLogLevel(logLevelValue);
        if (logLevelValue == LogLevelEnum.PROGRESS) {
            LogHelper.fixForShowProgress();
        }
    }

    private static void fixForShowProgress() {
        LogHelper.setLevelForClass(JadxCLI.class, Level.INFO);
        LogHelper.setLevelForClass(JadxDecompiler.class, Level.INFO);
        LogHelper.setLevelForClass(SingleClassMode.class, Level.INFO);
    }

    private static void applyLogLevel(@NotNull LogLevelEnum logLevel) {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        rootLogger.setLevel(logLevel.getLevel());
    }

    @Nullable
    public static LogLevelEnum getLogLevel() {
        return logLevelValue;
    }

    public static void setLevelForClass(Class<?> cls, Level level) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger(cls)).setLevel(level);
    }

    public static void setLevelForPackage(String pkgName, Level level) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger(pkgName)).setLevel(level);
    }

    private static boolean isCustomLogConfig() {
        try {
            String logbackConfig = System.getProperty("logback.configurationFile");
            if (logbackConfig == null) {
                return false;
            }
            LOG.debug("Use custom log config: {}", (Object)logbackConfig);
            return true;
        }
        catch (Exception e15) {
            LOG.error("Failed to detect custom log config", e15);
            return false;
        }
    }

    public static enum LogLevelEnum {
        QUIET(Level.OFF),
        PROGRESS(Level.OFF),
        ERROR(Level.ERROR),
        WARN(Level.WARN),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG);

        private final Level level;

        private LogLevelEnum(Level level) {
            this.level = level;
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

