/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class PublishProcessor<@NonNull T>
extends FlowableProcessor<T> {
    static final PublishSubscription[] TERMINATED = new PublishSubscription[0];
    static final PublishSubscription[] EMPTY = new PublishSubscription[0];
    final AtomicReference<PublishSubscription<T>[]> subscribers = new AtomicReference<PublishSubscription[]>(EMPTY);
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> PublishProcessor<T> create() {
        return new PublishProcessor<T>();
    }

    PublishProcessor() {
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super T> t15) {
        PublishSubscription<T> ps4 = new PublishSubscription<T>(t15, this);
        t15.onSubscribe(ps4);
        if (this.add(ps4)) {
            if (ps4.isCancelled()) {
                this.remove(ps4);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                t15.onError(ex4);
            } else {
                t15.onComplete();
            }
        }
    }

    boolean add(PublishSubscription<T> ps4) {
        PublishSubscription[] b15;
        PublishSubscription<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new PublishSubscription[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = ps4;
        } while (!this.subscribers.compareAndSet(a15, b15));
        return true;
    }

    void remove(PublishSubscription<T> ps4) {
        PublishSubscription[] b15;
        PublishSubscription<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED || a15 == EMPTY) {
                return;
            }
            int n15 = a15.length;
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != ps4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new PublishSubscription[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.subscribers.compareAndSet(a15, b15));
    }

    @Override
    public void onSubscribe(@NonNull Subscription s15) {
        if (this.subscribers.get() == TERMINATED) {
            s15.cancel();
            return;
        }
        s15.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(@NonNull T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        for (PublishSubscription<T> s15 : this.subscribers.get()) {
            s15.onNext(t15);
        }
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.error = t15;
        for (PublishSubscription s15 : this.subscribers.getAndSet(TERMINATED)) {
            s15.onError(t15);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishSubscription s15 : this.subscribers.getAndSet(TERMINATED)) {
            s15.onComplete();
        }
    }

    @CheckReturnValue
    public boolean offer(@NonNull T t15) {
        PublishSubscription<T>[] array;
        ExceptionHelper.nullCheck(t15, "offer called with a null value.");
        for (PublishSubscription<T> s15 : array = this.subscribers.get()) {
            if (!s15.isFull()) continue;
            return false;
        }
        for (PublishSubscription<T> s15 : array) {
            s15.onNext(t15);
        }
        return true;
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        if (this.subscribers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    static final class PublishSubscription<@NonNull T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 3562861878281475070L;
        final Subscriber<? super T> downstream;
        final PublishProcessor<T> parent;

        PublishSubscription(Subscriber<? super T> actual, PublishProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        public void onNext(T t15) {
            long r15 = this.get();
            if (r15 == Long.MIN_VALUE) {
                return;
            }
            if (r15 != 0L) {
                this.downstream.onNext(t15);
                BackpressureHelper.producedCancel(this, 1L);
            } else {
                this.cancel();
                this.downstream.onError(MissingBackpressureException.createDefault());
            }
        }

        public void onError(Throwable t15) {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onError(t15);
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        public void onComplete() {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.addCancel(this, n15);
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }

        boolean isFull() {
            return this.get() == 0L;
        }
    }
}

