/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Subscription;

public abstract class BlockingBaseSubscriber<T>
extends CountDownLatch
implements FlowableSubscriber<T> {
    T value;
    Throwable error;
    Subscription upstream;
    volatile boolean cancelled;

    public BlockingBaseSubscriber() {
        super(1);
    }

    @Override
    public final void onSubscribe(Subscription s15) {
        if (SubscriptionHelper.validate(this.upstream, s15)) {
            this.upstream = s15;
            if (!this.cancelled) {
                s15.request(Long.MAX_VALUE);
                if (this.cancelled) {
                    this.upstream = SubscriptionHelper.CANCELLED;
                    s15.cancel();
                }
            }
        }
    }

    @Override
    public final void onComplete() {
        this.countDown();
    }

    public final T blockingGet() {
        Throwable e15;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex4) {
                Subscription s15 = this.upstream;
                this.upstream = SubscriptionHelper.CANCELLED;
                if (s15 != null) {
                    s15.cancel();
                }
                throw ExceptionHelper.wrapOrThrow(ex4);
            }
        }
        if ((e15 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(e15);
        }
        return this.value;
    }
}

