/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMap<T, R>
extends Single<R> {
    final SingleSource<? extends T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;

    public SingleFlatMap(SingleSource<? extends T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        this.mapper = mapper;
        this.source = source;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> downstream) {
        this.source.subscribe(new SingleFlatMapCallback<T, R>(downstream, this.mapper));
    }

    static final class SingleFlatMapCallback<T, R>
    extends AtomicReference<Disposable>
    implements SingleObserver<T>,
    Disposable {
        private static final long serialVersionUID = 3258103020495908596L;
        final SingleObserver<? super R> downstream;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;

        SingleFlatMapCallback(SingleObserver<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.setOnce(this, d15)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            SingleSource<R> o15;
            try {
                o15 = Objects.requireNonNull(this.mapper.apply(value), "The single returned by the mapper is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                return;
            }
            if (!this.isDisposed()) {
                o15.subscribe(new FlatMapSingleObserver<R>(this, this.downstream));
            }
        }

        @Override
        public void onError(Throwable e15) {
            this.downstream.onError(e15);
        }

        static final class FlatMapSingleObserver<R>
        implements SingleObserver<R> {
            final AtomicReference<Disposable> parent;
            final SingleObserver<? super R> downstream;

            FlatMapSingleObserver(AtomicReference<Disposable> parent, SingleObserver<? super R> downstream) {
                this.parent = parent;
                this.downstream = downstream;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.replace(this.parent, d15);
            }

            @Override
            public void onSuccess(R value) {
                this.downstream.onSuccess(value);
            }

            @Override
            public void onError(Throwable e15) {
                this.downstream.onError(e15);
            }
        }
    }
}

