/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableOnErrorComplete<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super Throwable> predicate;

    public ObservableOnErrorComplete(ObservableSource<T> source, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new OnErrorCompleteObserver<T>(observer, this.predicate));
    }

    public static final class OnErrorCompleteObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final Predicate<? super Throwable> predicate;
        Disposable upstream;

        public OnErrorCompleteObserver(Observer<? super T> actual, Predicate<? super Throwable> predicate) {
            this.downstream = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        @Override
        public void onError(Throwable e15) {
            boolean b15;
            try {
                b15 = this.predicate.test(e15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(new CompositeException(e15, ex4));
                return;
            }
            if (b15) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

