/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableFromSupplier<T>
extends Observable<T>
implements Supplier<T> {
    final Supplier<? extends T> supplier;

    public ObservableFromSupplier(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        T value;
        DeferredScalarDisposable<T> d15 = new DeferredScalarDisposable<T>(observer);
        observer.onSubscribe(d15);
        if (d15.isDisposed()) {
            return;
        }
        try {
            value = ExceptionHelper.nullCheck(this.supplier.get(), "Supplier returned a null value.");
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            if (!d15.isDisposed()) {
                observer.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
            return;
        }
        d15.complete(value);
    }

    @Override
    public T get() throws Throwable {
        return ExceptionHelper.nullCheck(this.supplier.get(), "The supplier returned a null value.");
    }
}

