/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferTimed<T, U extends Collection<? super T>>
extends AbstractFlowableWithUpstream<T, U> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Supplier<U> bufferSupplier;
    final int maxSize;
    final boolean restartTimerOnMaxSize;

    public FlowableBufferTimed(Flowable<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Supplier<U> bufferSupplier, int maxSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSupplier = bufferSupplier;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s15) {
        if (this.timespan == this.timeskip && this.maxSize == Integer.MAX_VALUE) {
            this.source.subscribe(new BufferExactUnboundedSubscriber(new SerializedSubscriber<U>(s15), this.bufferSupplier, this.timespan, this.unit, this.scheduler));
            return;
        }
        Scheduler.Worker w15 = this.scheduler.createWorker();
        if (this.timespan == this.timeskip) {
            this.source.subscribe(new BufferExactBoundedSubscriber(new SerializedSubscriber<U>(s15), this.bufferSupplier, this.timespan, this.unit, this.maxSize, this.restartTimerOnMaxSize, w15));
            return;
        }
        this.source.subscribe(new BufferSkipBoundedSubscriber(new SerializedSubscriber<U>(s15), this.bufferSupplier, this.timespan, this.timeskip, this.unit, w15));
    }

    static final class BufferExactBoundedSubscriber<T, U extends Collection<? super T>>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Runnable,
    Disposable {
        final Supplier<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final int maxSize;
        final boolean restartTimerOnMaxSize;
        final Scheduler.Worker w;
        U buffer;
        Disposable timer;
        Subscription upstream;
        long producerIndex;
        long consumerIndex;

        BufferExactBoundedSubscriber(Subscriber<? super U> actual, Supplier<U> bufferSupplier, long timespan, TimeUnit unit, int maxSize, boolean restartOnMaxSize, Scheduler.Worker w15) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartOnMaxSize;
            this.w = w15;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            Collection b15;
            if (!SubscriptionHelper.validate(this.upstream, s15)) {
                return;
            }
            this.upstream = s15;
            try {
                b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.w.dispose();
                s15.cancel();
                EmptySubscription.error(e15, this.downstream);
                return;
            }
            this.buffer = b15;
            this.downstream.onSubscribe(this);
            this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            s15.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            Object b15;
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                b15.add(t15);
                if (b15.size() < this.maxSize) {
                    return;
                }
                this.buffer = null;
                ++this.producerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer.dispose();
            }
            this.fastPathOrderedEmitMax(b15, false, this);
            try {
                b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.cancel();
                this.downstream.onError(e15);
                return;
            }
            bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = b15;
                ++this.consumerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t15) {
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = null;
            }
            this.downstream.onError(t15);
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b15;
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                b15 = this.buffer;
                this.buffer = null;
            }
            if (b15 != null) {
                this.queue.offer(b15);
                this.done = true;
                if (this.enter()) {
                    QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, this, this);
                }
                this.w.dispose();
            }
        }

        @Override
        public boolean accept(Subscriber<? super U> a15, U v15) {
            a15.onNext(v15);
            return true;
        }

        @Override
        public void request(long n15) {
            this.requested(n15);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = null;
            }
            this.upstream.cancel();
            this.w.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.w.isDisposed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.cancel();
                this.downstream.onError(e15);
                return;
            }
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                current = this.buffer;
                if (current == null || this.producerIndex != this.consumerIndex) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathOrderedEmitMax(current, false, this);
        }
    }

    static final class BufferSkipBoundedSubscriber<T, U extends Collection<? super T>>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Runnable {
        final Supplier<U> bufferSupplier;
        final long timespan;
        final long timeskip;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final List<U> buffers;
        Subscription upstream;

        BufferSkipBoundedSubscriber(Subscriber<? super U> actual, Supplier<U> bufferSupplier, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker w15) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.timeskip = timeskip;
            this.unit = unit;
            this.w = w15;
            this.buffers = new LinkedList<U>();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            Collection b15;
            if (!SubscriptionHelper.validate(this.upstream, s15)) {
                return;
            }
            this.upstream = s15;
            try {
                b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.w.dispose();
                s15.cancel();
                EmptySubscription.error(e15, this.downstream);
                return;
            }
            this.buffers.add(b15);
            this.downstream.onSubscribe(this);
            s15.request(Long.MAX_VALUE);
            this.w.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
            this.w.schedule(new RemoveFromBuffer(this, b15), this.timespan, this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                for (Collection b15 : this.buffers) {
                    b15.add(t15);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.done = true;
            this.w.dispose();
            this.clear();
            this.downstream.onError(t15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            ArrayList<U> bs4;
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                bs4 = new ArrayList<U>(this.buffers);
                this.buffers.clear();
            }
            for (Collection b15 : bs4) {
                this.queue.offer(b15);
            }
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, this.w, this);
            }
        }

        @Override
        public void request(long n15) {
            this.requested(n15);
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.w.dispose();
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                this.buffers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection b15;
            if (this.cancelled) {
                return;
            }
            try {
                b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.cancel();
                this.downstream.onError(e15);
                return;
            }
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b15);
            }
            this.w.schedule(new RemoveFromBuffer(this, b15), this.timespan, this.unit);
        }

        @Override
        public boolean accept(Subscriber<? super U> a15, U v15) {
            a15.onNext(v15);
            return true;
        }

        static final class RemoveFromBuffer
        implements Runnable {
            private final U buffer;
            final /* synthetic */ BufferSkipBoundedSubscriber this$0;

            RemoveFromBuffer(U buffer) {
                this.this$0 = this$0;
                this.buffer = buffer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this.this$0;
                synchronized (bufferSkipBoundedSubscriber) {
                    this.this$0.buffers.remove(this.buffer);
                }
                this.this$0.fastPathOrderedEmitMax(this.buffer, false, this.this$0.w);
            }
        }
    }

    static final class BufferExactUnboundedSubscriber<T, U extends Collection<? super T>>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Runnable,
    Disposable {
        final Supplier<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        Subscription upstream;
        U buffer;
        final AtomicReference<Disposable> timer = new AtomicReference();

        BufferExactUnboundedSubscriber(Subscriber<? super U> actual, Supplier<U> bufferSupplier, long timespan, TimeUnit unit, Scheduler scheduler) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                Collection b15;
                this.upstream = s15;
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.cancel();
                    EmptySubscription.error(e15, this.downstream);
                    return;
                }
                this.buffer = b15;
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    s15.request(Long.MAX_VALUE);
                    Disposable d15 = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit);
                    if (!this.timer.compareAndSet(null, d15)) {
                        d15.dispose();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                U b15 = this.buffer;
                if (b15 != null) {
                    b15.add(t15);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t15) {
            DisposableHelper.dispose(this.timer);
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                this.buffer = null;
            }
            this.downstream.onError(t15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b15;
            DisposableHelper.dispose(this.timer);
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                b15 = this.buffer;
                if (b15 == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b15);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, null, this);
            }
        }

        @Override
        public void request(long n15) {
            this.requested(n15);
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            DisposableHelper.dispose(this.timer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The supplied buffer is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.cancel();
                this.downstream.onError(e15);
                return;
            }
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                current = this.buffer;
                if (current == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmitMax(current, false, this);
        }

        @Override
        public boolean accept(Subscriber<? super U> a15, U v15) {
            this.downstream.onNext(v15);
            return true;
        }

        @Override
        public void dispose() {
            this.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.timer.get() == DisposableHelper.DISPOSED;
        }
    }
}

