/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common.asm;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;

public enum StackType {
    TOP(Opcodes.TOP, "Top"),
    INTEGER(Opcodes.INTEGER, "int"),
    FLOAT(Opcodes.FLOAT, "float"),
    DOUBLE(Opcodes.DOUBLE, "double"),
    LONG(Opcodes.LONG, "long"),
    NULL(Opcodes.NULL, "null"),
    UNINIT_THIS(Opcodes.UNINITIALIZED_THIS, "UninitializedThis");

    private final Integer value;
    private final String name;
    private static final Map<Integer, StackType> VALUES_MAP;
    private static final Map<String, StackType> NAMES_MAP;

    private StackType(Integer value, String name) {
        this.value = value;
        this.name = name;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static StackType getByName(String name) {
        return NAMES_MAP.get(name);
    }

    @Nullable
    public static StackType getByValue(Integer value) {
        return VALUES_MAP.get(value);
    }

    static {
        StackType[] values2 = StackType.values();
        IdentityHashMap<Integer, StackType> valuesMap = new IdentityHashMap<Integer, StackType>(values2.length);
        HashMap<String, StackType> namesMap = new HashMap<String, StackType>(values2.length);
        for (StackType value : values2) {
            valuesMap.put(value.value, value);
            namesMap.put(value.name, value);
        }
        VALUES_MAP = valuesMap;
        NAMES_MAP = namesMap;
    }
}

