/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageViewer;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Synchronizer {
    private final WeakHashMap<ImageViewer, Void> viewers = new WeakHashMap(4);
    private ImageViewer leader = null;
    private final ChangeListener scrollChangeListener = new ChangeListener(){
        boolean adjusting = false;

        @Override
        public void stateChanged(ChangeEvent e15) {
            if (Synchronizer.this.leader != null) {
                return;
            }
            if (this.adjusting) {
                return;
            }
            ImageViewer source = null;
            for (ImageViewer viewer : Synchronizer.this.viewers.keySet()) {
                if (viewer.getScrollPane().getHorizontalScrollBar().getModel() != e15.getSource() && viewer.getScrollPane().getVerticalScrollBar().getModel() != e15.getSource()) continue;
                source = viewer;
                break;
            }
            if (source == null) {
                throw new AssertionError((Object)"Couldn't find the source of the scroll bar change event");
            }
            this.adjusting = true;
            for (ImageViewer viewer : Synchronizer.this.viewers.keySet()) {
                Synchronizer.this.updateScroll(viewer, source);
            }
            this.adjusting = false;
        }
    };

    public Synchronizer(ImageViewer viewer) {
        this.viewers.put(viewer, null);
        viewer.getScrollPane().getHorizontalScrollBar().getModel().addChangeListener(this.scrollChangeListener);
        viewer.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this.scrollChangeListener);
    }

    private void updateScroll(ImageViewer viewer, ImageViewer reference) {
        if (reference == viewer) {
            return;
        }
        viewer.getScrollPane().getHorizontalScrollBar().getModel().setValue(reference.getScrollPane().getHorizontalScrollBar().getModel().getValue());
        viewer.getScrollPane().getVerticalScrollBar().getModel().setValue(reference.getScrollPane().getVerticalScrollBar().getModel().getValue());
    }

    public void add(ImageViewer viewer) {
        if (viewer.getSynchronizer() == this) {
            return;
        }
        ImageViewer referenceViewer = this.viewers.keySet().iterator().next();
        ArrayList<ImageViewer> otherViewers = new ArrayList<ImageViewer>(viewer.getSynchronizer().viewers.keySet());
        for (ImageViewer otherViewer : otherViewers) {
            otherViewer.getSynchronizer().remove(otherViewer);
            otherViewer.setSynchronizer(this);
            this.viewers.put(otherViewer, null);
            otherViewer.setStatusBarVisible(referenceViewer.isStatusBarVisible());
            otherViewer.setResizeStrategy(referenceViewer.getResizeStrategy());
            otherViewer.setZoomFactor(referenceViewer.getZoomFactor());
            otherViewer.setPixelatedZoom(referenceViewer.isPixelatedZoom());
            otherViewer.setInterpolationType(referenceViewer.getInterpolationType());
            this.updateScroll(otherViewer, referenceViewer);
            otherViewer.getScrollPane().getHorizontalScrollBar().getModel().addChangeListener(this.scrollChangeListener);
            otherViewer.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this.scrollChangeListener);
        }
    }

    public void remove(ImageViewer viewer) {
        this.viewers.remove(viewer);
        viewer.getScrollPane().getHorizontalScrollBar().getModel().removeChangeListener(this.scrollChangeListener);
        viewer.getScrollPane().getVerticalScrollBar().getModel().removeChangeListener(this.scrollChangeListener);
    }

    boolean resizeStrategyChangedCanIRescroll(ImageViewer source) {
        if (this.leader != null) {
            return false;
        }
        this.leader = source;
        for (ImageViewer viewer : this.viewers.keySet()) {
            viewer.setResizeStrategy(source.getResizeStrategy());
        }
        return true;
    }

    boolean zoomFactorChangedCanIRescroll(ImageViewer source) {
        if (this.leader != null) {
            return false;
        }
        this.leader = source;
        for (ImageViewer viewer : this.viewers.keySet()) {
            viewer.setZoomFactor(source.getZoomFactor());
        }
        return true;
    }

    void doneRescrolling(ImageViewer source) {
        if (this.leader != source) {
            throw new AssertionError();
        }
        for (ImageViewer otherViewer : this.viewers.keySet()) {
            if (otherViewer == this.leader) continue;
            ((JComponent)otherViewer.getScrollPane().getViewport().getView()).scrollRectToVisible(this.leader.getScrollPane().getViewport().getViewRect());
            this.updateScroll(otherViewer, this.leader);
        }
        this.leader = null;
    }

    void interpolationTypeChanged(ImageViewer source) {
        for (ImageViewer viewer : this.viewers.keySet()) {
            viewer.setInterpolationType(source.getInterpolationType());
        }
    }

    void statusBarVisibilityChanged(ImageViewer source) {
        for (ImageViewer viewer : this.viewers.keySet()) {
            viewer.setStatusBarVisible(source.isStatusBarVisible());
        }
    }

    void pixelatedZoomChanged(ImageViewer source) {
        for (ImageViewer viewer : this.viewers.keySet()) {
            viewer.setPixelatedZoom(source.isPixelatedZoom());
        }
    }
}

