/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.swing;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;

public final class RxSwingPlugins {
    private static volatile Function<Runnable, Runnable> onSchedule;
    private static volatile Function<Scheduler, Scheduler> onEdtScheduler;
    private static volatile Function<Observable, Observable> onAssembly;

    private RxSwingPlugins() {
        throw new IllegalStateException("No instances!");
    }

    public static Runnable onSchedule(Runnable run) {
        Function<Runnable, Runnable> f15 = onSchedule;
        if (f15 == null) {
            return run;
        }
        try {
            return f15.apply(run);
        }
        catch (Throwable ex4) {
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
    }

    public static Scheduler onEdtScheduler(Scheduler original) {
        Function<Scheduler, Scheduler> f15 = onEdtScheduler;
        if (f15 == null) {
            return original;
        }
        try {
            return f15.apply(original);
        }
        catch (Throwable ex4) {
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
    }

    public static <T> Observable<T> onAssembly(Observable<T> original) {
        Function<Observable, Observable> f15 = onAssembly;
        if (f15 == null) {
            return original;
        }
        try {
            return f15.apply(original);
        }
        catch (Throwable ex4) {
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
    }

    public static Function<Runnable, Runnable> getOnSchedule() {
        return onSchedule;
    }

    public static void setOnSchedule(Function<Runnable, Runnable> handler) {
        onSchedule = handler;
    }

    public static Function<Scheduler, Scheduler> getOnEdtScheduler() {
        return onEdtScheduler;
    }

    public static void setOnEdtScheduler(Function<Scheduler, Scheduler> handler) {
        onEdtScheduler = handler;
    }

    public static Function<Observable, Observable> getOnAssembly() {
        return onAssembly;
    }

    public static void setOnAssembly(Function<Observable, Observable> handler) {
        onAssembly = handler;
    }

    public static void reset() {
        onSchedule = null;
        onEdtScheduler = null;
        onAssembly = null;
    }
}

