/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long CALENDAR_YEAR = 31556952000L;

    private DateUtil() {
    }

    public static long delta(long l15) {
        return System.currentTimeMillis() - l15;
    }

    public static long delta(Date date) {
        return System.currentTimeMillis() - date.getTime();
    }

    public static long currentTimeSecond() {
        return DateUtil.roundToSecond(System.currentTimeMillis());
    }

    public static long currentTimeMinute() {
        return DateUtil.roundToMinute(System.currentTimeMillis());
    }

    public static long currentTimeHour() {
        return DateUtil.roundToHour(System.currentTimeMillis());
    }

    public static long currentTimeDay() {
        return DateUtil.roundToDay(System.currentTimeMillis());
    }

    public static long roundToSecond(long l15) {
        return l15 / 1000L * 1000L;
    }

    public static long roundToMinute(long l15) {
        return l15 / 60000L * 60000L;
    }

    public static long roundToHour(long l15) {
        return DateUtil.roundToHour(l15, TimeZone.getDefault());
    }

    public static long roundToHour(long l15, TimeZone timeZone) {
        int n15 = timeZone.getOffset(l15);
        return l15 / 3600000L * 3600000L - (long)n15;
    }

    public static long roundToDay(long l15) {
        return DateUtil.roundToDay(l15, TimeZone.getDefault());
    }

    public static long roundToDay(long l15, TimeZone timeZone) {
        int n15 = timeZone.getOffset(l15);
        return (l15 + (long)n15) / 86400000L * 86400000L - (long)n15;
    }
}

